/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.stats;

import org.z2six.weaponcraft.features.blueprint.stats.BlueprintMetrics;
import org.z2six.weaponcraft.features.blueprint.stats.StatResult;
import org.z2six.weaponcraft.features.rendering.util.BitmapPayload;

public final class NameGenerator {
    private NameGenerator() {
    }

    public static String autoName(BitmapPayload p, StatResult sr) {
        String speedPrefix = NameGenerator.speedPrefixFrom(sr);
        String material = NameGenerator.dominantMaterialFrom(p);
        String type = NameGenerator.weaponTypeFrom(p, sr);
        return speedPrefix + " " + material + " " + type;
    }

    public static String mergedDisplayName(String custom, String auto) {
        String c;
        String string = c = custom == null ? "" : custom.trim();
        if (c.isEmpty()) {
            return auto;
        }
        return c + ", " + auto;
    }

    private static String speedPrefixFrom(StatResult sr) {
        int speedPct = NameGenerator.clampI(Math.round((1.0f - sr.tMass) * 100.0f), 0, 100);
        if (speedPct <= 20) {
            return "Colossal";
        }
        if (speedPct <= 40) {
            return "Heavy";
        }
        if (speedPct <= 60) {
            return "Balanced";
        }
        if (speedPct <= 80) {
            return "Swift";
        }
        return "Featherweight";
    }

    private static String dominantMaterialFrom(BitmapPayload p) {
        int fh = p.fineMaterials.length;
        int fw = fh == 0 ? 0 : p.fineMaterials[0].length;
        int[] counts = new int[5];
        for (int y = 0; y < fh; ++y) {
            byte[] row = p.fineMaterials[y];
            for (int x = 0; x < fw; ++x) {
                int m = row[x] & 0xFF;
                if (m < 1 || m > 4) continue;
                int n = m;
                counts[n] = counts[n] + 1;
            }
        }
        int best = 1;
        int bestCount = counts[1];
        for (int i = 2; i <= 4; ++i) {
            if (counts[i] <= bestCount) continue;
            best = i;
            bestCount = counts[i];
        }
        return switch (best) {
            case 1 -> "Iron";
            case 2 -> "Gold";
            case 3 -> "Diamond";
            case 4 -> "Netherite";
            default -> "Iron";
        };
    }

    private static String weaponTypeFrom(BitmapPayload p, StatResult sr) {
        boolean blunt;
        int span = BlueprintMetrics.horizontalSpanCoarse(p);
        boolean bl = blunt = sr.tBulk > 0.5f;
        if (!blunt) {
            if (span <= 6) {
                return "Katar";
            }
            if (span <= 12) {
                return "Dagger";
            }
            if (span <= 20) {
                return "Sword";
            }
            if (span <= 30) {
                return "Longsword";
            }
            return "Zweihander";
        }
        if (span <= 6) {
            return "Cestus";
        }
        if (span <= 12) {
            return "Club";
        }
        if (span <= 20) {
            return "Mace";
        }
        if (span <= 30) {
            return "Maul";
        }
        return "Great Maul";
    }

    private static int clampI(int v, int lo, int hi) {
        return v < lo ? lo : (v > hi ? hi : v);
    }
}

