/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.blueprint.validation;

import java.util.ArrayDeque;
import java.util.Queue;
import org.z2six.weaponcraft.features.rendering.util.BitmapPayload;

public final class ConnectedShapeValidator {
    private ConnectedShapeValidator() {
    }

    public static boolean isConnected(BitmapPayload p) {
        int ds = p.detailScale;
        int fh = p.height * ds;
        int fw = p.width * ds;
        int sx = -1;
        int sy = -1;
        int filledTotal = 0;
        for (int y = 0; y < fh; ++y) {
            for (int x = 0; x < fw; ++x) {
                if ((p.fineMaterials[y][x] & 0xFF) == 0) continue;
                ++filledTotal;
                if (sx >= 0) continue;
                sx = x;
                sy = y;
            }
        }
        if (filledTotal == 0) {
            return true;
        }
        boolean[][] vis = new boolean[fh][fw];
        ArrayDeque<int[]> q = new ArrayDeque<int[]>();
        q.add(new int[]{sx, sy});
        vis[sy][sx] = true;
        int visitedFilled = 1;
        while (!q.isEmpty()) {
            int[] cur = (int[])q.poll();
            int cx = cur[0];
            int cy = cur[1];
            if (cx - 1 >= 0) {
                visitedFilled += ConnectedShapeValidator.tryVisit(p, vis, q, cx - 1, cy);
            }
            if (cx + 1 < fw) {
                visitedFilled += ConnectedShapeValidator.tryVisit(p, vis, q, cx + 1, cy);
            }
            if (cy - 1 >= 0) {
                visitedFilled += ConnectedShapeValidator.tryVisit(p, vis, q, cx, cy - 1);
            }
            if (cy + 1 >= fh) continue;
            visitedFilled += ConnectedShapeValidator.tryVisit(p, vis, q, cx, cy + 1);
        }
        return visitedFilled == filledTotal;
    }

    private static int tryVisit(BitmapPayload p, boolean[][] vis, Queue<int[]> q, int x, int y) {
        if (vis[y][x]) {
            return 0;
        }
        if ((p.fineMaterials[y][x] & 0xFF) == 0) {
            return 0;
        }
        vis[y][x] = true;
        q.add(new int[]{x, y});
        return 1;
    }
}

