/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.combat.client.tooltip;

import java.util.List;
import java.util.Locale;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import org.z2six.weaponcraft.content.item.ForgedWeaponItem;
import org.z2six.weaponcraft.features.net.client.ClientConfigMirror;

@EventBusSubscriber(modid="weaponcraft", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public final class ForgedWeaponTooltipHandler {
    private ForgedWeaponTooltipHandler() {
    }

    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent e) {
        Component c;
        int end;
        ItemStack stack = e.getItemStack();
        if (!(stack.getItem() instanceof ForgedWeaponItem)) {
            return;
        }
        Totals totals = ForgedWeaponTooltipHandler.readTotalsFromStats(stack);
        if (totals == null) {
            return;
        }
        List list = e.getToolTip();
        int hdr = ForgedWeaponTooltipHandler.indexOfMainHandHeader(list);
        if (hdr < 0) {
            ForgedWeaponTooltipHandler.insertOurBlock(list, list.size(), totals);
            return;
        }
        for (end = hdr + 1; end < list.size() && !ForgedWeaponTooltipHandler.isEmptyLine(c = (Component)list.get(end)) && !ForgedWeaponTooltipHandler.isAnyHandHeader(c); ++end) {
        }
        list.subList(hdr, end).clear();
        ForgedWeaponTooltipHandler.insertOurBlock(list, hdr, totals);
    }

    private static boolean isEmptyLine(Component c) {
        return c.getString().isBlank();
    }

    private static boolean isMainHandHeader(Component c) {
        TranslatableContents tc;
        MutableComponent mc;
        ComponentContents componentContents;
        return c instanceof MutableComponent && (componentContents = (mc = (MutableComponent)c).getContents()) instanceof TranslatableContents && "item.modifiers.mainhand".equals((tc = (TranslatableContents)componentContents).getKey());
    }

    private static boolean isAnyHandHeader(Component c) {
        if (!(c instanceof MutableComponent)) {
            return false;
        }
        MutableComponent mc = (MutableComponent)c;
        ComponentContents componentContents = mc.getContents();
        if (!(componentContents instanceof TranslatableContents)) {
            return false;
        }
        TranslatableContents tc = (TranslatableContents)componentContents;
        String k = tc.getKey();
        return "item.modifiers.mainhand".equals(k) || "item.modifiers.offhand".equals(k);
    }

    private static int indexOfMainHandHeader(List<Component> list) {
        for (int i = 0; i < list.size(); ++i) {
            if (!ForgedWeaponTooltipHandler.isMainHandHeader(list.get(i))) continue;
            return i;
        }
        return -1;
    }

    private static void insertOurBlock(List<Component> list, int at, Totals t) {
        String multStr;
        list.add(at++, (Component)Component.translatable((String)"item.modifiers.mainhand").withStyle(ChatFormatting.GRAY));
        list.add(at++, ForgedWeaponTooltipHandler.blue(ForgedWeaponTooltipHandler.line(t.damage) + " Attack Damage"));
        list.add(at++, ForgedWeaponTooltipHandler.blue(ForgedWeaponTooltipHandler.line(t.speed) + " Attack Speed"));
        list.add(at++, ForgedWeaponTooltipHandler.blue(ForgedWeaponTooltipHandler.intLine(t.reach) + " Reach"));
        list.add(at++, ForgedWeaponTooltipHandler.blue(ForgedWeaponTooltipHandler.line(t.knockback) + " Knockback"));
        float multDisplay = ClientConfigMirror.getCritMultiplier();
        String string = multStr = (double)Math.abs(multDisplay - (float)Math.round(multDisplay)) < 0.001 ? Integer.toString(Math.round(multDisplay)) : String.format(Locale.ROOT, "%.2f", Float.valueOf(multDisplay));
        if (!Float.isNaN(t.critChance) && t.critChance > 0.0f && ClientConfigMirror.getCritEnabled()) {
            list.add(at, ForgedWeaponTooltipHandler.blue(Math.round(t.critChance * 100.0f) + "% Crit Chance (\u00d7" + multStr + ")"));
        }
    }

    private static Component blue(String s) {
        return Component.literal((String)s).withStyle(ChatFormatting.BLUE);
    }

    private static String line(float f) {
        return String.format(Locale.ROOT, (double)Math.abs(f - (float)Math.round(f)) < 0.001 ? "%.0f" : "%.2f", Float.valueOf(f));
    }

    private static String intLine(float f) {
        return Integer.toString(Math.round(f));
    }

    private static Totals readTotalsFromStats(ItemStack stack) {
        CustomData cd = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (cd == null || !cd.contains("WeaponBlueprint")) {
            return null;
        }
        CompoundTag bp = cd.copyTag().getCompound("WeaponBlueprint");
        if (!bp.contains("Stats", 10)) {
            return null;
        }
        CompoundTag st = bp.getCompound("Stats");
        if (!(st.contains("Damage") && st.contains("Speed") && st.contains("Reach") && st.contains("Knockback"))) {
            return null;
        }
        float crit = st.contains("CritChance") ? st.getFloat("CritChance") : Float.NaN;
        return new Totals(st.getFloat("Damage"), st.getFloat("Speed"), st.getFloat("Reach"), st.getFloat("Knockback"), crit);
    }

    private record Totals(float damage, float speed, float reach, float knockback, float critChance) {
    }
}

