/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.combat.server;

import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingIncomingDamageEvent;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import org.z2six.weaponcraft.config.feature.BalanceConfig;
import org.z2six.weaponcraft.content.item.ForgedWeaponItem;

@EventBusSubscriber(modid="weaponcraft", bus=EventBusSubscriber.Bus.GAME)
public final class CritHandler {
    private CritHandler() {
    }

    @SubscribeEvent
    public static void onCriticalHit(CriticalHitEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        ItemStack stack = sp.getMainHandItem();
        if (!(stack.getItem() instanceof ForgedWeaponItem)) {
            return;
        }
        BalanceConfig cfg = BalanceConfig.get();
        if (!cfg.critEnabled) {
            return;
        }
        if (event.isVanillaCritical()) {
            return;
        }
        float chance = CritHandler.readCritChanceFromBlueprint(stack);
        if (chance <= 0.0f) {
            return;
        }
        if (sp.getRandom().nextFloat() <= chance) {
            double mult = Math.max(1.0, (double)cfg.critMultiplier);
            CritHandler.trySetCritical(event, true);
            CritHandler.trySetCritMultiplier(event, mult);
        }
    }

    @SubscribeEvent
    public static void onIncomingDamage(LivingIncomingDamageEvent event) {
        if (event.getEntity().level().isClientSide) {
            return;
        }
        DamageSource src = event.getSource();
        Entity entity = src.getEntity();
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer attacker = (ServerPlayer)entity;
        ItemStack stack = attacker.getMainHandItem();
        if (!(stack.getItem() instanceof ForgedWeaponItem)) {
            return;
        }
        BalanceConfig cfg = BalanceConfig.get();
        if (!cfg.critEnabled) {
            return;
        }
        float chance = CritHandler.readCritChanceFromBlueprint(stack);
        if (chance <= 0.0f) {
            return;
        }
        if (attacker.getRandom().nextFloat() <= chance) {
            float mult = Math.max(1.0f, cfg.critMultiplier);
            float before = event.getAmount();
            event.setAmount(before * mult);
        }
    }

    private static float readCritChanceFromBlueprint(ItemStack stack) {
        float v;
        CustomData cd = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (cd == null || !cd.contains("WeaponBlueprint")) {
            return 0.0f;
        }
        CompoundTag bp = cd.copyTag().getCompound("WeaponBlueprint");
        if (!bp.contains("Stats", 10)) {
            return 0.0f;
        }
        CompoundTag st = bp.getCompound("Stats");
        float f = v = st.contains("CritChance") ? st.getFloat("CritChance") : 0.0f;
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private static void trySetCritical(CriticalHitEvent e, boolean critical) {
        try {
            e.getClass().getMethod("setCriticalHit", Boolean.TYPE).invoke((Object)e, critical);
            return;
        }
        catch (Throwable throwable) {
            try {
                e.getClass().getMethod("setCritical", Boolean.TYPE).invoke((Object)e, critical);
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            return;
        }
    }

    private static void trySetCritMultiplier(CriticalHitEvent e, double mult) {
        try {
            e.getClass().getMethod("setDamageModifier", Double.TYPE).invoke((Object)e, mult);
            return;
        }
        catch (Throwable throwable) {
            try {
                e.getClass().getMethod("setDamageModifier", Float.TYPE).invoke((Object)e, Float.valueOf((float)mult));
                return;
            }
            catch (Throwable throwable2) {
                try {
                    e.getClass().getMethod("setDamageMultiplier", Double.TYPE).invoke((Object)e, mult);
                }
                catch (Throwable throwable3) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

