/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import org.z2six.weaponcraft.core.Constants;
import org.z2six.weaponcraft.features.blueprint.client.preview.BlueprintCompanionHead;
import org.z2six.weaponcraft.features.rendering.BlueprintMeshBuilder;

@EventBusSubscriber(modid="weaponcraft", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public final class ClientTuningCommands {
    public static final State STATE = new State();

    private ClientTuningCommands() {
    }

    @SubscribeEvent
    public static void onRegisterClientCommands(RegisterClientCommandsEvent e) {
        CommandDispatcher dispatcher = e.getDispatcher();
        LiteralArgumentBuilder root = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wcmodel").then(Commands.literal((String)"rot").then(Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).then(Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).then(Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            float rx = FloatArgumentType.getFloat((CommandContext)ctx, (String)"x");
            float ry = FloatArgumentType.getFloat((CommandContext)ctx, (String)"y");
            float rz = FloatArgumentType.getFloat((CommandContext)ctx, (String)"z");
            BlueprintMeshBuilder.setRotation(rx, ry, rz);
            ClientTuningCommands.STATE.rotX = rx;
            ClientTuningCommands.STATE.rotY = ry;
            ClientTuningCommands.STATE.rotZ = rz;
            ClientTuningCommands.logAndToast("Set ROT \u2192 " + STATE.asLine());
            return 1;
        })))))).then(Commands.literal((String)"grip").then(Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)2.0f)).then(Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)2.0f)).then(Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)-1.0f, (float)2.0f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            float gx = FloatArgumentType.getFloat((CommandContext)ctx, (String)"x");
            float gy = FloatArgumentType.getFloat((CommandContext)ctx, (String)"y");
            float gz = FloatArgumentType.getFloat((CommandContext)ctx, (String)"z");
            BlueprintMeshBuilder.setGrip(gx, gy, gz);
            ClientTuningCommands.STATE.gripX = gx;
            ClientTuningCommands.STATE.gripY = gy;
            ClientTuningCommands.STATE.gripZ = gz;
            ClientTuningCommands.logAndToast("Set GRIP \u2192 " + STATE.asLine());
            return 1;
        })))))).then(Commands.literal((String)"thick").then(Commands.argument((String)"t", (ArgumentType)FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            float t = FloatArgumentType.getFloat((CommandContext)ctx, (String)"t");
            BlueprintMeshBuilder.setThickness(t);
            ClientTuningCommands.STATE.thickness = t;
            ClientTuningCommands.logAndToast("Set THICK \u2192 " + STATE.asLine());
            return 1;
        })))).then(Commands.literal((String)"cell").then(Commands.argument((String)"s", (ArgumentType)FloatArgumentType.floatArg((float)0.01f, (float)64.0f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            float s = FloatArgumentType.getFloat((CommandContext)ctx, (String)"s");
            BlueprintMeshBuilder.setCellSize(s);
            ClientTuningCommands.STATE.cellSize = s;
            ClientTuningCommands.logAndToast("Set CELL \u2192 " + STATE.asLine());
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"ghost").then(Commands.literal((String)"on").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintMeshBuilder.setGhost(true);
            ClientTuningCommands.STATE.ghost = true;
            ClientTuningCommands.logAndToast("Ghost ON \u2192 " + STATE.asLine());
            return 1;
        }))).then(Commands.literal((String)"off").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintMeshBuilder.setGhost(false);
            ClientTuningCommands.STATE.ghost = false;
            ClientTuningCommands.logAndToast("Ghost OFF \u2192 " + STATE.asLine());
            return 1;
        })))).then(Commands.literal((String)"print").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintMeshBuilder.printToLog("cmd/print");
            ClientTuningCommands.logAndToast("STATE \u2192 " + STATE.asLine());
            return 1;
        }))).then(Commands.literal((String)"reset").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintMeshBuilder.resetTuning();
            STATE.reset();
            ClientTuningCommands.logAndToast("RESET \u2192 " + STATE.asLine());
            return 1;
        }));
        dispatcher.register(root);
        LiteralArgumentBuilder head = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"wchead").then(Commands.literal((String)"rot").then(Commands.argument((String)"yaw", (ArgumentType)FloatArgumentType.floatArg((float)-720.0f, (float)720.0f)).then(Commands.argument((String)"pitch", (ArgumentType)FloatArgumentType.floatArg((float)-90.0f, (float)90.0f)).then(Commands.argument((String)"roll", (ArgumentType)FloatArgumentType.floatArg((float)-720.0f, (float)720.0f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.CAM_YAW_DEG = FloatArgumentType.getFloat((CommandContext)ctx, (String)"yaw");
            BlueprintCompanionHead.CAM_PITCH_DEG = FloatArgumentType.getFloat((CommandContext)ctx, (String)"pitch");
            BlueprintCompanionHead.CAM_ROLL_DEG = FloatArgumentType.getFloat((CommandContext)ctx, (String)"roll");
            ClientTuningCommands.logAndToast(String.format("Head ROT \u2192 cam(yaw=%.1f pitch=%.1f) roll=%.1f", Float.valueOf(BlueprintCompanionHead.CAM_YAW_DEG), Float.valueOf(BlueprintCompanionHead.CAM_PITCH_DEG), Float.valueOf(BlueprintCompanionHead.CAM_ROLL_DEG)));
            return 1;
        })))))).then(Commands.literal((String)"look").then(Commands.argument((String)"headYaw", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).then(Commands.argument((String)"headPitch", (ArgumentType)FloatArgumentType.floatArg((float)-89.9f, (float)89.9f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.HEAD_YAW_DEG_ADJ = FloatArgumentType.getFloat((CommandContext)ctx, (String)"headYaw");
            BlueprintCompanionHead.HEAD_PITCH_DEG_ADJ = FloatArgumentType.getFloat((CommandContext)ctx, (String)"headPitch");
            ClientTuningCommands.logAndToast(String.format("Head LOOK \u2192 headYaw=%.1f headPitch=%.1f", Float.valueOf(BlueprintCompanionHead.HEAD_YAW_DEG_ADJ), Float.valueOf(BlueprintCompanionHead.HEAD_PITCH_DEG_ADJ)));
            return 1;
        }))))).then(Commands.literal((String)"body").then(Commands.argument((String)"bodyYaw", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.BODY_YAW_DEG_ADJ = FloatArgumentType.getFloat((CommandContext)ctx, (String)"bodyYaw");
            ClientTuningCommands.logAndToast(String.format("Head BODY \u2192 bodyYawAdj=%.1f", Float.valueOf(BlueprintCompanionHead.BODY_YAW_DEG_ADJ)));
            return 1;
        })))).then(Commands.literal((String)"pose").then(Commands.argument((String)"bodyYaw", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).then(Commands.argument((String)"headYaw", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).then(Commands.argument((String)"headPitch", (ArgumentType)FloatArgumentType.floatArg((float)-89.9f, (float)89.9f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.EXTRA_BODY_YAW_DEG = FloatArgumentType.getFloat((CommandContext)ctx, (String)"bodyYaw");
            BlueprintCompanionHead.EXTRA_HEAD_YAW_DEG = FloatArgumentType.getFloat((CommandContext)ctx, (String)"headYaw");
            BlueprintCompanionHead.EXTRA_HEAD_PITCH_DEG = FloatArgumentType.getFloat((CommandContext)ctx, (String)"headPitch");
            ClientTuningCommands.logAndToast(String.format("Head POSE \u2192 bodyYaw=%.1f headYaw=%.1f headPitch=%.1f", Float.valueOf(BlueprintCompanionHead.EXTRA_BODY_YAW_DEG), Float.valueOf(BlueprintCompanionHead.EXTRA_HEAD_YAW_DEG), Float.valueOf(BlueprintCompanionHead.EXTRA_HEAD_PITCH_DEG)));
            return 1;
        })))))).then(Commands.literal((String)"offset").then(Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)-500.0f, (float)500.0f)).then(Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)-500.0f, (float)500.0f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.SCREEN_OFFSET_X = FloatArgumentType.getFloat((CommandContext)ctx, (String)"x");
            BlueprintCompanionHead.SCREEN_OFFSET_Y = FloatArgumentType.getFloat((CommandContext)ctx, (String)"y");
            ClientTuningCommands.logAndToast(String.format("Head OFFSET \u2192 x=%.1f y=%.1f", Float.valueOf(BlueprintCompanionHead.SCREEN_OFFSET_X), Float.valueOf(BlueprintCompanionHead.SCREEN_OFFSET_Y)));
            return 1;
        }))))).then(Commands.literal((String)"boxoffset").then(Commands.argument((String)"x", (ArgumentType)IntegerArgumentType.integer((int)-2000, (int)2000)).then(Commands.argument((String)"y", (ArgumentType)IntegerArgumentType.integer((int)-2000, (int)2000)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.BOX_OFFSET_X = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"x");
            BlueprintCompanionHead.BOX_OFFSET_Y = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"y");
            ClientTuningCommands.logAndToast(String.format("Head BOX_OFFSET \u2192 x=%d y=%d", BlueprintCompanionHead.BOX_OFFSET_X, BlueprintCompanionHead.BOX_OFFSET_Y));
            return 1;
        }))))).then(Commands.literal((String)"sizefrac").then(Commands.argument((String)"f", (ArgumentType)FloatArgumentType.floatArg((float)0.2f, (float)1.5f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.SIZE_FRACTION = FloatArgumentType.getFloat((CommandContext)ctx, (String)"f");
            ClientTuningCommands.logAndToast(String.format("Head SIZE_FRACTION \u2192 %.2f", Float.valueOf(BlueprintCompanionHead.SIZE_FRACTION)));
            return 1;
        })))).then(Commands.literal((String)"boxscale").then(Commands.argument((String)"s", (ArgumentType)FloatArgumentType.floatArg((float)0.2f, (float)2.0f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.BOX_SCALE = FloatArgumentType.getFloat((CommandContext)ctx, (String)"s");
            ClientTuningCommands.logAndToast(String.format("Head BOX_SCALE \u2192 %.2f", Float.valueOf(BlueprintCompanionHead.BOX_SCALE)));
            return 1;
        })))).then(Commands.literal((String)"margin").then(Commands.argument((String)"px", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.MARGIN_PX = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"px");
            ClientTuningCommands.logAndToast("Head MARGIN_PX \u2192 " + BlueprintCompanionHead.MARGIN_PX);
            return 1;
        })))).then(Commands.literal((String)"pad").then(Commands.argument((String)"px", (ArgumentType)IntegerArgumentType.integer((int)0, (int)200)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.BACKDROP_PAD = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"px");
            ClientTuningCommands.logAndToast("Head BACKDROP_PAD \u2192 " + BlueprintCompanionHead.BACKDROP_PAD);
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"crop").then(Commands.literal((String)"on").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.CROP_TO_BOX = true;
            ClientTuningCommands.logAndToast("Head CROP \u2192 ON");
            return 1;
        }))).then(Commands.literal((String)"off").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.CROP_TO_BOX = false;
            ClientTuningCommands.logAndToast("Head CROP \u2192 OFF");
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"backdrop").then(Commands.literal((String)"on").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.SHOW_BACKDROP = true;
            ClientTuningCommands.logAndToast("Head BACKDROP \u2192 ON");
            return 1;
        }))).then(Commands.literal((String)"off").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.SHOW_BACKDROP = false;
            ClientTuningCommands.logAndToast("Head BACKDROP \u2192 OFF");
            return 1;
        })))).then(((LiteralArgumentBuilder)Commands.literal((String)"lockface").then(Commands.literal((String)"on").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.ABSOLUTE_FACE = true;
            ClientTuningCommands.logAndToast("Head LOCKFACE \u2192 ON (face independent of in-world look)");
            return 1;
        }))).then(Commands.literal((String)"off").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.ABSOLUTE_FACE = false;
            ClientTuningCommands.logAndToast("Head LOCKFACE \u2192 OFF (additive to in-world look)");
            return 1;
        })))).then(Commands.literal((String)"arm").then(Commands.argument((String)"x", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).then(Commands.argument((String)"y", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).then(Commands.argument((String)"z", (ArgumentType)FloatArgumentType.floatArg((float)-360.0f, (float)360.0f)).executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.ARM_X_DEG = FloatArgumentType.getFloat((CommandContext)ctx, (String)"x");
            BlueprintCompanionHead.ARM_Y_DEG = FloatArgumentType.getFloat((CommandContext)ctx, (String)"y");
            BlueprintCompanionHead.ARM_Z_DEG = FloatArgumentType.getFloat((CommandContext)ctx, (String)"z");
            ClientTuningCommands.logAndToast(String.format("Head ARM \u2192 right(x=%.1f, y=%.1f, z=%.1f)", Float.valueOf(BlueprintCompanionHead.ARM_X_DEG), Float.valueOf(BlueprintCompanionHead.ARM_Y_DEG), Float.valueOf(BlueprintCompanionHead.ARM_Z_DEG)));
            return 1;
        })))))).then(Commands.literal((String)"armon").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.ARM_ENABLED = true;
            ClientTuningCommands.logAndToast("Head ARM \u2192 ON");
            return 1;
        }))).then(Commands.literal((String)"armoff").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.ARM_ENABLED = false;
            ClientTuningCommands.logAndToast("Head ARM \u2192 OFF");
            return 1;
        }))).then(Commands.literal((String)"print").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            ClientTuningCommands.logAndToast(String.format("Head STATE \u2192 cam(yaw=%.1f pitch=%.1f) roll=%.1f | absFace=%s headAdj(yaw=%.1f pitch=%.1f) bodyAdj=%.1f | offset(%.1f, %.1f) boxScale=%.2f boxOffset=(%d,%d) margin=%d pad=%d crop=%s backdrop=%s sizeFrac=%.2f bobAmp=%.1f | armEnabled=%s armDeg(%.1f, %.1f, %.1f)", Float.valueOf(BlueprintCompanionHead.CAM_YAW_DEG), Float.valueOf(BlueprintCompanionHead.CAM_PITCH_DEG), Float.valueOf(BlueprintCompanionHead.CAM_ROLL_DEG), BlueprintCompanionHead.ABSOLUTE_FACE, Float.valueOf(BlueprintCompanionHead.HEAD_YAW_DEG_ADJ), Float.valueOf(BlueprintCompanionHead.HEAD_PITCH_DEG_ADJ), Float.valueOf(BlueprintCompanionHead.BODY_YAW_DEG_ADJ), Float.valueOf(BlueprintCompanionHead.SCREEN_OFFSET_X), Float.valueOf(BlueprintCompanionHead.SCREEN_OFFSET_Y), Float.valueOf(BlueprintCompanionHead.BOX_SCALE), BlueprintCompanionHead.BOX_OFFSET_X, BlueprintCompanionHead.BOX_OFFSET_Y, BlueprintCompanionHead.MARGIN_PX, BlueprintCompanionHead.BACKDROP_PAD, BlueprintCompanionHead.CROP_TO_BOX, BlueprintCompanionHead.SHOW_BACKDROP, Float.valueOf(BlueprintCompanionHead.SIZE_FRACTION), Float.valueOf(BlueprintCompanionHead.BOB_AMPLITUDE_PX), BlueprintCompanionHead.ARM_ENABLED, Float.valueOf(BlueprintCompanionHead.ARM_X_DEG), Float.valueOf(BlueprintCompanionHead.ARM_Y_DEG), Float.valueOf(BlueprintCompanionHead.ARM_Z_DEG)));
            return 1;
        }))).then(Commands.literal((String)"reset").executes(ctx -> {
            if (!ClientTuningCommands.requireOp()) {
                return 0;
            }
            BlueprintCompanionHead.CAM_YAW_DEG = 0.0f;
            BlueprintCompanionHead.CAM_PITCH_DEG = 0.0f;
            BlueprintCompanionHead.CAM_ROLL_DEG = 0.0f;
            BlueprintCompanionHead.EXTRA_BODY_YAW_DEG = 12.0f;
            BlueprintCompanionHead.EXTRA_HEAD_YAW_DEG = 18.0f;
            BlueprintCompanionHead.EXTRA_HEAD_PITCH_DEG = -12.0f;
            BlueprintCompanionHead.HEAD_YAW_DEG_ADJ = -5.0f;
            BlueprintCompanionHead.HEAD_PITCH_DEG_ADJ = 0.0f;
            BlueprintCompanionHead.BODY_YAW_DEG_ADJ = 0.0f;
            BlueprintCompanionHead.SIZE_FRACTION = 0.9f;
            BlueprintCompanionHead.BOX_SCALE = 0.6f;
            BlueprintCompanionHead.MARGIN_PX = 10;
            BlueprintCompanionHead.BACKDROP_PAD = 6;
            BlueprintCompanionHead.SHOW_BACKDROP = true;
            BlueprintCompanionHead.CROP_TO_BOX = true;
            BlueprintCompanionHead.SCREEN_OFFSET_X = 0.0f;
            BlueprintCompanionHead.SCREEN_OFFSET_Y = 200.0f;
            BlueprintCompanionHead.BOX_OFFSET_X = 0;
            BlueprintCompanionHead.BOX_OFFSET_Y = -150;
            BlueprintCompanionHead.BOB_AMPLITUDE_PX = 0.0f;
            BlueprintCompanionHead.ABSOLUTE_FACE = true;
            BlueprintCompanionHead.ARM_ENABLED = true;
            BlueprintCompanionHead.ARM_X_DEG = -40.0f;
            BlueprintCompanionHead.ARM_Y_DEG = 20.0f;
            BlueprintCompanionHead.ARM_Z_DEG = 10.0f;
            ClientTuningCommands.logAndToast("Head RESET \u2192 defaults (abs face ON, bob OFF, arm pose ON)");
            return 1;
        }));
        dispatcher.register(head);
    }

    private static boolean requireOp() {
        Minecraft mc = Minecraft.getInstance();
        if (mc == null || mc.player == null) {
            return false;
        }
        boolean ok = mc.player.hasPermissions(2);
        if (!ok) {
            mc.player.displayClientMessage((Component)Component.literal((String)"[WeaponCraft] You must be an operator to use tuning commands."), false);
        }
        return ok;
    }

    private static void logAndToast(String msg) {
        Constants.LOG.info("[WeaponCraft] {}", (Object)msg);
        Minecraft mc = Minecraft.getInstance();
        if (mc != null && mc.player != null) {
            mc.player.displayClientMessage((Component)Component.literal((String)msg), false);
        }
    }

    public static final class State {
        public float rotX = 0.0f;
        public float rotY = 180.0f;
        public float rotZ = 0.0f;
        public float gripX = 0.175f;
        public float gripY = 0.115f;
        public float gripZ = 0.19f;
        public float thickness = 0.02f;
        public float cellSize = 3.0f;
        public boolean ghost = false;
        public boolean gizmo = false;

        public void reset() {
            this.rotX = 0.0f;
            this.rotY = 180.0f;
            this.rotZ = 0.0f;
            this.gripX = 0.175f;
            this.gripY = 0.115f;
            this.gripZ = 0.19f;
            this.thickness = 0.02f;
            this.cellSize = 3.0f;
            this.ghost = false;
            this.gizmo = false;
        }

        public String asLine() {
            return String.format("rot=(%.3f, %.3f, %.3f)  grip=(%.3f, %.3f, %.3f)  thick=%.5f  cell=%.4f  ghost=%s gizmo=%s", Float.valueOf(this.rotX), Float.valueOf(this.rotY), Float.valueOf(this.rotZ), Float.valueOf(this.gripX), Float.valueOf(this.gripY), Float.valueOf(this.gripZ), Float.valueOf(this.thickness), Float.valueOf(this.cellSize), this.ghost, this.gizmo);
        }
    }
}

