/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.model;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.z2six.weaponcraft.features.rendering.BlueprintMeshBuilder;

public final class ForgedWeaponBakedModel
implements BakedModel {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final BakedModel base;
    private final ItemOverrides overrides;

    public ForgedWeaponBakedModel(BakedModel base, ModelBakery bakery) {
        this.base = base;
        this.overrides = new OverridesImpl(base);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.base.getQuads(state, side, rand);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
        return this.base.getQuads(state, side, rand, modelData, renderType);
    }

    public boolean useAmbientOcclusion() {
        return this.base.useAmbientOcclusion();
    }

    public boolean isGui3d() {
        return this.base.isGui3d();
    }

    public boolean usesBlockLight() {
        return this.base.usesBlockLight();
    }

    public boolean isCustomRenderer() {
        return false;
    }

    public TextureAtlasSprite getParticleIcon() {
        return this.base.getParticleIcon();
    }

    public ItemOverrides getOverrides() {
        return this.overrides;
    }

    private static final class OverridesImpl
    extends ItemOverrides {
        private static final ResourceLocation TEX_IRON = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"material/iron");
        private static final ResourceLocation TEX_GOLD = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"material/gold");
        private static final ResourceLocation TEX_DIAMOND = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"material/diamond");
        private static final ResourceLocation TEX_NETHERITE = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"material/netherite");
        private final Map<Long, BakedModel> cache = new ConcurrentHashMap<Long, BakedModel>();
        private final BakedModel fallback;

        private OverridesImpl(BakedModel fallback) {
            this.fallback = fallback;
        }

        private static float effectiveThickness(float factor) {
            float base;
            float f = base = BlueprintMeshBuilder.THICKNESS > 0.0f ? BlueprintMeshBuilder.THICKNESS : 0.0625f;
            if (factor <= 0.0f) {
                return base;
            }
            return base * factor;
        }

        public BakedModel resolve(BakedModel original, ItemStack stack, @Nullable ClientLevel level, @Nullable LivingEntity entity, int seed) {
            boolean layered;
            int ay;
            CompoundTag bp = OverridesImpl.tryGetBlueprint(stack);
            if (bp == null) {
                return this.fallback;
            }
            int w = bp.getInt("w");
            int h = bp.getInt("h");
            int ds = bp.contains("detailScale") ? Math.max(1, bp.getInt("detailScale")) : 1;
            int ax = bp.contains("ax") ? bp.getInt("ax") : -1;
            int n = ay = bp.contains("ay") ? bp.getInt("ay") : -1;
            if (w <= 0 || h <= 0) {
                return this.fallback;
            }
            LayerData layers = OverridesImpl.readLayersIfPresent(bp, w, h, ds);
            boolean bl = layered = layers != null && layers.hasAnyLayer();
            int bpHash = layered ? OverridesImpl.hashBlueprintLayers(layers, w, h, ds, ax, ay) : OverridesImpl.hashBlueprint(layers != null ? layers.singleMaterials : null, layers != null ? layers.singleColors : null, w, h, ds, ax, ay, layers != null ? layers.singleThickness : 0.0f);
            int mutVer = BlueprintMeshBuilder.mutationVersion();
            long key = (long)mutVer << 32 ^ (long)bpHash & 0xFFFFFFFFL;
            boolean fLayered = layered;
            LayerData fLayers = layers;
            int fW = w;
            int fH = h;
            int fDs = ds;
            int fAx = ax;
            int fAy = ay;
            return this.cache.computeIfAbsent(key, k -> {
                List<BakedQuad> quads;
                ModelManager mm = Minecraft.getInstance().getModelManager();
                TextureAtlas atlas = mm.getAtlas(TextureAtlas.LOCATION_BLOCKS);
                TextureAtlasSprite[] table = new TextureAtlasSprite[5];
                table[1] = atlas.getSprite(TEX_IRON);
                table[2] = atlas.getSprite(TEX_GOLD);
                table[3] = atlas.getSprite(TEX_DIAMOND);
                table[4] = atlas.getSprite(TEX_NETHERITE);
                TextureAtlasSprite particle = OverridesImpl.firstNonNull(table);
                if (particle == null) {
                    particle = this.fallback.getParticleIcon();
                }
                if (fLayered) {
                    quads = BlueprintMeshBuilder.buildFine3(fLayers.left, fLayers.middle, fLayers.right, fW, fH, fDs, table, fAx, fAy, fLayers.colorsLeft, fLayers.colorsMiddle, fLayers.colorsRight, OverridesImpl.effectiveThickness(fLayers.tL), OverridesImpl.effectiveThickness(fLayers.tM), OverridesImpl.effectiveThickness(fLayers.tR));
                } else {
                    byte[][] mats = fLayers != null ? fLayers.singleMaterials : OverridesImpl.readMaterialsSingle(bp, fW, fH, fDs);
                    int[][] cols = fLayers != null ? fLayers.singleColors : OverridesImpl.readColorsSingle(bp, fW, fH, fDs);
                    quads = fLayers != null && fLayers.singleThickness > 0.0f ? BlueprintMeshBuilder.buildFine3(null, mats, null, fW, fH, fDs, table, fAx, fAy, null, cols, null, 0.0f, OverridesImpl.effectiveThickness(fLayers.singleThickness), 0.0f) : BlueprintMeshBuilder.buildFine(mats, fW, fH, fDs, table, fAx, fAy, cols);
                }
                return new StaticItemQuadsModel(this.fallback, particle, quads, (int)(k ^ k >>> 32));
            });
        }

        private static TextureAtlasSprite firstNonNull(TextureAtlasSprite[] arr) {
            if (arr == null) {
                return null;
            }
            for (int i = 1; i < arr.length; ++i) {
                if (arr[i] == null) continue;
                return arr[i];
            }
            return null;
        }

        private static CompoundTag tryGetBlueprint(ItemStack stack) {
            CustomData cd = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
            if (cd == null) {
                return null;
            }
            CompoundTag root = cd.copyTag();
            if (root == null) {
                return null;
            }
            if (root.contains("WeaponBlueprint")) {
                return root.getCompound("WeaponBlueprint");
            }
            if (root.contains("Blueprint")) {
                return root.getCompound("Blueprint");
            }
            return null;
        }

        private static byte[][] readMaterialsSingle(CompoundTag bp, int w, int h, int ds) {
            byte[][] grid;
            block4: {
                block3: {
                    int fw = w * ds;
                    int fh = h * ds;
                    grid = new byte[fh][fw];
                    if (!bp.contains("materials", 9)) break block3;
                    ListTag rows = bp.getList("materials", 10);
                    for (int y = 0; y < fh && y < rows.size(); ++y) {
                        CompoundTag rowTag = rows.getCompound(y);
                        ByteArrayTag ba = (ByteArrayTag)rowTag.get("r");
                        if (ba == null) continue;
                        byte[] row = ba.getAsByteArray();
                        System.arraycopy(row, 0, grid[y], 0, Math.min(row.length, fw));
                    }
                    break block4;
                }
                if (!bp.contains("rows", 9)) break block4;
                ListTag rows = bp.getList("rows", 10);
                for (int y = 0; y < h && y < rows.size(); ++y) {
                    CompoundTag rowTag = rows.getCompound(y);
                    byte[] row = rowTag.getByteArray("r");
                    for (int x = 0; x < Math.min(row.length, w); ++x) {
                        grid[y][x] = row[x] != 0 ? (byte)1 : 0;
                    }
                }
            }
            return grid;
        }

        private static int[][] readColorsSingle(CompoundTag bp, int w, int h, int ds) {
            if (!bp.contains("colors", 9)) {
                return null;
            }
            int fw = w * ds;
            int fh = h * ds;
            int[][] colors = new int[fh][fw];
            ListTag rows = bp.getList("colors", 10);
            for (int y = 0; y < fh && y < rows.size(); ++y) {
                CompoundTag rowTag = rows.getCompound(y);
                IntArrayTag ia = (IntArrayTag)rowTag.get("c");
                if (ia == null) continue;
                int[] arr = ia.getAsIntArray();
                System.arraycopy(arr, 0, colors[y], 0, Math.min(arr.length, fw));
            }
            return colors;
        }

        private static LayerData readLayersIfPresent(CompoundTag bp, int w, int h, int ds) {
            boolean anyAlt;
            if (bp.contains("layers", 9)) {
                ListTag layers = bp.getList("layers", 10);
                byte[][] left = null;
                byte[][] mid = null;
                byte[][] right = null;
                int[][] cLeft = null;
                int[][] cMid = null;
                int[][] cRight = null;
                float tL = 0.0f;
                float tM = 0.0f;
                float tR = 0.0f;
                for (int i = 0; i < Math.min(3, layers.size()); ++i) {
                    CompoundTag lt = layers.getCompound(i);
                    byte[][] mats = OverridesImpl.readMaterialsFromTag(lt, w, h, ds);
                    int[][] cols = OverridesImpl.readColorsFromTag(lt, w, h, ds);
                    float thk = OverridesImpl.readThicknessFromLayerTag(lt);
                    if (i == 0) {
                        left = mats;
                        cLeft = cols;
                        tL = thk;
                    }
                    if (i == 1) {
                        mid = mats;
                        cMid = cols;
                        tM = thk;
                    }
                    if (i != 2) continue;
                    right = mats;
                    cRight = cols;
                    tR = thk;
                }
                if (!OverridesImpl.hasAnyLayer(left, mid, right)) {
                    return null;
                }
                float tL2 = OverridesImpl.readFloatIfPresent(bp, "thicknessL", 0.0f);
                float tM2 = OverridesImpl.readFloatIfPresent(bp, "thicknessM", 0.0f);
                float tR2 = OverridesImpl.readFloatIfPresent(bp, "thicknessR", 0.0f);
                if (tL2 > 0.0f) {
                    tL = tL2;
                }
                if (tM2 > 0.0f) {
                    tM = tM2;
                }
                if (tR2 > 0.0f) {
                    tR = tR2;
                }
                return new LayerData(left, mid, right, cLeft, cMid, cRight, null, null, tL, tM, tR, 0.0f);
            }
            boolean bl = anyAlt = bp.contains("materialsL", 9) || bp.contains("materialsM", 9) || bp.contains("materialsR", 9);
            if (anyAlt) {
                byte[][] left = OverridesImpl.readMaterialsByKey(bp, w, h, ds, "materialsL");
                byte[][] mid = OverridesImpl.readMaterialsByKey(bp, w, h, ds, "materialsM");
                byte[][] right = OverridesImpl.readMaterialsByKey(bp, w, h, ds, "materialsR");
                int[][] cLeft = OverridesImpl.readColorsByKey(bp, w, h, ds, "colorsL");
                int[][] cMid = OverridesImpl.readColorsByKey(bp, w, h, ds, "colorsM");
                int[][] cRight = OverridesImpl.readColorsByKey(bp, w, h, ds, "colorsR");
                if (!OverridesImpl.hasAnyLayer(left, mid, right)) {
                    return null;
                }
                float tL = OverridesImpl.readFloatIfPresent(bp, "thicknessL", 0.0f);
                float tM = OverridesImpl.readFloatIfPresent(bp, "thicknessM", 0.0f);
                float tR = OverridesImpl.readFloatIfPresent(bp, "thicknessR", 0.0f);
                return new LayerData(left, mid, right, cLeft, cMid, cRight, null, null, tL, tM, tR, 0.0f);
            }
            if (bp.contains("materials", 9) || bp.contains("rows", 9)) {
                byte[][] singleM = OverridesImpl.readMaterialsSingle(bp, w, h, ds);
                int[][] singleC = OverridesImpl.readColorsSingle(bp, w, h, ds);
                float t = OverridesImpl.readFloatIfPresent(bp, "thickness", 0.0f);
                return new LayerData(null, null, null, null, null, null, singleM, singleC, 0.0f, 0.0f, 0.0f, t);
            }
            return null;
        }

        private static boolean hasAnyLayer(byte[][] L, byte[][] M, byte[][] R) {
            return OverridesImpl.hasAnyFill(L) || OverridesImpl.hasAnyFill(M) || OverridesImpl.hasAnyFill(R);
        }

        private static boolean hasAnyFill(byte[][] grid) {
            if (grid == null) {
                return false;
            }
            byte[][] byArray = grid;
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                byte[] row;
                for (byte b : row = byArray[i]) {
                    if ((b & 0xFF) == 0) continue;
                    return true;
                }
            }
            return false;
        }

        private static byte[][] readMaterialsFromTag(CompoundTag tag, int w, int h, int ds) {
            int fw = w * ds;
            int fh = h * ds;
            byte[][] grid = new byte[fh][fw];
            if (tag.contains("materials", 9)) {
                ListTag rows = tag.getList("materials", 10);
                for (int y = 0; y < fh && y < rows.size(); ++y) {
                    CompoundTag rowTag = rows.getCompound(y);
                    ByteArrayTag ba = (ByteArrayTag)rowTag.get("r");
                    if (ba == null) continue;
                    byte[] row = ba.getAsByteArray();
                    System.arraycopy(row, 0, grid[y], 0, Math.min(row.length, fw));
                }
            }
            return grid;
        }

        private static int[][] readColorsFromTag(CompoundTag tag, int w, int h, int ds) {
            if (!tag.contains("colors", 9)) {
                return null;
            }
            int fw = w * ds;
            int fh = h * ds;
            int[][] colors = new int[fh][fw];
            ListTag rows = tag.getList("colors", 10);
            for (int y = 0; y < fh && y < rows.size(); ++y) {
                CompoundTag rowTag = rows.getCompound(y);
                IntArrayTag ia = (IntArrayTag)rowTag.get("c");
                if (ia == null) continue;
                int[] arr = ia.getAsIntArray();
                System.arraycopy(arr, 0, colors[y], 0, Math.min(arr.length, fw));
            }
            return colors;
        }

        private static byte[][] readMaterialsByKey(CompoundTag bp, int w, int h, int ds, String key) {
            if (!bp.contains(key, 9)) {
                return new byte[h * ds][w * ds];
            }
            CompoundTag tmp = new CompoundTag();
            tmp.put("materials", (Tag)bp.getList(key, 10));
            return OverridesImpl.readMaterialsFromTag(tmp, w, h, ds);
        }

        private static int[][] readColorsByKey(CompoundTag bp, int w, int h, int ds, String key) {
            if (!bp.contains(key, 9)) {
                return null;
            }
            CompoundTag tmp = new CompoundTag();
            tmp.put("colors", (Tag)bp.getList(key, 10));
            return OverridesImpl.readColorsFromTag(tmp, w, h, ds);
        }

        private static float readThicknessFromLayerTag(CompoundTag layerTag) {
            if (layerTag.contains("thickness")) {
                return layerTag.getFloat("thickness");
            }
            if (layerTag.contains("t")) {
                return layerTag.getFloat("t");
            }
            return 0.0f;
        }

        private static float readFloatIfPresent(CompoundTag tag, String key, float def) {
            return tag.contains(key) ? tag.getFloat(key) : def;
        }

        private static int hashBlueprint(byte[][] materials, int[][] colors, int w, int h, int ds, int ax, int ay, float thickness) {
            int hsh = 1;
            hsh = 31 * hsh + w;
            hsh = 31 * hsh + h;
            hsh = 31 * hsh + ds;
            hsh = 31 * hsh + ax;
            hsh = 31 * hsh + ay;
            hsh = 31 * hsh + Float.floatToIntBits(thickness);
            int fh = h * ds;
            if (materials != null) {
                for (int y = 0; y < fh; ++y) {
                    hsh = 31 * hsh + Arrays.hashCode(materials[y]);
                    if (colors == null) continue;
                    hsh = 31 * hsh + Arrays.hashCode(colors[y]);
                }
            }
            return hsh;
        }

        private static int hashBlueprintLayers(LayerData ld, int w, int h, int ds, int ax, int ay) {
            int y;
            int hsh = 1;
            hsh = 31 * hsh + w;
            hsh = 31 * hsh + h;
            hsh = 31 * hsh + ds;
            hsh = 31 * hsh + ax;
            hsh = 31 * hsh + ay;
            hsh = 31 * hsh + Float.floatToIntBits(ld.tL);
            hsh = 31 * hsh + Float.floatToIntBits(ld.tM);
            hsh = 31 * hsh + Float.floatToIntBits(ld.tR);
            int fh = h * ds;
            if (ld.left != null) {
                for (y = 0; y < fh; ++y) {
                    hsh = 31 * hsh + Arrays.hashCode(ld.left[y]);
                }
                if (ld.colorsLeft != null) {
                    for (y = 0; y < fh; ++y) {
                        hsh = 31 * hsh + Arrays.hashCode(ld.colorsLeft[y]);
                    }
                }
            }
            if (ld.middle != null) {
                for (y = 0; y < fh; ++y) {
                    hsh = 31 * hsh + Arrays.hashCode(ld.middle[y]);
                }
                if (ld.colorsMiddle != null) {
                    for (y = 0; y < fh; ++y) {
                        hsh = 31 * hsh + Arrays.hashCode(ld.colorsMiddle[y]);
                    }
                }
            }
            if (ld.right != null) {
                for (y = 0; y < fh; ++y) {
                    hsh = 31 * hsh + Arrays.hashCode(ld.right[y]);
                }
                if (ld.colorsRight != null) {
                    for (y = 0; y < fh; ++y) {
                        hsh = 31 * hsh + Arrays.hashCode(ld.colorsRight[y]);
                    }
                }
            }
            return hsh;
        }

        private static final class LayerData {
            final byte[][] left;
            final byte[][] middle;
            final byte[][] right;
            final int[][] colorsLeft;
            final int[][] colorsMiddle;
            final int[][] colorsRight;
            final byte[][] singleMaterials;
            final int[][] singleColors;
            final float tL;
            final float tM;
            final float tR;
            final float singleThickness;

            LayerData(byte[][] left, byte[][] middle, byte[][] right, int[][] colorsLeft, int[][] colorsMiddle, int[][] colorsRight, byte[][] singleMaterials, int[][] singleColors, float tL, float tM, float tR, float singleThickness) {
                this.left = left;
                this.middle = middle;
                this.right = right;
                this.colorsLeft = colorsLeft;
                this.colorsMiddle = colorsMiddle;
                this.colorsRight = colorsRight;
                this.singleMaterials = singleMaterials;
                this.singleColors = singleColors;
                this.tL = tL;
                this.tM = tM;
                this.tR = tR;
                this.singleThickness = singleThickness;
            }

            boolean hasAnyLayer() {
                return OverridesImpl.hasAnyFill(this.left) || OverridesImpl.hasAnyFill(this.middle) || OverridesImpl.hasAnyFill(this.right);
            }
        }
    }

    private static final class StaticItemQuadsModel
    implements BakedModel {
        private final BakedModel fallback;
        private final TextureAtlasSprite particle;
        private final List<BakedQuad> quads;
        private final int dbgHash;

        private StaticItemQuadsModel(BakedModel fallback, TextureAtlasSprite particle, List<BakedQuad> quads, int dbgHash) {
            this.fallback = fallback;
            this.particle = particle;
            this.quads = List.copyOf(quads);
            this.dbgHash = dbgHash;
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
            if (side == null) {
                return this.quads;
            }
            return Collections.emptyList();
        }

        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, RandomSource rand, ModelData modelData, @Nullable RenderType renderType) {
            if (side == null) {
                return this.quads;
            }
            return Collections.emptyList();
        }

        public List<RenderType> getRenderTypes(ItemStack stack, boolean fabulous) {
            RenderType nocull = RenderType.entityCutoutNoCull((ResourceLocation)TextureAtlas.LOCATION_BLOCKS);
            return List.of(nocull);
        }

        public boolean useAmbientOcclusion() {
            return this.fallback.useAmbientOcclusion();
        }

        public boolean isGui3d() {
            return this.fallback.isGui3d();
        }

        public boolean usesBlockLight() {
            return this.fallback.usesBlockLight();
        }

        public boolean isCustomRenderer() {
            return false;
        }

        public TextureAtlasSprite getParticleIcon() {
            return this.particle != null ? this.particle : this.fallback.getParticleIcon();
        }

        public ItemOverrides getOverrides() {
            return ItemOverrides.EMPTY;
        }
    }
}

