/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.model;

import com.mojang.logging.LogUtils;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ModelEvent;
import org.slf4j.Logger;
import org.z2six.weaponcraft.features.model.ForgedWeaponBakedModel;

@EventBusSubscriber(modid="weaponcraft", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.MOD)
public final class ModelBakeHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    private ModelBakeHandler() {
    }

    @SubscribeEvent
    public static void onModifyBaking(ModelEvent.ModifyBakingResult e) {
        ResourceLocation myId = ResourceLocation.fromNamespaceAndPath((String)"weaponcraft", (String)"forged_weapon");
        ModelResourceLocation myMrl = new ModelResourceLocation(myId, "inventory");
        BakedModel original = (BakedModel)e.getModels().get(myMrl);
        if (original == null) {
            LOGGER.warn("[WeaponCraft] ModelBakeHandler: missing baked model {}", (Object)myMrl);
            return;
        }
        ForgedWeaponBakedModel wrapped = new ForgedWeaponBakedModel(original, e.getModelBakery());
        e.getModels().put(myMrl, wrapped);
        LOGGER.info("[WeaponCraft] ModelBakeHandler: wrapped baked model for {}", (Object)myMrl);
    }
}

