/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.net;

import com.mojang.logging.LogUtils;
import java.util.Locale;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import org.slf4j.Logger;
import org.z2six.weaponcraft.config.BlueprintConfig;
import org.z2six.weaponcraft.config.feature.BalanceConfig;
import org.z2six.weaponcraft.content.ModItems;
import org.z2six.weaponcraft.core.Constants;
import org.z2six.weaponcraft.features.blueprint.stats.BlueprintMetrics;
import org.z2six.weaponcraft.features.blueprint.stats.BlueprintStatCalculator;
import org.z2six.weaponcraft.features.blueprint.stats.NameGenerator;
import org.z2six.weaponcraft.features.blueprint.stats.StatResult;
import org.z2six.weaponcraft.features.blueprint.validation.ConnectedShapeValidator;
import org.z2six.weaponcraft.features.net.client.ClientConfigMirror;
import org.z2six.weaponcraft.features.net.client.ClientPackets;
import org.z2six.weaponcraft.features.net.payload.BlueprintMintResultPayload;
import org.z2six.weaponcraft.features.net.payload.RequestBlueprintConfigPayload;
import org.z2six.weaponcraft.features.net.payload.RequestBlueprintItemPayload;
import org.z2six.weaponcraft.features.net.payload.RequestForgeWeaponPayload;
import org.z2six.weaponcraft.features.net.payload.ServerBalanceConfigPayload;
import org.z2six.weaponcraft.features.net.payload.ServerBlueprintConfigPayload;
import org.z2six.weaponcraft.features.rendering.util.BitmapPayload;

@EventBusSubscriber(modid="weaponcraft", bus=EventBusSubscriber.Bus.MOD)
public final class Networking {
    private static final Logger LOGGER = LogUtils.getLogger();

    private Networking() {
    }

    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent e) {
        e.registrar("weaponcraft").versioned("1").playToServer(RequestBlueprintItemPayload.TYPE, RequestBlueprintItemPayload.CODEC, (payload, ctx) -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                LOGGER.info("[WeaponCraft] Net: RequestBlueprintItemPayload from {}", (Object)sp.getGameProfile().getName());
                CompoundTag bp = payload.tag();
                ValidationResult vr = Networking.validateBlueprint(bp);
                if (!vr.ok) {
                    LOGGER.info("[WeaponCraft] Net: Mint rejected: {}", (Object)vr.reason);
                    ctx.reply((CustomPacketPayload)new BlueprintMintResultPayload(false, vr.reason));
                    return;
                }
                BalanceConfig bc = BalanceConfig.get();
                BitmapPayload payloadObj = BitmapPayload.fromNBT(bp);
                float tL = bp.contains("thicknessL") ? bp.getFloat("thicknessL") : bc.defaultCellThicknessL;
                float tM = bp.contains("thicknessM") ? bp.getFloat("thicknessM") : bc.defaultCellThicknessM;
                float tR = bp.contains("thicknessR") ? bp.getFloat("thicknessR") : bc.defaultCellThicknessR;
                try {
                    tL = Mth.clamp((float)tL, (float)bc.minCellThickness, (float)bc.maxCellThicknessL);
                    tM = Mth.clamp((float)tM, (float)bc.minCellThickness, (float)bc.maxCellThicknessM);
                    tR = Mth.clamp((float)tR, (float)bc.minCellThickness, (float)bc.maxCellThicknessR);
                }
                catch (Throwable ignore) {
                    tL = Math.max(bc.minCellThickness, Math.min(tL, bc.maxCellThicknessL));
                    tM = Math.max(bc.minCellThickness, Math.min(tM, bc.maxCellThicknessM));
                    tR = Math.max(bc.minCellThickness, Math.min(tR, bc.maxCellThicknessR));
                }
                StatResult sr = BlueprintStatCalculator.compute(payloadObj, bc);
                Networking.writeStatsToNbt(bp, sr, payloadObj, bc, tL, tM, tR);
                String autoName = NameGenerator.autoName(payloadObj, sr);
                String customName = bp.contains("CustomName") ? bp.getString("CustomName") : "";
                String displayName = NameGenerator.mergedDisplayName(customName, autoName);
                bp.putString("AutoName", autoName);
                bp.putString("CustomName", customName);
                bp.putString("DisplayName", displayName);
                ItemStack stack = new ItemStack((ItemLike)ModItems.BLUEPRINT.get());
                CompoundTag root = new CompoundTag();
                root.put("Blueprint", (Tag)bp.copy());
                stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
                stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)displayName));
                if (!sp.getInventory().add(stack)) {
                    sp.drop(stack, false);
                }
                String layerInfo = Networking.describeLayering(bp);
                LOGGER.info("[WeaponCraft] Net: Minted blueprint item {} (w={}, h={}, ds={})", new Object[]{layerInfo, bp.getInt("w"), bp.getInt("h"), bp.getInt("detailScale")});
                ctx.reply((CustomPacketPayload)new BlueprintMintResultPayload(true, "Blueprint accepted"));
            }
        });
        e.registrar("weaponcraft").versioned("1").playToServer(RequestForgeWeaponPayload.TYPE, RequestForgeWeaponPayload.CODEC, (payload, ctx) -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sp = (ServerPlayer)patt0$temp;
                LOGGER.info("[WeaponCraft] Net: RequestForgeWeaponPayload from {}", (Object)sp.getGameProfile().getName());
                CompoundTag bp = payload.tag().copy();
                ValidationResult vr = Networking.validateBlueprint(bp);
                if (!vr.ok) {
                    LOGGER.info("[WeaponCraft] Net: Forge rejected: {}", (Object)vr.reason());
                    ctx.reply((CustomPacketPayload)new BlueprintMintResultPayload(false, "Forge rejected: " + vr.reason()));
                    return;
                }
                Networking.embedPerCellColorsServer(bp);
                BalanceConfig bc = BalanceConfig.get();
                BitmapPayload payloadObj = BitmapPayload.fromNBT(bp);
                float tL = bp.contains("thicknessL") ? bp.getFloat("thicknessL") : bc.defaultCellThicknessL;
                float tM = bp.contains("thicknessM") ? bp.getFloat("thicknessM") : bc.defaultCellThicknessM;
                float tR = bp.contains("thicknessR") ? bp.getFloat("thicknessR") : bc.defaultCellThicknessR;
                try {
                    tL = Mth.clamp((float)tL, (float)bc.minCellThickness, (float)bc.maxCellThicknessL);
                    tM = Mth.clamp((float)tM, (float)bc.minCellThickness, (float)bc.maxCellThicknessM);
                    tR = Mth.clamp((float)tR, (float)bc.minCellThickness, (float)bc.maxCellThicknessR);
                }
                catch (Throwable ignore) {
                    tL = Math.max(bc.minCellThickness, Math.min(tL, bc.maxCellThicknessL));
                    tM = Math.max(bc.minCellThickness, Math.min(tM, bc.maxCellThicknessM));
                    tR = Math.max(bc.minCellThickness, Math.min(tR, bc.maxCellThicknessR));
                }
                StatResult sr = BlueprintStatCalculator.compute(payloadObj, bc);
                Networking.writeStatsToNbt(bp, sr, payloadObj, bc, tL, tM, tR);
                String autoName = NameGenerator.autoName(payloadObj, sr);
                String customName = bp.contains("CustomName") ? bp.getString("CustomName") : "";
                String displayName = NameGenerator.mergedDisplayName(customName, autoName);
                bp.putString("AutoName", autoName);
                bp.putString("CustomName", customName);
                bp.putString("DisplayName", displayName);
                ItemStack sword = new ItemStack((ItemLike)ModItems.FORGED_WEAPON.get());
                CompoundTag root = new CompoundTag();
                root.put("WeaponBlueprint", (Tag)bp);
                ItemAttributeModifiers itemMods = Networking.buildModifiersFromStats(sr, payloadObj, bc, tL, tM, tR);
                sword.set(DataComponents.ATTRIBUTE_MODIFIERS, (Object)itemMods);
                sword.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)displayName));
                sword.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)root));
                if (!sp.getInventory().add(sword)) {
                    sp.drop(sword, false);
                }
                String layerInfo = Networking.describeLayering(bp);
                LOGGER.info("[WeaponCraft] Net: Forged weapon item {} (w={}, h={}, ds={})", new Object[]{layerInfo, bp.getInt("w"), bp.getInt("h"), bp.getInt("detailScale")});
                ctx.reply((CustomPacketPayload)new BlueprintMintResultPayload(true, "Forged weapon accepted"));
            }
        });
        e.registrar("weaponcraft").versioned("1").playToServer(RequestBlueprintConfigPayload.TYPE, RequestBlueprintConfigPayload.CODEC, (payload, ctx) -> {
            int gw = BlueprintConfig.getMaxGridWidth();
            int gh = BlueprintConfig.getMaxGridHeight();
            LOGGER.info("[WeaponCraft] Net: Sending blueprint cfg to client: {}x{}", (Object)gw, (Object)gh);
            ctx.reply((CustomPacketPayload)new ServerBlueprintConfigPayload(gw, gh));
            BalanceConfig bc = BalanceConfig.get();
            ctx.reply((CustomPacketPayload)new ServerBalanceConfigPayload(bc.critEnabled, bc.critMultiplier, bc.weightIron, bc.weightGold, bc.weightDiamond, bc.weightNetherite, bc.costMulGlobal, bc.costMulIron, bc.costMulGold, bc.costMulDiamond, bc.costMulNetherite, bc.bonusPerCellSpeedGold, bc.bonusPerCellCritDiamond, bc.bonusPerCellDamageNetherite, bc.bonusPerCellKnockbackNetherite, bc.bonusPerCellDurabilityIron, bc.bonusCapSpeed, bc.bonusCapCrit, bc.bonusCapDamage, bc.bonusCapKnockback, bc.bonusCapDurability, bc.bonusDiminishK, bc.bonusLinearFrac, bc.minCellThickness, bc.defaultCellThicknessL, bc.defaultCellThicknessM, bc.defaultCellThicknessR, bc.maxCellThicknessL, bc.maxCellThicknessM, bc.maxCellThicknessR));
        });
        e.registrar("weaponcraft").versioned("1").playToClient(ServerBlueprintConfigPayload.TYPE, ServerBlueprintConfigPayload.CODEC, (payload, ctx) -> {
            int gw = payload.gridWidth();
            int gh = payload.gridHeight();
            LOGGER.info("[WeaponCraft] Net: Client received blueprint cfg: {}x{}", (Object)gw, (Object)gh);
            ClientPackets.openBlueprintScreen(gw, gh);
        });
        e.registrar("weaponcraft").versioned("1").playToClient(ServerBalanceConfigPayload.TYPE, ServerBalanceConfigPayload.CODEC, (payload, ctx) -> {
            LOGGER.info("[WeaponCraft] Net: Client received balance cfg + cost multipliers + bonus knobs + thickness cfg");
            ClientConfigMirror.apply(payload.critEnabled(), payload.critMultiplier(), payload.weightIron(), payload.weightGold(), payload.weightDiamond(), payload.weightNetherite(), payload.costMulGlobal(), payload.costMulIron(), payload.costMulGold(), payload.costMulDiamond(), payload.costMulNetherite(), payload.bonusPerCellSpeedGold(), payload.bonusPerCellCritDiamond(), payload.bonusPerCellDamageNetherite(), payload.bonusPerCellKnockbackNetherite(), payload.bonusPerCellDurabilityIron(), payload.bonusCapSpeed(), payload.bonusCapCrit(), payload.bonusCapDamage(), payload.bonusCapKnockback(), payload.bonusCapDurability(), payload.bonusDiminishK(), payload.bonusLinearFrac(), payload.minCellThickness(), payload.defaultCellThicknessL(), payload.defaultCellThicknessM(), payload.defaultCellThicknessR(), payload.maxCellThicknessL(), payload.maxCellThicknessM(), payload.maxCellThicknessR());
        });
        e.registrar("weaponcraft").versioned("1").playToClient(BlueprintMintResultPayload.TYPE, BlueprintMintResultPayload.CODEC, (payload, ctx) -> {
            if (payload.accepted()) {
                ClientPackets.showToast(payload.reason().isEmpty() ? "Accepted." : payload.reason());
                ClientPackets.closeIfBlueprintScreen();
            } else {
                ClientPackets.showToast(payload.reason().isEmpty() ? "Rejected." : payload.reason());
            }
        });
    }

    private static ValidationResult validateBlueprint(CompoundTag bp) {
        boolean layeredAlt;
        int ds;
        if (bp == null) {
            return ValidationResult.failure("missing payload");
        }
        int w = bp.getInt("w");
        int h = bp.getInt("h");
        int n = ds = bp.contains("detailScale") ? Math.max(1, bp.getInt("detailScale")) : 1;
        if (w <= 0 || h <= 0) {
            return ValidationResult.failure("invalid size");
        }
        if (w > BlueprintConfig.getMaxGridWidth() || h > BlueprintConfig.getMaxGridHeight()) {
            return ValidationResult.failure("exceeds server max size (" + BlueprintConfig.getMaxGridWidth() + "x" + BlueprintConfig.getMaxGridHeight() + ")");
        }
        boolean layeredPreferred = bp.contains("layers", 9);
        boolean bl = layeredAlt = bp.contains("materialsL", 9) || bp.contains("materialsM", 9) || bp.contains("materialsR", 9);
        if (layeredPreferred) {
            vr = Networking.validateLayersList(bp, w, h, ds);
            if (!vr.ok) {
                return vr;
            }
        } else if (layeredAlt) {
            vr = Networking.validateLayersAlt(bp, w, h, ds);
            if (!vr.ok) {
                return vr;
            }
        } else {
            vr = Networking.validateSingleLayer(bp, w, h, ds);
            if (!vr.ok) {
                return vr;
            }
        }
        if (!bp.contains("ax") || !bp.contains("ay")) {
            return ValidationResult.failure("grip not set (middle-click to set grip on Middle layer)");
        }
        int fw = w * ds;
        int fh = h * ds;
        int ax = bp.getInt("ax");
        int ay = bp.getInt("ay");
        if (ax < 0 || ax >= fw) {
            return ValidationResult.failure("anchorX out of bounds");
        }
        if (ay < 0 || ay >= fh) {
            return ValidationResult.failure("anchorY out of bounds");
        }
        int axCoarse = ax / ds;
        int ayCoarse = ay / ds;
        if (axCoarse < 2 || axCoarse > w - 2 || ayCoarse < 1 || ayCoarse > h - 2) {
            return ValidationResult.failure("grip box must fully fit on the grid");
        }
        BalanceConfig bc = BalanceConfig.get();
        BitmapPayload payloadObj = BitmapPayload.fromNBT(bp);
        float modelSize = BlueprintMetrics.modelSizeUnits(payloadObj);
        if (modelSize < (float)bc.minCells) {
            return ValidationResult.failure("too small (model size " + Networking.trim(modelSize) + " < " + bc.minCells + ")");
        }
        if (modelSize > (float)bc.maxCells) {
            return ValidationResult.failure("too large (model size " + Networking.trim(modelSize) + " > " + bc.maxCells + ")");
        }
        if (!ConnectedShapeValidator.isConnected(payloadObj)) {
            return ValidationResult.failure("blueprint must be one connected shape (no diagonal-only connections)");
        }
        return ValidationResult.success();
    }

    private static ValidationResult validateSingleLayer(CompoundTag bp, int w, int h, int ds) {
        ListTag rows = bp.contains("materials", 9) ? bp.getList("materials", 10) : bp.getList("rows", 10);
        int expected = h * ds;
        if (rows.size() != expected) {
            return ValidationResult.failure("row count mismatch (expected " + expected + ")");
        }
        int fw = w * ds;
        for (int y = 0; y < expected; ++y) {
            CompoundTag r = rows.getCompound(y);
            if (!r.contains("r")) {
                return ValidationResult.failure("row " + y + " missing data");
            }
            byte[] arr = r.getByteArray("r");
            if (arr.length < fw) {
                return ValidationResult.failure("row " + y + " too short");
            }
            for (int i = 0; i < fw; ++i) {
                int m = arr[i] & 0xFF;
                if (m >= 0 && m <= 4) continue;
                return ValidationResult.failure("invalid material index at row " + y);
            }
        }
        return ValidationResult.success();
    }

    private static ValidationResult validateLayersList(CompoundTag bp, int w, int h, int ds) {
        ListTag layers = bp.getList("layers", 10);
        if (layers.isEmpty()) {
            return ValidationResult.failure("layers list is empty");
        }
        int count = Math.min(3, layers.size());
        int expected = h * ds;
        int fw = w * ds;
        boolean anyNonEmpty = false;
        for (int i = 0; i < count; ++i) {
            CompoundTag layer = layers.getCompound(i);
            if (!layer.contains("materials", 9)) continue;
            ListTag rows = layer.getList("materials", 10);
            if (rows.size() != expected) {
                return ValidationResult.failure(String.format(Locale.ROOT, "layer %d: row count mismatch (expected %d)", i, expected));
            }
            boolean layerHasFill = false;
            for (int y = 0; y < expected; ++y) {
                CompoundTag r = rows.getCompound(y);
                if (!r.contains("r")) {
                    return ValidationResult.failure(String.format(Locale.ROOT, "layer %d: row %d missing data", i, y));
                }
                byte[] arr = r.getByteArray("r");
                if (arr.length < fw) {
                    return ValidationResult.failure(String.format(Locale.ROOT, "layer %d: row %d too short", i, y));
                }
                for (int x = 0; x < fw; ++x) {
                    int m = arr[x] & 0xFF;
                    if (m < 0 || m > 4) {
                        return ValidationResult.failure(String.format(Locale.ROOT, "layer %d: invalid material index at row %d", i, y));
                    }
                    if (m == 0) continue;
                    layerHasFill = true;
                }
            }
            anyNonEmpty |= layerHasFill;
        }
        if (!anyNonEmpty) {
            return ValidationResult.failure("layers contain no filled cells");
        }
        return ValidationResult.success();
    }

    private static ValidationResult validateLayersAlt(CompoundTag bp, int w, int h, int ds) {
        String[] keys = new String[]{"materialsL", "materialsM", "materialsR"};
        int expected = h * ds;
        int fw = w * ds;
        boolean anyNonEmpty = false;
        for (int i = 0; i < keys.length; ++i) {
            String key = keys[i];
            if (!bp.contains(key, 9)) continue;
            ListTag rows = bp.getList(key, 10);
            if (rows.size() != expected) {
                return ValidationResult.failure(key + ": row count mismatch (expected " + expected + ")");
            }
            boolean layerHasFill = false;
            for (int y = 0; y < expected; ++y) {
                CompoundTag r = rows.getCompound(y);
                if (!r.contains("r")) {
                    return ValidationResult.failure(key + ": row " + y + " missing data");
                }
                byte[] arr = r.getByteArray("r");
                if (arr.length < fw) {
                    return ValidationResult.failure(key + ": row " + y + " too short");
                }
                for (int x = 0; x < fw; ++x) {
                    int m = arr[x] & 0xFF;
                    if (m < 0 || m > 4) {
                        return ValidationResult.failure(key + ": invalid material index at row " + y);
                    }
                    if (m == 0) continue;
                    layerHasFill = true;
                }
            }
            anyNonEmpty |= layerHasFill;
        }
        if (!anyNonEmpty) {
            return ValidationResult.failure("layers contain no filled cells");
        }
        return ValidationResult.success();
    }

    private static void embedPerCellColorsServer(CompoundTag bp) {
        boolean alt;
        if (bp.contains("layers", 9)) {
            ListTag layers = bp.getList("layers", 10);
            for (int i = 0; i < layers.size(); ++i) {
                CompoundTag layer = layers.getCompound(i);
                if (!layer.contains("materials", 9) || layer.contains("colors", 9)) continue;
                ListTag matsRows = layer.getList("materials", 10);
                ListTag colorsRows = Networking.buildColorsFromMaterialsList(matsRows);
                layer.put("colors", (Tag)colorsRows);
            }
            return;
        }
        boolean bl = alt = bp.contains("materialsL", 9) || bp.contains("materialsM", 9) || bp.contains("materialsR", 9);
        if (alt) {
            Networking.addColorsIfMissingAlt(bp, "materialsL", "colorsL");
            Networking.addColorsIfMissingAlt(bp, "materialsM", "colorsM");
            Networking.addColorsIfMissingAlt(bp, "materialsR", "colorsR");
            return;
        }
        if (bp.contains("materials", 9) && !bp.contains("colors", 9)) {
            ListTag matsRows = bp.getList("materials", 10);
            ListTag colorsRows = Networking.buildColorsFromMaterialsList(matsRows);
            bp.put("colors", (Tag)colorsRows);
        }
    }

    private static void addColorsIfMissingAlt(CompoundTag bp, String matsKey, String colorsKey) {
        if (!bp.contains(matsKey, 9)) {
            return;
        }
        if (bp.contains(colorsKey, 9)) {
            return;
        }
        ListTag matsRows = bp.getList(matsKey, 10);
        ListTag colorsRows = Networking.buildColorsFromMaterialsList(matsRows);
        bp.put(colorsKey, (Tag)colorsRows);
    }

    private static ListTag buildColorsFromMaterialsList(ListTag matsRows) {
        Random rng = new Random();
        ListTag colorsRows = new ListTag();
        for (int y = 0; y < matsRows.size(); ++y) {
            byte[] arr = matsRows.getCompound(y).getByteArray("r");
            int[] line = new int[arr.length];
            for (int x = 0; x < arr.length; ++x) {
                int m = arr[x] & 0xFF;
                line[x] = m == 0 ? 0 : Networking.randomDarkenABGR(rng);
            }
            CompoundTag row = new CompoundTag();
            row.put("c", (Tag)new IntArrayTag(line));
            colorsRows.add((Object)row);
        }
        return colorsRows;
    }

    private static void embedPerCellColors(CompoundTag bp) {
        int w = bp.getInt("w");
        int h = bp.getInt("h");
        int ds = bp.contains("detailScale") ? Math.max(1, bp.getInt("detailScale")) : 1;
        int fw = w * ds;
        int fh = h * ds;
        ListTag matsRows = bp.getList("materials", 10);
        byte[][] mats = new byte[fh][fw];
        for (int y = 0; y < fh; ++y) {
            byte[] arr = matsRows.getCompound(y).getByteArray("r");
            System.arraycopy(arr, 0, mats[y], 0, Math.min(arr.length, fw));
        }
        ListTag colorsRows = new ListTag();
        Random rng = new Random();
        for (int y = 0; y < fh; ++y) {
            int[] line = new int[fw];
            for (int x = 0; x < fw; ++x) {
                int m = mats[y][x] & 0xFF;
                line[x] = m == 0 ? 0 : Networking.randomDarkenABGR(rng);
            }
            CompoundTag row = new CompoundTag();
            row.put("c", (Tag)new IntArrayTag(line));
            colorsRows.add((Object)row);
        }
        bp.put("colors", (Tag)colorsRows);
    }

    private static String describeLayering(CompoundTag bp) {
        if (bp.contains("layers", 9)) {
            ListTag layers = bp.getList("layers", 10);
            return "(3-layer:" + layers.size() + ")";
        }
        boolean alt = bp.contains("materialsL", 9) || bp.contains("materialsM", 9) || bp.contains("materialsR", 9);
        return alt ? "(3-layer:alt)" : "(single-layer)";
    }

    private static void writeStatsToNbt(CompoundTag bp, StatResult base, BitmapPayload payload, BalanceConfig bc, float tL, float tM, float tR) {
        Bonus b = Networking.computeAdditionalBonuses(payload, bc, tL, tM, tR);
        float adjDamage = base.damage * (1.0f + b.damagePct);
        float adjSpeed = base.speed * (1.0f + b.speedPct);
        float adjKnockback = base.knockbackMult * (1.0f + b.knockbackPct);
        float adjCrit = Networking.clamp01(base.critChance + b.critPct);
        int adjDurability = Math.max(1, Math.round((float)base.durability * (1.0f + b.durabilityPct)));
        CompoundTag stats = new CompoundTag();
        stats.putFloat("Damage", adjDamage);
        stats.putFloat("Speed", adjSpeed);
        stats.putFloat("Reach", base.reach);
        stats.putInt("Durability", adjDurability);
        stats.putFloat("Knockback", adjKnockback);
        stats.putFloat("CritChance", adjCrit);
        float dmgPct = base.tMass;
        float spdPct = 1.0f - base.tMass;
        float kbPct = base.tBulk;
        float critPct = 1.0f - base.tBulk;
        float reachPct = base.tReach;
        float durPct = 1.0f - base.tReach;
        stats.putFloat("DamagePct", dmgPct);
        stats.putFloat("SpeedPct", spdPct);
        stats.putFloat("KnockbackPct", kbPct);
        stats.putFloat("CritPct", critPct);
        stats.putFloat("ReachPct", reachPct);
        stats.putFloat("DurabilityPct", durPct);
        Totals totals = Networking.computeTotals(payload, bc);
        stats.putInt("FineCellsFilled", totals.filledFine());
        stats.putFloat("TotalWeight", totals.totalWeight());
        stats.putFloat("BonusFromGoldSpeedPct", b.speedPct);
        stats.putFloat("BonusFromDiamondCritPct", b.critPct);
        stats.putFloat("BonusFromNetheriteDamagePct", b.damagePct);
        stats.putFloat("BonusFromNetheriteKnockbackPct", b.knockbackPct);
        stats.putFloat("BonusFromIronDurabilityPct", b.durabilityPct);
        bp.put("Stats", (Tag)stats);
        int[] cost = Networking.computeCraftingCost(payload, bc, tL, tM, tR);
        CompoundTag costTag = new CompoundTag();
        costTag.putInt("iron", cost[1]);
        costTag.putInt("gold", cost[2]);
        costTag.putInt("diamond", cost[3]);
        costTag.putInt("netherite", cost[4]);
        bp.put("CraftingCost", (Tag)costTag);
    }

    private static ItemAttributeModifiers buildModifiersFromStats(StatResult base, BitmapPayload payload, BalanceConfig bc, float tL, float tM, float tR) {
        Bonus b = Networking.computeAdditionalBonuses(payload, bc, tL, tM, tR);
        float damage = base.damage * (1.0f + b.damagePct);
        float speed = base.speed * (1.0f + b.speedPct);
        float knockbackM = base.knockbackMult * (1.0f + b.knockbackPct);
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        builder.add(Attributes.ATTACK_DAMAGE, new AttributeModifier(Constants.MOD_DAMAGE_ID, (double)damage, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        double speedDelta = speed - 4.0f;
        builder.add(Attributes.ATTACK_SPEED, new AttributeModifier(Constants.MOD_SPEED_ID, speedDelta, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        double rangeAdd = base.reach - 3.0f;
        builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(Constants.MOD_RANGE_ID, rangeAdd, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        double kbAdd = knockbackM - 1.0f;
        builder.add(Attributes.ATTACK_KNOCKBACK, new AttributeModifier(Constants.MOD_KB_ID, kbAdd, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND);
        return builder.build();
    }

    private static Totals computeTotals(BitmapPayload p, BalanceConfig bc) {
        int fh = p.height * p.detailScale;
        int fw = p.width * p.detailScale;
        float perFine = p.detailScale <= 1 ? 1.0f : 1.0f / (float)(p.detailScale * p.detailScale);
        int filled = 0;
        float totalWeight = 0.0f;
        boolean hasLayers = p.layerL != null || p.layerM != null || p.layerR != null;
        for (int y = 0; y < fh; ++y) {
            byte[] mergedRow = p.fineMaterials[y];
            byte[] rowL = hasLayers && p.layerL != null ? p.layerL[y] : null;
            byte[] rowM = hasLayers && p.layerM != null ? p.layerM[y] : null;
            byte[] rowR = hasLayers && p.layerR != null ? p.layerR[y] : null;
            for (int x = 0; x < fw; ++x) {
                int m = mergedRow[x] & 0xFF;
                if (m < 1 || m > 4) continue;
                ++filled;
                float thicknessScale = 1.0f;
                if (hasLayers) {
                    thicknessScale = rowR != null && (rowR[x] & 0xFF) != 0 ? p.thicknessR : (rowM != null && (rowM[x] & 0xFF) != 0 ? p.thicknessM : (rowL != null && (rowL[x] & 0xFF) != 0 ? p.thicknessL : 1.0f));
                }
                totalWeight += perFine * Networking.weightForIndex(m, bc) * thicknessScale;
            }
        }
        return new Totals(filled, totalWeight);
    }

    private static int[] computeCraftingCost(BitmapPayload p, BalanceConfig bc, float tL, float tM, float tR) {
        int fh = p.height * p.detailScale;
        int fw = p.width * p.detailScale;
        float perFine = p.detailScale <= 1 ? 1.0f : 1.0f / (float)(p.detailScale * p.detailScale);
        float[] weightByMat = new float[5];
        BiConsumer<byte[][], Float> acc = (layer, scale) -> {
            if (layer == null || scale == null || scale.floatValue() <= 0.0f) {
                return;
            }
            for (int y = 0; y < fh; ++y) {
                byte[] row = layer[y];
                for (int x = 0; x < fw; ++x) {
                    int m = row[x] & 0xFF;
                    if (m < 1 || m > 4) continue;
                    int n = m;
                    weightByMat[n] = weightByMat[n] + perFine * Networking.weightForIndex(m, bc) * scale.floatValue();
                }
            }
        };
        acc.accept(p.layerL, Float.valueOf(tL));
        acc.accept(p.layerM, Float.valueOf(tM));
        acc.accept(p.layerR, Float.valueOf(tR));
        if (p.layerL == null && p.layerM == null && p.layerR == null) {
            for (int y = 0; y < fh; ++y) {
                byte[] row = p.fineMaterials[y];
                for (int x = 0; x < fw; ++x) {
                    int m = row[x] & 0xFF;
                    if (m < 1 || m > 4) continue;
                    int n = m;
                    weightByMat[n] = weightByMat[n] + perFine * Networking.weightForIndex(m, bc) * tM;
                }
            }
        }
        int[] out = new int[5];
        for (int m = 1; m <= 4; ++m) {
            float mul = Networking.effectiveCostMulForIndex(m, bc);
            out[m] = Networking.roundUp(weightByMat[m] * mul);
        }
        return out;
    }

    private static float weightForIndex(int matIdx, BalanceConfig bc) {
        return switch (matIdx) {
            case 1 -> bc.weightIron;
            case 2 -> bc.weightGold;
            case 3 -> bc.weightDiamond;
            case 4 -> bc.weightNetherite;
            default -> 0.0f;
        };
    }

    private static float effectiveCostMulForIndex(int matIdx, BalanceConfig bc) {
        return switch (matIdx) {
            case 1 -> {
                if (bc.costMulIron > 0.0f) {
                    yield bc.costMulIron;
                }
                yield bc.costMulGlobal;
            }
            case 2 -> {
                if (bc.costMulGold > 0.0f) {
                    yield bc.costMulGold;
                }
                yield bc.costMulGlobal;
            }
            case 3 -> {
                if (bc.costMulDiamond > 0.0f) {
                    yield bc.costMulDiamond;
                }
                yield bc.costMulGlobal;
            }
            case 4 -> {
                if (bc.costMulNetherite > 0.0f) {
                    yield bc.costMulNetherite;
                }
                yield bc.costMulGlobal;
            }
            default -> bc.costMulGlobal;
        };
    }

    private static int roundUp(float v) {
        if (v <= 0.0f) {
            return 0;
        }
        int i = (int)v;
        return v == (float)i ? i : i + 1;
    }

    private static int randomDarkenABGR(Random rng) {
        float darkness = Networking.rr(rng, 0.0f, 0.3f);
        float f = 1.0f - darkness;
        int gray = (int)(f * 255.0f + 0.5f);
        int A = 255;
        return (A & 0xFF) << 24 | (gray & 0xFF) << 16 | (gray & 0xFF) << 8 | gray & 0xFF;
    }

    private static float rr(Random rng, float a, float b) {
        return a + (b - a) * rng.nextFloat();
    }

    private static float clamp01(float f) {
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }

    private static String trim(float f) {
        return (double)Math.abs(f - (float)Math.round(f)) < 0.001 ? Integer.toString(Math.round(f)) : String.format(Locale.ROOT, "%.1f", Float.valueOf(f));
    }

    private static Bonus computeAdditionalBonuses(BitmapPayload p, BalanceConfig bc, float tL, float tM, float tR) {
        int[] coarse = Networking.countEffectiveCoarseCellsByMaterial(p, tL, tM, tR);
        float k = Math.max(0.0f, bc.bonusDiminishK);
        float linearFrac = Networking.clamp01(bc.bonusLinearFrac);
        float c0Gold = Networking.kneeCells(linearFrac, bc.bonusCapSpeed, bc.bonusPerCellSpeedGold);
        float c0Dia = Networking.kneeCells(linearFrac, bc.bonusCapCrit, bc.bonusPerCellCritDiamond);
        float c0NethD = Networking.kneeCells(linearFrac, bc.bonusCapDamage, bc.bonusPerCellDamageNetherite);
        float c0NethK = Networking.kneeCells(linearFrac, bc.bonusCapKnockback, bc.bonusPerCellKnockbackNetherite);
        float c0Iron = Networking.kneeCells(linearFrac, bc.bonusCapDurability, bc.bonusPerCellDurabilityIron);
        float speed = Networking.bonusPiecewise(coarse[2], bc.bonusPerCellSpeedGold, bc.bonusCapSpeed, k, c0Gold);
        float crit = Networking.bonusPiecewise(coarse[3], bc.bonusPerCellCritDiamond, bc.bonusCapCrit, k, c0Dia);
        float dmg = Networking.bonusPiecewise(coarse[4], bc.bonusPerCellDamageNetherite, bc.bonusCapDamage, k, c0NethD);
        float kb = Networking.bonusPiecewise(coarse[4], bc.bonusPerCellKnockbackNetherite, bc.bonusCapKnockback, k, c0NethK);
        float dura = Networking.bonusPiecewise(coarse[1], bc.bonusPerCellDurabilityIron, bc.bonusCapDurability, k, c0Iron);
        return new Bonus(dmg, speed, kb, crit, dura);
    }

    private static int[] countEffectiveCoarseCellsByMaterial(BitmapPayload p, float tL, float tM, float tR) {
        float[] eff = new float[5];
        int ds = p.detailScale;
        BiConsumer<byte[][], Float> addLayer = (layer, scale) -> {
            if (layer == null || scale == null || scale.floatValue() <= 0.0f) {
                return;
            }
            for (int cy = 0; cy < p.height; ++cy) {
                for (int cx = 0; cx < p.width; ++cx) {
                    int mat = Networking.majorityMaterialInBlock(layer, cx * ds, cy * ds, ds);
                    if (mat < 1 || mat > 4) continue;
                    int n = mat;
                    eff[n] = eff[n] + scale.floatValue();
                }
            }
        };
        addLayer.accept(p.layerL, Float.valueOf(tL));
        addLayer.accept(p.layerM, Float.valueOf(tM));
        addLayer.accept(p.layerR, Float.valueOf(tR));
        if (p.layerL == null && p.layerM == null && p.layerR == null) {
            for (int cy = 0; cy < p.height; ++cy) {
                for (int cx = 0; cx < p.width; ++cx) {
                    int mat = Networking.majorityMaterialInBlock(p.fineMaterials, cx * ds, cy * ds, ds);
                    if (mat < 1 || mat > 4) continue;
                    int n = mat;
                    eff[n] = eff[n] + tM;
                }
            }
        }
        int[] out = new int[5];
        for (int m = 1; m <= 4; ++m) {
            out[m] = Math.round(eff[m]);
        }
        return out;
    }

    private static float bonusPiecewise(int cells, float perCell, float cap, float k, float c0Cells) {
        if (cells <= 0 || perCell <= 0.0f || cap <= 0.0f) {
            return 0.0f;
        }
        float c0 = Math.max(0.0f, c0Cells);
        float b0 = perCell * Math.min((float)cells, c0);
        if (b0 >= cap) {
            return cap;
        }
        if ((float)cells <= c0 || k <= 0.0f) {
            return Math.min(b0, cap);
        }
        float remCap = cap - b0;
        if (remCap <= 0.0f) {
            return cap;
        }
        float tailCells = (float)((double)cap * (1.0 - Math.exp(-((double)k) * (double)perCell * (double)((float)cells - c0) / (double)remCap)));
        float out = b0 + Math.min(tailCells, remCap);
        return out > cap ? cap : Math.max(out, 0.0f);
    }

    private static float kneeCells(float linearFrac, float cap, float perCell) {
        if (linearFrac <= 0.0f || cap <= 0.0f || perCell <= 0.0f) {
            return 0.0f;
        }
        return linearFrac * cap / perCell;
    }

    private static int[] countCoarseCellsByMaterial(BitmapPayload p) {
        int[] counts = new int[5];
        int ds = p.detailScale;
        for (int cy = 0; cy < p.height; ++cy) {
            for (int cx = 0; cx < p.width; ++cx) {
                int mat = Networking.majorityMaterialInBlock(p.fineMaterials, cx * ds, cy * ds, ds);
                if (mat < 1 || mat > 4) continue;
                int n = mat;
                counts[n] = counts[n] + 1;
            }
        }
        return counts;
    }

    private static int majorityMaterialInBlock(byte[][] fine, int x0, int y0, int ds) {
        int m;
        int[] c = new int[5];
        for (int dy = 0; dy < ds; ++dy) {
            for (int dx = 0; dx < ds; ++dx) {
                m = fine[y0 + dy][x0 + dx] & 0xFF;
                if (m < 1 || m > 4) continue;
                int n = m;
                c[n] = c[n] + 1;
            }
        }
        int best = 0;
        int bestCount = 0;
        for (m = 1; m <= 4; ++m) {
            if (c[m] <= bestCount) continue;
            bestCount = c[m];
            best = m;
        }
        return bestCount == 0 ? 0 : best;
    }

    private record ValidationResult(boolean ok, String reason) {
        static ValidationResult success() {
            return new ValidationResult(true, "ok");
        }

        static ValidationResult failure(String reason) {
            return new ValidationResult(false, reason);
        }
    }

    private static final class Bonus {
        final float damagePct;
        final float speedPct;
        final float knockbackPct;
        final float critPct;
        final float durabilityPct;

        Bonus(float dmg, float spd, float kb, float crit, float dura) {
            this.damagePct = Networking.clamp01(dmg);
            this.speedPct = Networking.clamp01(spd);
            this.knockbackPct = Networking.clamp01(kb);
            this.critPct = Networking.clamp01(crit);
            this.durabilityPct = Networking.clamp01(dura);
        }
    }

    private record Totals(int filledFine, float totalWeight) {
    }
}

