/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.rendering;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.z2six.weaponcraft.core.Constants;

public final class BlueprintMeshBuilder {
    public static Mapping ACTIVE_MAPPING = Mapping.B;
    public static float THICKNESS = 0.06f;
    public static float GRIP_X = 0.525f;
    public static float GRIP_Y = 0.35f;
    public static float GRIP_Z = 0.6f;
    public static float ROT_X_DEG = 0.0f;
    public static float ROT_Y_DEG = 180.0f;
    public static float ROT_Z_DEG = 0.0f;
    private static int MUTATION_VERSION = 1;
    public static final float BASE_CELL_SIZE = 0.015625f;
    public static float CELL_SIZE = 4.0f;
    private static boolean SHOW_GHOST = false;
    private static boolean SHOW_GIZMO = false;
    private static final float GIZMO_LEN = 0.18f;
    private static final float GIZMO_W = 0.012f;

    private BlueprintMeshBuilder() {
    }

    public static void setGrip(float x, float y, float z) {
        GRIP_X = BlueprintMeshBuilder.clamp01(x);
        GRIP_Y = BlueprintMeshBuilder.clamp01(y);
        GRIP_Z = BlueprintMeshBuilder.clamp01(z);
        BlueprintMeshBuilder.bumpMutation("setGrip");
    }

    public static void setRotation(float xDeg, float yDeg, float zDeg) {
        ROT_X_DEG = xDeg;
        ROT_Y_DEG = yDeg;
        ROT_Z_DEG = zDeg;
        BlueprintMeshBuilder.bumpMutation("setRotation");
    }

    public static void setThickness(float t) {
        THICKNESS = Math.clamp((float)0.0f, (float)1.0f, (float)t);
        BlueprintMeshBuilder.bumpMutation("setThickness");
    }

    public static void setCellSize(float k) {
        float clamped;
        CELL_SIZE = clamped = Math.clamp((float)0.01f, (float)64.0f, (float)k);
        BlueprintMeshBuilder.bumpMutation("setCellScale=" + clamped);
    }

    public static void setGhost(boolean on) {
        SHOW_GHOST = on;
        BlueprintMeshBuilder.bumpMutation("setGhost=" + on);
    }

    public static void setGizmo(boolean on) {
        SHOW_GIZMO = on;
        BlueprintMeshBuilder.bumpMutation("setGizmo=" + on);
    }

    public static boolean isGhostEnabled() {
        return SHOW_GHOST;
    }

    public static void resetTuning() {
        THICKNESS = 0.02f;
        GRIP_X = 0.175f;
        GRIP_Y = 0.115f;
        GRIP_Z = 0.19f;
        ROT_X_DEG = 0.0f;
        ROT_Y_DEG = 180.0f;
        ROT_Z_DEG = 0.0f;
        CELL_SIZE = 3.0f;
        SHOW_GHOST = false;
        SHOW_GIZMO = false;
        BlueprintMeshBuilder.bumpMutation("reset");
    }

    public static int mutationVersion() {
        return MUTATION_VERSION;
    }

    public static void printToLog(String reason) {
        Constants.LOG.info("[WeaponCraft] Tuning({}): THICKNESS={} BASE_CELL={} CELL_SCALE={} (effCell={}) GRIP=({}, {}, {}) ROT=({}, {}, {}) mapping={} ghost={} gizmo={}", new Object[]{reason, Float.valueOf(THICKNESS), Float.valueOf(0.015625f), Float.valueOf(CELL_SIZE), Float.valueOf(0.015625f * CELL_SIZE), Float.valueOf(GRIP_X), Float.valueOf(GRIP_Y), Float.valueOf(GRIP_Z), Float.valueOf(ROT_X_DEG), Float.valueOf(ROT_Y_DEG), Float.valueOf(ROT_Z_DEG), ACTIVE_MAPPING, SHOW_GHOST, SHOW_GIZMO});
    }

    private static void bumpMutation(String why) {
        ++MUTATION_VERSION;
        BlueprintMeshBuilder.printToLog(why);
    }

    private static float clamp01(float f) {
        return Math.clamp((float)0.0f, (float)1.0f, (float)f);
    }

    public static List<BakedQuad> build(byte[][] pixels, int w, int h, TextureAtlasSprite sprite, int anchorX, int anchorY) {
        return BlueprintMeshBuilder.buildFine(BlueprintMeshBuilder.mapCoarse01ToFine(pixels), w, h, 1, new TextureAtlasSprite[]{null, sprite, sprite, sprite, sprite}, anchorX, anchorY, null);
    }

    public static List<BakedQuad> buildFine(byte[][] materialsFine, int w, int h, int detailScale, TextureAtlasSprite[] materialSprites, int anchorX, int anchorY, int[][] colorsFine) {
        float[] d = BlueprintMeshBuilder.computeTranslationFromAnchor(w, h, detailScale, anchorX, anchorY, 0.0f);
        float defaultT = THICKNESS > 0.0f ? THICKNESS : 0.0625f;
        return BlueprintMeshBuilder.buildFineAtZ(materialsFine, w, h, detailScale, materialSprites, anchorX, anchorY, colorsFine, 0.0f, defaultT, d[0], d[1], d[2]);
    }

    public static List<BakedQuad> buildFine3(byte[][] fineL, byte[][] fineM, byte[][] fineR, int w, int h, int detailScale, TextureAtlasSprite[] materialSprites, int anchorX, int anchorY, int[][] colorsL, int[][] colorsM, int[][] colorsR) {
        float t = THICKNESS > 0.0f ? THICKNESS : 0.0625f;
        return BlueprintMeshBuilder.buildFine3(fineL, fineM, fineR, w, h, detailScale, materialSprites, anchorX, anchorY, colorsL, colorsM, colorsR, t, t, t);
    }

    public static List<BakedQuad> buildFine3(byte[][] fineL, byte[][] fineM, byte[][] fineR, int w, int h, int detailScale, TextureAtlasSprite[] materialSprites, int anchorX, int anchorY, int[][] colorsL, int[][] colorsM, int[][] colorsR, float thicknessL, float thicknessM, float thicknessR) {
        ArrayList<BakedQuad> out = new ArrayList<BakedQuad>();
        float tL = thicknessL > 0.0f ? thicknessL : 0.0625f;
        float tM = thicknessM > 0.0f ? thicknessM : 0.0625f;
        float tR = thicknessR > 0.0f ? thicknessR : 0.0625f;
        float[] d = BlueprintMeshBuilder.computeTranslationFromAnchor(w, h, detailScale, anchorX, anchorY, tL);
        float dx = d[0];
        float dy = d[1];
        float dz = d[2];
        if (fineL != null) {
            out.addAll(BlueprintMeshBuilder.buildFineAtZ(fineL, w, h, detailScale, materialSprites, anchorX, anchorY, colorsL, 0.0f, tL, dx, dy, dz));
        }
        if (fineM != null) {
            out.addAll(BlueprintMeshBuilder.buildFineAtZ(fineM, w, h, detailScale, materialSprites, anchorX, anchorY, colorsM, tL, tM, dx, dy, dz));
        }
        if (fineR != null) {
            out.addAll(BlueprintMeshBuilder.buildFineAtZ(fineR, w, h, detailScale, materialSprites, anchorX, anchorY, colorsR, tL + tM, tR, dx, dy, dz));
        }
        return out;
    }

    private static float[] computeTranslationFromAnchor(int w, int h, int detailScale, int anchorX, int anchorY, float zBaseRef) {
        float s = 0.015625f * CELL_SIZE;
        float scaledW = (float)w * s;
        float scaledH = (float)h * s;
        float ox = (1.0f - scaledW) * 0.5f;
        float oy = (1.0f - scaledH) * 0.5f;
        int fw = w * detailScale;
        int fh = h * detailScale;
        float ax = (anchorX >= 0 ? (float)anchorX + 0.5f : (float)(fw - 1) + 0.5f) / (float)detailScale;
        float ay = (anchorY >= 0 ? (float)anchorY + 0.5f : (float)fh * 0.5f) / (float)detailScale;
        float lx_anchor = ox + ax * s;
        float ly_anchor = oy + ((float)h - ay) * s;
        float lz_anchor = zBaseRef;
        Vector3f gAnchor = BlueprintMeshBuilder.mapLocalToFinal(lx_anchor, ly_anchor, lz_anchor, ACTIVE_MAPPING);
        BlueprintMeshBuilder.rotateInPlace(gAnchor, ROT_Z_DEG, ROT_Y_DEG, ROT_X_DEG);
        return new float[]{GRIP_X - gAnchor.x, GRIP_Y - gAnchor.y, GRIP_Z - gAnchor.z};
    }

    private static List<BakedQuad> buildFineAtZ(byte[][] materialsFine, int w, int h, int detailScale, TextureAtlasSprite[] materialSprites, int anchorX, int anchorY, int[][] colorsFine, float zBase, float thickness, float dx, float dy, float dz) {
        float t = thickness > 0.0f ? thickness : 0.0625f;
        float s = 0.015625f * CELL_SIZE;
        int fw = w * detailScale;
        int fh = h * detailScale;
        float scaledW = (float)w * s;
        float scaledH = (float)h * s;
        float ox = (1.0f - scaledW) * 0.5f;
        float oy = (1.0f - scaledH) * 0.5f;
        ArrayList<BakedQuad> out = new ArrayList<BakedQuad>();
        for (int fy = 0; fy < fh; ++fy) {
            for (int fx = 0; fx < fw; ++fx) {
                TextureAtlasSprite sprite;
                int mat = materialsFine[fy][fx] & 0xFF;
                if (mat == 0 || (sprite = BlueprintMeshBuilder.selectSprite(materialSprites, mat)) == null) continue;
                float lx0 = ox + (float)fx / (float)detailScale * s;
                float lx1 = ox + (float)(fx + 1) / (float)detailScale * s;
                float ly0 = oy + ((float)h - (float)(fy + 1) / (float)detailScale) * s;
                float ly1 = oy + ((float)h - (float)fy / (float)detailScale) * s;
                int abgr = colorsFine != null ? colorsFine[fy][fx] : -1;
                float zBack = zBase;
                float zFront = zBase + t;
                BlueprintMeshBuilder.addQuad(out, Direction.SOUTH, lx0, ly0, zFront, lx1, ly1, zFront, sprite, dx, dy, dz, abgr);
                BlueprintMeshBuilder.addQuad(out, Direction.NORTH, lx0, ly0, zBack, lx1, ly1, zBack, sprite, dx, dy, dz, abgr);
            }
        }
        int fwFine = w * detailScale;
        int fhFine = h * detailScale;
        for (int fy = 0; fy < fhFine; ++fy) {
            for (int fx = 0; fx < fwFine; ++fx) {
                boolean nU;
                TextureAtlasSprite sprite;
                int mat = materialsFine[fy][fx] & 0xFF;
                if (mat == 0 || (sprite = BlueprintMeshBuilder.selectSprite(materialSprites, mat)) == null) continue;
                float lxL = ox + (float)fx / (float)detailScale * s;
                float lxR = ox + (float)(fx + 1) / (float)detailScale * s;
                float lyT = oy + ((float)h - (float)(fy + 1) / (float)detailScale) * s;
                float lyB = oy + ((float)h - (float)fy / (float)detailScale) * s;
                int abgr = colorsFine != null ? colorsFine[fy][fx] : -1;
                float zBack = zBase;
                float zFront = zBase + t;
                boolean nL = fx - 1 < 0 || materialsFine[fy][fx - 1] == 0;
                boolean nR = fx + 1 >= fwFine || materialsFine[fy][fx + 1] == 0;
                boolean nD = fy - 1 < 0 || materialsFine[fy - 1][fx] == 0;
                boolean bl = nU = fy + 1 >= fhFine || materialsFine[fy + 1][fx] == 0;
                if (nL) {
                    BlueprintMeshBuilder.addQuadDoubleSided(out, Direction.WEST, lxL, lyT, lyB, zBack, zFront, sprite, dx, dy, dz, abgr);
                }
                if (nR) {
                    BlueprintMeshBuilder.addQuadDoubleSided(out, Direction.EAST, lxR, lyT, lyB, zBack, zFront, sprite, dx, dy, dz, abgr);
                }
                if (nD) {
                    BlueprintMeshBuilder.addQuadEdgeYDouble(out, Direction.DOWN, lxL, lxR, lyB, zBack, zFront, sprite, dx, dy, dz, abgr);
                }
                if (!nU) continue;
                BlueprintMeshBuilder.addQuadEdgeYDouble(out, Direction.UP, lxL, lxR, lyT, zBack, zFront, sprite, dx, dy, dz, abgr);
            }
        }
        if (SHOW_GIZMO) {
            BlueprintMeshBuilder.addAxisGizmo(out, dx, dy, dz);
        }
        return out;
    }

    private static TextureAtlasSprite selectSprite(TextureAtlasSprite[] sprites, int mat) {
        TextureAtlasSprite s;
        if (sprites == null) {
            return null;
        }
        int idx = mat;
        if (idx < 0 || idx >= sprites.length) {
            idx = 0;
        }
        if ((s = sprites[idx]) == null) {
            for (int i = 1; i < sprites.length; ++i) {
                if (sprites[i] == null) continue;
                return sprites[i];
            }
        }
        return s;
    }

    private static byte[][] mapCoarse01ToFine(byte[][] px) {
        int h = px.length;
        int w = h == 0 ? 0 : px[0].length;
        byte[][] out = new byte[h][w];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                out[y][x] = px[y][x] != 0 ? (byte)1 : 0;
            }
        }
        return out;
    }

    private static Vector3f mapLocalToFinal(float lx, float ly, float lz, Mapping m) {
        return switch (m.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> new Vector3f(lz, 1.0f - ly, 1.0f - lx);
            case 1 -> new Vector3f(lz, 1.0f - lx, 1.0f - ly);
        };
    }

    private static Direction mapFace(Direction local, Mapping m) {
        return switch (m.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> {
                switch (local) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case SOUTH: {
                        yield Direction.EAST;
                    }
                    case NORTH: {
                        yield Direction.WEST;
                    }
                    case WEST: {
                        yield Direction.SOUTH;
                    }
                    case EAST: {
                        yield Direction.NORTH;
                    }
                    case DOWN: {
                        yield Direction.UP;
                    }
                    case UP: 
                }
                yield Direction.DOWN;
            }
            case 1 -> {
                switch (local) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case SOUTH: {
                        yield Direction.EAST;
                    }
                    case NORTH: {
                        yield Direction.WEST;
                    }
                    case WEST: {
                        yield Direction.UP;
                    }
                    case EAST: {
                        yield Direction.DOWN;
                    }
                    case DOWN: {
                        yield Direction.SOUTH;
                    }
                    case UP: 
                }
                yield Direction.NORTH;
            }
        };
    }

    private static Direction opposite(Direction d) {
        return switch (d) {
            default -> throw new MatchException(null, null);
            case Direction.NORTH -> Direction.SOUTH;
            case Direction.SOUTH -> Direction.NORTH;
            case Direction.WEST -> Direction.EAST;
            case Direction.EAST -> Direction.WEST;
            case Direction.UP -> Direction.DOWN;
            case Direction.DOWN -> Direction.UP;
        };
    }

    private static void rotateInPlace(Vector3f p, float rzDeg, float ryDeg, float rxDeg) {
        Quaternionf q = new Quaternionf().rotateZ(Math.toRadians((float)rzDeg)).rotateY(Math.toRadians((float)ryDeg)).rotateX(Math.toRadians((float)rxDeg));
        q.transform(p);
    }

    private static int abgrToArgb(int abgr) {
        return abgr & 0xFF00FF00 | (abgr & 0xFF0000) >>> 16 | (abgr & 0xFF) << 16;
    }

    private static void addQuad(List<BakedQuad> out, Direction localFace, float lx0, float ly0, float lz, float lx1, float ly1, float lzSame, TextureAtlasSprite s, float dx, float dy, float dz, int abgrColor) {
        out.add(BlueprintMeshBuilder.quad(localFace, lx0, ly0, lz, lx1, ly1, lzSame, s, 0.0f, 0.0f, 1.0f, 1.0f, true, dx, dy, dz, abgrColor));
    }

    private static void addQuadDoubleSided(List<BakedQuad> out, Direction localFace, float lx, float lyTop, float lyBot, float lzBack, float lzFront, TextureAtlasSprite s, float dx, float dy, float dz, int abgr) {
        BlueprintMeshBuilder.addQuadSide(out, localFace, lx, lyTop, lyBot, lzBack, lzFront, s, dx, dy, dz, abgr);
        BlueprintMeshBuilder.addQuadSide(out, BlueprintMeshBuilder.opposite(localFace), lx, lyTop, lyBot, lzFront, lzBack, s, dx, dy, dz, abgr);
    }

    private static void addQuadSide(List<BakedQuad> out, Direction localFace, float lx, float lyTop, float lyBot, float lzBack, float lzFront, TextureAtlasSprite s, float dx, float dy, float dz, int abgr) {
        float lx0 = lx;
        float lx1 = lx;
        out.add(BlueprintMeshBuilder.quad(localFace, lx0, lyTop, lzBack, lx1, lyBot, lzFront, s, 0.0f, 0.0f, 1.0f, 1.0f, true, dx, dy, dz, abgr));
    }

    private static void addQuadEdgeYDouble(List<BakedQuad> out, Direction localFace, float lx0, float lx1, float ly, float lzBack, float lzFront, TextureAtlasSprite s, float dx, float dy, float dz, int abgr) {
        BlueprintMeshBuilder.addQuadEdgeY(out, localFace, lx0, lx1, ly, lzBack, lzFront, s, dx, dy, dz, abgr);
        BlueprintMeshBuilder.addQuadEdgeY(out, BlueprintMeshBuilder.opposite(localFace), lx0, lx1, ly, lzFront, lzBack, s, dx, dy, dz, abgr);
    }

    private static void addQuadEdgeY(List<BakedQuad> out, Direction localFace, float lx0, float lx1, float ly, float lzBack, float lzFront, TextureAtlasSprite s, float dx, float dy, float dz, int abgr) {
        out.add(BlueprintMeshBuilder.quad(localFace, lx0, ly, lzBack, lx1, ly, lzFront, s, 0.0f, 0.0f, 1.0f, 1.0f, true, dx, dy, dz, abgr));
    }

    private static BakedQuad quad(Direction localFace, float lx0, float ly0, float lz0, float lx1, float ly1, float lz1, TextureAtlasSprite sprite, float u0, float v0, float u1, float v1, boolean shade, float dx, float dy, float dz, int abgrColor) {
        Vector3f p2;
        Vector3f p1;
        Vector3f p0;
        float U0 = Mth.lerp((float)u0, (float)sprite.getU0(), (float)sprite.getU1());
        float V0 = Mth.lerp((float)v0, (float)sprite.getV0(), (float)sprite.getV1());
        float U1 = Mth.lerp((float)u1, (float)sprite.getU0(), (float)sprite.getU1());
        float V1 = Mth.lerp((float)v1, (float)sprite.getV0(), (float)sprite.getV1());
        Vector3f p3 = switch (localFace) {
            case Direction.SOUTH -> {
                p0 = new Vector3f(lx0, ly0, lz0);
                p1 = new Vector3f(lx1, ly0, lz0);
                p2 = new Vector3f(lx1, ly1, lz0);
                yield new Vector3f(lx0, ly1, lz0);
            }
            case Direction.NORTH -> {
                p0 = new Vector3f(lx1, ly0, lz0);
                p1 = new Vector3f(lx0, ly0, lz0);
                p2 = new Vector3f(lx0, ly1, lz0);
                yield new Vector3f(lx1, ly1, lz0);
            }
            case Direction.WEST -> {
                p0 = new Vector3f(lx0, ly0, lz0);
                p1 = new Vector3f(lx0, ly1, lz0);
                p2 = new Vector3f(lx0, ly1, lz1);
                yield new Vector3f(lx0, ly0, lz1);
            }
            case Direction.EAST -> {
                p0 = new Vector3f(lx0, ly0, lz1);
                p1 = new Vector3f(lx0, ly1, lz1);
                p2 = new Vector3f(lx0, ly1, lz0);
                yield new Vector3f(lx0, ly0, lz0);
            }
            case Direction.DOWN -> {
                p0 = new Vector3f(lx0, ly0, lz0);
                p1 = new Vector3f(lx1, ly0, lz0);
                p2 = new Vector3f(lx1, ly0, lz1);
                yield new Vector3f(lx0, ly0, lz1);
            }
            case Direction.UP -> {
                p0 = new Vector3f(lx0, ly0, lz1);
                p1 = new Vector3f(lx1, ly0, lz1);
                p2 = new Vector3f(lx1, ly0, lz0);
                yield new Vector3f(lx0, ly0, lz0);
            }
            default -> throw new IllegalStateException("Unexpected face " + String.valueOf(localFace));
        };
        BlueprintMeshBuilder.transformRotateTranslate(p0, dx, dy, dz);
        BlueprintMeshBuilder.transformRotateTranslate(p1, dx, dy, dz);
        BlueprintMeshBuilder.transformRotateTranslate(p2, dx, dy, dz);
        BlueprintMeshBuilder.transformRotateTranslate(p3, dx, dy, dz);
        Direction mappedFace = BlueprintMeshBuilder.mapFace(localFace, ACTIVE_MAPPING);
        int packedNormal = BlueprintMeshBuilder.packFaceNormal(mappedFace);
        int[] data = new int[32];
        float[] u = new float[]{U0, U1, U1, U0};
        float[] v = new float[]{V0, V0, V1, V1};
        int argb = BlueprintMeshBuilder.abgrToArgb(abgrColor);
        BlueprintMeshBuilder.packVertex(data, 0, p0, u[0], v[0], argb, packedNormal);
        BlueprintMeshBuilder.packVertex(data, 1, p1, u[1], v[1], argb, packedNormal);
        BlueprintMeshBuilder.packVertex(data, 2, p2, u[2], v[2], argb, packedNormal);
        BlueprintMeshBuilder.packVertex(data, 3, p3, u[3], v[3], argb, packedNormal);
        int tintIndex = -1;
        return new BakedQuad(data, tintIndex, mappedFace, sprite, shade);
    }

    private static void transformRotateTranslate(Vector3f p, float dx, float dy, float dz) {
        Vector3f g = BlueprintMeshBuilder.mapLocalToFinal(p.x, p.y, p.z, ACTIVE_MAPPING);
        BlueprintMeshBuilder.rotateInPlace(g, ROT_Z_DEG, ROT_Y_DEG, ROT_X_DEG);
        g.add(dx, dy, dz);
        p.set((Vector3fc)g);
    }

    private static int packFaceNormal(Direction face) {
        int nx = 0;
        int ny = 0;
        int nz = 0;
        switch (face) {
            case SOUTH: {
                nz = 127;
                break;
            }
            case NORTH: {
                nz = -127;
                break;
            }
            case EAST: {
                nx = 127;
                break;
            }
            case WEST: {
                nx = -127;
                break;
            }
            case UP: {
                ny = 127;
                break;
            }
            case DOWN: {
                ny = -127;
            }
        }
        return nx & 0xFF | (ny & 0xFF) << 8 | (nz & 0xFF) << 16;
    }

    private static void packVertex(int[] data, int vi, Vector3f pos, float u, float v, int argb, int packedNormal) {
        int base = vi * 8;
        data[base] = Float.floatToRawIntBits(pos.x());
        data[base + 1] = Float.floatToRawIntBits(pos.y());
        data[base + 2] = Float.floatToRawIntBits(pos.z());
        data[base + 3] = argb;
        data[base + 4] = Float.floatToRawIntBits(u);
        data[base + 5] = Float.floatToRawIntBits(v);
        data[base + 6] = 0;
        data[base + 7] = packedNormal;
    }

    private static void addAxisGizmo(List<BakedQuad> out, float dx, float dy, float dz) {
        float w = 0.012f;
        float L = 0.18f;
        BlueprintMeshBuilder.addColoredRibbon(out, new Vector3f(0.0f, -0.012f, -0.012f), new Vector3f(0.18f, -0.012f, -0.012f), new Vector3f(0.18f, 0.012f, 0.012f), new Vector3f(0.0f, 0.012f, 0.012f), -65536, dx, dy, dz);
        BlueprintMeshBuilder.addColoredRibbon(out, new Vector3f(-0.012f, 0.0f, -0.012f), new Vector3f(-0.012f, 0.18f, -0.012f), new Vector3f(0.012f, 0.18f, 0.012f), new Vector3f(0.012f, 0.0f, 0.012f), -16711936, dx, dy, dz);
        BlueprintMeshBuilder.addColoredRibbon(out, new Vector3f(-0.012f, -0.012f, 0.0f), new Vector3f(-0.012f, 0.012f, 0.0f), new Vector3f(0.012f, 0.012f, 0.18f), new Vector3f(0.012f, -0.012f, 0.18f), -16776961, dx, dy, dz);
    }

    private static void addColoredRibbon(List<BakedQuad> out, Vector3f f0, Vector3f f1, Vector3f f2, Vector3f f3, int argb, float dx, float dy, float dz) {
        float U0 = 0.0f;
        float V0 = 0.0f;
        float U1 = 1.0f;
        float V1 = 1.0f;
        Vector3f p0 = new Vector3f(f0.x + dx, f0.y + dy, f0.z + dz);
        Vector3f p1 = new Vector3f(f1.x + dx, f1.y + dy, f1.z + dz);
        Vector3f p2 = new Vector3f(f2.x + dx, f2.y + dy, f2.z + dz);
        Vector3f p3 = new Vector3f(f3.x + dx, f3.y + dy, f3.z + dz);
        int[] data = new int[32];
        BlueprintMeshBuilder.packVertexRaw(data, 0, p0, U0, V0, argb, 0);
        BlueprintMeshBuilder.packVertexRaw(data, 1, p1, U1, V0, argb, 0);
        BlueprintMeshBuilder.packVertexRaw(data, 2, p2, U1, V1, argb, 0);
        BlueprintMeshBuilder.packVertexRaw(data, 3, p3, U0, V1, argb, 0);
        out.add(new BakedQuad(data, -1, Direction.SOUTH, null, true));
        int[] data2 = new int[32];
        BlueprintMeshBuilder.packVertexRaw(data2, 0, p3, U0, V0, argb, 0);
        BlueprintMeshBuilder.packVertexRaw(data2, 1, p2, U1, V0, argb, 0);
        BlueprintMeshBuilder.packVertexRaw(data2, 2, p1, U1, V1, argb, 0);
        BlueprintMeshBuilder.packVertexRaw(data2, 3, p0, U0, V1, argb, 0);
        out.add(new BakedQuad(data2, -1, Direction.NORTH, null, true));
    }

    private static void packVertexRaw(int[] data, int vi, Vector3f pos, float u, float v, int argb, int uv2) {
        int base = vi * 8;
        data[base] = Float.floatToRawIntBits(pos.x());
        data[base + 1] = Float.floatToRawIntBits(pos.y());
        data[base + 2] = Float.floatToRawIntBits(pos.z());
        data[base + 3] = argb;
        data[base + 4] = Float.floatToRawIntBits(u);
        data[base + 5] = Float.floatToRawIntBits(v);
        data[base + 6] = uv2;
        data[base + 7] = 0;
    }

    public static enum Mapping {
        A,
        B;

    }
}

