/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.rendering;

public enum MaterialPalette {
    EMPTY(0, 0, 0),
    IRON(1, -5195840, -4143153),
    GOLD(2, -1785798, -997304),
    DIAMOND(3, -12065309, -10882834),
    NETHERITE(4, -11911354, -11056302);

    public final int index;
    public final int guiAbgr;
    public final int baseAbgr;

    private MaterialPalette(int index, int guiAbgr, int baseAbgr) {
        this.index = index;
        this.guiAbgr = guiAbgr;
        this.baseAbgr = baseAbgr;
    }

    public static MaterialPalette byIndex(int i) {
        switch (i) {
            case 1: {
                return IRON;
            }
            case 2: {
                return GOLD;
            }
            case 3: {
                return DIAMOND;
            }
            case 4: {
                return NETHERITE;
            }
        }
        return EMPTY;
    }

    public static int guiColorFor(byte matIndex) {
        return MaterialPalette.byIndex((int)(matIndex & 0xFF)).guiAbgr;
    }

    public static int baseRenderColorFor(byte matIndex) {
        return MaterialPalette.byIndex((int)(matIndex & 0xFF)).baseAbgr;
    }

    public static boolean isSolid(byte matIndex) {
        int i = matIndex & 0xFF;
        return i >= 1 && i <= 4;
    }
}

