/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.rendering.util;

import net.minecraft.nbt.ByteArrayTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;

public final class BitmapPayload {
    public final int width;
    public final int height;
    public final int detailScale;
    public final byte[][] fineMaterials;
    public final int[][] fineColors;
    public final int anchorXFine;
    public final int anchorYFine;
    public final byte[][] layerL;
    public final byte[][] layerM;
    public final byte[][] layerR;
    public final int[][] colorsL;
    public final int[][] colorsM;
    public final int[][] colorsR;
    public final float thicknessL;
    public final float thicknessM;
    public final float thicknessR;
    public final byte[][] fineMaterialsL;
    public final byte[][] fineMaterialsM;
    public final byte[][] fineMaterialsR;
    public final int[][] fineColorsL;
    public final int[][] fineColorsM;
    public final int[][] fineColorsR;

    private BitmapPayload(int width, int height, int detailScale, byte[][] mergedFine, int[][] mergedColors, byte[][] layerL, byte[][] layerM, byte[][] layerR, int[][] colorsL, int[][] colorsM, int[][] colorsR, int anchorXFine, int anchorYFine, float thicknessL, float thicknessM, float thicknessR) {
        this.width = Math.max(1, width);
        this.height = Math.max(1, height);
        this.detailScale = Math.max(1, detailScale);
        int fh = this.height * this.detailScale;
        int fw = this.width * this.detailScale;
        this.fineMaterials = new byte[fh][fw];
        for (int y = 0; y < fh; ++y) {
            if (mergedFine == null || y >= mergedFine.length) continue;
            System.arraycopy(mergedFine[y], 0, this.fineMaterials[y], 0, Math.min(mergedFine[y].length, fw));
        }
        this.fineColors = BitmapPayload.copyOrNull(mergedColors, fw, fh);
        this.layerL = BitmapPayload.copyOrNull(layerL, fw, fh);
        this.layerM = BitmapPayload.copyOrNull(layerM, fw, fh);
        this.layerR = BitmapPayload.copyOrNull(layerR, fw, fh);
        this.colorsL = BitmapPayload.copyOrNull(colorsL, fw, fh);
        this.colorsM = BitmapPayload.copyOrNull(colorsM, fw, fh);
        this.colorsR = BitmapPayload.copyOrNull(colorsR, fw, fh);
        this.thicknessL = thicknessL < 0.0f ? 0.0f : thicknessL;
        this.thicknessM = thicknessM < 0.0f ? 0.0f : thicknessM;
        this.thicknessR = thicknessR < 0.0f ? 0.0f : thicknessR;
        this.fineMaterialsL = this.layerL;
        this.fineMaterialsM = this.layerM;
        this.fineMaterialsR = this.layerR;
        this.fineColorsL = this.colorsL;
        this.fineColorsM = this.colorsM;
        this.fineColorsR = this.colorsR;
        this.anchorXFine = anchorXFine;
        this.anchorYFine = anchorYFine;
    }

    private static byte[][] copyOrNull(byte[][] src, int fw, int fh) {
        if (src == null) {
            return null;
        }
        byte[][] out = new byte[fh][fw];
        for (int y = 0; y < Math.min(fh, src.length); ++y) {
            System.arraycopy(src[y], 0, out[y], 0, Math.min(fw, src[y].length));
        }
        return out;
    }

    private static int[][] copyOrNull(int[][] src, int fw, int fh) {
        if (src == null) {
            return null;
        }
        int[][] out = new int[fh][fw];
        for (int y = 0; y < Math.min(fh, src.length); ++y) {
            System.arraycopy(src[y], 0, out[y], 0, Math.min(fw, src[y].length));
        }
        return out;
    }

    public static BitmapPayload fromFineMaterials(int w, int h, int detailScale, byte[][] fine, int[][] colors, int axFine, int ayFine) {
        int ds = Math.max(1, detailScale);
        int fw = w * ds;
        int fh = h * ds;
        byte[][] merged = new byte[fh][fw];
        for (int y = 0; y < Math.min(fh, fine.length); ++y) {
            System.arraycopy(fine[y], 0, merged[y], 0, Math.min(fw, fine[y].length));
        }
        int[][] mergedColors = BitmapPayload.copyOrNull(colors, fw, fh);
        return new BitmapPayload(w, h, ds, merged, mergedColors, null, null, null, null, null, null, axFine, ayFine, 1.0f, 1.0f, 1.0f);
    }

    public static BitmapPayload fromFineMaterials3(int w, int h, int detailScale, byte[][] fineL, byte[][] fineM, byte[][] fineR, int[][] colorsL, int[][] colorsM, int[][] colorsR, int axFine, int ayFine) {
        int ds = Math.max(1, detailScale);
        int fw = w * ds;
        int fh = h * ds;
        byte[][] L = BitmapPayload.copyOrNull(fineL, fw, fh);
        byte[][] M = BitmapPayload.copyOrNull(fineM, fw, fh);
        byte[][] R = BitmapPayload.copyOrNull(fineR, fw, fh);
        int[][] cL = BitmapPayload.copyOrNull(colorsL, fw, fh);
        int[][] cM = BitmapPayload.copyOrNull(colorsM, fw, fh);
        int[][] cR = BitmapPayload.copyOrNull(colorsR, fw, fh);
        byte[][] merged = new byte[fh][fw];
        for (int y = 0; y < fh; ++y) {
            for (int x = 0; x < fw; ++x) {
                int r = R != null ? R[y][x] & 0xFF : 0;
                int m = M != null ? M[y][x] & 0xFF : 0;
                int l = L != null ? L[y][x] & 0xFF : 0;
                merged[y][x] = (byte)(r != 0 ? r : (m != 0 ? m : l));
            }
        }
        return new BitmapPayload(w, h, ds, merged, null, L, M, R, cL, cM, cR, axFine, ayFine, 1.0f, 1.0f, 1.0f);
    }

    public CompoundTag toNBT() {
        CompoundTag out = new CompoundTag();
        out.putInt("w", this.width);
        out.putInt("h", this.height);
        out.putInt("detailScale", this.detailScale);
        if (this.anchorXFine >= 0) {
            out.putInt("ax", this.anchorXFine);
        }
        if (this.anchorYFine >= 0) {
            out.putInt("ay", this.anchorYFine);
        }
        int fw = this.width * this.detailScale;
        int fh = this.height * this.detailScale;
        out.put("materials", (Tag)BitmapPayload.writeRowsBytes(this.fineMaterials, fw, fh));
        if (this.fineColors != null) {
            out.put("colors", (Tag)BitmapPayload.writeRowsInts(this.fineColors, fw, fh));
        }
        if (this.layerL != null || this.layerM != null || this.layerR != null) {
            out.put("materialsL", (Tag)BitmapPayload.writeRowsBytes(BitmapPayload.nullToZerosB(this.layerL, fw, fh), fw, fh));
            out.put("materialsM", (Tag)BitmapPayload.writeRowsBytes(BitmapPayload.nullToZerosB(this.layerM, fw, fh), fw, fh));
            out.put("materialsR", (Tag)BitmapPayload.writeRowsBytes(BitmapPayload.nullToZerosB(this.layerR, fw, fh), fw, fh));
            if (this.colorsL != null) {
                out.put("colorsL", (Tag)BitmapPayload.writeRowsInts(BitmapPayload.nullToZerosI(this.colorsL, fw, fh), fw, fh));
            }
            if (this.colorsM != null) {
                out.put("colorsM", (Tag)BitmapPayload.writeRowsInts(BitmapPayload.nullToZerosI(this.colorsM, fw, fh), fw, fh));
            }
            if (this.colorsR != null) {
                out.put("colorsR", (Tag)BitmapPayload.writeRowsInts(BitmapPayload.nullToZerosI(this.colorsR, fw, fh), fw, fh));
            }
            out.putInt("layers", 3);
            out.putFloat("thicknessL", this.thicknessL);
            out.putFloat("thicknessM", this.thicknessM);
            out.putFloat("thicknessR", this.thicknessR);
        }
        return out;
    }

    private static byte[][] nullToZerosB(byte[][] a, int fw, int fh) {
        if (a != null) {
            return a;
        }
        return new byte[fh][fw];
    }

    private static int[][] nullToZerosI(int[][] a, int fw, int fh) {
        if (a != null) {
            return a;
        }
        return new int[fh][fw];
    }

    public static BitmapPayload fromNBT(CompoundTag tag) {
        byte[][] merged;
        if (tag == null) {
            throw new IllegalArgumentException("BitmapPayload.fromNBT: null tag");
        }
        int w = Math.max(1, tag.getInt("w"));
        int h = Math.max(1, tag.getInt("h"));
        int ds = tag.contains("detailScale") ? Math.max(1, tag.getInt("detailScale")) : 1;
        int fw = w * ds;
        int fh = h * ds;
        int ax = tag.contains("ax") ? tag.getInt("ax") : -1;
        int ay = tag.contains("ay") ? tag.getInt("ay") : -1;
        byte[][] L = null;
        byte[][] M = null;
        byte[][] R = null;
        int[][] cL = null;
        int[][] cM = null;
        int[][] cR = null;
        int[][] mergedColors = null;
        boolean hasLayers = tag.contains("materialsL", 9) || tag.contains("materialsM", 9) || tag.contains("materialsR", 9);
        float tL = 1.0f;
        float tM = 1.0f;
        float tR = 1.0f;
        if (hasLayers) {
            L = BitmapPayload.readRowsBytes(tag.getList("materialsL", 10), fw, fh);
            M = BitmapPayload.readRowsBytes(tag.getList("materialsM", 10), fw, fh);
            R = BitmapPayload.readRowsBytes(tag.getList("materialsR", 10), fw, fh);
            if (tag.contains("colorsL", 9)) {
                cL = BitmapPayload.readRowsInts(tag.getList("colorsL", 10), fw, fh);
            }
            if (tag.contains("colorsM", 9)) {
                cM = BitmapPayload.readRowsInts(tag.getList("colorsM", 10), fw, fh);
            }
            if (tag.contains("colorsR", 9)) {
                cR = BitmapPayload.readRowsInts(tag.getList("colorsR", 10), fw, fh);
            }
            if (tag.contains("thicknessL")) {
                tL = tag.getFloat("thicknessL");
            }
            if (tag.contains("thicknessM")) {
                tM = tag.getFloat("thicknessM");
            }
            if (tag.contains("thicknessR")) {
                tR = tag.getFloat("thicknessR");
            }
            merged = new byte[fh][fw];
            for (int y = 0; y < fh; ++y) {
                for (int x = 0; x < fw; ++x) {
                    int r = R[y][x] & 0xFF;
                    int m = M[y][x] & 0xFF;
                    int l = L[y][x] & 0xFF;
                    merged[y][x] = (byte)(r != 0 ? r : (m != 0 ? m : l));
                }
            }
        } else {
            merged = BitmapPayload.readRowsBytes(tag.getList("materials", 10), fw, fh);
            if (merged == null || merged.length == 0) {
                merged = new byte[fh][fw];
            }
            if (tag.contains("colors", 9)) {
                mergedColors = BitmapPayload.readRowsInts(tag.getList("colors", 10), fw, fh);
            }
        }
        return new BitmapPayload(w, h, ds, merged, mergedColors, L, M, R, cL, cM, cR, ax, ay, tL, tM, tR);
    }

    private static ListTag writeRowsBytes(byte[][] grid, int fw, int fh) {
        ListTag rows = new ListTag();
        for (int y = 0; y < fh; ++y) {
            CompoundTag row = new CompoundTag();
            byte[] arr = new byte[fw];
            if (grid != null && y < grid.length) {
                System.arraycopy(grid[y], 0, arr, 0, Math.min(grid[y].length, fw));
            }
            row.put("r", (Tag)new ByteArrayTag(arr));
            rows.add((Object)row);
        }
        return rows;
    }

    private static ListTag writeRowsInts(int[][] grid, int fw, int fh) {
        ListTag rows = new ListTag();
        for (int y = 0; y < fh; ++y) {
            CompoundTag row = new CompoundTag();
            int[] arr = new int[fw];
            if (grid != null && y < grid.length) {
                System.arraycopy(grid[y], 0, arr, 0, Math.min(grid[y].length, fw));
            }
            row.put("c", (Tag)new IntArrayTag(arr));
            rows.add((Object)row);
        }
        return rows;
    }

    private static byte[][] readRowsBytes(ListTag rows, int fw, int fh) {
        if (rows == null || rows.isEmpty()) {
            return new byte[fh][fw];
        }
        byte[][] out = new byte[fh][fw];
        for (int y = 0; y < Math.min(fh, rows.size()); ++y) {
            byte[] arr = rows.getCompound(y).getByteArray("r");
            if (arr == null) continue;
            System.arraycopy(arr, 0, out[y], 0, Math.min(arr.length, fw));
        }
        return out;
    }

    private static int[][] readRowsInts(ListTag rows, int fw, int fh) {
        if (rows == null || rows.isEmpty()) {
            return new int[fh][fw];
        }
        int[][] out = new int[fh][fw];
        for (int y = 0; y < Math.min(fh, rows.size()); ++y) {
            int[] arr = rows.getCompound(y).getIntArray("c");
            if (arr == null) continue;
            System.arraycopy(arr, 0, out[y], 0, Math.min(arr.length, fw));
        }
        return out;
    }

    public boolean hasLayerL() {
        return BitmapPayload.hasAnyFill(this.layerL);
    }

    public boolean hasLayerM() {
        return BitmapPayload.hasAnyFill(this.layerM);
    }

    public boolean hasLayerR() {
        return BitmapPayload.hasAnyFill(this.layerR);
    }

    private static boolean hasAnyFill(byte[][] grid) {
        if (grid == null) {
            return false;
        }
        byte[][] byArray = grid;
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byte[] row;
            for (byte b : row = byArray[i]) {
                if ((b & 0xFF) == 0) continue;
                return true;
            }
        }
        return false;
    }

    public void forEachFilled(CellConsumer consumer) {
        int fh = this.height * this.detailScale;
        int fw = this.width * this.detailScale;
        for (int y = 0; y < fh; ++y) {
            for (int x = 0; x < fw; ++x) {
                int m = this.fineMaterials[y][x] & 0xFF;
                if (m < 1 || m > 4) continue;
                consumer.accept(x, y, m);
            }
        }
    }

    public static int toFine(int coarse, int detailScale) {
        if (coarse < 0) {
            return -1;
        }
        return coarse * Math.max(1, detailScale);
    }

    public static BitmapPayload fromFineMaterials(int w, int h, int detailScale, byte[][] fine, int axFine, int ayFine) {
        return BitmapPayload.fromFineMaterials(w, h, detailScale, fine, null, axFine, ayFine);
    }

    public static BitmapPayload fromFineMaterials3(int w, int h, int detailScale, byte[][] fineL, byte[][] fineM, byte[][] fineR, int axFine, int ayFine) {
        return BitmapPayload.fromFineMaterials3(w, h, detailScale, fineL, fineM, fineR, null, null, null, axFine, ayFine);
    }

    public int getAnchorXFine() {
        return this.anchorXFine;
    }

    public int getAnchorYFine() {
        return this.anchorYFine;
    }

    public float getThicknessL() {
        return this.thicknessL;
    }

    public float getThicknessM() {
        return this.thicknessM;
    }

    public float getThicknessR() {
        return this.thicknessR;
    }

    public static interface CellConsumer {
        public void accept(int var1, int var2, int var3);
    }
}

