/*
 * Decompiled with CFR 0.152.
 */
package org.z2six.weaponcraft.features.rendering.util;

public final class ColorUtil {
    private ColorUtil() {
    }

    private static float c01(float f) {
        return f < 0.0f ? 0.0f : (f > 1.0f ? 1.0f : f);
    }

    public static int abgr(float a, float r, float g, float b) {
        int A = (int)(ColorUtil.c01(a) * 255.0f + 0.5f);
        int R = (int)(ColorUtil.c01(r) * 255.0f + 0.5f);
        int G = (int)(ColorUtil.c01(g) * 255.0f + 0.5f);
        int B = (int)(ColorUtil.c01(b) * 255.0f + 0.5f);
        return (A & 0xFF) << 24 | (B & 0xFF) << 16 | (G & 0xFF) << 8 | R & 0xFF;
    }

    public static float[] unAbgr(int abgr) {
        float a = (float)(abgr >>> 24 & 0xFF) / 255.0f;
        float b = (float)(abgr >>> 16 & 0xFF) / 255.0f;
        float g = (float)(abgr >>> 8 & 0xFF) / 255.0f;
        float r = (float)(abgr & 0xFF) / 255.0f;
        return new float[]{r, g, b, a};
    }

    public static float[] rgbToHsv(float r, float g, float b) {
        float min;
        float max = Math.max(r, Math.max(g, b));
        float d = max - (min = Math.min(r, Math.min(g, b)));
        float h = d == 0.0f ? 0.0f : (max == r ? (g - b) / d % 6.0f : (max == g ? (b - r) / d + 2.0f : (r - g) / d + 4.0f));
        if ((h /= 6.0f) < 0.0f) {
            h += 1.0f;
        }
        float s = max == 0.0f ? 0.0f : d / max;
        float v = max;
        return new float[]{h, s, v};
    }

    public static float[] hsvToRgb(float h, float s, float v) {
        h = (h - (float)Math.floor(h)) * 6.0f;
        int i = (int)Math.floor(h);
        float f = h - (float)i;
        float p = v * (1.0f - s);
        float q = v * (1.0f - s * f);
        float t = v * (1.0f - s * (1.0f - f));
        switch (i % 6) {
            case 0: {
                return new float[]{v, t, p};
            }
            case 1: {
                return new float[]{q, v, p};
            }
            case 2: {
                return new float[]{p, v, t};
            }
            case 3: {
                return new float[]{p, q, v};
            }
            case 4: {
                return new float[]{t, p, v};
            }
        }
        return new float[]{v, p, q};
    }
}

