/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.animations;

import com.google.common.collect.Lists;
import com.hm.efn.animations.property.MyProperties;
import com.hm.efn.client.events.RenderEvents;
import com.hm.efn.util.ScanAttackConsumer;
import java.util.List;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.entity.PartEntity;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.AnimationVariables;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.AttackAnimation;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.EntityState;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.collider.Collider;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.HitEntityList;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;

public class ScanAttackAnimation
extends AttackAnimation {
    public static final AnimationVariables.SharedAnimationVariableKey<List<Entity>> SCANNED_ENTITY = AnimationVariables.shared(animator -> Lists.newArrayList(), (boolean)false);
    protected ScanAttackConsumer attackConsumer;

    public ScanAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends ScanAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(convertTime, antic, preDelay, contact, recovery, collider, colliderJoint, accessor, armature);
        this.attackConsumer = (animation, entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase) -> {};
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
    }

    public ScanAttackAnimation(float convertTime, float antic, float preDelay, float contact, float recovery, InteractionHand hand, @Nullable Collider collider, Joint colliderJoint, AnimationManager.AnimationAccessor<? extends ScanAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(convertTime, antic, preDelay, contact, recovery, hand, collider, colliderJoint, accessor, armature);
        this.attackConsumer = (animation, entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase) -> {};
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
    }

    public ScanAttackAnimation(float convertTime, AnimationManager.AnimationAccessor<? extends ScanAttackAnimation> accessor, AssetAccessor<? extends Armature> armature, AttackAnimation.Phase ... phases) {
        super(convertTime, accessor, armature, phases);
        this.attackConsumer = (animation, entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase) -> {};
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, false);
    }

    public ScanAttackAnimation(float convertTime, float antic, float contact, float recovery, InteractionHand hand, @javax.annotation.Nullable Collider collider, Joint scanner, AnimationManager.AnimationAccessor<? extends ScanAttackAnimation> accessor, AssetAccessor<? extends Armature> armature) {
        super(convertTime, accessor, armature, new AttackAnimation.Phase[]{new AttackAnimation.Phase(0.0f, antic, contact, recovery, Float.MAX_VALUE, hand, scanner, collider)});
        this.attackConsumer = (animation, entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase) -> {};
        this.addProperty((AnimationProperty.StaticAnimationProperty)AnimationProperty.ActionAnimationProperty.CANCELABLE_MOVE, true);
    }

    public static List<Entity> getScannedEntities(LivingEntityPatch<?> entityPatch) {
        return (List)entityPatch.getAnimator().getVariables().getOrDefaultSharedVariable(SCANNED_ENTITY);
    }

    public void begin(LivingEntityPatch<?> entitypatch) {
        super.begin(entitypatch);
        ScanAttackAnimation.getScannedEntities(entitypatch).clear();
    }

    public void end(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> nextAnimation, boolean isEnd) {
        super.end(entitypatch, nextAnimation, isEnd);
        entitypatch.removeHurtEntities();
        ScanAttackAnimation.getScannedEntities(entitypatch).clear();
    }

    public void tick(LivingEntityPatch<?> entitypatch) {
        super.tick(entitypatch);
        if (entitypatch.isLogicalClient() && this.getProperty((AnimationProperty)MyProperties.INVISIBLE_PHASE).isPresent()) {
            if (((MyProperties.SpecialPhase)this.getProperty((AnimationProperty)MyProperties.INVISIBLE_PHASE).get()).isInPhase(entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor()).getElapsedTime())) {
                RenderEvents.HiddenEntity((LivingEntity)entitypatch.getOriginal(), 10);
            } else {
                RenderEvents.UnhiddenEntity((LivingEntity)entitypatch.getOriginal());
            }
        }
    }

    public ScanAttackAnimation setAttackConsumer(ScanAttackConsumer consumer) {
        this.attackConsumer = consumer;
        return this;
    }

    public void modifyPose(DynamicAnimation animation, Pose pose, LivingEntityPatch<?> entitypatch, float time, float partialTicks) {
        AnimationProperty.PoseModifier modifier;
        if (this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.COORD).isEmpty()) {
            JointTransform jt = pose.orElseEmpty("Root");
            Vec3f jointPosition = jt.translation();
            OpenMatrix4f toRootTransformApplied = entitypatch.getArmature().searchJointByName("Root").getLocalTransform().removeTranslation();
            OpenMatrix4f toOrigin = OpenMatrix4f.invert((OpenMatrix4f)toRootTransformApplied, null);
            Vec3f worldPosition = OpenMatrix4f.transform3v((OpenMatrix4f)toRootTransformApplied, (Vec3f)jointPosition, null);
            if (!this.getProperty((AnimationProperty)MyProperties.MOVE_ROOT_PHASE).isPresent() || !((MyProperties.SpecialPhase)this.getProperty((AnimationProperty)MyProperties.MOVE_ROOT_PHASE).get()).isInPhase(time)) {
                worldPosition.x = 0.0f;
                worldPosition.y = this.getProperty((AnimationProperty)AnimationProperty.ActionAnimationProperty.MOVE_VERTICAL).orElse(false) != false && worldPosition.y > 0.0f ? 0.0f : worldPosition.y;
                worldPosition.z = 0.0f;
            }
            OpenMatrix4f.transform3v((OpenMatrix4f)toOrigin, (Vec3f)worldPosition, (Vec3f)worldPosition);
            jointPosition.x = worldPosition.x;
            jointPosition.y = worldPosition.y;
            jointPosition.z = worldPosition.z;
        }
        if ((modifier = (AnimationProperty.PoseModifier)this.getProperty((AnimationProperty)AnimationProperty.StaticAnimationProperty.POSE_MODIFIER).orElse(null)) != null) {
            modifier.modify(animation, pose, entitypatch, time, partialTicks);
        }
    }

    protected Vec3 getCoordVector(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> dynamicAnimation) {
        Vec3 vec3 = super.getCoordVector(entitypatch, dynamicAnimation);
        AnimationPlayer animPlayer = entitypatch.getAnimator().getPlayerFor(dynamicAnimation);
        if (animPlayer == null) {
            return vec3;
        }
        float t = animPlayer.getElapsedTime();
        if (this.getProperty((AnimationProperty)MyProperties.MOVE_ROOT_PHASE).isPresent() && ((MyProperties.SpecialPhase)this.getProperty((AnimationProperty)MyProperties.MOVE_ROOT_PHASE).get()).isInPhase(t)) {
            vec3 = vec3.m_82542_(0.0, 0.0, 0.0);
        }
        return vec3;
    }

    public void attackTick(LivingEntityPatch<?> entitypatch, AssetAccessor<? extends DynamicAnimation> animation) {
        AnimationPlayer player = entitypatch.getAnimator().getPlayerFor((AssetAccessor)this.getAccessor());
        float elapsedTime = player.getElapsedTime();
        float prevElapsedTime = player.getPrevElapsedTime();
        EntityState state = this.getState(entitypatch, elapsedTime);
        EntityState prevState = this.getState(entitypatch, prevElapsedTime);
        AttackAnimation.Phase phase = this.getPhaseByTime(elapsedTime);
        if (state.getLevel() == 1 && !state.turningLocked() && entitypatch instanceof MobPatch) {
            MobPatch mobpatch = (MobPatch)entitypatch;
            ((Mob)mobpatch.getOriginal()).m_21573_().m_26573_();
            ((LivingEntity)entitypatch.getOriginal()).f_20921_ = 2.0f;
            LivingEntity target = entitypatch.getTarget();
            if (target != null) {
                entitypatch.rotateTo((Entity)target, entitypatch.getYRotLimit(), false);
            }
        }
        if (prevState.attacking() || state.attacking() || prevState.getLevel() < 2 && state.getLevel() > 2) {
            if (!prevState.attacking()) {
                entitypatch.removeHurtEntities();
            }
            this.ScanTarget(entitypatch, prevElapsedTime, elapsedTime, prevState, state, phase);
        }
    }

    public void ScanTarget(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
        LivingEntity entity = (LivingEntity)entitypatch.getOriginal();
        float prevPoseTime = prevState.attacking() ? prevElapsedTime : phase.preDelay;
        float poseTime = state.attacking() ? elapsedTime : phase.contact;
        List list = this.getPhaseByTime(elapsedTime).getCollidingEntities(entitypatch, (AttackAnimation)this, prevPoseTime, poseTime, this.getPlaySpeed(entitypatch, (DynamicAnimation)this));
        if (list.size() > 0) {
            HitEntityList hitEntities = new HitEntityList(entitypatch, list, HitEntityList.Priority.DISTANCE);
            ((LivingEntity)entitypatch.getOriginal()).m_21335_((Entity)list.get(0));
            while (entitypatch.getCurrentlyActuallyHitEntities().size() < this.getMaxStrikes(entitypatch, phase) && hitEntities.next()) {
                Entity e = hitEntities.getEntity();
                if (!e.m_6084_()) continue;
                LivingEntity trueEntity = this.getTrueEntity(e);
                if (entitypatch.isTargetInvulnerable(e) || trueEntity == null || !(e instanceof LivingEntity) && !(e instanceof PartEntity) || !entity.m_142582_(e) || ScanAttackAnimation.getScannedEntities(entitypatch).contains(e)) continue;
                if (!entitypatch.getCurrentlyActuallyHitEntities().contains(trueEntity)) {
                    entitypatch.getCurrentlyActuallyHitEntities().add(trueEntity);
                }
                ScanAttackAnimation.getScannedEntities(entitypatch).add(e);
            }
        }
        if (!entitypatch.getCurrentlyActuallyHitEntities().contains(entitypatch.getOriginal())) {
            entitypatch.getCurrentlyActuallyHitEntities().add((LivingEntity)entitypatch.getOriginal());
        }
    }

    public void hurtCollidingEntities(LivingEntityPatch<?> entitypatch, float prevElapsedTime, float elapsedTime, EntityState prevState, EntityState state, AttackAnimation.Phase phase) {
    }

    public boolean isBasicAttackAnimation() {
        return true;
    }
}

