/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.client.input;

import com.hm.efn.client.input.keymapping.EFNKeyMappings;
import com.hm.efn.gameasset.combos.Aetherialdusk;
import com.hm.efn.gameasset.combos.Beastclaw;
import com.hm.efn.gameasset.combos.Exsiliumgladius;
import com.hm.efn.gameasset.combos.Meenlance;
import com.hm.efn.gameasset.combos.Pioneer;
import com.hm.efn.gameasset.combos.Ruinsgreatsword;
import com.hm.efn.gameasset.combos.Shortsword;
import com.hm.efn.gameasset.combos.Yamato;
import com.hm.efn.registries.EFNDataKey;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.BitSet;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.input.EpicFightKeyMappings;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class PressKeyHandler {
    private static final int KEY_COUNT = 5;
    private static final BitSet currentPressed = new BitSet(5);
    private static final BitSet lastPressed = new BitSet(5);
    private static final int[] KEY_MAPPINGS = new int[]{InvincibleKeyMappings.KEY1.getKey().m_84873_(), InvincibleKeyMappings.KEY2.getKey().m_84873_(), InvincibleKeyMappings.KEY3.getKey().m_84873_(), InvincibleKeyMappings.KEY4.getKey().m_84873_(), EpicFightKeyMappings.WEAPON_INNATE_SKILL.getKey().m_84873_()};

    @SubscribeEvent
    public static void onInputEvent(InputEvent event) {
        if (event instanceof InputEvent.Key) {
            InputEvent.Key keyEvent = (InputEvent.Key)event;
            PressKeyHandler.handleKeyInput(keyEvent.getKey(), keyEvent.getAction());
        } else if (event instanceof InputEvent.MouseButton.Pre) {
            InputEvent.MouseButton.Pre mouseEvent = (InputEvent.MouseButton.Pre)event;
            PressKeyHandler.handleKeyInput(mouseEvent.getButton(), mouseEvent.getAction());
        }
    }

    @SubscribeEvent
    public static void onClientTick(TickEvent.ClientTickEvent event) {
        boolean currentKeyState;
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        LocalPlayerPatch playerPatch = ClientEngine.getInstance().getPlayerPatch();
        if (playerPatch == null || !PressKeyHandler.hasRequiredWeapon((LivingEntity)playerPatch.getOriginal())) {
            return;
        }
        SkillContainer container = playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
        if (container == null) {
            return;
        }
        SkillDataManager manager = container.getDataManager();
        if (manager == null) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            boolean last;
            boolean current = currentPressed.get(i);
            if (current == (last = lastPressed.get(i))) continue;
            PressKeyHandler.syncKeyState(manager, i, current);
        }
        if (playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof ComboBasicAttack) {
            currentKeyState = EFNKeyMappings.ANGEL.m_90857_();
            if ((Boolean)manager.getDataValue(EFNDataKey.ANGEL_KEY.get()) != currentKeyState) {
                manager.setDataSync(EFNDataKey.ANGEL_KEY.get(), (Object)currentKeyState, (LocalPlayer)playerPatch.getOriginal());
            }
        }
        if (playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof ComboBasicAttack) {
            currentKeyState = Minecraft.m_91087_().f_91066_.f_92089_.m_90857_();
            if ((Boolean)manager.getDataValue(EFNDataKey.JUMP_KEY.get()) != currentKeyState) {
                manager.setDataSync(EFNDataKey.JUMP_KEY.get(), (Object)currentKeyState, (LocalPlayer)playerPatch.getOriginal());
            }
        }
        if (playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof ComboBasicAttack) {
            currentKeyState = Minecraft.m_91087_().f_91066_.f_92090_.m_90857_();
            if ((Boolean)manager.getDataValue(EFNDataKey.SNEAK_KEY.get()) != currentKeyState) {
                manager.setDataSync(EFNDataKey.SNEAK_KEY.get(), (Object)currentKeyState, (LocalPlayer)playerPatch.getOriginal());
            }
        }
        if (playerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE).getSkill() instanceof ComboBasicAttack) {
            currentKeyState = EFNKeyMappings.DEMON.m_90857_();
            if ((Boolean)manager.getDataValue(EFNDataKey.DEMON_KEY.get()) != currentKeyState) {
                manager.setDataSync(EFNDataKey.DEMON_KEY.get(), (Object)currentKeyState, (LocalPlayer)playerPatch.getOriginal());
            }
        }
        lastPressed.clear();
        lastPressed.or(currentPressed);
    }

    public static boolean hasRequiredWeapon(LivingEntity entity) {
        if (!(entity instanceof Player)) {
            return false;
        }
        PlayerPatch playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, PlayerPatch.class);
        if (playerPatch == null) {
            return false;
        }
        return playerPatch.getSkill(Aetherialdusk.Aetherialdusk) != null || playerPatch.getSkill(Meenlance.Meenlance) != null || playerPatch.getSkill(Pioneer.pioneer) != null || playerPatch.getSkill(Beastclaw.beastclaw) != null || playerPatch.getSkill(Exsiliumgladius.exsiliumgladius) != null || playerPatch.getSkill(Yamato.yamato) != null || playerPatch.getSkill(Shortsword.shortsword) != null || playerPatch.getSkill(Ruinsgreatsword.Ruinsgreatsword) != null;
    }

    private static void handleKeyInput(int keyCode, int action) {
        for (int i = 0; i < KEY_MAPPINGS.length; ++i) {
            if (keyCode != KEY_MAPPINGS[i]) continue;
            currentPressed.set(i, action != 0);
            break;
        }
    }

    private static void syncKeyState(SkillDataManager manager, int keyIndex, boolean isPressed) {
        switch (keyIndex) {
            case 0: {
                manager.setDataSync(EFNDataKey.KEY1_PRESS.get(), (Object)isPressed);
                break;
            }
            case 1: {
                manager.setDataSync(EFNDataKey.KEY2_PRESS.get(), (Object)isPressed);
                break;
            }
            case 2: {
                manager.setDataSync(EFNDataKey.KEY3_PRESS.get(), (Object)isPressed);
                break;
            }
            case 3: {
                manager.setDataSync(EFNDataKey.KEY4_PRESS.get(), (Object)isPressed);
                break;
            }
            case 4: {
                manager.setDataSync(EFNDataKey.INNATE_PRESS.get(), (Object)isPressed);
            }
        }
    }

    public static boolean isKeyPressed(int index) {
        return index >= 0 && index < 5 && currentPressed.get(index);
    }
}

