/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.comboevents;

import com.hm.efn.EFNConfig;
import com.hm.efn.entity.effect.SummonedSwordEntity_In;
import com.hm.efn.entity.effect.SummonedSwordEntity_Out;
import com.hm.efn.gameasset.combos.Yamato;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.p1nero.invincible.api.events.BaseEvent;
import com.p1nero.invincible.api.skill.ComboNode;
import com.p1nero.invincible.api.skill.ComboType;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillSlot;
import yesman.epicfight.skill.SkillSlots;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class HitEvents {
    protected final BiConsumer<LivingEntityPatch<?>, Entity> event;

    public HitEvents(BiConsumer<LivingEntityPatch<?>, Entity> event) {
        this.event = event;
    }

    public static BaseEvent createSoundHitEvent(SoundEvent sound) {
        return new BaseEvent((entityPatch, target) -> {
            if (!entityPatch.isLogicalClient()) {
                entityPatch.playSound(sound, 0.0f, 0.0f);
            }
        });
    }

    public static BaseEvent createParticleHitEvent(ParticleOptions particle, int count) {
        return new BaseEvent((entityPatch, target) -> {
            Level level;
            if (!entityPatch.isLogicalClient() && (level = ((Player)entityPatch.getOriginal()).m_9236_()) instanceof ServerLevel) {
                ((ServerLevel)level).m_8767_(particle, ((Player)entityPatch.getOriginal()).m_20185_(), ((Player)entityPatch.getOriginal()).m_20186_(), ((Player)entityPatch.getOriginal()).m_20189_(), count, 0.0, 0.0, 0.0, 0.0);
            }
        });
    }

    public static BaseEvent knockBackEntity(Vec3 sourceLocation, float power) {
        return new BaseEvent((entityPatch, target) -> {
            if (entityPatch != null && target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                double d1 = sourceLocation.m_7096_() - livingTarget.m_20185_();
                double d0 = sourceLocation.m_7094_() - livingTarget.m_20189_();
                while (d1 * d1 + d0 * d0 < 1.0E-4) {
                    d1 = (Math.random() - Math.random()) * 0.01;
                    d0 = (Math.random() - Math.random()) * 0.01;
                }
                float finalPower = power * (1.0f - (float)livingTarget.m_21133_(Attributes.f_22278_));
                if (finalPower > 0.0f) {
                    livingTarget.f_19864_ = true;
                    livingTarget.f_19812_ = true;
                    Vec3 currentMotion = livingTarget.m_20184_();
                    Vec3 knockbackVec = new Vec3(d1, 0.0, d0).m_82541_().m_82490_((double)finalPower);
                    livingTarget.m_20334_(currentMotion.f_82479_ / 2.0 - knockbackVec.f_82479_, livingTarget.m_20096_() ? Math.min(0.4, currentMotion.f_82480_ / 2.0) : currentMotion.f_82480_, currentMotion.f_82481_ / 2.0 - knockbackVec.f_82481_);
                }
            }
        });
    }

    public static BaseEvent summonSingleSwordAtPlayerWaist(Vec3 offset, float scale) {
        return BaseEvent.createServerEvent((playerPatch, entity) -> {
            if (playerPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
                SummonedSwordEntity_Out.summonAtWaist(serverPlayerPatch, offset, scale);
            }
        });
    }

    public static BaseEvent summonSingleSwordAtTargetWaist(Vec3 offset, float scale) {
        return BaseEvent.createServerEvent((playerPatch, entity) -> {
            if (playerPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
                LivingEntity target = playerPatch.getTarget();
                if (target != null && target.m_6084_()) {
                    SummonedSwordEntity_In.summonAtTargetWaist(serverPlayerPatch, target, offset, scale);
                    target.m_7292_(new MobEffectInstance(MobEffects.f_19615_, 100, 4));
                }
            }
        });
    }

    public static BaseEvent addEffectToPlayer(Supplier<MobEffect> effectSupplier, int duration, int amplifier) {
        return BaseEvent.createServerEvent((playerPatch, entity) -> {
            if (playerPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)playerPatch;
                ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
                player.m_7292_(new MobEffectInstance((MobEffect)effectSupplier.get(), duration, amplifier, false, false, false));
            }
        });
    }

    public static BaseEvent summonSingleSwordHitAtTargetWaist(Vec3 offset, float scale, int stackCost) {
        return new BaseEvent((entityPatch, target) -> {
            if (!entityPatch.isLogicalClient() && entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch = (ServerPlayerPatch)entityPatch;
                try {
                    int currentStack;
                    ServerPlayer player = (ServerPlayer)serverPlayerPatch.getOriginal();
                    boolean isCreativeMode = player.m_7500_();
                    SkillContainer container = serverPlayerPatch.getSkill(Yamato.yamato);
                    if (container == null) {
                        return;
                    }
                    if (!isCreativeMode && (currentStack = container.getStack()) < stackCost) {
                        return;
                    }
                    CompoundTag persistentData = player.getPersistentData();
                    long lastSummonTime = persistentData.m_128454_("LastSummonTime");
                    long currentTime = player.m_9236_().m_46467_();
                    if (currentTime - lastSummonTime < 20L) {
                        return;
                    }
                    LivingEntity currentTarget = serverPlayerPatch.getTarget();
                    if (currentTarget == null || !currentTarget.m_6084_()) {
                        return;
                    }
                    if (!isCreativeMode) {
                        int currentStack2 = container.getStack();
                        container.getSkill().setStackSynchronize(container, currentStack2 - stackCost);
                    }
                    SummonedSwordEntity_In.summonAtTargetWaist(serverPlayerPatch, currentTarget, offset, scale);
                    persistentData.m_128356_("LastSummonTime", currentTime);
                }
                catch (Exception e) {
                    System.err.println("Error in summonSingleSwordHitAtTargetWaist: " + e.getMessage());
                    e.printStackTrace();
                }
            }
        });
    }

    public static BaseEvent consumeStackBegin(int stackCost) {
        return BaseEvent.createServerEvent((serverPlayerPatch, target) -> {
            SkillContainer container = serverPlayerPatch.getSkill((SkillSlot)SkillSlots.WEAPON_INNATE);
            if (container != null && container.getStack() >= stackCost) {
                container.getSkill().setStackSynchronize(container, container.getStack() - stackCost);
            }
        });
    }

    public static BaseEvent knockBackEntityEnhanced(float verticalPower, float horizontalPower, int cooldownTicks) {
        return new BaseEvent((attackerPatch, target) -> {
            if (attackerPatch.isLogicalClient() || !(target instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            CompoundTag targetData = livingTarget.getPersistentData();
            String cooldownKey = "efn_knockback_cooldown";
            long currentTick = livingTarget.m_9236_().m_46467_();
            if (targetData.m_128441_(cooldownKey) && currentTick - targetData.m_128454_(cooldownKey) < (long)cooldownTicks) {
                return;
            }
            Vec3 attackerPos = ((Player)attackerPatch.getOriginal()).m_20182_();
            Vec3 targetPos = livingTarget.m_20182_();
            Vec3 direction = new Vec3(targetPos.f_82479_ - attackerPos.f_82479_, 0.0, targetPos.f_82481_ - attackerPos.f_82481_).m_82541_();
            float resistance = (float)livingTarget.m_21133_(Attributes.f_22278_);
            float finalHorizontal = horizontalPower * (1.0f - resistance);
            float finalVertical = verticalPower * (1.0f - resistance);
            if (finalHorizontal > 0.0f || finalVertical > 0.0f) {
                livingTarget.f_19864_ = true;
                livingTarget.f_19812_ = true;
                Vec3 currentMotion = livingTarget.m_20184_();
                Vec3 knockback = new Vec3(direction.f_82479_ * (double)finalHorizontal, (double)finalVertical, direction.f_82481_ * (double)finalHorizontal);
                livingTarget.m_20334_(currentMotion.f_82479_ / 2.0 + knockback.f_82479_, livingTarget.m_20096_() ? Math.max(currentMotion.f_82480_, knockback.f_82480_) : currentMotion.f_82480_ + knockback.f_82480_ * 0.5, currentMotion.f_82481_ / 2.0 + knockback.f_82481_);
                targetData.m_128356_(cooldownKey, currentTick);
            }
        });
    }

    public static BaseEvent knockBackEntityEnhanced(float verticalPower, float horizontalPower) {
        return HitEvents.knockBackEntityEnhanced(verticalPower, horizontalPower, 20);
    }

    public static BaseEvent knockBackFromEntity(float power) {
        return new BaseEvent((entityPatch, target, invinciblePlayer) -> {
            if (entityPatch != null && target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                LivingEntity source = (LivingEntity)entityPatch.getOriginal();
                HitEvents.knockBackEntity(source.m_20182_(), power).testAndExecute(entityPatch, target, invinciblePlayer);
            }
        });
    }

    public static BaseEvent consumeStamina(float consumeStamina) {
        return new BaseEvent((entityPatch, target) -> {
            if (entityPatch instanceof ServerPlayerPatch) {
                ServerPlayerPatch serverPlayerPatch;
                float currentStamina = (serverPlayerPatch = (ServerPlayerPatch)entityPatch).getStamina();
                serverPlayerPatch.setStamina(currentStamina < consumeStamina ? 0.0f : currentStamina - consumeStamina);
            }
        });
    }

    public static BaseEvent createLostHealthDamage_Meen(float percentage) {
        return new BaseEvent((attackerPatch, target) -> {
            ServerPlayer player;
            block5: {
                block4: {
                    Entity patt12755$temp;
                    if (attackerPatch.isLogicalClient() || !((patt12755$temp = attackerPatch.getOriginal()) instanceof ServerPlayer)) break block4;
                    player = (ServerPlayer)patt12755$temp;
                    if (target instanceof LivingEntity) break block5;
                }
                return;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            MobEffectInstance effect = player.m_21124_((MobEffect)EFNMobEffectRegistry.MEEN_LANCE.get());
            if (effect == null || effect.m_19557_() <= 0) {
                return;
            }
            HitEvents.processLostHealthDamage((Player)player, livingTarget, percentage, 20.0f);
        });
    }

    public static BaseEvent createLostHealthDamage_Blood(float percentage) {
        return new BaseEvent((attackerPatch, target) -> {
            ServerPlayer player;
            block5: {
                block4: {
                    Entity patt13447$temp;
                    if (attackerPatch.isLogicalClient() || !((patt13447$temp = attackerPatch.getOriginal()) instanceof ServerPlayer)) break block4;
                    player = (ServerPlayer)patt13447$temp;
                    if (target instanceof LivingEntity) break block5;
                }
                return;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            MobEffectInstance effect = player.m_21124_((MobEffect)EFNMobEffectRegistry.BLODDLUST.get());
            if (effect == null || effect.m_19557_() <= 0) {
                return;
            }
            HitEvents.processLostHealthDamage((Player)player, livingTarget, percentage, 20.0f);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processPercentageDamage(Player player, LivingEntity target, float damage) {
        CompoundTag compoundTag = target.getPersistentData();
        synchronized (compoundTag) {
            if (target.getPersistentData().m_128441_("efn_percentageDamageProcessing")) {
                return;
            }
            try {
                target.getPersistentData().m_128379_("efn_percentageDamageProcessing", true);
                if (damage > 0.0f) {
                    target.m_6469_(target.m_269291_().m_269075_(player), damage);
                }
            }
            finally {
                target.getPersistentData().m_128473_("efn_percentageDamageProcessing");
            }
        }
    }

    public static BaseEvent createLostHealthDamage(float percentage) {
        return new BaseEvent((attackerPatch, target) -> {
            ServerPlayer player;
            block3: {
                block2: {
                    Entity patt16387$temp;
                    if (attackerPatch.isLogicalClient() || !((patt16387$temp = attackerPatch.getOriginal()) instanceof ServerPlayer)) break block2;
                    player = (ServerPlayer)patt16387$temp;
                    if (target instanceof LivingEntity) break block3;
                }
                return;
            }
            LivingEntity livingTarget = (LivingEntity)target;
            HitEvents.processLostHealthDamage((Player)player, livingTarget, percentage, 30.0f);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processLostHealthDamage(Player player, LivingEntity target, float percentage, float maxDamage) {
        CompoundTag compoundTag = target.getPersistentData();
        synchronized (compoundTag) {
            if (target.getPersistentData().m_128441_("efn_lostHealthDamageProcessing")) {
                return;
            }
            try {
                target.getPersistentData().m_128379_("efn_lostHealthDamageProcessing", true);
                float maxHealth = target.m_21233_();
                float currentHealth = target.m_21223_();
                float damage = (maxHealth - currentHealth) * percentage;
                damage = Math.min(damage, maxDamage);
                damage = Math.max(damage, 1.0f);
                if (damage > 0.0f) {
                    target.m_6469_(target.m_269291_().m_269075_(player), damage);
                }
            }
            finally {
                target.getPersistentData().m_128473_("efn_lostHealthDamageProcessing");
            }
        }
    }

    public static BaseEvent addEffect(Supplier<MobEffect> effect, int level, int duration) {
        return new BaseEvent((entityPatch, target) -> {
            if (!entityPatch.isLogicalClient() && target instanceof LivingEntity) {
                LivingEntity livingTarget = (LivingEntity)target;
                livingTarget.m_7292_(new MobEffectInstance((MobEffect)effect.get(), duration, level));
            }
        });
    }

    public static BaseEvent addEffect(MobEffect effect, int level, int duration) {
        return HitEvents.addEffect(() -> effect, level, duration);
    }

    public static BaseEvent playTargetAnimation(Supplier<? extends StaticAnimation> animation, float convertTime, float cooldown) {
        return new BaseEvent((entityPatch, entity) -> {
            long lastTriggerTick;
            if (entityPatch == null || !(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingTarget = (LivingEntity)entity;
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)livingTarget.m_6095_());
            if (entityId != null && ((List)EFNConfig.ANIMATION_BLACKLIST.get()).contains(entityId.toString())) {
                return;
            }
            LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)livingTarget, LivingEntityPatch.class);
            if (targetPatch == null) {
                return;
            }
            CompoundTag persistentData = livingTarget.getPersistentData();
            String cooldownKey = "efn_anim_cooldown_" + ((StaticAnimation)animation.get()).getRegistryName();
            long currentTick = livingTarget.m_9236_().m_46467_();
            if ((float)(currentTick - (lastTriggerTick = persistentData.m_128454_(cooldownKey))) < cooldown * 20.0f) {
                return;
            }
            persistentData.m_128356_(cooldownKey, currentTick);
            targetPatch.playAnimationSynchronized((AssetAccessor)((StaticAnimation)animation.get()).getAccessor(), convertTime);
        });
    }

    public static BaseEvent playTargetAnimationWithGroundCheck(Supplier<? extends StaticAnimation> groundAnimation, Supplier<? extends StaticAnimation> airAnimation, float convertTime, float cooldown) {
        return new BaseEvent((entityPatch, entity) -> {
            long lastTriggerTick;
            if (entityPatch == null || !(entity instanceof LivingEntity)) {
                return;
            }
            LivingEntity livingTarget = (LivingEntity)entity;
            ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)livingTarget.m_6095_());
            if (entityId != null && ((List)EFNConfig.ANIMATION_BLACKLIST.get()).contains(entityId.toString())) {
                return;
            }
            LivingEntityPatch targetPatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)livingTarget, LivingEntityPatch.class);
            if (targetPatch == null) {
                return;
            }
            CompoundTag persistentData = livingTarget.getPersistentData();
            boolean isGrounded = livingTarget.m_20096_();
            String animationName = String.valueOf(((StaticAnimation)(isGrounded ? groundAnimation : airAnimation).get()).getRegistryName());
            String cooldownKey = "efn_anim_cooldown_" + animationName;
            long currentTick = livingTarget.m_9236_().m_46467_();
            if ((float)(currentTick - (lastTriggerTick = persistentData.m_128454_(cooldownKey))) < cooldown * 20.0f) {
                return;
            }
            StaticAnimation selectedAnimation = isGrounded ? (StaticAnimation)groundAnimation.get() : (StaticAnimation)airAnimation.get();
            persistentData.m_128356_(cooldownKey, currentTick);
            targetPatch.playAnimationSynchronized((AssetAccessor)selectedAnimation.getAccessor(), convertTime);
        });
    }

    public static BaseEvent consumeStack(int stackCost) {
        return new BaseEvent((entityPatch, target) -> {
            ServerPlayerPatch serverPlayerPatch;
            SkillContainer container;
            if (entityPatch instanceof ServerPlayerPatch && (container = (serverPlayerPatch = (ServerPlayerPatch)entityPatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE)) != null && container.getStack() >= stackCost) {
                container.getSkill().setStackSynchronize(container, container.getStack() - stackCost);
            }
        });
    }

    public static BaseEvent consumeConsumption(float amount) {
        return new BaseEvent((entityPatch, target) -> {
            ServerPlayerPatch serverPlayerPatch;
            SkillContainer container;
            if (entityPatch instanceof ServerPlayerPatch && (container = (serverPlayerPatch = (ServerPlayerPatch)entityPatch).getSkill((SkillSlot)SkillSlots.WEAPON_INNATE)) != null) {
                float newValue = Math.max(0.0f, container.getResource() - amount);
                container.getSkill().setConsumptionSynchronize(container, newValue);
            }
        });
    }

    public static BaseEvent HitSimulationComboNodeEvent(ComboNode.ComboTypes comboType) {
        return new BaseEvent((entityPatch, target) -> {
            Entity patt22790$temp = entityPatch.getOriginal();
            if (patt22790$temp instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)patt22790$temp;
                ComboBasicAttack.executeOnServer((ServerPlayer)serverPlayer, (ComboType)comboType);
            }
        });
    }
}

