/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.effect;

import com.hm.efn.entity.EFNEntity;
import com.hm.efn.entity.doppelganger.DoppelgangerEntity;
import com.hm.efn.gameasset.EFNAnimations;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Armatures;

public class SummonedSwordEntity
extends VFXEntity {
    private int tickCount = 0;
    private boolean hasAppliedTargetRotation = false;
    private final float targetYRot = 0.0f;

    public SummonedSwordEntity(LivingEntity owner, float scale, Vec3 offset) {
        super((EntityType)EFNEntity.SUMMONED_SWORD.get(), owner, scale);
        this.f_19811_ = true;
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    public SummonedSwordEntity(EntityType<? extends VFXEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19811_ = true;
        this.f_19794_ = true;
        this.m_20242_(true);
    }

    private static float normalizeAngle(float angle) {
        if ((angle %= 360.0f) > 180.0f) {
            angle -= 360.0f;
        } else if (angle < -180.0f) {
            angle += 360.0f;
        }
        return angle;
    }

    private static float calculateTargetYRotation(Vec3 spawnPos, LivingEntity target, ServerPlayer player) {
        if (target != null) {
            Vec3 targetPos = target.m_146892_();
            Vec3 toTarget = targetPos.m_82546_(spawnPos);
            float rawAngle = (float)Math.toDegrees(Math.atan2(toTarget.f_82479_, toTarget.f_82481_));
            float minecraftYRot = -rawAngle;
            return SummonedSwordEntity.normalizeAngle(minecraftYRot);
        }
        return player.m_146908_();
    }

    private static boolean isHostileMob(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        if (entity instanceof DoppelgangerEntity) {
            return false;
        }
        return entity instanceof Enemy || entity instanceof Monster || entity.m_6095_() == EntityType.f_20526_ || entity.m_6095_() == EntityType.f_20468_ || entity.m_6095_() == EntityType.f_20509_ || entity.m_6095_() == EntityType.f_20453_;
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.tickCount;
        if (!this.m_9236_().f_46443_ && !this.hasAppliedTargetRotation && this.tickCount <= 20) {
            this.applyTargetRotation();
        }
    }

    private void applyTargetRotation() {
        float rawCurrentYRot = this.m_146908_();
        float currentYRot = SummonedSwordEntity.normalizeAngle(rawCurrentYRot);
        float normalizedTargetYRot = SummonedSwordEntity.normalizeAngle(0.0f);
        float shortestPath = this.calculateShortestRotation(currentYRot, normalizedTargetYRot);
        float newYRot = currentYRot + shortestPath * 0.3f;
        this.m_146922_(newYRot);
        this.m_5618_(newYRot);
        this.m_5616_(newYRot);
        float remainingPath = this.calculateShortestRotation(newYRot, normalizedTargetYRot);
        if (Math.abs(remainingPath) < 0.5f || this.tickCount <= 20) {
            this.m_146922_(normalizedTargetYRot);
            this.m_5618_(normalizedTargetYRot);
            this.m_5616_(normalizedTargetYRot);
            this.hasAppliedTargetRotation = true;
        }
    }

    private float calculateShortestRotation(float current, float target) {
        float diff = target - current;
        if (diff > 180.0f) {
            diff -= 360.0f;
        } else if (diff < -180.0f) {
            diff += 360.0f;
        }
        return diff;
    }

    public float getTargetYRot() {
        return 0.0f;
    }

    public boolean hasAppliedTargetRotation() {
        return this.hasAppliedTargetRotation;
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getIdleAnimation() {
        return EFNAnimations.SUMMONED_SWORD_IDLE;
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDefaultAnimation() {
        return EFNAnimations.SUMMONED_SWORD_IDLE;
    }

    @Nullable
    public Armature getArmature() {
        return Armatures.ArmatureAccessor.create((String)"efn", (String)"entity/effect/summoned_sword", Armature::new).get();
    }

    @Nullable
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.MeshAccessor.create((String)"efn", (String)"entity/effect/summoned_sword", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }

    @Nullable
    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/summoned_sword.png");
    }

    @Nullable
    public ResourceLocation getLitTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/summoned_sword.png");
    }
}

