/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.entity.effect;

import com.hm.efn.entity.EFNEntity;
import com.hm.efn.gameasset.EFNAnimations;
import com.hm.efn.gameasset.EFNWeaponCategories;
import com.hm.efn.registries.EFNMobEffectRegistry;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;

public class SummonedSwordEntity_Out
extends VFXEntity {
    private static final int MAX_LIFE_TIME = 600;
    private LivingEntity owner;
    private Vec3 offset;
    private Vec3 lastOwnerPos;
    private Vec3 lastOwnerMotion;
    private int lifeTime = 0;
    private boolean shouldRemove = false;
    private boolean effectsApplied = false;

    public SummonedSwordEntity_Out(LivingEntity owner, float scale, Vec3 offset) {
        super((EntityType)EFNEntity.SUMMONED_SWORD_OUT.get(), owner, scale);
        this.owner = owner;
        this.f_19811_ = true;
        this.offset = offset;
        this.f_19794_ = true;
        this.m_20331_(true);
        this.lastOwnerPos = owner.m_20182_();
        this.lastOwnerMotion = Vec3.f_82478_;
        this.m_20242_(true);
    }

    public SummonedSwordEntity_Out(EntityType<? extends VFXEntity> entityType, Level level) {
        super(entityType, level);
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.m_20331_(true);
        this.m_20242_(true);
    }

    public static boolean isHoldingYamato(Player player) {
        if (player == null) {
            return false;
        }
        return Stream.of(player.m_21205_(), player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == EFNWeaponCategories.EFN_YAMATO);
    }

    public static void summonAtWaist(ServerPlayerPatch ownerPatch, Vec3 offset, float scale) {
        LivingEntity owner = (LivingEntity)ownerPatch.getOriginal();
        ServerLevel level = (ServerLevel)owner.m_9236_();
        Vec3 waistPos = owner.m_20182_().m_82520_(0.0, (double)owner.m_20206_() * 0.6, 0.0);
        Vec3 spawnPos = waistPos.m_82549_(offset);
        SummonedSwordEntity_Out sword = new SummonedSwordEntity_Out(owner, scale, offset);
        sword.m_146884_(spawnPos);
        sword.m_146922_(owner.m_146908_());
        sword.m_146926_(0.0f);
        level.m_6263_(null, owner.m_20185_(), owner.m_20186_(), owner.m_20189_(), SoundEvents.f_144049_, SoundSource.PLAYERS, 1.0f, 1.0f);
        level.m_7967_((Entity)sword);
    }

    public void markForRemoval() {
        this.shouldRemove = true;
    }

    public void m_8119_() {
        LivingEntity owner;
        Player player;
        super.m_8119_();
        this.f_19789_ = 0.0f;
        LivingEntity livingEntity = this.owner;
        if (livingEntity instanceof Player && !SummonedSwordEntity_Out.isHoldingYamato(player = (Player)livingEntity)) {
            this.removeEffects();
            this.m_146870_();
            return;
        }
        if (!this.effectsApplied && this.owner != null && this.owner.m_6084_()) {
            this.applyEffects();
            this.effectsApplied = true;
        }
        if ((owner = this.getOwner()) != null && owner.m_6084_()) {
            this.moveToOwner(owner);
        }
        if (owner != null && !owner.m_6084_()) {
            this.removeEffects();
            this.m_146870_();
        }
        ++this.lifeTime;
        if (this.lifeTime >= 600) {
            this.removeEffects();
            this.m_146870_();
        }
    }

    protected void moveToOwner(LivingEntity owner) {
        this.m_146922_(owner.f_20883_);
        this.m_5618_(owner.f_20883_);
        this.m_5616_(owner.f_20883_);
        this.m_146884_(owner.m_20182_().m_82520_(0.0, (double)owner.m_20206_() * 0.6, 0.0));
    }

    private void applyEffects() {
        if (this.owner != null && !this.owner.m_9236_().m_5776_()) {
            MobEffectInstance resistance = new MobEffectInstance(MobEffects.f_19606_, 600, 3, false, false, false);
            MobEffectInstance regeneration = new MobEffectInstance(MobEffects.f_19605_, 600, 3, false, false, false);
            MobEffectInstance stun_immunity = new MobEffectInstance((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get(), 600, 3, false, false, false);
            this.owner.m_7292_(resistance);
            this.owner.m_7292_(regeneration);
            this.owner.m_7292_(stun_immunity);
        }
    }

    private void removeEffects() {
        if (this.owner != null && !this.owner.m_9236_().m_5776_() && this.effectsApplied) {
            this.owner.m_21195_(MobEffects.f_19606_);
            this.owner.m_21195_(MobEffects.f_19605_);
            this.owner.m_21195_((MobEffect)EFNMobEffectRegistry.SIN_STUN_IMMUNITY.get());
            this.effectsApplied = false;
        }
    }

    @NotNull
    public AABB m_6921_() {
        return this.m_20191_().m_82400_(100.0);
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getIdleAnimation() {
        return EFNAnimations.SUMMONED_SWORD_CIRCLE;
    }

    @Nullable
    public AnimationManager.AnimationAccessor<? extends StaticAnimation> getDefaultAnimation() {
        return EFNAnimations.SUMMONED_SWORD_OUT;
    }

    @Nullable
    public Armature getArmature() {
        return Armatures.ArmatureAccessor.create((String)"efn", (String)"entity/effect/summoned_sword_circle", Armature::new).get();
    }

    @Nullable
    public AssetAccessor<? extends SkinnedMesh> getMesh() {
        return Meshes.MeshAccessor.create((String)"efn", (String)"entity/effect/summoned_sword_circle", jsonModelLoader -> jsonModelLoader.loadSkinnedMesh(SkinnedMesh::new));
    }

    @Nullable
    public ResourceLocation getTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/summoned_sword.png");
    }

    @Nullable
    public ResourceLocation getLitTexture() {
        return ResourceLocation.fromNamespaceAndPath((String)"efn", (String)"textures/entity/summoned_sword.png");
    }

    public Vec3 getLastOwnerMotion() {
        return this.lastOwnerMotion;
    }

    public Vec3 getLastOwnerPos() {
        return this.lastOwnerPos;
    }

    public Vec3 getOffset() {
        return this.offset;
    }

    public boolean isShouldRemove() {
        return this.shouldRemove;
    }
}

