/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.skill.weapon_innate;

import com.google.common.collect.Lists;
import com.hm.efn.gameasset.combos.Murasama;
import com.hm.efn.registries.EFNDataKey;
import com.p1nero.invincible.capability.InvinciblePlayerCapabilityProvider;
import com.p1nero.invincible.client.InvincibleKeyMappings;
import com.p1nero.invincible.skill.ComboBasicAttack;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import yesman.epicfight.skill.SkillContainer;
import yesman.epicfight.skill.SkillDataManager;
import yesman.epicfight.skill.dodge.DodgeSkill;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;
import yesman.epicfight.world.capabilities.entitypatch.player.ServerPlayerPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.entity.eventlistener.PlayerEventListener;

public class MurasamaInnate
extends ComboBasicAttack {
    private static final UUID DODGE_TRIGGER_UUID = UUID.fromString("e5f6a1b2-c8d1-11ed-a51b-0242ac120219");

    public MurasamaInnate(ComboBasicAttack.Builder builder) {
        super(builder);
    }

    public void onInitiate(SkillContainer container) {
        super.onInitiate(container);
        SkillDataManager data = container.getDataManager();
        PlayerEventListener listener = container.getExecutor().getEventListener();
        this.registerKeyData(data);
        listener.addEventListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID, event -> {
            ServerPlayerPatch playerPatch;
            ServerPlayer player;
            PlayerPatch patt2080$temp;
            if (event.getSkillContainer().getSkill() instanceof DodgeSkill && (patt2080$temp = container.getExecutor()) instanceof ServerPlayerPatch && this.isHoldingTachi(player = (ServerPlayer)(playerPatch = (ServerPlayerPatch)patt2080$temp).getOriginal())) {
                player.getCapability(InvinciblePlayerCapabilityProvider.INVINCIBLE_PLAYER).ifPresent(inv -> inv.setCurrentNode(Murasama.DodgeCounter));
            }
        });
    }

    private void registerKeyData(SkillDataManager data) {
        data.registerData(EFNDataKey.KEY1_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY2_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY3_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY4_LONG_PRESS.get());
        data.registerData(EFNDataKey.INNATE_LONG_PRESS.get());
        data.registerData(EFNDataKey.KEY1_PRESS.get());
        data.registerData(EFNDataKey.KEY2_PRESS.get());
        data.registerData(EFNDataKey.KEY3_PRESS.get());
        data.registerData(EFNDataKey.KEY4_PRESS.get());
        data.registerData(EFNDataKey.INNATE_PRESS.get());
        data.registerData(EFNDataKey.SUMMON_SWORD.get());
        data.registerData(EFNDataKey.DOPPELGANGER.get());
        data.registerData(EFNDataKey.KEY1_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY2_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY3_PRESS_TIMER.get());
        data.registerData(EFNDataKey.KEY4_PRESS_TIMER.get());
        data.registerData(EFNDataKey.INNATE_PRESS_TIMER.get());
        data.registerData(EFNDataKey.COMBO_COUNTER.get());
        data.registerData(EFNDataKey.ANGEL_KEY.get());
        data.registerData(EFNDataKey.DEMON_KEY.get());
        data.registerData(EFNDataKey.JUMP_KEY.get());
        data.registerData(EFNDataKey.SNEAK_KEY.get());
        data.registerData(EFNDataKey.UP_KEY.get());
        data.registerData(EFNDataKey.DOWN_KEY.get());
    }

    private boolean isHoldingTachi(ServerPlayer player) {
        return Stream.of(player.m_21205_(), player.m_21206_()).map(EpicFightCapabilities::getItemStackCapability).filter(Objects::nonNull).anyMatch(cap -> cap.getWeaponCategory() == CapabilityItem.WeaponCategories.TACHI);
    }

    public void onRemoved(SkillContainer container) {
        super.onRemoved(container);
        container.getExecutor().getEventListener().removeListener(PlayerEventListener.EventType.SKILL_CAST_EVENT, DODGE_TRIGGER_UUID);
    }

    public List<Component> getTooltipOnItem(ItemStack itemStack, CapabilityItem cap, PlayerPatch<?> playerpatch) {
        ArrayList list = Lists.newArrayList();
        list.add(Component.m_237115_((String)"skill.efn.bloodlust.tooltip").m_130940_(ChatFormatting.RED).m_7220_((Component)Component.m_237115_((String)"skill.efn.bloodlust.tooltip1")).m_7220_(InvincibleKeyMappings.KEY3.m_90863_()));
        list.add(Component.m_237115_((String)"skill.efn.bloodlust.tooltip2"));
        return list;
    }
}

