/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.util;

import com.hm.efn.EFN;
import com.hm.efn.gameasset.combos.Yamato;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.LargeFireball;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.player.PlayerPatch;

@Mod.EventBusSubscriber
public class FireballExplosionListener {
    private static final Logger LOGGER = LogManager.getLogger((String)"EFNExplosionListener");

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Start event) {
        Player owner;
        PlayerPatch playerPatch;
        LargeFireball fireball;
        Entity entity;
        Entity entity2 = event.getExplosion().m_253049_();
        if (entity2 instanceof LargeFireball && (entity = (fireball = (LargeFireball)entity2).m_19749_()) instanceof Player && (playerPatch = (PlayerPatch)EpicFightCapabilities.getEntityPatch((Entity)(owner = (Player)entity), PlayerPatch.class)) != null && playerPatch.getSkill(Yamato.yamato) != null) {
            event.setCanceled(true);
            Vec3 explosionPos = event.getExplosion().getPosition();
            EFN.LOGGER.debug("Yamato weapon fireball exploded at: {}", (Object)explosionPos);
            FireballExplosionListener.handleYamatoDriveExplosion(fireball, explosionPos, owner);
        }
    }

    private static void handleYamatoDriveExplosion(LargeFireball fireball, Vec3 explosionPos, Player owner) {
        Level level = fireball.m_9236_();
        if (!level.m_5776_()) {
            ServerLevel serverLevel = (ServerLevel)level;
            float originalRadius = 1.0f;
            float expandedRadius = originalRadius * 3.5f;
            AABB explosionArea = new AABB(explosionPos.f_82479_ - (double)expandedRadius, explosionPos.f_82480_ - (double)expandedRadius, explosionPos.f_82481_ - (double)expandedRadius, explosionPos.f_82479_ + (double)expandedRadius, explosionPos.f_82480_ + (double)expandedRadius, explosionPos.f_82481_ + (double)expandedRadius);
            List entitiesInRange = level.m_45933_(null, explosionArea);
            for (Entity entity : entitiesInRange) {
                LivingEntity target;
                if (!(entity instanceof LivingEntity) || (target = (LivingEntity)entity) == owner) continue;
                FireballExplosionListener.applyCustomDamage(owner, target);
            }
            FireballExplosionListener.spawnEnhancedExplosionParticles(serverLevel, explosionPos, expandedRadius);
            Vec3 groundPos = FireballExplosionListener.getGroundPosition(explosionPos, level);
            FireballExplosionListener.spawnGroundFireParticles(serverLevel, groundPos);
        }
    }

    private static void applyCustomDamage(Player owner, LivingEntity target) {
        float playerAttackDamage = (float)Objects.requireNonNull(owner.m_21051_(Attributes.f_22281_)).m_22135_();
        float baseDamage = 6.0f;
        float finalDamage = baseDamage + playerAttackDamage * 0.5f;
        DamageSource damageSource = owner.m_269291_().m_269075_(owner);
        target.m_6469_(damageSource, finalDamage);
        EFN.LOGGER.debug("Applied {} damage to {} (no distance attenuation)", (Object)Float.valueOf(finalDamage), (Object)target.m_7755_().getString());
    }

    private static void spawnEnhancedExplosionParticles(ServerLevel level, Vec3 center, float radius) {
        level.m_8767_((ParticleOptions)ParticleTypes.f_123813_, center.f_82479_, center.f_82480_, center.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        int flameParticles = (int)(20.0f * (radius / 2.0f));
        level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_, center.f_82480_, center.f_82481_, flameParticles, (double)(radius * 0.8f), (double)(radius * 0.8f), (double)(radius * 0.8f), 0.1);
        level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, center.f_82479_, center.f_82480_, center.f_82481_, 10, (double)(radius * 0.4f), (double)(radius * 0.4f), (double)(radius * 0.4f), 0.02);
    }

    private static void spawnGroundFireParticles(ServerLevel level, Vec3 center) {
        int particles = 20;
        float radius = 2.0f;
        for (int i = 0; i < particles; ++i) {
            float angle = (float)(Math.PI * 2 * (double)i / (double)particles);
            float x = radius * Mth.m_14089_((float)angle);
            float z = radius * Mth.m_14031_((float)angle);
            Vec3 particlePos = center.m_82520_((double)x, 0.1, (double)z);
            if (i % 3 == 0) {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, particlePos.f_82479_, particlePos.f_82480_ + 0.2, particlePos.f_82481_, 1, 0.15, 0.1, 0.15, 0.01);
            }
            if (i % 5 != 0) continue;
            level.m_8767_((ParticleOptions)ParticleTypes.f_123756_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.05, 0.02, 0.05, 0.0);
        }
        level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, center.f_82479_, center.f_82480_ + 0.3, center.f_82481_, 10, 0.3, 0.2, 0.3, 0.05);
    }

    public static Vec3 getGroundPosition(Vec3 startPos, Level level) {
        BlockState block;
        double dpy;
        double dpx = startPos.f_82479_;
        double dpz = startPos.f_82481_;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(dpx, dpy, dpz);
        for (dpy = startPos.f_82480_; ((block = level.m_8055_((BlockPos)pos)).m_60734_() instanceof BushBlock || block.m_60795_()) && !block.m_60713_(Blocks.f_50626_) && !(dpy <= -64.0); dpy -= 1.0) {
            pos.m_142448_(pos.m_123342_() - 1);
        }
        return new Vec3(dpx, dpy + 1.0, dpz);
    }
}

