/*
 * Decompiled with CFR 0.152.
 */
package com.hm.efn.util;

import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class WeaponTrailGroundSplitter {
    public static AnimationEvent.InPeriodEvent create(int startFrame, int endFrame, InteractionHand hand, Vec3 startOffset, Vec3 endOffset, float radius, ParticleOptions particle, int particleCount, float timeInterpolation, float positionDensity, int soundInterval) {
        float start = WeaponTrailGroundSplitter.frameToSeconds(startFrame);
        float end = WeaponTrailGroundSplitter.frameToSeconds(endFrame);
        Joint joint = WeaponTrailGroundSplitter.getWeaponJoint(hand);
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            int[] soundCounter = new int[]{0};
            Level level = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
            int soundIntervalMultiplier = 40;
            Vec3[] lastSoundPos = new Vec3[]{null};
            float prevTime = Objects.requireNonNull(entityPatch.getAnimator().getPlayerFor(null)).getPrevElapsedTime();
            float currentTime = Objects.requireNonNull(entityPatch.getAnimator().getPlayerFor(null)).getElapsedTime();
            float step = (currentTime - prevTime) / timeInterpolation;
            Vec3f trailDirection = new Vec3f((float)(endOffset.f_82479_ - startOffset.f_82479_), (float)(endOffset.f_82480_ - startOffset.f_82480_), (float)(endOffset.f_82481_ - startOffset.f_82481_));
            for (float t = prevTime; t <= currentTime; t += step) {
                Vec3 soundPos;
                float timeProgress = Mth.m_14036_((float)((t - start) / (end - start)), (float)0.0f, (float)1.0f);
                int n = soundCounter[0];
                soundCounter[0] = n + 1;
                boolean playSoundThisFrame = n % (soundInterval * 40) == 0;
                Vec3 currentWeaponTip = WeaponTrailGroundSplitter.calculateWeaponImpactPos(entityPatch, joint, new Vec3f(0.0f, 0.0f, -1.5f), t);
                Vec3 vec3 = soundPos = lastSoundPos[0] != null ? lastSoundPos[0].m_165921_(currentWeaponTip, (double)0.3f) : currentWeaponTip;
                if (entityPatch.isLogicalClient() || !(level instanceof ServerLevel)) continue;
                ServerLevel serverLevel = (ServerLevel)level;
                if (playSoundThisFrame) {
                    float distanceToPlayer = (float)soundPos.m_82554_(((LivingEntity)entityPatch.getOriginal()).m_20182_());
                    float volume = Mth.m_14036_((float)(0.4f - distanceToPlayer * 0.03f), (float)0.2f, (float)0.4f);
                    serverLevel.m_6263_(null, soundPos.f_82479_, soundPos.f_82480_, soundPos.f_82481_, (SoundEvent)EpicFightSounds.SLAM_HEAVY.get(), SoundSource.PLAYERS, volume, 1.0f);
                    lastSoundPos[0] = soundPos;
                }
                int i = 0;
                while ((float)i < positionDensity) {
                    float spaceProgress = (float)i / positionDensity;
                    Vec3f pointOffset = new Vec3f((float)(startOffset.f_82479_ + (double)(trailDirection.x * spaceProgress)), (float)(startOffset.f_82480_ + (double)(trailDirection.y * spaceProgress)), (float)(startOffset.f_82481_ + (double)(trailDirection.z * spaceProgress)));
                    Vec3 basePos = WeaponTrailGroundSplitter.calculateWeaponImpactPos(entityPatch, joint, pointOffset, t);
                    for (int dy = -1; dy <= 1; ++dy) {
                        Vec3 groundPos = basePos.m_82520_(0.0, (double)dy, 0.0);
                        LevelUtil.circleSlamFracture((LivingEntity)((LivingEntity)entityPatch.getOriginal()), (Level)serverLevel, (Vec3)groundPos, (double)(radius * (0.8f + 0.2f * Mth.m_14031_((float)(timeProgress * (float)Math.PI)))), (boolean)true, (boolean)true, (boolean)false);
                    }
                    if (particle != null) {
                        Vec3 particlePos = basePos.m_82520_(0.0, 0.5, 0.0);
                        serverLevel.m_8767_(particle, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, particleCount, 0.0, 0.0, 0.0, 0.05);
                    }
                    ++i;
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    private static Vec3 calculateWeaponImpactPos(LivingEntityPatch<?> entityPatch, Joint joint, Vec3f offset, float currentTime) {
        Pose pose = ((DynamicAnimation)Objects.requireNonNull(entityPatch.getAnimator().getPlayerFor(null)).getAnimation().get()).getRawPose(currentTime);
        OpenMatrix4f transformMatrix = entityPatch.getArmature().getBoundTransformFor(pose, joint);
        float yRot = ((LivingEntity)entityPatch.getOriginal()).m_146908_();
        OpenMatrix4f rotation = new OpenMatrix4f().rotate(-((float)Math.toRadians(yRot + 180.0f)), new Vec3f(0.0f, 1.0f, 0.0f));
        OpenMatrix4f rotatedMatrix = new OpenMatrix4f();
        OpenMatrix4f.mul((OpenMatrix4f)rotation, (OpenMatrix4f)transformMatrix, (OpenMatrix4f)rotatedMatrix);
        OpenMatrix4f finalTransform = new OpenMatrix4f(rotatedMatrix);
        finalTransform.translate(offset);
        return new Vec3((double)finalTransform.m30 + ((LivingEntity)entityPatch.getOriginal()).m_20185_(), (double)finalTransform.m31 + ((LivingEntity)entityPatch.getOriginal()).m_20186_(), (double)finalTransform.m32 + ((LivingEntity)entityPatch.getOriginal()).m_20189_());
    }

    private static float frameToSeconds(int frame) {
        return (float)frame / 60.0f;
    }

    private static Joint getWeaponJoint(InteractionHand hand) {
        return hand == InteractionHand.MAIN_HAND ? ((HumanoidArmature)Armatures.BIPED.get()).toolR : ((HumanoidArmature)Armatures.BIPED.get()).toolL;
    }

    private static Vec3 lerp(Vec3 start, Vec3 end, float t) {
        return new Vec3(Mth.m_14139_((double)t, (double)start.f_82479_, (double)end.f_82479_), Mth.m_14139_((double)t, (double)start.f_82480_, (double)end.f_82480_), Mth.m_14139_((double)t, (double)start.f_82481_, (double)end.f_82481_));
    }
}

