/*
 * Decompiled with CFR 0.152.
 */
package com.p1nero.invincible.skill;

import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.p1nero.invincible.data.ComboJsonLoader;
import com.p1nero.invincible.data.SkillJsonLoader;
import com.p1nero.invincible.skill.ComboBasicAttack;
import com.p1nero.invincible.skill.SimpleCustomInnateSkill;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.fml.loading.FMLPaths;
import org.slf4j.Logger;
import yesman.epicfight.api.forgeevent.SkillBuildEvent;
import yesman.epicfight.skill.SkillBuilder;

public class InvincibleSkillManager {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Set<String> MOD_ID_SET = new HashSet<String>();

    public static void buildAdditionalCombos(SkillBuildEvent event) {
        Path invincibleCombos = FMLPaths.CONFIGDIR.get().resolve("invincible_combos");
        if (!Files.exists(invincibleCombos, new LinkOption[0])) {
            try {
                Files.createDirectory(invincibleCombos, new FileAttribute[0]);
                return;
            }
            catch (IOException e) {
                LOGGER.error("Failed to create default file!", (Throwable)e);
            }
        }
        try (Stream<Path> subDirs = Files.list(invincibleCombos);){
            subDirs.filter(path -> path.getFileName().toString().toLowerCase().endsWith(".json")).forEach(comboFile -> {
                try {
                    FileInputStream inputStream = new FileInputStream(comboFile.toFile());
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    InputStreamReader reader = new InputStreamReader((InputStream)bufferedInputStream, StandardCharsets.UTF_8);
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    JsonObject combo = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
                    reader.close();
                    ComboBasicAttack.Builder skillBuilder = ComboJsonLoader.loadCombos(combo);
                    String modId = combo.get("mod_id").getAsString();
                    String skillName = combo.get("name").getAsString();
                    SkillBuildEvent.ModRegistryWorker registryWorker = event.createRegistryWorker(modId);
                    ComboBasicAttack skill = (ComboBasicAttack)registryWorker.build(skillName, ComboBasicAttack::new, (SkillBuilder)skillBuilder);
                    CompoundTag params = new CompoundTag();
                    if (combo.has("consumption")) {
                        params.m_128350_("consumption", combo.get("consumption").getAsFloat());
                    }
                    if (combo.has("max_stacks")) {
                        params.m_128405_("max_stacks", combo.get("max_stacks").getAsInt());
                    }
                    skill.setParams(params);
                    MOD_ID_SET.add(modId);
                    LOGGER.info("LOAD ADDITIONAL SKILL >> {}", (Object)(modId + ":" + skillName));
                }
                catch (CommandSyntaxException | IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("error when loading combos", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static void buildAdditionalSkills(SkillBuildEvent event) {
        Path invincibleSkills = FMLPaths.CONFIGDIR.get().resolve("invincible_skills");
        if (!Files.exists(invincibleSkills, new LinkOption[0])) {
            try {
                Files.createDirectory(invincibleSkills, new FileAttribute[0]);
                return;
            }
            catch (IOException e) {
                LOGGER.error("Failed to create default file!", (Throwable)e);
            }
        }
        try (Stream<Path> subDirs = Files.list(invincibleSkills);){
            subDirs.filter(path -> path.getFileName().toString().toLowerCase().endsWith(".json")).forEach(comboFile -> {
                try {
                    FileInputStream inputStream = new FileInputStream(comboFile.toFile());
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    InputStreamReader reader = new InputStreamReader((InputStream)bufferedInputStream, StandardCharsets.UTF_8);
                    JsonReader jsonReader = new JsonReader((Reader)reader);
                    jsonReader.setLenient(true);
                    JsonObject combo = Streams.parse((JsonReader)jsonReader).getAsJsonObject();
                    reader.close();
                    SimpleCustomInnateSkill.Builder skillBuilder = SkillJsonLoader.loadSkill(combo);
                    String modId = combo.get("mod_id").getAsString();
                    String skillName = combo.get("name").getAsString();
                    SkillBuildEvent.ModRegistryWorker registryWorker = event.createRegistryWorker(modId);
                    SimpleCustomInnateSkill skill = (SimpleCustomInnateSkill)registryWorker.build(skillName, SimpleCustomInnateSkill::new, (SkillBuilder)skillBuilder);
                    CompoundTag params = new CompoundTag();
                    if (combo.has("consumption")) {
                        params.m_128350_("consumption", combo.get("consumption").getAsFloat());
                    }
                    if (combo.has("max_stacks")) {
                        params.m_128405_("max_stacks", combo.get("max_stacks").getAsInt());
                    }
                    skill.setParams(params);
                    LOGGER.info("LOAD ADDITIONAL SKILL >> {}", (Object)(modId + ":" + skillName));
                }
                catch (CommandSyntaxException | IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            LOGGER.error("error when loading custom skills", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

