/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.avalon.vfx.type;

import com.merlin204.avalon.entity.AvalonEntities;
import com.merlin204.avalon.entity.vfx.AnimationTextureVFXEntity;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.gameasset.Armatures;

public class AnimationTextureAvalonVFXManager {
    protected final Armatures.ArmatureAccessor<? extends Armature> ARMATURE_ACCESSOR;
    protected final ResourceLocation MESH;
    protected final String TEXTURE_PACK;
    protected final String LIGHT_TEXTURE_PACK;
    protected final int FROM;
    protected final int TO;
    protected final float SPEED;
    protected final AnimationManager.AnimationAccessor<? extends StaticAnimation> DEFAULT_ANIMATION;

    public AnimationTextureAvalonVFXManager(Armatures.ArmatureAccessor<? extends Armature> armatureAccessor, ResourceLocation mesh, String texture, String lightTexture, int from, int to, float speed, AnimationManager.AnimationAccessor<? extends StaticAnimation> defaultAnimation) {
        this.ARMATURE_ACCESSOR = armatureAccessor;
        this.MESH = mesh;
        this.TEXTURE_PACK = texture;
        this.LIGHT_TEXTURE_PACK = lightTexture;
        this.FROM = from;
        this.TO = to;
        this.SPEED = speed;
        this.DEFAULT_ANIMATION = defaultAnimation;
    }

    public AnimationTextureAvalonVFXManager(String armaturePath, String meshPath, String texturePath, String lightTexturePath, int from, int to, float speed, AnimationManager.AnimationAccessor<? extends StaticAnimation> defaultAnimation) {
        this.ARMATURE_ACCESSOR = Armatures.ArmatureAccessor.create((String)ResourceLocation.parse((String)armaturePath).m_135827_(), (String)ResourceLocation.parse((String)armaturePath).m_135815_(), Armature::new);
        this.MESH = ResourceLocation.parse((String)meshPath);
        this.TEXTURE_PACK = texturePath;
        this.LIGHT_TEXTURE_PACK = lightTexturePath;
        this.FROM = from;
        this.TO = to;
        this.SPEED = speed;
        this.DEFAULT_ANIMATION = defaultAnimation;
    }

    public AnimationTextureAvalonVFXManager(String armatureAndMeshPath, String texturePath, String lightTexturePath, int from, int to, float speed, AnimationManager.AnimationAccessor<? extends StaticAnimation> defaultAnimation) {
        this.ARMATURE_ACCESSOR = Armatures.ArmatureAccessor.create((String)ResourceLocation.parse((String)armatureAndMeshPath).m_135827_(), (String)ResourceLocation.parse((String)armatureAndMeshPath).m_135815_(), Armature::new);
        this.MESH = ResourceLocation.parse((String)armatureAndMeshPath);
        this.TEXTURE_PACK = texturePath;
        this.LIGHT_TEXTURE_PACK = lightTexturePath;
        this.FROM = from;
        this.TO = to;
        this.SPEED = speed;
        this.DEFAULT_ANIMATION = defaultAnimation;
    }

    public AnimationEvent.InTimeEvent createSpawnVFXEntityEvent(int startFrame, Vec3f rotOffset, Vec3f posOffset, float scale) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            if (((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) {
                // empty if block
            }
            AnimationTextureVFXEntity vfxEntity = new AnimationTextureVFXEntity((EntityType<? extends VFXEntity>)((EntityType)AvalonEntities.ANIMATION_TEXTURE_VFX.get()), (LivingEntity)entityPatch.getOriginal(), scale, rotOffset, this.ARMATURE_ACCESSOR, this.MESH, this.FROM, this.TO, this.SPEED, this.TEXTURE_PACK, this.LIGHT_TEXTURE_PACK, this.DEFAULT_ANIMATION);
            Vec3 pos = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
            Vec3 totalOffset = AnimationTextureAvalonVFXManager.getOffset(posOffset, (LivingEntity)entityPatch.getOriginal());
            Vec3 target = pos.m_82520_(totalOffset.f_82479_, totalOffset.f_82480_, totalOffset.f_82481_);
            vfxEntity.m_146884_(target);
            ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7967_((Entity)vfxEntity);
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public void spawnVFXEntity(LivingEntity owner, Vec3 pos, Vec3f rotOffset, float scale) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        AnimationTextureVFXEntity vfxEntity = new AnimationTextureVFXEntity((EntityType<? extends VFXEntity>)((EntityType)AvalonEntities.ANIMATION_TEXTURE_VFX.get()), owner, scale, rotOffset, this.ARMATURE_ACCESSOR, this.MESH, this.FROM, this.TO, this.SPEED, this.TEXTURE_PACK, this.LIGHT_TEXTURE_PACK, this.DEFAULT_ANIMATION);
        vfxEntity.m_146884_(pos);
        owner.m_9236_().m_7967_((Entity)vfxEntity);
    }

    public void spawnVFXEntity(LivingEntity owner, Vec3f posOffset, Vec3f rotOffset, float scale) {
        if (owner.m_9236_().f_46443_) {
            return;
        }
        AnimationTextureVFXEntity vfxEntity = new AnimationTextureVFXEntity((EntityType<? extends VFXEntity>)((EntityType)AvalonEntities.ANIMATION_TEXTURE_VFX.get()), owner, scale, rotOffset, this.ARMATURE_ACCESSOR, this.MESH, this.FROM, this.TO, this.SPEED, this.TEXTURE_PACK, this.LIGHT_TEXTURE_PACK, this.DEFAULT_ANIMATION);
        Vec3 pos = owner.m_20182_();
        Vec3 totalOffset = AnimationTextureAvalonVFXManager.getOffset(posOffset, owner);
        Vec3 target = pos.m_82520_(totalOffset.f_82479_, totalOffset.f_82480_, totalOffset.f_82481_);
        vfxEntity.m_146884_(target);
        owner.m_9236_().m_7967_((Entity)vfxEntity);
    }

    @NotNull
    static Vec3 getOffset(Vec3f posOffset, LivingEntity livingEntity) {
        float xOffset = posOffset.x;
        float yOffset = posOffset.y;
        float zOffset = posOffset.z;
        float yaw = livingEntity.m_146908_();
        double radians = Math.toRadians(yaw);
        double cosYaw = Math.cos(radians);
        double sinYaw = Math.sin(radians);
        double worldX = (double)xOffset * cosYaw + (double)zOffset * sinYaw;
        double worldZ = (double)(-xOffset) * sinYaw + (double)zOffset * cosYaw;
        Vec3 viewDir = new Vec3(-sinYaw, 0.0, cosYaw);
        Vec3 totalOffset = viewDir.m_82520_(worldX, (double)yOffset, worldZ);
        return totalOffset;
    }
}

