/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.client.particle;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.JointTransform;
import yesman.epicfight.api.animation.Pose;
import yesman.epicfight.api.animation.property.AnimationProperty;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.animation.property.ClientAnimationProperties;
import yesman.epicfight.api.client.animation.property.TrailInfo;
import yesman.epicfight.api.physics.bezier.CubicBezierCurve;
import yesman.epicfight.api.utils.math.MathUtils;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.particle.AbstractTrailParticle;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class AvalonAnimationTrailParticle
extends AbstractTrailParticle<LivingEntityPatch<?>> {
    protected final Joint joint;
    protected final AssetAccessor<? extends StaticAnimation> animation;
    protected final List<AbstractTrailParticle.TrailEdge> invisibleTrailEdges;

    protected AvalonAnimationTrailParticle(ClientLevel level, LivingEntityPatch<?> owner, Joint joint, AssetAccessor<? extends StaticAnimation> animation, TrailInfo trailInfo) {
        super(level, owner, trailInfo);
        this.joint = joint;
        this.animation = animation;
        this.invisibleTrailEdges = Lists.newLinkedList();
        Pose prevPose = ((LivingEntityPatch)this.owner).getAnimator().getPose(0.0f);
        Pose middlePose = ((LivingEntityPatch)this.owner).getAnimator().getPose(0.5f);
        Pose currentPose = ((LivingEntityPatch)this.owner).getAnimator().getPose(1.0f);
        Vec3 posOld = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_20318_(0.0f);
        Vec3 posMid = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_20318_(0.5f);
        Vec3 posCur = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_20318_(1.0f);
        OpenMatrix4f prvmodelTf = OpenMatrix4f.createTranslation((float)((float)posOld.f_82479_), (float)((float)posOld.f_82480_), (float)((float)posOld.f_82481_)).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(((LivingEntityPatch)this.owner).getModelMatrix(0.0f));
        OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)((float)posMid.f_82479_), (float)((float)posMid.f_82480_), (float)((float)posMid.f_82481_)).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(((LivingEntityPatch)this.owner).getModelMatrix(0.5f));
        OpenMatrix4f curModelTf = OpenMatrix4f.createTranslation((float)((float)posCur.f_82479_), (float)((float)posCur.f_82480_), (float)((float)posCur.f_82481_)).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(((LivingEntityPatch)this.owner).getModelMatrix(1.0f));
        OpenMatrix4f prevJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(prevPose, this.joint).mulFront(prvmodelTf);
        OpenMatrix4f middleJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(middlePose, this.joint).mulFront(middleModelTf);
        OpenMatrix4f currentJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(currentPose, this.joint).mulFront(curModelTf);
        Vec3 prevStartPos = OpenMatrix4f.transform((OpenMatrix4f)prevJointTf, (Vec3)trailInfo.start());
        Vec3 prevEndPos = OpenMatrix4f.transform((OpenMatrix4f)prevJointTf, (Vec3)trailInfo.end());
        Vec3 middleStartPos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)trailInfo.start());
        Vec3 middleEndPos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)trailInfo.end());
        Vec3 currentStartPos = OpenMatrix4f.transform((OpenMatrix4f)currentJointTf, (Vec3)trailInfo.start());
        Vec3 currentEndPos = OpenMatrix4f.transform((OpenMatrix4f)currentJointTf, (Vec3)trailInfo.end());
        this.invisibleTrailEdges.add(new AbstractTrailParticle.TrailEdge(prevStartPos, prevEndPos, this.trailInfo.trailLifetime()));
        this.invisibleTrailEdges.add(new AbstractTrailParticle.TrailEdge(middleStartPos, middleEndPos, this.trailInfo.trailLifetime()));
        this.invisibleTrailEdges.add(new AbstractTrailParticle.TrailEdge(currentStartPos, currentEndPos, this.trailInfo.trailLifetime()));
        this.f_107227_ = Math.max(this.trailInfo.rCol(), 0.0f);
        this.f_107228_ = Math.max(this.trailInfo.gCol(), 0.0f);
        this.f_107229_ = Math.max(this.trailInfo.bCol(), 0.0f);
        if (this.trailInfo.texturePath() != null) {
            TextureManager texturemanager = Minecraft.m_91087_().m_91097_();
            AbstractTexture abstracttexture = texturemanager.m_118506_(this.trailInfo.texturePath());
            RenderSystem.bindTexture((int)abstracttexture.m_117963_());
            RenderSystem.texParameter((int)3553, (int)10242, (int)33071);
            RenderSystem.texParameter((int)3553, (int)10243, (int)33071);
        }
    }

    protected boolean canContinue() {
        AnimationPlayer animPlayer = ((LivingEntityPatch)this.owner).getAnimator().getPlayerFor(this.animation);
        return ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_6084_() && this.animation == animPlayer.getRealAnimation() && animPlayer.getElapsedTime() <= this.trailInfo.endTime();
    }

    protected boolean canCreateNextCurve() {
        AnimationPlayer animPlayer = ((LivingEntityPatch)this.owner).getAnimator().getPlayerFor(this.animation);
        if (TrailInfo.isValidTime((float)this.trailInfo.fadeTime()) && this.trailInfo.endTime() < animPlayer.getElapsedTime()) {
            return false;
        }
        return super.canCreateNextCurve();
    }

    protected void createNextCurve() {
        boolean visibleTrail;
        List finalEndPositions;
        List finalStartPositions;
        boolean needCorrection;
        AnimationPlayer animPlayer = ((LivingEntityPatch)this.owner).getAnimator().getPlayerFor(this.animation);
        boolean isTrailInvisible = ((DynamicAnimation)animPlayer.getAnimation().get()).isLinkAnimation() || animPlayer.getElapsedTime() <= this.trailInfo.startTime();
        boolean isFirstTrail = this.trailEdges.isEmpty();
        boolean bl = needCorrection = !isTrailInvisible && isFirstTrail;
        if (needCorrection) {
            float startCorrection = Math.max((this.trailInfo.startTime() - animPlayer.getPrevElapsedTime()) / (animPlayer.getElapsedTime() - animPlayer.getPrevElapsedTime()), 0.0f);
            this.startEdgeCorrection = (float)(this.trailInfo.interpolateCount() * 2) * startCorrection;
        }
        TrailInfo trailInfo = this.trailInfo;
        Pose prevPose = ((LivingEntityPatch)this.owner).getAnimator().getPose(0.0f);
        Pose currentPose = ((LivingEntityPatch)this.owner).getAnimator().getPose(1.0f);
        Pose middlePose = ((LivingEntityPatch)this.owner).getAnimator().getPose(0.5f);
        Vec3 posOld = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_20318_(0.0f);
        Vec3 posCur = ((LivingEntity)((LivingEntityPatch)this.owner).getOriginal()).m_20318_(1.0f);
        Vec3 posMid = MathUtils.lerpVector((Vec3)posOld, (Vec3)posCur, (float)0.5f);
        OpenMatrix4f prevModelMatrix = ((LivingEntityPatch)this.owner).getModelMatrix(0.0f);
        OpenMatrix4f curModelMatrix = ((LivingEntityPatch)this.owner).getModelMatrix(1.0f);
        JointTransform lastTransform = JointTransform.fromMatrix((OpenMatrix4f)curModelMatrix);
        JointTransform currentTransform = JointTransform.fromMatrix((OpenMatrix4f)curModelMatrix);
        OpenMatrix4f prvmodelTf = OpenMatrix4f.createTranslation((float)((float)posOld.f_82479_), (float)((float)posOld.f_82480_), (float)((float)posOld.f_82481_)).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(prevModelMatrix);
        OpenMatrix4f middleModelTf = OpenMatrix4f.createTranslation((float)((float)posMid.f_82479_), (float)((float)posMid.f_82480_), (float)((float)posMid.f_82481_)).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(JointTransform.interpolate((JointTransform)lastTransform, (JointTransform)currentTransform, (float)0.5f).toMatrix());
        OpenMatrix4f curModelTf = OpenMatrix4f.createTranslation((float)((float)posCur.f_82479_), (float)((float)posCur.f_82480_), (float)((float)posCur.f_82481_)).rotateDeg(180.0f, Vec3f.Y_AXIS).mulBack(curModelMatrix);
        OpenMatrix4f prevJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(prevPose, this.joint).mulFront(prvmodelTf);
        OpenMatrix4f middleJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(middlePose, this.joint).mulFront(middleModelTf);
        OpenMatrix4f currentJointTf = ((LivingEntityPatch)this.owner).getArmature().getBoundTransformFor(currentPose, this.joint).mulFront(curModelTf);
        Vec3 prevStartPos = OpenMatrix4f.transform((OpenMatrix4f)prevJointTf, (Vec3)trailInfo.start());
        Vec3 prevEndPos = OpenMatrix4f.transform((OpenMatrix4f)prevJointTf, (Vec3)trailInfo.end());
        Vec3 middleStartPos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)trailInfo.start());
        Vec3 middleEndPos = OpenMatrix4f.transform((OpenMatrix4f)middleJointTf, (Vec3)trailInfo.end());
        Vec3 currentStartPos = OpenMatrix4f.transform((OpenMatrix4f)currentJointTf, (Vec3)trailInfo.start());
        Vec3 currentEndPos = OpenMatrix4f.transform((OpenMatrix4f)currentJointTf, (Vec3)trailInfo.end());
        if (isTrailInvisible) {
            finalStartPositions = Lists.newArrayList();
            finalEndPositions = Lists.newArrayList();
            finalStartPositions.add(prevStartPos);
            finalStartPositions.add(middleStartPos);
            finalEndPositions.add(prevEndPos);
            finalEndPositions.add(middleEndPos);
            this.invisibleTrailEdges.clear();
            visibleTrail = false;
        } else {
            AbstractTrailParticle.TrailEdge edge2;
            AbstractTrailParticle.TrailEdge edge1;
            ArrayList startPosList = Lists.newArrayList();
            ArrayList endPosList = Lists.newArrayList();
            if (isFirstTrail) {
                int lastIdx = this.invisibleTrailEdges.size() - 1;
                edge1 = this.invisibleTrailEdges.get(lastIdx);
                edge2 = new AbstractTrailParticle.TrailEdge(prevStartPos, prevEndPos, -1);
            } else {
                edge1 = (AbstractTrailParticle.TrailEdge)this.trailEdges.get(this.trailEdges.size() - (this.trailInfo.interpolateCount() / 2 + 1));
                edge2 = (AbstractTrailParticle.TrailEdge)this.trailEdges.get(this.trailEdges.size() - 1);
                ++edge2.lifetime;
            }
            startPosList.add(edge1.start);
            endPosList.add(edge1.end);
            startPosList.add(edge2.start);
            endPosList.add(edge2.end);
            startPosList.add(middleStartPos);
            endPosList.add(middleEndPos);
            startPosList.add(currentStartPos);
            endPosList.add(currentEndPos);
            finalStartPositions = CubicBezierCurve.getBezierInterpolatedPoints((List)startPosList, (int)1, (int)3, (int)this.trailInfo.interpolateCount());
            finalEndPositions = CubicBezierCurve.getBezierInterpolatedPoints((List)endPosList, (int)1, (int)3, (int)this.trailInfo.interpolateCount());
            if (!isFirstTrail) {
                finalStartPositions.remove(0);
                finalEndPositions.remove(0);
            }
            visibleTrail = true;
        }
        this.makeTrailEdges(finalStartPositions, finalEndPositions, visibleTrail ? this.trailEdges : this.invisibleTrailEdges);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            TrailInfo timeChange;
            ItemStack stack;
            RenderItemBase renderItemBase;
            int eid = (int)Double.doubleToRawLongBits(x);
            int animid = (int)Double.doubleToRawLongBits(z);
            int jointId = (int)Double.doubleToRawLongBits(xSpeed);
            int idx = (int)Double.doubleToRawLongBits(ySpeed);
            Entity entity = level.m_6815_(eid);
            if (entity == null) {
                return null;
            }
            LivingEntityPatch entitypatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)entity, LivingEntityPatch.class);
            if (entitypatch == null) {
                return null;
            }
            AnimationManager.AnimationAccessor animation = AnimationManager.byId((int)animid);
            if (animation == null) {
                return null;
            }
            Optional trailInfo = ((StaticAnimation)animation.get()).getProperty((AnimationProperty)ClientAnimationProperties.TRAIL_EFFECT);
            if (trailInfo.isEmpty()) {
                return null;
            }
            TrailInfo result = (TrailInfo)((List)trailInfo.get()).get(idx);
            if (result.hand() != null && (renderItemBase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack = ((LivingEntity)entitypatch.getOriginal()).m_21120_(result.hand()))) != null && renderItemBase.trailInfo() != null) {
                result = renderItemBase.trailInfo().overwrite(result);
            }
            if ((result = result.overwrite(timeChange = TrailInfo.builder().time(result.startTime() / 60.0f, result.endTime() / 60.0f).create())).playable()) {
                return new AvalonAnimationTrailParticle(level, entitypatch, entitypatch.getArmature().searchJointById(jointId), (AssetAccessor<? extends StaticAnimation>)animation, result);
            }
            return null;
        }
    }
}

