/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.entity.client.renderer.patch.entity;

import com.merlin204.avalon.entity.client.model.EmptyEntityModel;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import com.merlin204.avalon.entity.vfx.VFXEntityPatch;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.asset.AssetAccessor;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.client.model.SkinnedMesh;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.events.engine.RenderEngine;
import yesman.epicfight.client.renderer.patched.entity.PatchedLivingEntityRenderer;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

@OnlyIn(value=Dist.CLIENT)
public class AvalonVFXRendererPatch
extends PatchedLivingEntityRenderer<VFXEntity, VFXEntityPatch<VFXEntity>, EmptyEntityModel<VFXEntity>, LivingEntityRenderer<VFXEntity, EmptyEntityModel<VFXEntity>>, SkinnedMesh> {
    public static final ResourceLocation NOISE_TEX = ResourceLocation.fromNamespaceAndPath((String)"epic_fight_avalon", (String)"textures/noise.png");
    private AssetAccessor<? extends SkinnedMesh> meshAssetAccessor = null;

    public AvalonVFXRendererPatch(EntityRendererProvider.Context context, EntityType<?> entityType) {
        super(context, entityType);
    }

    public void render(VFXEntity entity, VFXEntityPatch entityPatch, LivingEntityRenderer renderer, MultiBufferSource buffer, PoseStack poseStack, int packedLight, float partialTicks) {
        Minecraft mc = Minecraft.m_91087_();
        if (((DynamicAnimation)entityPatch.getAnimator().getPlayerFor(null).getAnimation().get()).isLinkAnimation() || ((DynamicAnimation)entityPatch.getClientAnimator().getPlayerFor(null).getAnimation().get()).isLinkAnimation()) {
            return;
        }
        Armature armature = entityPatch.getArmature();
        if (entity.getMesh() == null) {
            return;
        }
        this.meshAssetAccessor = entity.getMesh();
        SkinnedMesh mesh = (SkinnedMesh)entity.getMesh().get();
        ResourceLocation texture = entity.getTexture();
        if (armature == null || mesh == null || texture == null) {
            return;
        }
        ResourceLocation litTexture = entity.getLitTexture();
        if (!entity.getShouldRender()) {
            return;
        }
        poseStack.m_85836_();
        this.mulPoseStack(poseStack, armature, (LivingEntity)entity, (LivingEntityPatch)entityPatch, partialTicks);
        this.setArmaturePose((LivingEntityPatch)entityPatch, armature, partialTicks);
        if (entity.getDisRatio() < 1.0f) {
            mesh.draw(poseStack, buffer, RenderType.m_173235_((ResourceLocation)NOISE_TEX), packedLight, 1.0f, 1.0f, 1.0f, 1.0f - entity.getDisRatio(), OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
            mesh.draw(poseStack, buffer, RenderType.m_110479_((ResourceLocation)texture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
        } else {
            mesh.draw(poseStack, buffer, RenderType.m_110473_((ResourceLocation)texture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
            if (litTexture != null) {
                mesh.draw(poseStack, buffer, RenderType.m_234338_((ResourceLocation)litTexture), packedLight, 1.0f, 1.0f, 1.0f, 1.0f, OverlayTexture.f_118083_, entityPatch.getArmature(), armature.getPoseMatrices());
            }
        }
        if (armature instanceof HumanoidArmature) {
            ItemStack offHandStack = entity.m_21206_();
            ItemStack mainHandStack = entity.m_21205_();
            RenderEngine renderEngine = ClientEngine.getInstance().renderEngine;
            if (mainHandStack.m_41720_() != Items.f_41852_) {
                renderEngine.getItemRenderer(mainHandStack).renderItemInHand(mainHandStack, (LivingEntityPatch)entityPatch, InteractionHand.MAIN_HAND, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
            }
            if (entityPatch.isOffhandItemValid() && offHandStack.m_41720_() != Items.f_41852_) {
                renderEngine.getItemRenderer(offHandStack).renderItemInHand(offHandStack, (LivingEntityPatch)entityPatch, InteractionHand.OFF_HAND, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
            }
        }
        this.renderLayer(renderer, (LivingEntityPatch)entityPatch, (LivingEntity)entity, armature.getPoseMatrices(), buffer, poseStack, packedLight, partialTicks);
        if (Minecraft.m_91087_().m_91290_().m_114377_()) {
            entityPatch.getClientAnimator().renderDebuggingInfoForAllLayers(poseStack, buffer, partialTicks);
        }
        poseStack.m_85849_();
    }

    public AssetAccessor<SkinnedMesh> getDefaultMesh() {
        if (this.meshAssetAccessor != null && this.meshAssetAccessor.get() instanceof SkinnedMesh) {
            return this.meshAssetAccessor;
        }
        return Meshes.BOOTS;
    }
}

