/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.event;

import com.merlin204.avalon.entity.AvalonEntities;
import com.merlin204.avalon.entity.client.renderer.EmptyRenderer;
import com.merlin204.avalon.entity.client.renderer.patch.entity.AvalonRendererPatch;
import com.merlin204.avalon.entity.client.renderer.patch.entity.AvalonVFXRendererPatch;
import com.merlin204.avalon.entity.client.renderer.patch.item.RenderAnimationItem;
import com.merlin204.avalon.entity.client.renderer.patch.item.RenderChangeMeshItem;
import com.merlin204.avalon.entity.client.renderer.patch.item.RenderMeshItem;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import com.merlin204.avalon.entity.vfx.VFXEntityPatch;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import yesman.epicfight.api.client.forgeevent.PatchedRenderersEvent;
import yesman.epicfight.api.forgeevent.EntityPatchRegistryEvent;

@Mod.EventBusSubscriber(modid="epic_fight_avalon", bus=Mod.EventBusSubscriber.Bus.MOD)
public class AvalonEntityEventHandler {
    @SubscribeEvent
    public static void handleEntityPatchRegistry(EntityPatchRegistryEvent event) {
        event.getTypeEntry().put((EntityType)AvalonEntities.SHAKE_WAVE.get(), entity -> VFXEntityPatch::new);
        event.getTypeEntry().put((EntityType)AvalonEntities.VFX.get(), entity -> VFXEntityPatch::new);
        event.getTypeEntry().put((EntityType)AvalonEntities.ANIMATION_TEXTURE_VFX.get(), entity -> VFXEntityPatch::new);
    }

    @SubscribeEvent
    public static void entityAttributeEvent(EntityAttributeCreationEvent event) {
        event.put((EntityType)AvalonEntities.SHAKE_WAVE.get(), VFXEntity.getDefaultAttribute());
        event.put((EntityType)AvalonEntities.VFX.get(), VFXEntity.getDefaultAttribute());
        event.put((EntityType)AvalonEntities.ANIMATION_TEXTURE_VFX.get(), VFXEntity.getDefaultAttribute());
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleClientSetup(FMLClientSetupEvent event) {
        EntityRenderers.m_174036_((EntityType)((EntityType)AvalonEntities.SHAKE_WAVE.get()), EmptyRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)AvalonEntities.VFX.get()), EmptyRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)AvalonEntities.ANIMATION_TEXTURE_VFX.get()), EmptyRenderer::new);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handlePatchedRenderers(PatchedRenderersEvent.Add event) {
        event.addPatchedEntityRenderer((EntityType)AvalonEntities.SHAKE_WAVE.get(), entityType -> new AvalonRendererPatch(event.getContext(), (EntityType<?>)entityType).initLayerLast(event.getContext(), (EntityType)entityType));
        event.addPatchedEntityRenderer((EntityType)AvalonEntities.VFX.get(), entityType -> new AvalonVFXRendererPatch(event.getContext(), (EntityType<?>)entityType).initLayerLast(event.getContext(), (EntityType)entityType));
        event.addPatchedEntityRenderer((EntityType)AvalonEntities.ANIMATION_TEXTURE_VFX.get(), entityType -> new AvalonVFXRendererPatch(event.getContext(), (EntityType<?>)entityType).initLayerLast(event.getContext(), (EntityType)entityType));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderers(PatchedRenderersEvent.RegisterItemRenderer event) {
        event.addItemRenderer(ResourceLocation.fromNamespaceAndPath((String)"epic_fight_avalon", (String)"mesh_item"), RenderMeshItem::new);
        event.addItemRenderer(ResourceLocation.fromNamespaceAndPath((String)"epic_fight_avalon", (String)"change_mesh_item"), RenderChangeMeshItem::new);
        event.addItemRenderer(ResourceLocation.fromNamespaceAndPath((String)"epic_fight_avalon", (String)"animation_item"), RenderAnimationItem::new);
    }
}

