/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.util;

import com.merlin204.avalon.client.CameraShake;
import com.merlin204.avalon.entity.vfx.VFXEntity;
import com.merlin204.avalon.util.AvalonAnimationUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.AnimationManager;
import yesman.epicfight.api.animation.AnimationPlayer;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.api.animation.property.AnimationEvent;
import yesman.epicfight.api.utils.LevelUtil;
import yesman.epicfight.api.utils.math.Vec3f;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.renderer.patched.item.RenderItemBase;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.damagesource.EpicFightDamageSources;
import yesman.epicfight.world.damagesource.StunType;

public class AvalonEventUtils {
    public static AnimationEvent.InPeriodEvent rotateToTarget(int startFrame, int endFrame, float step) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch.getTarget() != null) {
                entityPatch.rotateTo((Entity)entityPatch.getTarget(), step, true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InPeriodEvent chaseToTarget(int startFrame, int endFrame, float speed, float distance) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            if (entityPatch.getTarget() != null) {
                Vec3 playerPosition = ((LivingEntity)entityPatch.getOriginal()).m_20182_();
                Vec3 targetPosition = entityPatch.getTarget().m_20182_();
                if (((LivingEntity)entityPatch.getOriginal()).m_20182_().m_82554_(entityPatch.getTarget().m_20182_()) > (double)distance) {
                    Vec3 dir = entityPatch.getTarget().m_20182_().m_82546_(((LivingEntity)entityPatch.getOriginal()).m_20182_()).m_82541_().m_82490_((double)speed);
                    ((LivingEntity)entityPatch.getOriginal()).m_6478_(MoverType.SELF, new Vec3(dir.f_82479_, 0.0, dir.f_82481_));
                }
                entityPatch.rotateTo((Entity)entityPatch.getTarget(), 5.0f, true);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent simpleGroundSplit(int startFrame, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, boolean teamProtect) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> AvalonEventUtils.groundSplit(entityPatch, viewOffset, xOffset, yOffset, zOffset, radius, teamProtect), (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InTimeEvent simpleSonicBoom(int startFrame, Joint startJoint, float damage) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Vec3 startPos = AvalonAnimationUtils.getJointWorldPos(entityPatch, startJoint);
            if (entityPatch.getTarget() != null) {
                entityPatch.rotateTo((Entity)entityPatch.getTarget(), 90.0f, true);
                Vec3 toTarget = entityPatch.getTarget().m_146892_().m_82546_(startPos);
                Vec3 direction = toTarget.m_82541_();
                for (int step = 1; step < Mth.m_14107_((double)toTarget.m_82553_()) + 7; ++step) {
                    Vec3 particlePos = startPos.m_82549_(direction.m_82490_((double)step));
                    Level patt5075$temp = ((LivingEntity)entityPatch.getOriginal()).m_9236_();
                    if (!(patt5075$temp instanceof ServerLevel)) continue;
                    ServerLevel serverLevel = (ServerLevel)patt5075$temp;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_235902_, particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
                }
                ((LivingEntity)entityPatch.getOriginal()).m_5496_(SoundEvents.f_215771_, 3.0f, 1.0f);
                entityPatch.getTarget().f_19802_ = 0;
                entityPatch.getTarget().m_6469_((DamageSource)EpicFightDamageSources.shockwave((LivingEntity)((LivingEntity)entityPatch.getOriginal())).setAnimation((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION).setBaseImpact(damage * 10.0f), damage);
                double verticalKnockback = 0.5 * (1.0 - entityPatch.getTarget().m_21133_(Attributes.f_22278_));
                double horizontalKnockback = 2.5 * (1.0 - entityPatch.getTarget().m_21133_(Attributes.f_22278_));
                entityPatch.getTarget().m_5997_(direction.m_7096_() * horizontalKnockback, direction.m_7098_() * verticalKnockback, direction.m_7094_() * horizontalKnockback);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InPeriodEvent groundSplitAtk(int startFrame, int endFrame, Joint joint, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, float radius) {
        return AvalonEventUtils.groundSplitAtk(startFrame, endFrame, joint, startOffset, endOffset, timeInterpolation, radius, false);
    }

    public static AnimationEvent.InPeriodEvent groundSplitAtk(int startFrame, int endFrame, Joint joint, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, float radius, boolean test) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        Joint finalJoint = joint;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
            float prevElapsedTime = player.getPrevElapsedTime();
            float elapsedTime = player.getElapsedTime();
            float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
            Vec3 trailStartOffset = startOffset;
            Vec3 trailEndOffset = endOffset;
            Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
            for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                int particleCount = 10;
                for (int i = 0; i <= particleCount; ++i) {
                    float ratio = (float)i / (float)particleCount;
                    Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                    Vec3 worldPos = AvalonAnimationUtils.getJointWorldRawPos(entityPatch, finalJoint, f + step, pointOffset);
                    if (((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_ && test) {
                        ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123810_, worldPos.f_82479_, worldPos.f_82480_, worldPos.f_82481_, 0.0, 0.0, 0.0);
                        continue;
                    }
                    LevelUtil.circleSlamFracture((LivingEntity)((LivingEntity)entityPatch.getOriginal()), (Level)((LivingEntity)entityPatch.getOriginal()).m_9236_(), (Vec3)worldPos, (double)radius, (boolean)true, (boolean)false);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.BOTH);
    }

    public static AnimationEvent.InPeriodEvent particleTrail(int startFrame, int endFrame, InteractionHand hand, float timeInterpolation, int particleCount, ParticleOptions particleOptions) {
        return AvalonEventUtils.particleTrail(startFrame, endFrame, hand, timeInterpolation, particleCount, particleOptions, 0.0f);
    }

    public static AnimationEvent.InPeriodEvent particleTrail(int startFrame, int endFrame, InteractionHand hand, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, int particleCount, ParticleOptions particleOptions) {
        return AvalonEventUtils.particleTrail(startFrame, endFrame, hand, startOffset, endOffset, timeInterpolation, particleCount, particleOptions, 0.0f);
    }

    public static AnimationEvent.InPeriodEvent particleTrail(int startFrame, int endFrame, InteractionHand hand, Vec3 startOffset, Vec3 endOffset, float timeInterpolation, int particleCount, ParticleOptions particleOptions, float random) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        Joint joint = null;
        switch (hand) {
            case MAIN_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolR;
                break;
            }
            case OFF_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolL;
            }
        }
        Joint finalJoint = joint;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
            float prevElapsedTime = player.getPrevElapsedTime();
            float elapsedTime = player.getElapsedTime();
            float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
            Vec3 trailStartOffset = startOffset;
            Vec3 trailEndOffset = endOffset;
            Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
            for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                for (int i = 0; i <= particleCount; ++i) {
                    float ratio = (float)i / (float)particleCount;
                    Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                    double randX = (Math.random() - 0.5) * (double)random;
                    double randY = (Math.random() - 0.5) * (double)random;
                    double randZ = (Math.random() - 0.5) * (double)random;
                    Vec3 worldPos = AvalonAnimationUtils.getJointWorldRawPos(entityPatch, finalJoint, f + step, pointOffset);
                    if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                    ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleOptions, worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0, 0.0, 0.0);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InPeriodEvent particleTrail(int startFrame, int endFrame, InteractionHand hand, float timeInterpolation, int particleCount, ParticleOptions particleOptions, float random) {
        float start = (float)startFrame / 60.0f;
        float end = (float)endFrame / 60.0f;
        Joint joint = null;
        switch (hand) {
            case MAIN_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolR;
                break;
            }
            case OFF_HAND: {
                joint = ((HumanoidArmature)Armatures.BIPED.get()).toolL;
            }
        }
        Joint finalJoint = joint;
        return AnimationEvent.InPeriodEvent.create((float)start, (float)end, (entityPatch, self, params) -> {
            AnimationPlayer player = entityPatch.getAnimator().getPlayerFor(null);
            float prevElapsedTime = player.getPrevElapsedTime();
            float elapsedTime = player.getElapsedTime();
            float step = (elapsedTime - prevElapsedTime) / timeInterpolation;
            ItemStack stack = ((LivingEntity)entityPatch.getOriginal()).m_21120_(hand);
            RenderItemBase renderItemBase = ClientEngine.getInstance().renderEngine.getItemRenderer(stack);
            if (renderItemBase == null) {
                return;
            }
            Vec3 trailStartOffset = renderItemBase.trailInfo().start();
            Vec3 trailEndOffset = renderItemBase.trailInfo().end();
            Vec3f trailDirection = new Vec3f((float)(trailEndOffset.f_82479_ - trailStartOffset.f_82479_), (float)(trailEndOffset.f_82480_ - trailStartOffset.f_82480_), (float)(trailEndOffset.f_82481_ - trailStartOffset.f_82481_));
            for (float f = prevElapsedTime; f <= elapsedTime; f += step) {
                for (int i = 0; i <= particleCount; ++i) {
                    float ratio = (float)i / (float)particleCount;
                    Vec3f pointOffset = new Vec3f((float)(trailStartOffset.f_82479_ + (double)(trailDirection.x * ratio)), (float)(trailStartOffset.f_82480_ + (double)(trailDirection.y * ratio)), (float)(trailStartOffset.f_82481_ + (double)(trailDirection.z * ratio)));
                    double randX = (Math.random() - 0.5) * (double)random;
                    double randY = (Math.random() - 0.5) * (double)random;
                    double randZ = (Math.random() - 0.5) * (double)random;
                    Vec3 worldPos = AvalonAnimationUtils.getJointWorldRawPos(entityPatch, finalJoint, f + step, pointOffset);
                    if (!((LivingEntity)entityPatch.getOriginal()).m_9236_().f_46443_) continue;
                    ((LivingEntity)entityPatch.getOriginal()).m_9236_().m_7106_(particleOptions, worldPos.f_82479_ + randX, worldPos.f_82480_ + randY, worldPos.f_82481_ + randZ, 0.0, 0.0, 0.0);
                }
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent simpleSound(int startFrame, SoundEvent soundEvent, float volume, float pitch) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> ((LivingEntity)entityPatch.getOriginal()).m_5496_(soundEvent, volume, pitch), (AnimationEvent.Side)AnimationEvent.Side.SERVER);
    }

    public static AnimationEvent.InTimeEvent simpleCameraShake(int startFrame, int duration, float intensity, float frequency, float radius) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> CameraShake.shake(duration, intensity, frequency, ((LivingEntity)entityPatch.getOriginal()).m_20182_(), radius), (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static AnimationEvent.InTimeEvent startDispersed(int startFrame, float speed) {
        float start = (float)startFrame / 60.0f;
        return AnimationEvent.InTimeEvent.create((float)start, (entityPatch, self, params) -> {
            Entity patt15848$temp = entityPatch.getOriginal();
            if (patt15848$temp instanceof VFXEntity) {
                VFXEntity vfxEntity = (VFXEntity)patt15848$temp;
                vfxEntity.setDisSpeed(speed);
            }
        }, (AnimationEvent.Side)AnimationEvent.Side.CLIENT);
    }

    public static void groundSplit(LivingEntityPatch<?> entityPatch, double viewOffset, double xOffset, double yOffset, double zOffset, float radius, boolean teamProtect) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        float damage = AvalonEventUtils.getTotalAttackDamage(entityPatch) * 0.5f;
        Vec3 pos = entity.m_20182_();
        float yaw = entityPatch.getYRot();
        double radians = Math.toRadians(yaw);
        double cosYaw = Math.cos(radians);
        double sinYaw = Math.sin(radians);
        double worldX = xOffset * cosYaw + zOffset * sinYaw;
        double worldZ = -xOffset * sinYaw + zOffset * cosYaw;
        Vec3 viewDir = new Vec3(-sinYaw, 0.0, cosYaw).m_82490_(viewOffset);
        Vec3 totalOffset = viewDir.m_82520_(worldX, yOffset, worldZ);
        Vec3 target = pos.m_82520_(totalOffset.f_82479_, -1.0 + totalOffset.f_82480_, totalOffset.f_82481_);
        Vec3 damagetarget = pos.m_82520_(totalOffset.f_82479_, totalOffset.f_82480_, totalOffset.f_82481_);
        Level level = entity.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (target != null) {
                LevelUtil.circleSlamFracture((LivingEntity)entity, (Level)level2, (Vec3)target, (double)radius, (boolean)false);
                AvalonEventUtils.dealAreaDamage(level2, damagetarget, entity, damage, radius, StunType.LONG, teamProtect);
            }
        }
    }

    private static void dealAreaDamage(ServerLevel level, Vec3 center, LivingEntity source, float damage, float radius, StunType stunType, boolean teamProtect) {
        if (radius <= 0.0f) {
            return;
        }
        AABB area = new AABB(center.m_7096_() - (double)radius, center.m_7098_() - (double)radius, center.m_7094_() - (double)radius, center.m_7096_() + (double)radius, center.m_7098_() + (double)radius, center.m_7094_() + (double)radius);
        if (teamProtect) {
            List entities = level.m_6443_(LivingEntity.class, area, entity -> entity.m_6084_() && entity.m_20238_(center) <= (double)(radius * radius) && entity.m_6095_().m_20674_() != source.m_6095_().m_20674_() && entity != source);
            for (LivingEntity entity2 : new ArrayList(entities)) {
                if (entity2.f_19802_ >= 0 && source != null) {
                    entity2.f_19802_ = 0;
                    entity2.m_6469_((DamageSource)EpicFightDamageSources.shockwave((LivingEntity)source).setAnimation((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION).setInitialPosition(center).setStunType(stunType).setBaseImpact(damage / 5.0f), damage);
                }
                entity2.f_19802_ = 0;
            }
        } else {
            List entities = level.m_6443_(LivingEntity.class, area, entity -> entity.m_6084_() && entity.m_20238_(center) <= (double)(radius * radius) && entity.m_6095_() != source.m_6095_() && entity != source);
            for (LivingEntity entity3 : new ArrayList(entities)) {
                if (entity3.f_19802_ < 0 || source == null) continue;
                entity3.f_19802_ = 0;
                entity3.m_6469_((DamageSource)EpicFightDamageSources.shockwave((LivingEntity)source).setAnimation((AnimationManager.AnimationAccessor)Animations.EMPTY_ANIMATION).setInitialPosition(center).setStunType(stunType).setBaseImpact(damage / 5.0f), damage);
                entity3.f_19802_ = 0;
            }
        }
    }

    public static float getTotalAttackDamage(LivingEntityPatch<?> entityPatch) {
        LivingEntity owner = (LivingEntity)entityPatch.getOriginal();
        double baseDamage = owner.m_21133_(Attributes.f_22281_);
        return (float)baseDamage;
    }
}

