/*
 * Decompiled with CFR 0.152.
 */
package com.merlin204.avalon.util;

import com.merlin204.avalon.util.AvalonAnimationUtils;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import yesman.epicfight.api.animation.Joint;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;

public class AvalonParticleUtils {
    public static void createLineBetweenJoint(LivingEntityPatch<?> entityPatch, Joint joint1, Joint joint2, ParticleOptions particleOptions, int count) {
        Vec3 pos1 = AvalonAnimationUtils.getJointWorldPos(entityPatch, joint1);
        Vec3 pos2 = AvalonAnimationUtils.getJointWorldPos(entityPatch, joint2);
        LivingEntity livingEntity = (LivingEntity)entityPatch.getOriginal();
        AvalonParticleUtils.createLineSegmentParticles(livingEntity.m_9236_(), pos1, pos2, particleOptions, count, livingEntity.m_20184_());
    }

    public static void createRandomLine(Level level, Vec3 center, ParticleOptions particleOptions, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random1 = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)(particleCount - 1);
            double distance = t * 5.0;
            double angle = random1.m_188500_() * 2.0 * Math.PI;
            double pitch = random1.m_188500_() * Math.PI - 1.5707963267948966;
            double offsetX = Math.cos(angle) * Math.cos(pitch);
            double offsetY = Math.sin(pitch);
            double offsetZ = Math.sin(angle) * Math.cos(pitch);
            double x = center.m_7096_() + offsetX * distance;
            double y = center.m_7098_() + offsetY * distance;
            double z = center.m_7094_() + offsetZ * distance;
            double speed = minSpeed + random1.m_188500_() * (maxSpeed - minSpeed);
            level.m_7106_(particleOptions, x, y, z, offsetX * speed, offsetY * speed, offsetZ * speed);
        }
    }

    public static void createJointRandomLine(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 vec3 = AvalonAnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)(particleCount - 1);
            double distance = t * 5.0;
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = random.m_188500_() * Math.PI - 1.5707963267948966;
            double offsetX = Math.cos(angle) * Math.cos(pitch);
            double offsetY = Math.sin(pitch);
            double offsetZ = Math.sin(angle) * Math.cos(pitch);
            double x = vec3.m_7096_() + offsetX * distance;
            double y = vec3.m_7098_() + offsetY * distance;
            double z = vec3.m_7094_() + offsetZ * distance;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            if (!level.f_46443_) continue;
            level.m_7106_(particleOptions, x, y, z, offsetX * speed, offsetY * speed, offsetZ * speed);
        }
    }

    public static void createSphereParticles(Level level, Vec3 center, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = Math.acos(2.0 * random.m_188500_() - 1.0) - 1.5707963267948966;
            double offsetX = Math.cos(angle) * Math.cos(pitch);
            double offsetY = Math.sin(pitch);
            double offsetZ = Math.sin(angle) * Math.cos(pitch);
            double x = center.m_7096_() + offsetX * radius;
            double y = center.m_7098_() + offsetY * radius;
            double z = center.m_7094_() + offsetZ * radius;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            level.m_6493_(particleOptions, true, x, y, z, offsetX * speed, offsetY * speed, offsetZ * speed);
        }
    }

    public static void createJointSphereParticles(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 vec3 = AvalonAnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = Math.acos(2.0 * random.m_188500_() - 1.0) - 1.5707963267948966;
            double offsetX = Math.cos(angle) * Math.cos(pitch);
            double offsetY = Math.sin(pitch);
            double offsetZ = Math.sin(angle) * Math.cos(pitch);
            double x = vec3.m_7096_() + offsetX * radius;
            double y = vec3.m_7098_() + offsetY * radius;
            double z = vec3.m_7094_() + offsetZ * radius;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            if (!level.f_46443_) continue;
            level.m_7106_(particleOptions, x, y, z, offsetX * speed, offsetY * speed, offsetZ * speed);
        }
    }

    public static void createDirectionalParticles(LivingEntityPatch<?> entityPatch, Vec3 center, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double theta = random.m_188500_() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.m_188500_() - 1.0);
            double dirX = Math.sin(phi) * Math.cos(theta);
            double dirY = Math.cos(phi);
            double dirZ = Math.sin(phi) * Math.sin(theta);
            double posX = center.m_7096_() + dirX;
            double posY = center.m_7098_() + dirY;
            double posZ = center.m_7094_() + dirZ;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            if (!level.f_46443_) continue;
            level.m_6493_(particleOptions, true, posX, posY, posZ, dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createJointDirectionalParticles(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 jointPos = AvalonAnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double theta = random.m_188500_() * 2.0 * Math.PI;
            double phi = Math.acos(2.0 * random.m_188500_() - 1.0);
            double dirX = Math.sin(phi) * Math.cos(theta);
            double dirY = Math.cos(phi);
            double dirZ = Math.sin(phi) * Math.sin(theta);
            double posX = jointPos.m_7096_() + dirX;
            double posY = jointPos.m_7098_() + dirY;
            double posZ = jointPos.m_7094_() + dirZ;
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            if (!level.f_46443_) continue;
            level.m_6493_(particleOptions, true, posX, posY, posZ, dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createRingParticles(Level level, Vec3 center, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double x = center.m_7096_() + Math.cos(angle) * radius;
            double y = center.m_7098_();
            double z = center.m_7094_() + Math.sin(angle) * radius;
            double speedX = -Math.sin(angle);
            double speedZ = Math.cos(angle);
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            level.m_7106_(particleOptions, x, y, z, speedX * speed, 0.0, speedZ * speed);
        }
    }

    public static void createJointRingParticles(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 vec3 = AvalonAnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double x = vec3.m_7096_() + Math.cos(angle) * radius;
            double y = vec3.m_7098_();
            double z = vec3.m_7094_() + Math.sin(angle) * radius;
            double speedX = -Math.sin(angle);
            double speedZ = Math.cos(angle);
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            level.m_7106_(particleOptions, x, y, z, speedX * speed, 0.0, speedZ * speed);
        }
    }

    public static void createRandomInSphereParticles(Level level, Vec3 center, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double r = radius * Math.cbrt(random.m_188500_());
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = Math.acos(2.0 * random.m_188500_() - 1.0) - 1.5707963267948966;
            double x = center.m_7096_() + r * Math.cos(angle) * Math.cos(pitch);
            double y = center.m_7098_() + r * Math.sin(pitch);
            double z = center.m_7094_() + r * Math.sin(angle) * Math.cos(pitch);
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            double dirAngle = random.m_188500_() * 2.0 * Math.PI;
            double dirPitch = random.m_188500_() * Math.PI - 1.5707963267948966;
            double dirX = Math.cos(dirAngle) * Math.cos(dirPitch);
            double dirY = Math.sin(dirPitch);
            double dirZ = Math.sin(dirAngle) * Math.cos(dirPitch);
            level.m_6493_(particleOptions, true, x, y, z, dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createJointRandomInSphereParticles(LivingEntityPatch<?> entityPatch, Joint joint, ParticleOptions particleOptions, double radius, double minSpeed, double maxSpeed, int particleCount) {
        LivingEntity entity = (LivingEntity)entityPatch.getOriginal();
        Level level = entity.m_9236_();
        Vec3 vec3 = AvalonAnimationUtils.getJointWorldPos(entityPatch, joint);
        RandomSource random = level.f_46441_;
        for (int i = 0; i < particleCount; ++i) {
            double r = radius * Math.cbrt(random.m_188500_());
            double angle = random.m_188500_() * 2.0 * Math.PI;
            double pitch = Math.acos(2.0 * random.m_188500_() - 1.0) - 1.5707963267948966;
            double x = vec3.m_7096_() + r * Math.cos(angle) * Math.cos(pitch);
            double y = vec3.m_7098_() + r * Math.sin(pitch);
            double z = vec3.m_7094_() + r * Math.sin(angle) * Math.cos(pitch);
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            double dirAngle = random.m_188500_() * 2.0 * Math.PI;
            double dirPitch = random.m_188500_() * Math.PI - 1.5707963267948966;
            double dirX = Math.cos(dirAngle) * Math.cos(dirPitch);
            double dirY = Math.sin(dirPitch);
            double dirZ = Math.sin(dirAngle) * Math.cos(dirPitch);
            if (!level.f_46443_) continue;
            level.m_7106_(particleOptions, x, y, z, dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createLineSegmentParticles(Level level, Vec3 start, Vec3 end, ParticleOptions particleOptions, int particleCount, Vec3 deltaMovement) {
        Vec3 direction = end.m_82546_(start);
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)(particleCount - 1);
            Vec3 pos = start.m_82549_(direction.m_82490_(t));
            level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, deltaMovement.f_82479_, deltaMovement.f_82480_, deltaMovement.f_82481_);
        }
    }

    public static void createLineSegmentParticles(Level level, Vec3 start, Vec3 end, ParticleOptions particleOptions, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        Vec3 direction = end.m_82546_(start);
        for (int i = 0; i < particleCount; ++i) {
            double t = (double)i / (double)(particleCount - 1);
            Vec3 pos = start.m_82549_(direction.m_82490_(t));
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            double dirX = direction.f_82479_ / (double)particleCount;
            double dirY = direction.f_82480_ / (double)particleCount;
            double dirZ = direction.f_82481_ / (double)particleCount;
            level.m_7106_(particleOptions, pos.f_82479_, pos.f_82480_, pos.f_82481_, dirX * speed, dirY * speed, dirZ * speed);
        }
    }

    public static void createMovingParticles(Level level, Vec3 start, Vec3 end, ParticleOptions particleOptions, double minSpeed, double maxSpeed, int particleCount) {
        RandomSource random = level.f_46441_;
        Vec3 direction = end.m_82546_(start).m_82541_();
        for (int i = 0; i < particleCount; ++i) {
            double speed = minSpeed + random.m_188500_() * (maxSpeed - minSpeed);
            level.m_7106_(particleOptions, start.f_82479_, start.f_82480_, start.f_82481_, direction.f_82479_ * speed, direction.f_82480_ * speed, direction.f_82481_ * speed);
        }
    }
}

