/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity;

import com.samxel.durabilityrarity.RarityUtil;
import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.DoubleValue BROKEN_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue DAMAGED_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue COMMON_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue RARE_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue EPIC_MULTIPLIER;
    public static final ModConfigSpec.DoubleValue LEGENDARY_MULTIPLIER;
    public static final ModConfigSpec.IntValue BROKEN_CHANCE;
    public static final ModConfigSpec.IntValue DAMAGED_CHANCE;
    public static final ModConfigSpec.IntValue COMMON_CHANCE;
    public static final ModConfigSpec.IntValue RARE_CHANCE;
    public static final ModConfigSpec.IntValue EPIC_CHANCE;
    public static final ModConfigSpec.IntValue LEGENDARY_CHANCE;
    public static final ModConfigSpec.DoubleValue LEGENDARY_SPEED;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> MODID_BLACKLIST;
    public static final ModConfigSpec.ConfigValue<List<? extends String>> ITEM_BLACKLIST;
    public static final ModConfigSpec SPEC;
    private static final double[] multipliers;
    private static final int[] chances;

    public static double getLegendarySpeed() {
        return (Double)LEGENDARY_SPEED.get();
    }

    public static double getMultiplier(RarityUtil.RarityClass rarity) {
        return multipliers[rarity.ordinal()];
    }

    public static int getChance(RarityUtil.RarityClass rarity) {
        return chances[rarity.ordinal()];
    }

    public static List<? extends String> getModIdBlacklist() {
        return (List)MODID_BLACKLIST.get();
    }

    public static List<? extends String> getItemBlacklist() {
        return (List)ITEM_BLACKLIST.get();
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        Config.multipliers[0] = (Double)BROKEN_MULTIPLIER.get();
        Config.multipliers[1] = (Double)DAMAGED_MULTIPLIER.get();
        Config.multipliers[2] = (Double)COMMON_MULTIPLIER.get();
        Config.multipliers[3] = (Double)RARE_MULTIPLIER.get();
        Config.multipliers[4] = (Double)EPIC_MULTIPLIER.get();
        Config.multipliers[5] = (Double)LEGENDARY_MULTIPLIER.get();
        Config.chances[0] = (Integer)BROKEN_CHANCE.get();
        Config.chances[1] = (Integer)DAMAGED_CHANCE.get();
        Config.chances[2] = (Integer)COMMON_CHANCE.get();
        Config.chances[3] = (Integer)RARE_CHANCE.get();
        Config.chances[4] = (Integer)EPIC_CHANCE.get();
        Config.chances[5] = (Integer)LEGENDARY_CHANCE.get();
    }

    static {
        BUILDER.push("multipliers");
        BROKEN_MULTIPLIER = BUILDER.defineInRange("broken", 0.3, 0.01, 10.0);
        DAMAGED_MULTIPLIER = BUILDER.defineInRange("damaged", 0.6, 0.01, 10.0);
        COMMON_MULTIPLIER = BUILDER.defineInRange("common", 1.0, 0.01, 10.0);
        RARE_MULTIPLIER = BUILDER.defineInRange("rare", 1.3, 0.01, 10.0);
        EPIC_MULTIPLIER = BUILDER.defineInRange("epic", 1.6, 0.01, 10.0);
        LEGENDARY_MULTIPLIER = BUILDER.defineInRange("legendary", 1.9, 0.01, 10.0);
        BUILDER.pop();
        BUILDER.push("chances");
        BROKEN_CHANCE = BUILDER.defineInRange("broken", 15, 0, 100);
        DAMAGED_CHANCE = BUILDER.defineInRange("damaged", 20, 0, 100);
        COMMON_CHANCE = BUILDER.defineInRange("common", 30, 0, 100);
        RARE_CHANCE = BUILDER.defineInRange("rare", 20, 0, 100);
        EPIC_CHANCE = BUILDER.defineInRange("epic", 10, 0, 100);
        LEGENDARY_CHANCE = BUILDER.defineInRange("legendary", 5, 0, 100);
        BUILDER.pop();
        BUILDER.push("attack_and_miningspeed_multiplier");
        LEGENDARY_SPEED = BUILDER.defineInRange("legendary", 1.1, 0.0, 10.0);
        BUILDER.pop();
        BUILDER.push("blacklists");
        MODID_BLACKLIST = BUILDER.comment(" List of mod IDs whose items should be ignored by DurabilityRarity.").defineListAllowEmpty(List.of("modid_blacklist"), () -> List.of("examplemod"), obj -> obj instanceof String);
        ITEM_BLACKLIST = BUILDER.comment(" List of specific items (namespace:path) that should be ignored.").defineListAllowEmpty(List.of("item_blacklist"), () -> List.of("minecraft:stick"), obj -> obj instanceof String);
        BUILDER.pop();
        SPEC = BUILDER.build();
        multipliers = new double[6];
        chances = new int[6];
    }
}

