/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity;

import com.mojang.logging.LogUtils;
import com.samxel.durabilityrarity.Config;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;
import org.slf4j.Logger;

public class RarityUtil {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String KEY_CLASS = "rarity_class";
    private static final String KEY_MAX = "rarity_max_durability";
    private static final double[] DEFAULT_MULTIPLIERS = new double[]{0.3, 0.6, 1.0, 1.3, 1.6, 1.9};
    private static final int[] DEFAULT_CHANCES = new int[]{15, 20, 30, 20, 10, 5};

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        Player player = event.getEntity();
        if (player.level().isClientSide()) {
            return;
        }
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            RarityUtil.ensureRarity(stack, player.getRandom(), player);
        }
    }

    public static void ensureRarity(ItemStack stack, RandomSource random, Player player) {
        if (stack.isEmpty()) {
            return;
        }
        if (!stack.isDamageableItem()) {
            return;
        }
        if (RarityUtil.getRarity(stack).isPresent()) {
            return;
        }
        if (RarityUtil.isBlacklisted(stack)) {
            return;
        }
        RarityClass rarity = RarityUtil.getRandomRarity(random);
        RarityUtil.applyRarity(stack, rarity, player);
    }

    private static boolean isBlacklisted(ItemStack stack) {
        Item item = stack.getItem();
        ResourceLocation id = item.builtInRegistryHolder().key().location();
        String modId = id.getNamespace();
        List<? extends String> modBlacklist = Config.getModIdBlacklist();
        if (modBlacklist.stream().anyMatch(bad -> bad.equalsIgnoreCase(modId))) {
            LOGGER.debug("Skipping item [{}] due to blacklisted mod id [{}]", (Object)id.toString(), (Object)modId);
            return true;
        }
        String fullName = id.toString();
        List<? extends String> itemBlacklist = Config.getItemBlacklist();
        if (itemBlacklist.stream().anyMatch(bad -> bad.equalsIgnoreCase(fullName))) {
            LOGGER.debug("Skipping item [{}] because it's in the item blacklist", (Object)fullName);
            return true;
        }
        return false;
    }

    public static RarityClass getRandomRarity(RandomSource random) {
        int i;
        int n = RarityClass.values().length;
        int[] chances = new int[n];
        int sum = 0;
        for (i = 0; i < n; ++i) {
            int v;
            chances[i] = v = Config.getChance(RarityClass.values()[i]);
            sum += v;
        }
        if (sum <= 0) {
            sum = 0;
            for (i = 0; i < n; ++i) {
                chances[i] = DEFAULT_CHANCES[i];
                sum += chances[i];
            }
        }
        int roll = random.nextInt(sum) + 1;
        int cumulative = 0;
        for (int i2 = 0; i2 < n; ++i2) {
            if (roll > (cumulative += chances[i2])) continue;
            return RarityClass.values()[i2];
        }
        return RarityClass.COMMON;
    }

    public static void applyRarity(ItemStack stack, RarityClass rarity, Player player) {
        int vanillaMaxDurability = new ItemStack((ItemLike)stack.getItem()).getMaxDamage();
        if (vanillaMaxDurability <= 0) {
            return;
        }
        double mult = Config.getMultiplier(rarity);
        if (mult <= 0.0) {
            mult = DEFAULT_MULTIPLIERS[rarity.ordinal()];
        }
        int newMax = Math.max(1, (int)Math.round((double)vanillaMaxDurability * mult));
        RarityUtil.putString(stack, KEY_CLASS, rarity.name());
        RarityUtil.putInt(stack, KEY_MAX, newMax);
        stack.set(DataComponents.MAX_DAMAGE, (Object)newMax);
        int currentDamage = stack.getDamageValue();
        int newDamage = Math.min(currentDamage, Math.max(0, newMax - 1));
        stack.setDamageValue(newDamage);
        if (player != null) {
            player.getInventory().setChanged();
        }
        LOGGER.debug("Assigned rarity [{}] to item [{}] for player [{}] (new max: {}, vanilla max: {}, current damage: {}, mult: {})", new Object[]{rarity.name(), stack.getDisplayName().getString(), player != null ? player.getName().getString() : "unknown", newMax, vanillaMaxDurability, currentDamage, mult});
    }

    public static Optional<RarityClass> getRarity(ItemStack stack) {
        String s = RarityUtil.getString(stack, KEY_CLASS);
        if (s == null || s.isEmpty()) {
            return Optional.empty();
        }
        try {
            return Optional.of(RarityClass.valueOf(s));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static Optional<Integer> getRarityMaxDurability(ItemStack stack) {
        Integer i = RarityUtil.getInt(stack, KEY_MAX);
        return i != null ? Optional.of(i) : Optional.empty();
    }

    private static CompoundTag getCustomTag(ItemStack stack) {
        CustomData data = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
        CompoundTag tag = data.copyTag();
        if (tag == null) {
            tag = new CompoundTag();
        }
        return tag;
    }

    private static void setCustomTag(ItemStack stack, CompoundTag tag) {
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)tag));
    }

    private static void putString(ItemStack stack, String key, String value) {
        CompoundTag tag = RarityUtil.getCustomTag(stack);
        tag.putString(key, value);
        RarityUtil.setCustomTag(stack, tag);
    }

    private static void putInt(ItemStack stack, String key, int value) {
        CompoundTag tag = RarityUtil.getCustomTag(stack);
        tag.putInt(key, value);
        RarityUtil.setCustomTag(stack, tag);
    }

    private static String getString(ItemStack stack, String key) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return null;
        }
        CompoundTag tag = data.copyTag();
        return tag.contains(key) ? (String)tag.getString(key).orElse(null) : null;
    }

    private static Integer getInt(ItemStack stack, String key) {
        CustomData data = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (data == null) {
            return null;
        }
        CompoundTag tag = data.copyTag();
        return tag.contains(key) ? (Integer)tag.getInt(key).orElse(null) : null;
    }

    public static void putRarityTag(ItemStack stack, RarityClass rarity) {
        if (stack.isEmpty()) {
            return;
        }
        CompoundTag tag = RarityUtil.getCustomTag(stack);
        tag.putString(KEY_CLASS, rarity.name());
        RarityUtil.setCustomTag(stack, tag);
    }

    public static enum RarityClass {
        BROKEN,
        DAMAGED,
        COMMON,
        RARE,
        EPIC,
        LEGENDARY;

    }
}

