/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity.mixin;

import com.mojang.logging.LogUtils;
import com.samxel.durabilityrarity.RarityUtil;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.ItemCombinerMenu;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ItemCombinerMenu.class})
public abstract class ItemCombinerMenuMixin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Inject(method={"slotsChanged"}, at={@At(value="TAIL")}, remap=false)
    private void durabilityrarity$applyRarityAfterSlotsChanged(Container container, CallbackInfo ci) {
        ItemCombinerMenu self = (ItemCombinerMenu)this;
        if (!(self instanceof SmithingMenu)) {
            return;
        }
        SmithingMenu smithing = (SmithingMenu)self;
        ItemStack result = smithing.getSlot(3).getItem();
        ItemStack base = smithing.getSlot(1).getItem();
        if (result.isEmpty() || base.isEmpty() || !result.isDamageableItem() || !base.isDamageableItem()) {
            return;
        }
        LOGGER.debug("[DR|Smithing] slotsChanged fired \u2192 base={} result={}", (Object)base.getDisplayName().getString(), (Object)result.getDisplayName().getString());
        RarityUtil.getRarity(base).ifPresent(rarity -> {
            int baseMax = Math.max(base.getMaxDamage(), 1);
            int baseDamage = base.getDamageValue();
            float usedRatio = Math.min(Math.max((float)baseDamage / (float)baseMax, 0.0f), 1.0f);
            int vanillaMax = new ItemStack((ItemLike)result.getItem()).getMaxDamage();
            RarityUtil.applyRarity(result, rarity, null);
            int finalMax = result.getMaxDamage();
            int finalDamage = Math.min(Math.round(usedRatio * (float)finalMax), finalMax - 1);
            result.setDamageValue(finalDamage);
            LOGGER.debug("[DR|Smithing] rarity={} usedRatio={} finalMax={} finalDmg={}", new Object[]{rarity, String.format("%.3f", Float.valueOf(usedRatio)), finalMax, finalDamage});
        });
    }
}

