/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity.mixin;

import com.mojang.logging.LogUtils;
import com.samxel.durabilityrarity.RarityUtil;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SmithingMenu.class}, remap=false)
public abstract class SmithingMenuMixin {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Inject(method={"createResult"}, at={@At(value="RETURN")})
    private void durabilityrarity$applyRarityAfterCreateResult(CallbackInfo ci) {
        SmithingMenu self = (SmithingMenu)this;
        ItemStack result = self.getSlot(3).getItem();
        ItemStack base = self.getSlot(1).getItem();
        LOGGER.warn("[DR|Smithing] createResult(RETURN) | resultEmpty={} baseEmpty={} resultDmgbl={} baseDmgbl={}", new Object[]{result.isEmpty(), base.isEmpty(), result.isDamageableItem(), base.isDamageableItem()});
        if (result.isEmpty() || base.isEmpty() || !result.isDamageableItem() || !base.isDamageableItem()) {
            return;
        }
        RarityUtil.getRarity(base).ifPresentOrElse(rarity -> {
            int baseCurMax = Math.max(base.getMaxDamage(), 1);
            int baseDmg = Math.max(base.getDamageValue(), 0);
            float usedRatio = Math.min(Math.max((float)baseDmg / (float)baseCurMax, 0.0f), 1.0f);
            int vanillaOutMax = new ItemStack((ItemLike)result.getItem()).getMaxDamage();
            LOGGER.warn("[DR|Smithing][PRE] base='{}' dmg={} curMax={} usedRatio={} | result='{}' curMax={} vanillaOutMax={} | rarity={}", new Object[]{base.getDisplayName().getString(), baseDmg, baseCurMax, String.format("%.4f", Float.valueOf(usedRatio)), result.getDisplayName().getString(), result.getMaxDamage(), vanillaOutMax, rarity});
            RarityUtil.applyRarity(result, rarity, null);
            int finalMax = Math.max(result.getMaxDamage(), 1);
            int finalDmg = Math.min(Math.round(usedRatio * (float)finalMax), Math.max(0, finalMax - 1));
            result.setDamageValue(finalDmg);
            LOGGER.warn("[DR|Smithing][POST] rarity={} | finalMax={} finalDmg={} remaining={} usedRatio={}", new Object[]{rarity, finalMax, finalDmg, finalMax - finalDmg, String.format("%.4f", Float.valueOf(usedRatio))});
        }, () -> LOGGER.warn("[DR|Smithing] base has no rarity -> no changes (result='{}')", (Object)result.getDisplayName().getString()));
    }
}

