/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.durabilityrarity;

import com.mojang.logging.LogUtils;
import com.samxel.durabilityrarity.Config;
import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.slf4j.Logger;

public class RarityUtil {
    private static final Logger LOGGER = LogUtils.getLogger();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        Player player = event.player;
        if (player.m_9236_().m_5776_()) {
            return;
        }
        for (ItemStack stack : player.m_150109_().f_35974_) {
            RarityUtil.ensureRarity(stack, player.m_217043_(), player);
        }
    }

    public static void ensureRarity(ItemStack stack, RandomSource random, Player player) {
        if (stack == null || stack.m_41619_()) {
            return;
        }
        if (!stack.m_41763_()) {
            return;
        }
        if (RarityUtil.isBlacklisted(stack)) {
            return;
        }
        if (!stack.m_41782_() || !stack.m_41783_().m_128441_("rarity_class")) {
            RarityClass rarity = RarityUtil.getRandomRarity(random);
            RarityUtil.applyRarity(stack, rarity, player);
        }
    }

    public static RarityClass getRandomRarity(RandomSource random) {
        int roll = random.m_188503_(100) + 1;
        int cumulative = 0;
        for (RarityClass rarity : RarityClass.values()) {
            if (roll > (cumulative += Config.getChance(rarity))) continue;
            return rarity;
        }
        return RarityClass.COMMON;
    }

    public static void applyRarity(ItemStack stack, RarityClass rarity, Player player) {
        double multiplier = Config.getMultiplier(rarity);
        int baseMaxDurability = stack.m_41776_();
        int newMax = (int)Math.round((double)baseMaxDurability * multiplier);
        CompoundTag tag = stack.m_41784_();
        tag.m_128359_("rarity_class", rarity.name());
        tag.m_128405_("rarity_max_durability", newMax);
        int currentDamage = stack.m_41773_();
        int newDamage = Math.min(currentDamage, newMax - 1);
        stack.m_41721_(newDamage);
        LOGGER.debug("Assigned rarity [{}] to item [{}] for player [{}] (new max durability: {}, old max: {}, current damage: {})", new Object[]{rarity.name(), stack.m_41611_().getString(), player != null ? player.m_7755_().getString() : "unknown", newMax, baseMaxDurability, currentDamage});
    }

    public static Optional<RarityClass> getRarity(ItemStack stack) {
        if (stack == null || stack.m_41619_() || !stack.m_41782_()) {
            return Optional.empty();
        }
        CompoundTag tag = stack.m_41783_();
        if (tag == null || !tag.m_128441_("rarity_class")) {
            return Optional.empty();
        }
        try {
            String name = tag.m_128461_("rarity_class");
            if (name == null || name.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(RarityClass.valueOf(name));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static boolean isBlacklisted(ItemStack stack) {
        if (stack == null || stack.m_41619_()) {
            return false;
        }
        ResourceLocation id = BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_());
        if (id == null) {
            return false;
        }
        String modid = id.m_135827_();
        String fullName = id.toString();
        boolean matchMod = Config.getModidBlacklist().stream().anyMatch(s -> s.equalsIgnoreCase(modid));
        boolean matchItem = Config.getItemBlacklist().stream().anyMatch(s -> s.equalsIgnoreCase(fullName));
        if (matchMod || matchItem) {
            LOGGER.debug("[DurRarity] skipped {} (matchMod={} matchItem={})", new Object[]{fullName, matchMod, matchItem});
            return true;
        }
        return false;
    }

    public static enum RarityClass {
        BROKEN,
        DAMAGED,
        COMMON,
        RARE,
        EPIC,
        LEGENDARY;

    }
}

