/*
 * Decompiled with CFR 0.152.
 */
package energon.srpextra.world;

import energon.srpextra.world.SRPEStructureUtils;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenSpawn {
    public static int spawn(World world, BlockPos pos, SRPEStructureUtils element, Random random, boolean loop, int worldPhase) {
        if (worldPhase >= element.phase) {
            if (element.checkBiome(world, pos)) {
                BlockPos ffPos = WorldGenSpawn.getStructureFinalPos(world, pos, element.type);
                if (ffPos == null) {
                    return 2;
                }
                return element.spawnStructure(world, ffPos, null, random, loop, worldPhase);
            }
            return 4;
        }
        return 0;
    }

    private static BlockPos getStructureFinalPos(World world, BlockPos pos, int type) {
        switch (type) {
            case 5: {
                return pos.func_177981_b(world.func_72800_K() - 10);
            }
            case 4: {
                return pos.func_177981_b(world.field_73012_v.nextInt(16) + 64 + world.func_175672_r(pos).func_177956_o());
            }
            case 3: {
                return WorldGenSpawn.mountains(world, pos);
            }
            case 2: {
                return pos.func_177981_b(world.func_181545_F());
            }
            case 1: {
                return WorldGenSpawn.testOne(world, pos);
            }
            case 0: {
                return WorldGenSpawn.testZero(world, pos);
            }
            case -1: {
                return WorldGenSpawn.testAqua(world, pos);
            }
            case -2: {
                return WorldGenSpawn.belowWater(world, pos);
            }
            case -3: {
                return pos.func_177981_b(world.field_73012_v.nextInt(32) + 8);
            }
            case -4: {
                return WorldGenSpawn.undergroundCave(world, pos);
            }
            case -5: {
                return pos.func_177981_b(2);
            }
        }
        return null;
    }

    private static BlockPos mountains(World world, BlockPos pos) {
        for (int y = Math.min(world.func_181545_F() + 64, world.func_72800_K() - 1); y > Math.min(world.func_181545_F() + 32, world.func_72800_K() - 1); --y) {
            if (!world.func_180495_p(pos.func_177981_b(y)).func_185914_p() || !world.func_180495_p(pos.func_177981_b(y + 1)).func_185904_a().func_76222_j()) continue;
            return pos.func_177981_b(y);
        }
        return null;
    }

    private static BlockPos testOne(World world, BlockPos pos) {
        int x4;
        int x3;
        int x2;
        int amortization = 3;
        int x1 = WorldGenSpawn.getY(world, pos.func_177965_g(2));
        if (Math.abs(x1 - (x2 = WorldGenSpawn.getY(world, pos.func_177970_e(2)))) < amortization && Math.abs(x1 - (x3 = WorldGenSpawn.getY(world, pos.func_177985_f(2)))) < amortization && Math.abs(x2 - x3) < amortization && Math.abs(x3 - (x4 = WorldGenSpawn.getY(world, pos.func_177964_d(2)))) < amortization) {
            int i = (x1 + x2 + x3 + x4) / 4;
            return i > world.func_181545_F() - 5 ? pos.func_177981_b(i) : null;
        }
        return null;
    }

    private static BlockPos testZero(World world, BlockPos pos) {
        int i = (WorldGenSpawn.getY(world, pos.func_177965_g(2)) + WorldGenSpawn.getY(world, pos.func_177970_e(2)) + WorldGenSpawn.getY(world, pos.func_177985_f(2)) + WorldGenSpawn.getY(world, pos.func_177964_d(2))) / 4;
        return i > world.func_181545_F() - 5 ? pos.func_177981_b(i) : null;
    }

    private static BlockPos testAqua(World world, BlockPos pos) {
        if (world.func_180495_p(pos = pos.func_177981_b(world.func_181545_F() - 1)).func_185904_a().func_76224_d() && world.func_175623_d(pos.func_177984_a())) {
            return pos;
        }
        return null;
    }

    private static BlockPos belowWater(World world, BlockPos pos) {
        for (int y = Math.max(world.func_181545_F() - 32, 0); y < Math.min(world.func_181545_F() - 5, world.func_72800_K() - 1); ++y) {
            if (!world.func_180495_p(pos.func_177981_b(y)).func_185914_p() || !world.func_180495_p(pos.func_177981_b(y + 1)).func_185904_a().func_76224_d()) continue;
            return pos.func_177981_b(y);
        }
        return null;
    }

    private static BlockPos undergroundCave(World world, BlockPos pos) {
        for (int y = 8; y < world.func_181545_F() - 16; ++y) {
            if (!world.func_180495_p(pos.func_177981_b(y)).func_185914_p() || !world.func_180495_p(pos.func_177981_b(y + 1)).func_185904_a().func_76222_j() || world.func_180495_p(pos.func_177981_b(y + 1)).func_185904_a().func_76224_d() || !world.func_180495_p(pos.func_177981_b(y + 2)).func_185904_a().func_76222_j()) continue;
            return pos.func_177981_b(y);
        }
        return null;
    }

    private static int getY(World world, BlockPos pos) {
        int down = world.func_181545_F() - 12;
        return WorldGenSpawn.getY(world, pos, world.func_181545_F() + 32, Math.max(down, 0));
    }

    private static int getY(World world, BlockPos pos, int top, int down) {
        for (int y = top; y > down; --y) {
            if (world.func_175623_d(pos.func_177981_b(y)) || !world.func_180495_p(pos.func_177981_b(y + 1)).func_185904_a().func_76222_j() || world.func_180495_p(pos.func_177981_b(y + 1)).func_185904_a().func_76224_d() || !world.func_175623_d(pos.func_177981_b(y + 2)) || !WorldGenSpawn.testBlock(world.func_180495_p(pos.func_177981_b(y)))) continue;
            return y;
        }
        return -999;
    }

    private static boolean testBlock(IBlockState state) {
        return state.func_185914_p() && state.func_185904_a() != Material.field_151584_j;
    }
}

