/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.util.Tuple;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.salju.supernatural.compat.Appleskin;
import net.salju.supernatural.init.SupernaturalBlocks;
import net.salju.supernatural.init.SupernaturalConfig;
import net.salju.supernatural.init.SupernaturalData;
import net.salju.supernatural.init.SupernaturalEffects;
import net.salju.supernatural.init.SupernaturalItems;
import net.salju.supernatural.init.SupernaturalMobs;
import net.salju.supernatural.init.SupernaturalSounds;
import net.salju.supernatural.init.SupernaturalTabs;

@Mod(value="supernatural")
public class Supernatural {
    public static final String MODID = "supernatural";
    private static final Collection<Tuple<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<Tuple<Runnable, Integer>>();

    public Supernatural(ModContainer mod, IEventBus bus) {
        NeoForge.EVENT_BUS.register((Object)this);
        SupernaturalData.REGISTRY.register(bus);
        SupernaturalSounds.REGISTRY.register(bus);
        SupernaturalBlocks.BE.register(bus);
        SupernaturalBlocks.REGISTRY.register(bus);
        SupernaturalBlocks.POI.register(bus);
        SupernaturalItems.REGISTRY.register(bus);
        SupernaturalTabs.REGISTRY.register(bus);
        SupernaturalMobs.REGISTRY.register(bus);
        SupernaturalEffects.REGISTRY.register(bus);
        mod.registerConfig(ModConfig.Type.COMMON, SupernaturalConfig.CONFIG, "supernatural-common.toml");
        if (FMLEnvironment.getDist().isClient() && ModList.get().isLoaded("appleskin")) {
            NeoForge.EVENT_BUS.register((Object)new Appleskin());
        }
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add((Tuple<Runnable, Integer>)new Tuple((Object)action, (Object)tick));
        }
    }

    @SubscribeEvent
    public void tick(ServerTickEvent.Post event) {
        ArrayList actions = new ArrayList();
        workQueue.forEach(work -> {
            work.setB((Object)((Integer)work.getB() - 1));
            if ((Integer)work.getB() == 0) {
                actions.add(work);
            }
        });
        actions.forEach(e -> ((Runnable)e.getA()).run());
        workQueue.removeAll(actions);
    }
}

