/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.client.model;

import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.entity.ArmorModelSet;
import net.salju.kobolds.client.model.KoboldArmorModel;

public class GothicKoboldArmorModel
extends HumanoidModel {
    public static ArmorModelSet<LayerDefinition> GOTHIC_KOBOLD_ARMOR_LAYER = GothicKoboldArmorModel.createArmorSet().map(mesh -> LayerDefinition.create((MeshDefinition)mesh, (int)64, (int)32));

    public GothicKoboldArmorModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createHeadLayer() {
        return (LayerDefinition)GOTHIC_KOBOLD_ARMOR_LAYER.head();
    }

    public static LayerDefinition createBodyLayer() {
        return (LayerDefinition)GOTHIC_KOBOLD_ARMOR_LAYER.chest();
    }

    public static LayerDefinition createLegsLayer() {
        return (LayerDefinition)GOTHIC_KOBOLD_ARMOR_LAYER.legs();
    }

    public static LayerDefinition createBootsLayer() {
        return (LayerDefinition)GOTHIC_KOBOLD_ARMOR_LAYER.feet();
    }

    public static ArmorModelSet<MeshDefinition> createArmorSet() {
        return KoboldArmorModel.createArmorSet(GothicKoboldArmorModel::createBaseArmor);
    }

    private static MeshDefinition createBaseArmor(CubeDeformation cube) {
        MeshDefinition mesh = KoboldArmorModel.createBaseArmor((CubeDeformation)cube);
        PartDefinition root = mesh.getRoot();
        root.getChild("head").clearChild("hat");
        root.getChild("head").addOrReplaceChild("front", CubeListBuilder.create().texOffs(32, 0).addBox(-4.0f, -7.5f, -7.0f, 8.0f, 8.0f, 8.0f, cube.extend(-0.25f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.48f, (float)0.0f, (float)0.0f));
        root.getChild("head").addOrReplaceChild("feather", CubeListBuilder.create().texOffs(25, -7).addBox(0.0f, -13.2f, 0.65f, 0.0f, 7.0f, 7.0f, cube), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        return mesh;
    }
}

