/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityReference;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;

public class AbstractMinionEntity
extends PathfinderMob {
    private static final EntityDataAccessor<Optional<EntityReference<LivingEntity>>> OWNER = SynchedEntityData.defineId(AbstractMinionEntity.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_LIVING_ENTITY_REFERENCE);

    public AbstractMinionEntity(EntityType<? extends AbstractMinionEntity> type, Level world) {
        super(type, world);
    }

    public void addAdditionalSaveData(ValueOutput tag) {
        super.addAdditionalSaveData(tag);
        if (this.getOwner() != null) {
            this.getOwner().store(tag, "Player");
        }
    }

    public void readAdditionalSaveData(ValueInput tag) {
        super.readAdditionalSaveData(tag);
        EntityReference target = EntityReference.readWithOldOwnerConversion((ValueInput)tag, (String)"Player", (Level)this.level());
        if (target != null) {
            try {
                this.entityData.set(OWNER, Optional.of(target));
            }
            catch (Throwable throwable) {}
        } else {
            this.entityData.set(OWNER, Optional.empty());
        }
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(OWNER, Optional.empty());
    }

    public void aiStep() {
        this.updateSwingTime();
        super.aiStep();
    }

    public void setOwner(@Nullable LivingEntity target) {
        this.entityData.set(OWNER, Optional.ofNullable(target).map(EntityReference::of));
    }

    public void setOwnerDirectly(@Nullable EntityReference<LivingEntity> target) {
        this.entityData.set(OWNER, Optional.ofNullable(target));
    }

    @Nullable
    public EntityReference<LivingEntity> getOwner() {
        return ((Optional)this.entityData.get(OWNER)).orElse(null);
    }

    public boolean isTamed() {
        return this.getOwner() != null;
    }
}

