/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.init;

import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.item.component.Consumables;
import net.minecraft.world.item.equipment.ArmorType;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.salju.supernatural.init.SupernaturalArmors;
import net.salju.supernatural.init.SupernaturalBlocks;
import net.salju.supernatural.init.SupernaturalMobs;
import net.salju.supernatural.item.AnchorballItem;
import net.salju.supernatural.item.AngelItem;
import net.salju.supernatural.item.BloodItem;
import net.salju.supernatural.item.ContractItem;
import net.salju.supernatural.item.RitualBookItem;
import net.salju.supernatural.item.RitualCompassItem;
import net.salju.supernatural.item.SoulgemItem;

public class SupernaturalItems {
    public static final Consumable BLOODY = Consumables.defaultDrink().consumeSeconds(2.0f).sound((Holder)SoundEvents.HONEY_DRINK).build();
    public static final DeferredRegister<Item> REGISTRY = DeferredRegister.createItems((String)"supernatural");
    public static final DeferredHolder<Item, Item> VAMPIRE_SPAWN_EGG = REGISTRY.register("vampire_spawn_egg", () -> new SpawnEggItem(SupernaturalItems.createBaseProps("vampire_spawn_egg").spawnEgg((EntityType)SupernaturalMobs.VAMPIRE.get())));
    public static final DeferredHolder<Item, Item> NECROMANCER_SPAWN_EGG = REGISTRY.register("necromancer_spawn_egg", () -> new SpawnEggItem(SupernaturalItems.createBaseProps("necromancer_spawn_egg").spawnEgg((EntityType)SupernaturalMobs.NECROMANCER.get())));
    public static final DeferredHolder<Item, Item> ARMOR_SPAWN_EGG = REGISTRY.register("armor_spawn_egg", () -> new SpawnEggItem(SupernaturalItems.createBaseProps("armor_spawn_egg").spawnEgg((EntityType)SupernaturalMobs.POSSESSED_ARMOR.get())));
    public static final DeferredHolder<Item, Item> SPOOKY_SPAWN_EGG = REGISTRY.register("spooky_spawn_egg", () -> new SpawnEggItem(SupernaturalItems.createBaseProps("spooky_spawn_egg").spawnEgg((EntityType)SupernaturalMobs.SPOOKY.get())));
    public static final DeferredHolder<Item, Item> GOTHIC_IRON_HELMET = REGISTRY.register("gothic_iron_helmet", () -> new Item(SupernaturalItems.createBaseProps("gothic_iron_helmet").durability(ArmorType.HELMET.getDurability(15)).humanoidArmor(SupernaturalArmors.IRON, ArmorType.HELMET)));
    public static final DeferredHolder<Item, Item> GOTHIC_DIAMOND_HELMET = REGISTRY.register("gothic_diamond_helmet", () -> new Item(SupernaturalItems.createBaseProps("gothic_diamond_helmet").durability(ArmorType.HELMET.getDurability(33)).humanoidArmor(SupernaturalArmors.DIAMOND, ArmorType.HELMET)));
    public static final DeferredHolder<Item, Item> GOTHIC_GOLDEN_HELMET = REGISTRY.register("gothic_golden_helmet", () -> new Item(SupernaturalItems.createBaseProps("gothic_golden_helmet").durability(ArmorType.HELMET.getDurability(7)).humanoidArmor(SupernaturalArmors.GOLDEN, ArmorType.HELMET)));
    public static final DeferredHolder<Item, Item> GOTHIC_NETHERITE_HELMET = REGISTRY.register("gothic_netherite_helmet", () -> new Item(SupernaturalItems.createBaseProps("gothic_netherite_helmet").fireResistant().durability(ArmorType.HELMET.getDurability(37)).humanoidArmor(SupernaturalArmors.NETHERITE, ArmorType.HELMET)));
    public static final DeferredHolder<Item, Item> GRAVE_SOIL = SupernaturalItems.block(SupernaturalBlocks.GRAVE_SOIL, "grave_soil");
    public static final DeferredHolder<Item, Item> RITUAL_ALTAR = SupernaturalItems.block(SupernaturalBlocks.RITUAL_ALTAR, "ritual_altar");
    public static final DeferredHolder<Item, Item> CONTRACT = REGISTRY.register("contract", () -> new ContractItem(SupernaturalItems.createBaseProps("contract").stacksTo(1).rarity(Rarity.UNCOMMON).fireResistant()));
    public static final DeferredHolder<Item, Item> RITUAL_BOOK = REGISTRY.register("ritual_book", () -> new RitualBookItem(SupernaturalItems.createBaseProps("ritual_book").stacksTo(1).rarity(Rarity.UNCOMMON).fireResistant()));
    public static final DeferredHolder<Item, Item> VAMPIRE_DUST = REGISTRY.register("vampire_dust", () -> new Item(SupernaturalItems.createBaseProps("vampire_dust")));
    public static final DeferredHolder<Item, Item> ANGEL_STATUE = REGISTRY.register("angel_statue", () -> new AngelItem(SupernaturalItems.createBaseProps("angel_statue").stacksTo(1).rarity(Rarity.UNCOMMON)));
    public static final DeferredHolder<Item, Item> SOULGEM = REGISTRY.register("soulgem", () -> new SoulgemItem(SupernaturalItems.createBaseProps("soulgem").stacksTo(1).rarity(Rarity.UNCOMMON).fireResistant()));
    public static final DeferredHolder<Item, Item> COMPASS = REGISTRY.register("ritual_compass", () -> new RitualCompassItem(SupernaturalItems.createBaseProps("ritual_compass").stacksTo(1).rarity(Rarity.UNCOMMON).fireResistant()));
    public static final DeferredHolder<Item, Item> ANCHORBALL = REGISTRY.register("anchorball", () -> new AnchorballItem(SupernaturalItems.createBaseProps("anchorball").stacksTo(1).rarity(Rarity.UNCOMMON).fireResistant()));
    public static final DeferredHolder<Item, Item> BLOOD = REGISTRY.register("blood_bottle", () -> new BloodItem(SupernaturalItems.createBaseProps("blood_bottle").stacksTo(16).component(DataComponents.CONSUMABLE, (Object)BLOODY).craftRemainder(Items.GLASS_BOTTLE).usingConvertsTo(Items.GLASS_BOTTLE)));

    private static DeferredHolder<Item, Item> block(DeferredHolder<Block, Block> block, String name) {
        return REGISTRY.register(block.getId().getPath(), () -> new BlockItem((Block)block.get(), SupernaturalItems.createBaseProps(name)));
    }

    public static Item.Properties createBaseProps(String name) {
        return new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"supernatural", (String)name)));
    }
}

