/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;

public abstract class AbstractSpellcasterEntity
extends Monster {
    public static final EntityDataAccessor<Integer> SPELL_TICK = SynchedEntityData.defineId(AbstractSpellcasterEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);

    public AbstractSpellcasterEntity(EntityType<? extends AbstractSpellcasterEntity> type, Level world) {
        super(type, world);
    }

    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putInt("SpellTick", this.getSpellTick());
    }

    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSpellTick(tag.getInt("SpellTick"));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPELL_TICK, (Object)0);
    }

    public void baseTick() {
        super.baseTick();
        if (this.getSpellTick() > 0) {
            this.setSpellTick(this.getSpellTick() - 1);
        }
    }

    public void setSpellTick(int i) {
        this.getEntityData().set(SPELL_TICK, (Object)i);
    }

    public void applySpellEffects(double x, double y, double z) {
        if (this.level().isClientSide()) {
            this.level().addParticle((ParticleOptions)ColorParticleOption.create((ParticleType)ParticleTypes.ENTITY_EFFECT, (int)this.getSpellColor()), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public boolean isCastingSpell() {
        return this.getSpellTick() > 0;
    }

    public int getSpellTick() {
        return (Integer)this.getEntityData().get(SPELL_TICK);
    }

    public abstract SoundEvent getCastingSoundEvent();

    public abstract int getSpellColor();
}

