/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomFlyingGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.level.Level;
import net.salju.supernatural.entity.AbstractMinionEntity;
import net.salju.supernatural.entity.ai.spells.AbstractSpellcasterGoal;
import net.salju.supernatural.entity.ai.spells.spooky.SpookyPossessionSpellGoal;
import net.salju.supernatural.entity.ai.targets.SpookyAttackSelector;
import net.salju.supernatural.events.SupernaturalManager;
import net.salju.supernatural.init.SupernaturalEffects;
import net.salju.supernatural.init.SupernaturalSounds;

public class Spooky
extends AbstractMinionEntity {
    public Spooky(EntityType<Spooky> type, Level world) {
        super((EntityType<? extends AbstractMinionEntity>)type, world);
        this.moveControl = new FlyingMoveControl((Mob)this, 20, true);
    }

    protected PathNavigation createNavigation(Level lvl) {
        return new FlyingPathNavigation((Mob)this, lvl);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new AbstractSpellcasterGoal((Mob)this));
        this.goalSelector.addGoal(1, (Goal)new SpookyPossessionSpellGoal(this));
        this.goalSelector.addGoal(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.goalSelector.addGoal(4, (Goal)new WaterAvoidingRandomFlyingGoal((PathfinderMob)this, 1.2));
        this.goalSelector.addGoal(5, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.targetSelector.addGoal(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.targetSelector.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, LivingEntity.class, 12, true, true, (Predicate)new SpookyAttackSelector(this)));
    }

    public SoundEvent getAmbientSound() {
        return SoundEvents.VEX_AMBIENT;
    }

    public SoundEvent getHurtSound(DamageSource source) {
        return SoundEvents.VEX_HURT;
    }

    public SoundEvent getDeathSound() {
        return SoundEvents.VEX_DEATH;
    }

    @Override
    public SoundEvent getCastingSoundEvent() {
        return SoundEvents.ILLUSIONER_CAST_SPELL;
    }

    public void aiStep() {
        super.aiStep();
        this.setNoGravity(true);
    }

    @Override
    public void baseTick() {
        super.baseTick();
        if (this.isAlive()) {
            Level level;
            if (this.getTarget() != null && this.getTarget().isAlive()) {
                if (this.getTarget().hasEffect(MobEffects.GLOWING) || this.getTarget().hasEffect(SupernaturalEffects.POSSESSION)) {
                    this.setTarget(null);
                } else if (this.getTarget() instanceof ArmorStand && !SupernaturalManager.hasArmor(this.getTarget())) {
                    this.setTarget(null);
                }
            }
            if (this.isCastingSpell()) {
                this.applySpellEffects(this.getX(), this.getY() + 0.35, this.getZ());
            }
            if ((level = this.level()) instanceof ServerLevel) {
                ServerLevel lvl = (ServerLevel)level;
                if (!this.isTamed() && this.level().isDay() && this.level().canSeeSkyFromBelowWater(BlockPos.containing((double)this.getX(), (double)this.getY(), (double)this.getZ()))) {
                    this.playSound((SoundEvent)SupernaturalSounds.SPOOK_POOF.get(), 1.0f, 1.0f);
                    this.discard();
                    double r = this.random.nextGaussian() * 0.02;
                    lvl.sendParticles((ParticleOptions)ParticleTypes.POOF, this.getRandomX(1.0), this.getRandomY(), this.getRandomZ(1.0), 10, r, r, r, 0.25);
                }
            }
        }
    }

    public void setNoGravity(boolean check) {
        super.setNoGravity(true);
    }

    public boolean causeFallDamage(float l, float d, DamageSource source) {
        return false;
    }

    @Override
    public int getSpellColor() {
        return -6697729;
    }

    protected float getSoundVolume() {
        return 0.35f;
    }
}

