/*
 * Decompiled with CFR 0.152.
 */
package net.salju.supernatural.entity.ai.spells.vampire;

import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.monster.Skeleton;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.salju.supernatural.Supernatural;
import net.salju.supernatural.entity.Necromancer;
import net.salju.supernatural.entity.Vampire;
import net.salju.supernatural.entity.ai.MinionTargetGoal;
import net.salju.supernatural.entity.ai.spells.AbstractSpellGoal;
import net.salju.supernatural.init.SupernaturalMobs;

public class NecromancerBoltSpellGoal
extends AbstractSpellGoal {
    public NecromancerBoltSpellGoal(Necromancer source) {
        super((Mob)source);
    }

    @Override
    protected void performSpellCasting() {
        LivingEntity target = this.user.getTarget();
        double x = target.getX();
        double y = target.getY();
        double z = target.getZ();
        BlockPos pos = BlockPos.containing((double)(x + 0.5), (double)y, (double)(z + 0.5));
        Level level = target.level();
        if (level instanceof ServerLevel) {
            ServerLevel lvl = (ServerLevel)level;
            Supernatural.queueServerWork(25, () -> {
                LightningBolt bolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create((Level)lvl);
                if (bolt != null) {
                    bolt.moveTo((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
                    if (target.getX() == x && target.getY() == y && target.getZ() == z) {
                        bolt.setDamage(12.0f);
                        lvl.addFreshEntity((Entity)bolt);
                    } else {
                        bolt.setVisualOnly(true);
                        lvl.addFreshEntity((Entity)bolt);
                        for (int bob = 0; bob < 2; ++bob) {
                            if (Math.random() <= 0.99) {
                                if (Math.random() <= 0.5) {
                                    Skeleton skele = (Skeleton)EntityType.SKELETON.spawn(lvl, pos, MobSpawnType.MOB_SUMMONED);
                                    if (skele == null) continue;
                                    skele.targetSelector.addGoal(1, (Goal)new MinionTargetGoal((PathfinderMob)skele, (LivingEntity)this.user));
                                    continue;
                                }
                                Zombie billy = (Zombie)EntityType.ZOMBIE.spawn(lvl, pos, MobSpawnType.MOB_SUMMONED);
                                if (billy == null) continue;
                                billy.targetSelector.addGoal(1, (Goal)new MinionTargetGoal((PathfinderMob)billy, (LivingEntity)this.user));
                                continue;
                            }
                            Vampire vampire = (Vampire)((EntityType)SupernaturalMobs.VAMPIRE.get()).spawn(lvl, pos, MobSpawnType.MOB_SUMMONED);
                            if (vampire == null) continue;
                            vampire.setCustomName((Component)Component.literal((String)"Bob"));
                        }
                    }
                }
            });
        }
    }

    @Override
    protected int getCastingTime() {
        return 40;
    }

    @Override
    protected int getCastingInterval() {
        return 420;
    }

    @Override
    protected int getSpell() {
        return 2;
    }

    @Override
    protected SoundEvent getSpellPrepareSound() {
        return SoundEvents.EVOKER_PREPARE_ATTACK;
    }
}

