/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary;

import com.araxer.araxers_bestiary.client.BestiaryCommandClient;
import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.EntityDataProvider;
import com.araxer.araxers_bestiary.data.GlobalPlayerProgressionData;
import com.araxer.araxers_bestiary.data.PlayerProgressionData;
import com.araxer.araxers_bestiary.data.RankUtils;
import com.araxer.araxers_bestiary.network.CommonPacketHandler;
import com.araxer.araxers_bestiary.network.ForgeNetwork;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.netty.buffer.Unpooled;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BestiaryCommand {
    private static final SuggestionProvider<CommandSourceStack> SUGGEST_ENTITY_TYPES = (context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)ForgeRegistries.ENTITY_TYPES.getKeys(), (SuggestionsBuilder)builder);

    @SubscribeEvent
    public static void onRegisterCommands(RegisterCommandsEvent event) {
        event.getDispatcher().register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)"bestiary").requires(source -> source.m_6761_(2))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> BestiaryCommandClient.openBestiaryScreen(player.m_20148_()));
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Opening Bestiary..."), false);
            return 1;
        })).then(Commands.m_82127_((String)"regenerate").executes(context -> {
            ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
            if (serverLevel == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to access server level."));
                return 0;
            }
            EntityDataProvider.clearCache();
            EntityDataProvider.getMonsterEntries((Level)serverLevel);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)"Bestiary cache regenerated."), true);
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"simulate").executes(context -> {
            ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
            if (serverLevel == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to access server level."));
                return 0;
            }
            EntityDataProvider.schedulePrewarm(serverLevel.m_7654_());
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Scheduled bestiary prewarm with tick budget: " + Config.prewarmMaxEntitiesPerTick)), true);
            return 1;
        })).then(Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).executes(context -> {
            ServerLevel serverLevel = ((CommandSourceStack)context.getSource()).m_81372_();
            if (serverLevel == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)"Failed to access server level."));
                return 0;
            }
            ResourceLocation rl = ResourceLocationArgument.m_107011_((CommandContext)context, (String)"entityType");
            EntityType et = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(rl);
            if (et == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(rl))));
                return 0;
            }
            EntityDataProvider.enqueueLazyBatchGeneration(serverLevel, et);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Queued lazy simulation for entity: " + String.valueOf(rl))), true);
            return 1;
        })))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rank").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"increase").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).executes(context -> BestiaryCommand.executeIncreaseRank((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82127_((String)"true").executes(context -> BestiaryCommand.executeIncreaseRank((CommandContext<CommandSourceStack>)context, true)))).then(Commands.m_82127_((String)"false").executes(context -> BestiaryCommand.executeIncreaseRank((CommandContext<CommandSourceStack>)context, false))))))).then(Commands.m_82127_((String)"roll").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).executes(context -> BestiaryCommand.executeRollRank((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82127_((String)"true").executes(context -> BestiaryCommand.executeRollRank((CommandContext<CommandSourceStack>)context, true)))).then(Commands.m_82127_((String)"false").executes(context -> BestiaryCommand.executeRollRank((CommandContext<CommandSourceStack>)context, false))))))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"rank", (ArgumentType)StringArgumentType.word()).executes(context -> BestiaryCommand.executeSetRank((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82127_((String)"true").executes(context -> BestiaryCommand.executeSetRank((CommandContext<CommandSourceStack>)context, true)))).then(Commands.m_82127_((String)"false").executes(context -> BestiaryCommand.executeSetRank((CommandContext<CommandSourceStack>)context, false)))))))).then(Commands.m_82127_((String)"reset").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).executes(context -> BestiaryCommand.executeResetRank((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82127_((String)"true").executes(context -> BestiaryCommand.executeResetRank((CommandContext<CommandSourceStack>)context, true)))).then(Commands.m_82127_((String)"false").executes(context -> BestiaryCommand.executeResetRank((CommandContext<CommandSourceStack>)context, false))))))).then(Commands.m_82127_((String)"get").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).executes(context -> BestiaryCommand.executeGetRank((CommandContext<CommandSourceStack>)context)))))).then(Commands.m_82127_((String)"meets").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).then(Commands.m_82129_((String)"threshold", (ArgumentType)StringArgumentType.word()).executes(context -> BestiaryCommand.executeMeetsRank((CommandContext<CommandSourceStack>)context)))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"observed").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).executes(context -> BestiaryCommand.executeSetSighted((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82127_((String)"true").executes(context -> BestiaryCommand.executeSetSighted((CommandContext<CommandSourceStack>)context, true)))).then(Commands.m_82127_((String)"false").executes(context -> BestiaryCommand.executeSetSighted((CommandContext<CommandSourceStack>)context, false))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).executes(context -> BestiaryCommand.executeRemoveSighted((CommandContext<CommandSourceStack>)context, false))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"discovered").requires(source -> source.m_6761_(2))).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).executes(context -> BestiaryCommand.executeSetDiscovered((CommandContext<CommandSourceStack>)context, false))).then(Commands.m_82127_((String)"true").executes(context -> BestiaryCommand.executeSetDiscovered((CommandContext<CommandSourceStack>)context, true)))).then(Commands.m_82127_((String)"false").executes(context -> BestiaryCommand.executeSetDiscovered((CommandContext<CommandSourceStack>)context, false))))))).then(Commands.m_82127_((String)"remove").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"entityType", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(SUGGEST_ENTITY_TYPES).executes(context -> BestiaryCommand.executeRemoveDiscovered((CommandContext<CommandSourceStack>)context)))))));
    }

    private static int executeIncreaseRank(CommandContext<CommandSourceStack> context, boolean showToast) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData progressData = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            String currentRank = progressData.getRank(player.m_20148_(), entityType);
            String nextRank = RankUtils.getNextRank(currentRank);
            if (nextRank.equals(currentRank) && !currentRank.equals("")) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Entity " + String.valueOf(entityId) + " is already at maximum rank " + currentRank + " for player " + player.m_7755_().getString())), true);
                return 1;
            }
            progressData.setRank(player.m_20148_(), entityType, nextRank);
            if (currentRank.equals("") && !nextRank.equals("")) {
                progressData.markAsNewlyDiscovered(player.m_20148_(), entityType);
            }
            int killCount = progressData.getKillCount(player.m_20148_(), entityType);
            if (showToast) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                buf.writeInt(-1);
                buf.m_130070_(currentRank);
                buf.m_130070_(nextRank);
                ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, nextRank);
            } else {
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, nextRank);
            }
            String baseMessage = currentRank.equals("") ? "Entity " + String.valueOf(entityId) + " has been discovered with rank " + nextRank + " for player " + player.m_7755_().getString() : "Entity " + String.valueOf(entityId) + " rank increased from " + currentRank + " to " + nextRank + " for player " + player.m_7755_().getString();
            String toastInfo = showToast ? " (with toast notification)" : " (without toast notification)";
            String finalMessage = baseMessage + toastInfo;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)finalMessage), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeRollRank(CommandContext<CommandSourceStack> context, boolean showToast) {
        try {
            boolean isSpyglassObserved;
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData progressData = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            String currentRank = progressData.getRank(player.m_20148_(), entityType);
            String rolledRank = RankUtils.tryIncreaseRank(currentRank, Config.commandRolls, null, isSpyglassObserved = progressData.isSpyglassObserved(player.m_20148_(), entityType), true);
            if (rolledRank.equals(currentRank)) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Entity " + String.valueOf(entityId) + " rank roll resulted in no change for player " + player.m_7755_().getString())), true);
                return 1;
            }
            PlayerProgressionData data = progressData;
            if (!"X".equals(rolledRank)) {
                data.clearRankXForEntity(player.m_20148_(), entityType);
            }
            data.setRank(player.m_20148_(), entityType, rolledRank);
            if (currentRank.equals("") && !rolledRank.equals("")) {
                data.markAsNewlyDiscovered(player.m_20148_(), entityType);
            }
            int killCount = progressData.getKillCount(player.m_20148_(), entityType);
            if (showToast) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                buf.writeInt(-1);
                buf.m_130070_(currentRank);
                buf.m_130070_(rolledRank);
                ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, rolledRank);
            } else {
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, rolledRank);
            }
            String baseMessage = currentRank.equals("") ? "Entity " + String.valueOf(entityId) + " has been discovered with rolled rank " + rolledRank + " for player " + player.m_7755_().getString() : "Entity " + String.valueOf(entityId) + " rank rolled from " + currentRank + " to " + rolledRank + " for player " + player.m_7755_().getString();
            String toastInfo = showToast ? " (with toast notification)" : " (without toast notification)";
            String finalMessage = baseMessage + toastInfo;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)finalMessage), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeSetRank(CommandContext<CommandSourceStack> context, boolean showToast) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            String newRank = StringArgumentType.getString(context, (String)"rank");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            if (!RankUtils.isValidRank(newRank)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid rank: " + newRank + ". Valid ranks are: " + String.join((CharSequence)", ", RankUtils.RANKS) + " or empty string for no rank.")));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData progressData = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            String currentRank = progressData.getRank(player.m_20148_(), entityType);
            if (newRank.equals(currentRank)) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Entity " + String.valueOf(entityId) + " already has rank " + currentRank + " for player " + player.m_7755_().getString())), true);
                return 1;
            }
            PlayerProgressionData data = progressData;
            if (!"X".equals(newRank)) {
                data.clearRankXForEntity(player.m_20148_(), entityType);
            }
            data.setRank(player.m_20148_(), entityType, newRank);
            if (currentRank.equals("") && !newRank.equals("")) {
                data.markAsNewlyDiscovered(player.m_20148_(), entityType);
            }
            int killCount = progressData.getKillCount(player.m_20148_(), entityType);
            if (showToast) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                buf.writeInt(-1);
                buf.m_130070_(currentRank);
                buf.m_130070_(newRank);
                ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, newRank);
            } else {
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, newRank);
            }
            String baseMessage = currentRank.equals("") ? "Entity " + String.valueOf(entityId) + " has been discovered with rank set to " + newRank + " for player " + player.m_7755_().getString() : "Entity " + String.valueOf(entityId) + " rank changed from " + currentRank + " to " + newRank + " for player " + player.m_7755_().getString();
            String toastInfo = showToast ? " (with toast notification)" : " (without toast notification)";
            String finalMessage = baseMessage + toastInfo;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)finalMessage), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeResetRank(CommandContext<CommandSourceStack> context, boolean showToast) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData progressData = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            String currentRank = progressData.getRank(player.m_20148_(), entityType);
            String newRank = "";
            PlayerProgressionData data = progressData;
            data.clearRankXForEntity(player.m_20148_(), entityType);
            data.setRank(player.m_20148_(), entityType, newRank);
            int killCount = progressData.getKillCount(player.m_20148_(), entityType);
            if (showToast) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                buf.writeInt(-1);
                buf.m_130070_(currentRank);
                buf.m_130070_(newRank);
                ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, newRank);
            } else {
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, newRank);
            }
            String finalMessage = "Entity " + String.valueOf(entityId) + " rank reset from " + (currentRank.isEmpty() ? "<none>" : currentRank) + " to <none> for player " + player.m_7755_().getString();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)finalMessage), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeSetSighted(CommandContext<CommandSourceStack> context, boolean showToast) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData progressData = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            boolean alreadySighted = progressData.isSpyglassObserved(player.m_20148_(), entityType);
            if (alreadySighted) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Entity " + String.valueOf(entityId) + " is already marked as observed for player " + player.m_7755_().getString())), true);
                return 1;
            }
            progressData.markAsSpyglassObserved(player.m_20148_(), entityType);
            int killCount = progressData.getKillCount(player.m_20148_(), entityType);
            String rank = progressData.getRank(player.m_20148_(), entityType);
            if (showToast) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                buf.writeInt(2);
                ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, rank);
            } else {
                progressData.sendProgressionUpdatePacket(player, entityType, killCount, rank);
            }
            String baseMessage = "Entity " + String.valueOf(entityId) + " has been marked as observed for player " + player.m_7755_().getString();
            String toastInfo = showToast ? " (with toast notification)" : " (without toast notification)";
            String finalMessage = baseMessage + toastInfo;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)finalMessage), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeRemoveSighted(CommandContext<CommandSourceStack> context, boolean showToast) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData progressData = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            boolean isSighted = progressData.isSpyglassObserved(player.m_20148_(), entityType);
            if (!isSighted) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)("Entity " + String.valueOf(entityId) + " is already not marked as observed for player " + player.m_7755_().getString())), true);
                return 1;
            }
            progressData.removeSpyglassObserved(player.m_20148_(), entityType);
            int killCount = progressData.getKillCount(player.m_20148_(), entityType);
            String rank = progressData.getRank(player.m_20148_(), entityType);
            progressData.sendProgressionUpdatePacket(player, entityType, killCount, rank);
            String finalMessage = "Entity " + String.valueOf(entityId) + " observed status has been removed for player " + player.m_7755_().getString();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)finalMessage), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeSetDiscovered(CommandContext<CommandSourceStack> context, boolean showToast) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData progressData = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            progressData.markAsNewlyDiscovered(player.m_20148_(), entityType);
            int killCount = progressData.getKillCount(player.m_20148_(), entityType);
            String rank = progressData.getRank(player.m_20148_(), entityType);
            if (showToast) {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
                buf.m_130085_(ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType));
                buf.writeInt(1);
                ForgeNetwork.sendToClient(player, CommonPacketHandler.PROGRESSION_TOAST_CHANNEL, buf);
            }
            progressData.sendProgressionUpdatePacket(player, entityType, killCount, rank);
            String toastInfo = showToast ? " (with toast notification)" : " (without toast notification)";
            String finalMessage = "Entity " + String.valueOf(entityId) + " has been marked as discovered for player " + player.m_7755_().getString() + toastInfo;
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)finalMessage), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeRemoveDiscovered(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData progressData = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            progressData.markAsViewed(player.m_20148_(), entityType);
            int killCount = progressData.getKillCount(player.m_20148_(), entityType);
            String rank = progressData.getRank(player.m_20148_(), entityType);
            progressData.sendProgressionUpdatePacket(player, entityType, killCount, rank);
            String finalMessage = "Entity " + String.valueOf(entityId) + " discovered status has been removed for player " + player.m_7755_().getString();
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237113_((String)finalMessage), true);
            return 1;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }

    private static int rankToCode(String rank) {
        if (rank == null || rank.equals("") || !RankUtils.isValidRank(rank)) {
            return 0;
        }
        switch (rank) {
            case "E": {
                return 1;
            }
            case "D": {
                return 2;
            }
            case "C": {
                return 3;
            }
            case "B": {
                return 4;
            }
            case "A": {
                return 5;
            }
            case "S": {
                return 6;
            }
            case "X": {
                return 7;
            }
        }
        return 0;
    }

    private static int executeGetRank(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData data = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            String rank = data.getRank(player.m_20148_(), entityType);
            int code = BestiaryCommand.rankToCode(rank);
            return code;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }

    private static int executeMeetsRank(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(context, (String)"player");
            ResourceLocation entityId = ResourceLocationArgument.m_107011_(context, (String)"entityType");
            EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityId);
            if (entityType == null) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Unknown entity type: " + String.valueOf(entityId))));
                return 0;
            }
            String threshold = StringArgumentType.getString(context, (String)"threshold");
            if (!RankUtils.isValidRank(threshold) || "".equals(threshold)) {
                ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Invalid threshold: " + threshold + ". Use one of E, D, C, B, A, S, X.")));
                return 0;
            }
            ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
            PlayerProgressionData data = GlobalPlayerProgressionData.get(level.m_7654_()).data();
            String rank = data.getRank(player.m_20148_(), entityType);
            boolean ok = RankUtils.meetsRankThreshold(rank, threshold);
            return ok ? 1 : 0;
        }
        catch (Exception e) {
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237113_((String)("Error executing command: " + e.getMessage())));
            return 0;
        }
    }
}

