/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.api;

import com.araxer.araxers_bestiary.api.BestiaryCapabilities;
import com.araxer.araxers_bestiary.api.IBestiaryProgress;
import com.araxer.araxers_bestiary.data.GlobalPlayerProgressionData;
import com.araxer.araxers_bestiary.data.PlayerProgressionData;
import com.araxer.araxers_bestiary.data.RankUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class BestiaryProgressProvider
implements ICapabilityProvider {
    private final ServerPlayer player;
    private final LazyOptional<IBestiaryProgress> lazy = LazyOptional.of(this::createImpl);

    public BestiaryProgressProvider(ServerPlayer player) {
        this.player = player;
    }

    private IBestiaryProgress createImpl() {
        return new IBestiaryProgress(){

            private PlayerProgressionData data() {
                return GlobalPlayerProgressionData.get(BestiaryProgressProvider.this.player.m_20194_()).data();
            }

            @Override
            public String getRank(EntityType<?> entityType) {
                return this.data().getRank(BestiaryProgressProvider.this.player.m_20148_(), entityType);
            }

            @Override
            public int getRankCode(EntityType<?> entityType) {
                String r = this.getRank(entityType);
                if (r == null || r.equals("")) {
                    return 0;
                }
                int idx = RankUtils.getRankIndex(r);
                return idx < 0 ? 0 : idx + 1;
            }

            @Override
            public boolean meets(EntityType<?> entityType, String threshold) {
                String r = this.getRank(entityType);
                if (!RankUtils.isValidRank(threshold) || "".equals(threshold)) {
                    return false;
                }
                return RankUtils.meetsRankThreshold(r, threshold);
            }

            @Override
            public boolean isObserved(EntityType<?> entityType) {
                return this.data().isSpyglassObserved(BestiaryProgressProvider.this.player.m_20148_(), entityType);
            }

            @Override
            public boolean isDiscovered(EntityType<?> entityType) {
                return this.data().isNewlyDiscovered(BestiaryProgressProvider.this.player.m_20148_(), entityType);
            }
        };
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        return cap == BestiaryCapabilities.BESTIARY ? this.lazy.cast() : LazyOptional.empty();
    }
}

