/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client.gui;

import com.araxer.araxers_bestiary.client.ClientProgressionData;
import com.araxer.araxers_bestiary.client.KeyBindings;
import com.araxer.araxers_bestiary.client.PacketHandler;
import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.BestiaryAttributeManager;
import com.araxer.araxers_bestiary.data.EntityAttributes;
import com.araxer.araxers_bestiary.data.EntityDataProvider;
import com.araxer.araxers_bestiary.data.LootItemEntry;
import com.araxer.araxers_bestiary.data.MonsterEntry;
import com.araxer.araxers_bestiary.data.ProgressiveEntityData;
import com.araxer.araxers_bestiary.data.RankUtils;
import com.araxer.araxers_bestiary.data.RankXConfig;
import com.araxer.araxers_bestiary.data.SpawnLocationInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import com.mojang.math.Axis;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@OnlyIn(value=Dist.CLIENT)
public class BestiaryScreen
extends Screen {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ResourceLocation TEXTURE = ResourceLocation.m_135820_((String)"araxers_bestiary:textures/gui/bestiary.png");
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.m_135820_((String)"araxers_bestiary:textures/gui/bestiary_background.png");
    private static String currentGlobalRankBarType = null;
    private static final ResourceLocation VANILLA_VILLAGER2_TEX = ResourceLocation.m_135820_((String)"minecraft:textures/gui/container/villager2.png");
    private static final int VANILLA_TEX_WIDTH = 512;
    private static final int VANILLA_TEX_HEIGHT = 256;
    private static final int VANILLA_BAR_U = 0;
    private static final int VANILLA_BAR_V_BG = 186;
    private static final int VANILLA_BAR_V_FG = 191;
    private static final ResourceLocation MOD_BESTIARY_TEX = TEXTURE;
    private static final int MOD_TEX_WIDTH = 512;
    private static final int MOD_TEX_HEIGHT = 512;
    private static final int MOD_BAR_U = 220;
    private static final int MOD_BAR_V_BG = 200;
    private static final int MOD_BAR_V_FG = 205;
    private static final int VILLAGER_BAR_WIDTH = 102;
    private static final int VILLAGER_BAR_HEIGHT = 5;
    private static final int TEXTURE_WIDTH = 512;
    private static final int TEXTURE_HEIGHT = 512;
    private static final int LOOT_SLOT_BG_U = 200;
    private static final int LOOT_SLOT_BG_V = 200;
    private static final int LOOT_SLOT_BG_SIZE = 20;
    private int benefitChipScrollPx = 0;
    private int benefitChipsAreaX = 0;
    private int benefitChipsAreaY = 0;
    private int benefitChipsAreaW = 0;
    private int benefitChipsAreaH = 0;
    private int benefitChipSizeUsed = 16;
    private int benefitChipsMaxOffset = 0;
    private boolean benefitChipsScrollable = false;
    private final List<int[]> benefitChipRects = new ArrayList<int[]>();
    private static final int SPAWN_LOC_BG_U = 0;
    private static final int SPAWN_LOC_BG_V = 320;
    private static final int SPAWN_LOC_BG_WIDTH = 170;
    private static final int SPAWN_LOC_BG_HEIGHT = 24;
    private static final int SPAWN_LOC_SCROLL_THRESHOLD = 138;
    private static final int SPAWN_LOC_SCROLL_GAP = 24;
    private static final float SPAWN_LOC_SCROLL_SPEED = 7.0f;
    private static final int PANEL_WIDTH = 170;
    private static final int PANEL_HEIGHT = 256;
    private static final int ENTITY_VIEW_SIZE = 150;
    private static final int ITEM_SIZE = 16;
    private static final int ITEM_SPACING = 35;
    private int scaledItemSpacing;
    private List<MonsterEntry> monsters = new ArrayList<MonsterEntry>();
    private List<MonsterEntry> filteredMonsters = new ArrayList<MonsterEntry>();
    private Map<EntityType<?>, Integer> killCounts = new HashMap();
    private Button switchUiButton;
    private Button categoryToggleButton;
    private EditBox searchBox;
    private MonsterListWidget monsterList;
    private EntityViewWidget entityView;
    private InfoPanel infoPanel;
    private Button rankXToggleButton;
    private Button variantPrevButton;
    private Button variantNextButton;
    private Button hideUnseenButton;
    private static boolean HIDE_UNSEEN_TOGGLED = false;
    private Button listTextModeButton;
    private static ListTextMode listTextMode = null;
    private boolean tabStylesDirty = true;
    private String cachedMonsterCountText = "";
    private int cachedFilteredCount = -1;
    private static List<String> CATEGORY_TOKENS = new ArrayList<String>();
    private static List<Component> CATEGORY_LABELS = new ArrayList<Component>();
    private static final Set<String> DYNAMIC_CATEGORY_TOKENS = new LinkedHashSet<String>();
    private static int activeCategoryIndex = -1;
    private boolean categoryMarqueeActive = false;
    private String categoryFullLabel = "";
    private String categoryMarqueeBase = "";
    private int categoryMarqueeIndex = 0;
    private long categoryMarqueeLastUpdate = 0L;
    private static final long CATEGORY_MARQUEE_INTERVAL_MS = 180L;
    private Button lootButton;
    private Button locationsButton;
    private Button attributesButton;
    private TabType currentTab = TabType.ATTRIBUTES;
    private MonsterEntry selectedMonster = null;
    private boolean openSoundPlayed = false;
    private float newTextBounceOffset = 0.0f;
    private float newTextRotation = 0.0f;
    private long lastUpdateTime = 0L;

    private static boolean useVanillaBar() {
        String s = Config.progressBarSpriteSource;
        return s == null || !"mod".equalsIgnoreCase(s);
    }

    private static ResourceLocation currentBarTexture() {
        return BestiaryScreen.useVanillaBar() ? VANILLA_VILLAGER2_TEX : MOD_BESTIARY_TEX;
    }

    private static int currentTexWidth() {
        return BestiaryScreen.useVanillaBar() ? 512 : 512;
    }

    private static int currentTexHeight() {
        return BestiaryScreen.useVanillaBar() ? 256 : 512;
    }

    private static int currentBarU() {
        return BestiaryScreen.useVanillaBar() ? 0 : 220;
    }

    private static int currentBarVBg() {
        return BestiaryScreen.useVanillaBar() ? 186 : 200;
    }

    private static int currentBarVfg() {
        return BestiaryScreen.useVanillaBar() ? 191 : 205;
    }

    private void ensureBaseCategoriesInitialized() {
        if (!CATEGORY_TOKENS.isEmpty() && !CATEGORY_LABELS.isEmpty()) {
            return;
        }
        CATEGORY_TOKENS.clear();
        CATEGORY_LABELS.clear();
        DYNAMIC_CATEGORY_TOKENS.clear();
        CATEGORY_TOKENS.add("new");
        CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.new"));
        CATEGORY_TOKENS.add("sighted");
        CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.sighted"));
        CATEGORY_TOKENS.add("discovered");
        CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.discovered"));
        CATEGORY_TOKENS.add("boss");
        CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.boss"));
        CATEGORY_TOKENS.add("monster");
        CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.monster"));
        CATEGORY_TOKENS.add("creature");
        CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.creature"));
        CATEGORY_TOKENS.add("water");
        CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.water"));
        CATEGORY_TOKENS.add("ambient");
        CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.ambient"));
        CATEGORY_TOKENS.add("misc");
        CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.misc"));
    }

    private void rebuildCategoryFiltersFromMonsters() {
        int newIdx;
        String prevActiveToken;
        this.ensureBaseCategoriesInitialized();
        String string = prevActiveToken = activeCategoryIndex >= 0 && activeCategoryIndex < CATEGORY_TOKENS.size() ? CATEGORY_TOKENS.get(activeCategoryIndex) : null;
        if (CATEGORY_TOKENS.size() > 9) {
            CATEGORY_TOKENS = new ArrayList<String>(CATEGORY_TOKENS.subList(0, 9));
            CATEGORY_LABELS = new ArrayList<Component>(CATEGORY_LABELS.subList(0, 9));
        }
        DYNAMIC_CATEGORY_TOKENS.clear();
        LinkedHashSet<String> present = new LinkedHashSet<String>();
        for (MonsterEntry m : this.monsters) {
            if (m == null || m.entityType() == null) continue;
            try {
                String name = m.entityType().m_20674_().m_21607_();
                if (name == null) continue;
                present.add(name.toLowerCase());
            }
            catch (Throwable name) {}
        }
        for (String n : present) {
            if (BestiaryScreen.isWaterCategoryName(n) || "monster".equals(n) || "creature".equals(n) || "ambient".equals(n) || "misc".equals(n) || CATEGORY_TOKENS.contains(n)) continue;
            CATEGORY_TOKENS.add(n);
            String displayName = n;
            int colon = displayName.indexOf(58);
            if (colon >= 0 && colon < displayName.length() - 1) {
                displayName = displayName.substring(colon + 1);
            }
            displayName = BestiaryScreen.toTitleCase(displayName.replace('_', ' '));
            CATEGORY_LABELS.add((Component)Component.m_237113_((String)displayName));
            DYNAMIC_CATEGORY_TOKENS.add(n);
        }
        int miscIdx = CATEGORY_TOKENS.indexOf("misc");
        if (miscIdx == -1) {
            CATEGORY_TOKENS.add("misc");
            CATEGORY_LABELS.add((Component)Component.m_237115_((String)"screen.araxers_bestiary.filter.display.misc"));
        } else if (miscIdx != CATEGORY_TOKENS.size() - 1) {
            String miscToken = CATEGORY_TOKENS.remove(miscIdx);
            Component miscLabel = CATEGORY_LABELS.remove(miscIdx);
            CATEGORY_TOKENS.add(miscToken);
            CATEGORY_LABELS.add(miscLabel);
        }
        if (prevActiveToken != null && (newIdx = CATEGORY_TOKENS.indexOf(prevActiveToken)) != -1) {
            activeCategoryIndex = newIdx;
        }
        this.ensureActiveCategoryValid();
        this.updateCategoryButtonMessage();
    }

    private static boolean isWaterCategoryName(String name) {
        if (name == null) {
            return false;
        }
        return "water_creature".equals(name) || "underground_water_creature".equals(name) || "water_ambient".equals(name) || "axolotls".equals(name);
    }

    private static String toTitleCase(String s) {
        if (s == null || s.isEmpty()) {
            return "";
        }
        String[] parts = s.trim().toLowerCase().split("\\s+|_");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < parts.length; ++i) {
            String p = parts[i];
            if (p.isEmpty()) continue;
            sb.append(Character.toUpperCase(p.charAt(0)));
            if (p.length() > 1) {
                sb.append(p.substring(1));
            }
            if (i >= parts.length - 1) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String stripNamespace(String s) {
        if (s == null) {
            return "";
        }
        int idx = s.indexOf(58);
        if (idx >= 0 && idx < s.length() - 1) {
            return s.substring(idx + 1);
        }
        return s;
    }

    private boolean isDynamicCategoryFilter(String filterType) {
        String f = filterType == null ? "" : filterType.toLowerCase();
        for (String t : DYNAMIC_CATEGORY_TOKENS) {
            if (t.contains(f)) {
                return true;
            }
            String title = BestiaryScreen.toTitleCase(BestiaryScreen.stripNamespace(t).replace('_', ' ')).toLowerCase();
            if (!title.contains(f)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesDynamicCategory(String filterType, String categoryName) {
        if (categoryName == null) {
            return false;
        }
        String f = filterType == null ? "" : filterType.toLowerCase();
        String n = categoryName.toLowerCase();
        if (!DYNAMIC_CATEGORY_TOKENS.contains(n)) {
            return false;
        }
        if (n.contains(f)) {
            return true;
        }
        String title = BestiaryScreen.toTitleCase(BestiaryScreen.stripNamespace(n).replace('_', ' ')).toLowerCase();
        return title.contains(f);
    }

    private boolean isCategoryAllowed(int idx) {
        this.ensureBaseCategoriesInitialized();
        if (idx < 0 || idx >= CATEGORY_TOKENS.size()) {
            return false;
        }
        if (Config.enableProgressionSystem) {
            return true;
        }
        String token = CATEGORY_TOKENS.get(idx);
        return !"new".equals(token) && !"sighted".equals(token) && !"discovered".equals(token);
    }

    private void ensureActiveCategoryValid() {
        if (activeCategoryIndex == -1) {
            return;
        }
        if (!this.isCategoryAllowed(activeCategoryIndex)) {
            activeCategoryIndex = -1;
        }
    }

    private Component getCategoryLabelForIndex(int idx) {
        this.ensureBaseCategoriesInitialized();
        if (idx < 0) {
            return Component.m_237115_((String)"screen.araxers_bestiary.filter.display.all");
        }
        if (idx >= 0 && idx < CATEGORY_LABELS.size()) {
            return CATEGORY_LABELS.get(idx);
        }
        return Component.m_237115_((String)"screen.araxers_bestiary.filter.display.all");
    }

    private void updateCategoryButtonMessage() {
        if (this.categoryToggleButton == null) {
            return;
        }
        this.ensureActiveCategoryValid();
        Component comp = this.getCategoryLabelForIndex(activeCategoryIndex);
        String full = comp.getString();
        this.setupOrDisableCategoryMarquee(full);
    }

    private void setupOrDisableCategoryMarquee(String fullText) {
        if (this.categoryToggleButton == null || this.f_96547_ == null) {
            return;
        }
        this.categoryFullLabel = fullText == null ? "" : fullText;
        int available = this.getCategoryButtonTextWidth();
        if (this.f_96547_.m_92895_(this.categoryFullLabel) <= available || available <= 0) {
            this.categoryMarqueeActive = false;
            this.categoryMarqueeBase = "";
            this.categoryMarqueeIndex = 0;
            this.categoryMarqueeLastUpdate = 0L;
            this.categoryToggleButton.m_93666_((Component)Component.m_237113_((String)this.categoryFullLabel));
        } else {
            String spacer = "   ";
            this.categoryMarqueeBase = this.categoryFullLabel + spacer + this.categoryFullLabel;
            this.categoryMarqueeActive = true;
            this.categoryMarqueeIndex = 0;
            this.categoryMarqueeLastUpdate = System.currentTimeMillis();
            this.updateCategoryMarqueeText();
        }
    }

    private int getCategoryButtonTextWidth() {
        int padding = 10;
        return Math.max(0, this.categoryToggleButton.m_5711_() - padding);
    }

    private void updateCategoryMarqueeText() {
        if (!this.categoryMarqueeActive || this.categoryToggleButton == null || this.f_96547_ == null) {
            return;
        }
        int available = this.getCategoryButtonTextWidth();
        String window = this.sliceLoopByWidth(this.categoryMarqueeBase, this.categoryMarqueeIndex, available);
        this.categoryToggleButton.m_93666_((Component)Component.m_237113_((String)window));
    }

    private String sliceLoopByWidth(String base, int startIndex, int maxWidth) {
        int w;
        if (base == null || base.isEmpty()) {
            return "";
        }
        int n = base.length();
        if (n == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        int width = 0;
        int maxChars = n * 2;
        for (int i = 0; i < maxChars && width < maxWidth; width += w, ++i) {
            char ch = base.charAt((startIndex + i) % n);
            String s = String.valueOf(ch);
            w = this.f_96547_.m_92895_(s);
            if (sb.length() > 0 && width + w > maxWidth) break;
            sb.append(ch);
        }
        if (sb.length() == 0) {
            sb.append(base.charAt(startIndex % n));
        }
        return sb.toString();
    }

    private void setActiveCategoryIndex(int idx) {
        activeCategoryIndex = idx;
        this.tabStylesDirty = true;
        this.updateCategoryButtonMessage();
        this.updateFilteredMonsters();
        if (this.monsterList != null) {
            this.monsterList.updateEntries(this.filteredMonsters);
        }
    }

    private void cycleCategory(int delta) {
        this.ensureBaseCategoriesInitialized();
        int count = CATEGORY_TOKENS.size();
        if (count == 0) {
            return;
        }
        if (activeCategoryIndex == -1) {
            if (delta > 0) {
                for (int i = 0; i < count; ++i) {
                    if (!this.isCategoryAllowed(i)) continue;
                    this.setActiveCategoryIndex(i);
                    return;
                }
                return;
            }
            for (int i = count - 1; i >= 0; --i) {
                if (!this.isCategoryAllowed(i)) continue;
                this.setActiveCategoryIndex(i);
                return;
            }
            return;
        }
        int next = activeCategoryIndex;
        for (int attempts = 0; attempts < count; ++attempts) {
            if ((next += delta > 0 ? 1 : -1) >= 0 && next < count) continue;
            this.setActiveCategoryIndex(-1);
            return;
        }
        this.setActiveCategoryIndex(-1);
    }

    public BestiaryScreen() {
        super((Component)Component.m_237115_((String)"screen.araxers_bestiary.bestiary"));
    }

    private float getScalingFactor() {
        int targetCap;
        int currentScale = (Integer)Minecraft.m_91087_().f_91066_.m_231928_().m_231551_();
        int windowHeight = Minecraft.m_91087_().m_91268_().m_85442_();
        int n = targetCap = windowHeight <= 1080 ? 2 : 3;
        if (currentScale == 0) {
            int height;
            int width = Minecraft.m_91087_().m_91268_().m_85441_();
            int scaleFactor = Math.max(1, Math.min(width / 320, (height = windowHeight) / 240));
            if (scaleFactor > targetCap) {
                return (float)targetCap / (float)scaleFactor;
            }
        } else if (currentScale > targetCap) {
            return (float)targetCap / (float)currentScale;
        }
        return 1.0f;
    }

    private void enableScaledScissor(GuiGraphics guiGraphics, int left, int top, int right, int bottom) {
        float s = this.getScalingFactor();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        int sl = Math.round(centerX + s * ((float)left - centerX));
        int st = Math.round(centerY + s * ((float)top - centerY));
        int sr = Math.round(centerX + s * ((float)right - centerX));
        int sb = Math.round(centerY + s * ((float)bottom - centerY));
        guiGraphics.m_280588_(sl, st, sr, sb);
    }

    protected void m_7856_() {
        LOGGER.debug("Initializing Modern Bestiary Screen");
        try {
            CATEGORY_TOKENS.clear();
            CATEGORY_LABELS.clear();
            DYNAMIC_CATEGORY_TOKENS.clear();
            activeCategoryIndex = -1;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (!this.openSoundPlayed) {
            try {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.openSoundPlayed = true;
        }
        currentGlobalRankBarType = Config.globalRankProgressBarType != null ? Config.globalRankProgressBarType : "S";
        int panelSpacing = 20;
        int totalWidth = 170 + panelSpacing + 150;
        this.scaledItemSpacing = 35;
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        int leftPanelX = Math.round(centerX - (float)totalWidth / 2.0f);
        int rightPanelX = leftPanelX + 170 + panelSpacing;
        int panelY = Math.round(centerY - 128.0f);
        int entityViewX = rightPanelX;
        int entityViewY = panelY;
        int infoPanelX = rightPanelX;
        int infoPanelY = panelY + 150 + 30;
        int infoPanelHeight = 76;
        int searchX = leftPanelX - 10;
        int searchY = panelY - 10;
        int searchHeight = 20;
        int hideBtnWidth = 20;
        int hideBtnHeight = 16;
        int listBtnWidth = hideBtnWidth;
        int listBtnHeight = hideBtnHeight;
        int gapBetweenButtons = 2;
        int gapSearchToButtons = 4;
        boolean sideButtonsEnabled = Config.enableProgressionSystem;
        float btnScale = (float)searchHeight / (float)hideBtnHeight;
        hideBtnHeight = searchHeight;
        listBtnHeight = searchHeight;
        hideBtnWidth = Math.max(16, Math.round((float)hideBtnWidth * btnScale));
        listBtnWidth = Math.max(16, Math.round((float)listBtnWidth * btnScale));
        int searchWidth = 170;
        if (sideButtonsEnabled) {
            searchWidth = Math.max(50, 170 - (listBtnWidth + hideBtnWidth + gapBetweenButtons + gapSearchToButtons));
        }
        this.searchBox = (EditBox)this.m_142416_((GuiEventListener)new EditBox(this.f_96547_, searchX, searchY, searchWidth, searchHeight, (Component)Component.m_237115_((String)"screen.araxers_bestiary.search")));
        this.searchBox.m_94151_(this::updateSearch);
        if (listTextMode == null) {
            listTextMode = "ranks".equals(Config.progressionSystemType) ? ListTextMode.RANK : ("kills".equals(Config.progressionSystemType) ? ListTextMode.KILLS : ListTextMode.HIDE);
        }
        if (!"ranks".equals(Config.progressionSystemType) && listTextMode == ListTextMode.RANK) {
            listTextMode = ListTextMode.KILLS;
        }
        int listBtnX = searchX + searchWidth + (sideButtonsEnabled ? gapSearchToButtons : 0);
        int listBtnY = searchY;
        this.listTextModeButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder(this.getListTextModeLabel(), btn -> {
            boolean ranksEnabled = "ranks".equals(Config.progressionSystemType);
            if (ranksEnabled) {
                switch (listTextMode) {
                    case RANK: {
                        listTextMode = ListTextMode.KILLS;
                        break;
                    }
                    case KILLS: {
                        listTextMode = ListTextMode.HIDE;
                        break;
                    }
                    case HIDE: {
                        listTextMode = ListTextMode.RANK;
                        break;
                    }
                    default: {
                        listTextMode = ListTextMode.RANK;
                        break;
                    }
                }
            } else {
                listTextMode = listTextMode == ListTextMode.KILLS ? ListTextMode.HIDE : ListTextMode.KILLS;
            }
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.updateListTextModeButtonLabel();
        }).m_252794_(listBtnX, listBtnY).m_253046_(listBtnWidth, listBtnHeight).m_253136_());
        this.listTextModeButton.f_93624_ = sideButtonsEnabled;
        this.updateListTextModeButtonLabel();
        int hideBtnX = listBtnX + listBtnWidth + (sideButtonsEnabled ? gapBetweenButtons : 0);
        int hideBtnY = searchY;
        this.hideUnseenButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"H"), btn -> {
            HIDE_UNSEEN_TOGGLED = !HIDE_UNSEEN_TOGGLED;
            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            this.updateHideUnseenButtonLabel();
            this.updateFilteredMonsters();
            if (this.monsterList != null) {
                this.monsterList.updateEntries(this.filteredMonsters);
            }
        }).m_252794_(hideBtnX, hideBtnY).m_253046_(hideBtnWidth, hideBtnHeight).m_253136_());
        this.hideUnseenButton.f_93624_ = sideButtonsEnabled;
        this.updateHideUnseenButtonLabel();
        this.categoryToggleButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder(this.getCategoryLabelForIndex(activeCategoryIndex), btn -> this.cycleCategory(1)).m_252794_(leftPanelX - 10, panelY - 34).m_253046_(90, 20).m_253136_());
        this.updateCategoryButtonMessage();
        this.loadMonsterData();
        this.monsterList = new MonsterListWidget(leftPanelX - 10, panelY + 30, 170, 256, this.filteredMonsters);
        this.m_142416_((GuiEventListener)this.monsterList);
        this.entityView = new EntityViewWidget(entityViewX, entityViewY, 150, 150);
        this.m_142416_((GuiEventListener)this.entityView);
        int buttonWidth = 56;
        int buttonY = entityViewY + 150 + 5;
        int buttonHeight = 20;
        this.attributesButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"screen.araxers_bestiary.tab.stats"), button -> {
            this.currentTab = TabType.ATTRIBUTES;
            this.tabStylesDirty = true;
        }).m_252794_(entityViewX - 8, buttonY).m_253046_(buttonWidth, buttonHeight).m_253136_());
        this.locationsButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"screen.araxers_bestiary.tab.spawn"), button -> {
            this.currentTab = TabType.LOCATIONS;
            this.tabStylesDirty = true;
        }).m_252794_(entityViewX + buttonWidth - 8, buttonY).m_253046_(buttonWidth, buttonHeight).m_253136_());
        this.lootButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237115_((String)"screen.araxers_bestiary.tab.loot"), button -> {
            this.currentTab = TabType.LOOT;
            this.tabStylesDirty = true;
        }).m_252794_(entityViewX + buttonWidth * 2 - 8, buttonY).m_253046_(buttonWidth, buttonHeight).m_253136_());
        this.infoPanel = new InfoPanel(infoPanelX - 8, infoPanelY, 170, infoPanelHeight);
        this.m_142416_((GuiEventListener)this.infoPanel);
        this.rankXToggleButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"X"), btn -> {
            if (this.infoPanel != null) {
                boolean bl = this.infoPanel.showRankXInsteadOfAttributes = !this.infoPanel.showRankXInsteadOfAttributes;
                if (this.infoPanel.showRankXInsteadOfAttributes) {
                    this.infoPanel.rankXScrollOffset = 0;
                }
            }
        }).m_252794_(infoPanelX - 8 + 170 - 22, infoPanelY + 22).m_253046_(16, 16).m_253136_());
        this.rankXToggleButton.f_93624_ = false;
        this.variantPrevButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)"<"), btn -> {
            if (this.entityView != null) {
                this.entityView.cycleVariant(-1);
            }
        }).m_252794_(0, 0).m_253046_(14, 14).m_253136_());
        this.variantPrevButton.f_93624_ = false;
        this.variantNextButton = (Button)this.m_142416_((GuiEventListener)new Button.Builder((Component)Component.m_237113_((String)">"), btn -> {
            if (this.entityView != null) {
                this.entityView.cycleVariant(1);
            }
        }).m_252794_(0, 0).m_253046_(14, 14).m_253136_());
        this.variantNextButton.f_93624_ = false;
    }

    private void loadMonsterData() {
        this.monsters.clear();
        this.filteredMonsters.clear();
        this.killCounts.clear();
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (level != null) {
            LOGGER.debug("Level is available, fetching FAST monster entries (lazy details)");
            this.monsters = EntityDataProvider.getFastMonsterEntries((Level)level);
            for (MonsterEntry monster : this.monsters) {
                if (monster.entityType() == null) continue;
                int killCount = ClientProgressionData.getKillCount(monster.entityType());
                this.killCounts.put(monster.entityType(), killCount);
                if (!LOGGER.isDebugEnabled()) continue;
                LOGGER.debug("Kill count for {}: {}", (Object)monster.name(), (Object)killCount);
            }
        }
        this.rebuildCategoryFiltersFromMonsters();
        this.updateFilteredMonsters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateFilteredMonsters() {
        this.filteredMonsters.clear();
        String rawSearchText = this.searchBox != null ? this.searchBox.m_94155_().toLowerCase() : "";
        Object effectiveSearchText = rawSearchText;
        boolean startsWithSpecial = ((String)effectiveSearchText).startsWith("@") || ((String)effectiveSearchText).startsWith("#") || ((String)effectiveSearchText).startsWith("$") || ((String)effectiveSearchText).startsWith("%");
        boolean appliedCategoryViaToggle = false;
        this.ensureActiveCategoryValid();
        if (activeCategoryIndex != -1 && !startsWithSpecial && this.isCategoryAllowed(activeCategoryIndex)) {
            appliedCategoryViaToggle = true;
            effectiveSearchText = "#" + CATEGORY_TOKENS.get(activeCategoryIndex);
        }
        String nameFilterForCombine = rawSearchText;
        Object searchText = effectiveSearchText;
        if (((String)searchText).equals("@") || ((String)searchText).equals("#") || ((String)searchText).equals("$") || ((String)searchText).equals("%")) {
            for (MonsterEntry monster : this.monsters) {
                if (Config.enableProgressionSystem && (Config.hideZeroKillEntities && "kills".equals(Config.progressionSystemType) && monster.entityType() != null && this.killCounts.getOrDefault(monster.entityType(), 0) == 0 && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || this.shouldHideByUnseen(monster.entityType())) continue;
                this.filteredMonsters.add(monster);
            }
            this.cachedFilteredCount = this.filteredMonsters.size();
            this.cachedMonsterCountText = Component.m_237110_((String)"screen.araxers_bestiary.monsters_count", (Object[])new Object[]{this.cachedFilteredCount}).getString();
            LOGGER.debug("Search text is '{}' - not filtering by name or mod ID", searchText);
            return;
        }
        if (((String)searchText).startsWith("$") && ((String)searchText).length() > 1) {
            String filterType = ((String)searchText).substring(1);
            LOGGER.debug("Filtering by entity type: {}", (Object)filterType);
            boolean isEFilter = "e".equals(filterType);
            boolean isDFilter = "d".equals(filterType);
            boolean isCFilter = "c".equals(filterType);
            boolean isBFilter = "b".equals(filterType);
            boolean isAFilter = "a".equals(filterType);
            boolean isSFilter = "s".equals(filterType);
            if (!(isEFilter || isAFilter || isBFilter || isCFilter || isSFilter || isDFilter)) {
                return;
            }
            for (MonsterEntry monster : this.monsters) {
                if (Config.enableProgressionSystem && (Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || this.shouldHideByUnseen(monster.entityType()) || monster.entityType() == null) continue;
                try {
                    String rank = ClientProgressionData.getRank(monster.entityType());
                    boolean shouldAdd = isEFilter && "E".equals(rank) || isDFilter && "D".equals(rank) || isCFilter && "C".equals(rank) || isBFilter && "B".equals(rank) || isAFilter && "A".equals(rank) || isSFilter && "S".equals(rank);
                    if (!shouldAdd) continue;
                    this.filteredMonsters.add(monster);
                }
                catch (Throwable t) {
                    LOGGER.debug("Rank filter check failed for {}: {}", monster.entityType(), (Object)t.toString());
                }
            }
            LOGGER.debug("Filtered by entity type '{}': {} entities shown", (Object)filterType, (Object)this.filteredMonsters.size());
            return;
        }
        if (((String)searchText).startsWith("%") && ((String)searchText).length() > 1) {
            String locationFilter = ((String)searchText).substring(1);
            LOGGER.debug("Filtering by spawn location containing: {}", (Object)locationFilter);
            for (MonsterEntry monster : this.monsters) {
                if (Config.enableProgressionSystem && (Config.hideZeroKillEntities && "kills".equals(Config.progressionSystemType) && monster.entityType() != null && this.killCounts.getOrDefault(monster.entityType(), 0) == 0 && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || this.shouldHideByUnseen(monster.entityType())) continue;
                boolean match = false;
                if (monster.spawnLocation() != null) {
                    List<Component> locations = monster.spawnLocation().getAllLocations();
                    for (Component loc : locations) {
                        String raw = loc.getString().toLowerCase();
                        if (raw.contains(locationFilter)) {
                            match = true;
                            break;
                        }
                        String processed = raw;
                        if (raw.contains("/")) {
                            String[] partsSlash = raw.split("/");
                            processed = partsSlash[partsSlash.length - 1];
                        } else if (raw.contains(".")) {
                            String[] partsDot = raw.split("\\.");
                            processed = partsDot[partsDot.length - 1];
                        }
                        if (!(processed = processed.replace('_', ' ')).contains(locationFilter)) continue;
                        match = true;
                        break;
                    }
                }
                if (!match) continue;
                this.filteredMonsters.add(monster);
            }
            LOGGER.debug("Filtered by spawn location '{}': {} entities shown", (Object)locationFilter, (Object)this.filteredMonsters.size());
            return;
        }
        if (((String)searchText).startsWith("#") && ((String)searchText).length() > 1) {
            String filterType = ((String)searchText).substring(1);
            LOGGER.debug("Filtering by entity type: {}", (Object)filterType);
            boolean isBossFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.boss").getString().toLowerCase().contains(filterType) || "boss".contains(filterType);
            boolean isMonsterFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.monster").getString().toLowerCase().contains(filterType) || "monster".contains(filterType);
            boolean isCreatureFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.creature").getString().toLowerCase().contains(filterType) || "creature".contains(filterType);
            boolean isWaterFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.water").getString().toLowerCase().contains(filterType) || "water".contains(filterType);
            boolean isAmbientFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.ambient").getString().toLowerCase().contains(filterType) || "ambient".contains(filterType);
            boolean isMiscFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.misc").getString().toLowerCase().contains(filterType) || "misc".contains(filterType);
            boolean isNewFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.new").getString().toLowerCase().contains(filterType) || "new".contains(filterType);
            boolean isPartiallyFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.sighted").getString().toLowerCase().contains(filterType) || "sighted".contains(filterType);
            boolean isDiscoveredFilter = Component.m_237115_((String)"screen.araxers_bestiary.filter.discovered").getString().toLowerCase().contains(filterType) || "discovered".contains(filterType);
            boolean isDynamicCatFilter = this.isDynamicCategoryFilter(filterType);
            if (!(isBossFilter || isMonsterFilter || isCreatureFilter || isWaterFilter || isAmbientFilter || isMiscFilter || isNewFilter || isPartiallyFilter || isDiscoveredFilter || isDynamicCatFilter)) {
                LOGGER.debug("No matching filter type for: {}", (Object)filterType);
                return;
            }
            for (MonsterEntry monster : this.monsters) {
                if (Config.enableProgressionSystem && !isBossFilter && (Config.hideZeroKillEntities && "kills".equals(Config.progressionSystemType) && monster.entityType() != null && this.killCounts.getOrDefault(monster.entityType(), 0) == 0 && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || "sighting".equals(Config.progressionSystemType) && monster.entityType() != null && !ClientProgressionData.isFullyDiscovered(monster.entityType()) && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || monster.entityType() == null) continue;
                boolean shouldAdd = false;
                if (isBossFilter) {
                    try {
                        ClientLevel lvl;
                        EntityType<?> t = monster.entityType();
                        boolean isBossDetected = monster.boss();
                        if (!isBossDetected) {
                            try {
                                isBossDetected = RankUtils.isBossType(t);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                        if (!isBossDetected && (lvl = Minecraft.m_91087_().f_91073_) != null) {
                            Entity tmp = null;
                            try {
                                tmp = t.m_20615_((Level)lvl);
                                if (tmp != null) {
                                    isBossDetected = RankUtils.isBossEntity(tmp);
                                }
                            }
                            catch (Throwable throwable) {
                            }
                            finally {
                                if (tmp != null) {
                                    try {
                                        tmp.m_142687_(Entity.RemovalReason.DISCARDED);
                                    }
                                    catch (Throwable throwable) {}
                                }
                            }
                        }
                        if (isBossDetected) {
                            shouldAdd = true;
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
                if (isNewFilter && ClientProgressionData.isNewlyDiscovered(monster.entityType())) {
                    shouldAdd = true;
                }
                if (isPartiallyFilter && ClientProgressionData.isPartiallyDiscovered(monster.entityType())) {
                    shouldAdd = true;
                }
                if (isDiscoveredFilter && (!ClientProgressionData.getRank(monster.entityType()).equals("") && "ranks".equals(Config.progressionSystemType) || this.killCounts.getOrDefault(monster.entityType(), 0) > 0 && "kills".equals(Config.progressionSystemType) || ClientProgressionData.isFullyDiscovered(monster.entityType()) && "sighting".equals(Config.progressionSystemType))) {
                    shouldAdd = true;
                }
                if (shouldAdd && this.shouldHideByUnseen(monster.entityType()) && !isPartiallyFilter && !isBossFilter) {
                    shouldAdd = false;
                }
                MobCategory category = monster.entityType().m_20674_();
                if (isWaterFilter && (category == MobCategory.WATER_CREATURE || category == MobCategory.UNDERGROUND_WATER_CREATURE || category == MobCategory.WATER_AMBIENT || category == MobCategory.AXOLOTLS)) {
                    shouldAdd = true;
                }
                if (isMonsterFilter && category == MobCategory.MONSTER) {
                    shouldAdd = true;
                }
                if (isCreatureFilter && category == MobCategory.CREATURE) {
                    shouldAdd = true;
                }
                if (isAmbientFilter && category == MobCategory.AMBIENT) {
                    shouldAdd = true;
                }
                if (isMiscFilter && category == MobCategory.MISC) {
                    shouldAdd = true;
                }
                if (!shouldAdd && isDynamicCatFilter && this.matchesDynamicCategory(filterType, category.m_21607_())) {
                    shouldAdd = true;
                }
                if (shouldAdd) {
                    if (appliedCategoryViaToggle && nameFilterForCombine != null && !nameFilterForCombine.isEmpty() && !monster.name().getString().toLowerCase().contains(nameFilterForCombine)) {
                        shouldAdd = false;
                    }
                    if (shouldAdd && this.shouldHideByUnseen(monster.entityType()) && !isPartiallyFilter && !isBossFilter) {
                        shouldAdd = false;
                    }
                }
                if (!shouldAdd) continue;
                this.filteredMonsters.add(monster);
            }
            LOGGER.debug("Filtered by entity type '{}': {} entities shown", (Object)filterType, (Object)this.filteredMonsters.size());
            return;
        }
        boolean isModSearch = false;
        String modIdFilter = "";
        if (((String)searchText).startsWith("@") && ((String)searchText).length() > 1) {
            isModSearch = true;
            modIdFilter = ((String)searchText).substring(1);
            LOGGER.debug("Filtering by mod ID: {}", (Object)modIdFilter);
        }
        for (MonsterEntry monster : this.monsters) {
            ResourceLocation entityId;
            if (Config.enableProgressionSystem && (Config.hideZeroKillEntities && "kills".equals(Config.progressionSystemType) && monster.entityType() != null && this.killCounts.getOrDefault(monster.entityType(), 0) == 0 && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideNoRankEntities && "ranks".equals(Config.progressionSystemType) && monster.entityType() != null && ClientProgressionData.getRank(monster.entityType()).equals("") && !ClientProgressionData.isSpyglassObserved(monster.entityType()) || Config.hideUndiscovered && monster.entityType() != null && !this.isEntityDiscovered(monster.entityType())) || this.shouldHideByUnseen(monster.entityType()) || !((String)searchText).isEmpty() && (isModSearch ? monster.entityType() == null || (entityId = ForgeRegistries.ENTITY_TYPES.getKey(monster.entityType())) == null || !entityId.m_135827_().toLowerCase().contains(modIdFilter) : !monster.name().getString().toLowerCase().contains((CharSequence)searchText))) continue;
            this.filteredMonsters.add(monster);
        }
        LOGGER.debug("Filtered monsters list: {} of {} monsters shown", (Object)this.filteredMonsters.size(), (Object)this.monsters.size());
        this.cachedFilteredCount = this.filteredMonsters.size();
        this.cachedMonsterCountText = Component.m_237110_((String)"screen.araxers_bestiary.monsters_count", (Object[])new Object[]{this.cachedFilteredCount}).getString();
    }

    private void updateSearch(String searchText) {
        this.updateFilteredMonsters();
        if (this.monsterList != null) {
            this.monsterList.updateEntries(this.filteredMonsters);
        }
    }

    private boolean isEntityDiscovered(EntityType<?> entityType) {
        if (!Config.enableProgressionSystem) {
            return true;
        }
        if (entityType != null && (ClientProgressionData.isSpyglassObserved(entityType) || ClientProgressionData.isPartiallyDiscovered(entityType))) {
            return true;
        }
        if ("kills".equals(Config.progressionSystemType)) {
            return this.killCounts.getOrDefault(entityType, 0) > 0;
        }
        if ("ranks".equals(Config.progressionSystemType)) {
            return !ClientProgressionData.getRank(entityType).equals("");
        }
        if ("sighting".equals(Config.progressionSystemType)) {
            return ClientProgressionData.isFullyDiscovered(entityType) || ClientProgressionData.isSpyglassObserved(entityType);
        }
        return false;
    }

    private boolean shouldHideByUnseen(EntityType<?> entityType) {
        if (!Config.enableProgressionSystem) {
            return false;
        }
        return HIDE_UNSEEN_TOGGLED && entityType != null && (ClientProgressionData.isPartiallyDiscovered(entityType) || !this.isEntityDiscovered(entityType));
    }

    private void updateHideUnseenButtonLabel() {
        if (this.hideUnseenButton != null) {
            this.hideUnseenButton.m_93666_((Component)Component.m_237113_((String)(HIDE_UNSEEN_TOGGLED ? "H*" : "H")));
        }
    }

    private Component getListTextModeLabel() {
        ListTextMode mode = listTextMode;
        if (mode == null) {
            if ("ranks".equals(Config.progressionSystemType)) {
                return Component.m_237113_((String)"R");
            }
            if ("kills".equals(Config.progressionSystemType)) {
                return Component.m_237113_((String)"K");
            }
            return Component.m_237113_((String)"-");
        }
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case ListTextMode.RANK -> Component.m_237113_((String)"R");
            case ListTextMode.KILLS -> Component.m_237113_((String)"K");
            case ListTextMode.HIDE -> Component.m_237113_((String)"-");
        };
    }

    private void updateListTextModeButtonLabel() {
        if (this.listTextModeButton != null) {
            this.listTextModeButton.m_93666_(this.getListTextModeLabel());
        }
    }

    public void selectMonster(MonsterEntry monster) {
        LOGGER.debug("selectMonster called for monster: {}", (Object)monster.name());
        this.selectedMonster = monster;
        this.currentTab = TabType.ATTRIBUTES;
        if (monster.entityType() != null && "ranks".equals(Config.progressionSystemType)) {
            String rank = ClientProgressionData.getRank(monster.entityType());
            LOGGER.debug("Selected monster {} with rank: {}", (Object)monster.name(), (Object)rank);
        }
        if (monster.entityType() == null) {
            LOGGER.warn("Monster {} has no entity type, cannot check if newly discovered", (Object)monster.name());
        } else {
            boolean isNewlyDiscovered = ClientProgressionData.isNewlyDiscovered(monster.entityType());
            LOGGER.debug("Entity {} is newly discovered: {}", (Object)monster.entityType().m_20675_(), (Object)isNewlyDiscovered);
            LOGGER.debug("Calling markAsViewed for entity {}", (Object)monster.entityType().m_20675_());
            ClientProgressionData.markAsViewed(monster.entityType());
            PacketHandler.sendEntityViewedPacket(monster.entityType());
            if (!isNewlyDiscovered) {
                LOGGER.debug("Entity {} was not newly discovered, but still marked as viewed", (Object)monster.entityType().m_20675_());
            }
        }
        try {
            ClientLevel lvl = Minecraft.m_91087_().f_91073_;
            LocalPlayer pl = Minecraft.m_91087_().f_91074_;
            if (lvl != null && monster.entityType() != null) {
                MonsterEntry progressive;
                MonsterEntry full = EntityDataProvider.getMonsterEntry((Level)lvl, monster.entityType());
                ProgressiveEntityData progData = new ProgressiveEntityData(full, (Player)pl, null);
                this.selectedMonster = progressive = progData.toMonsterEntry();
                monster = progressive;
            }
        }
        catch (Exception ex) {
            LOGGER.debug("Failed to build full details lazily: {}", (Object)ex.getMessage());
        }
        if (this.entityView != null) {
            LOGGER.debug("Setting entity in entityView: {}", (Object)monster.name());
            this.entityView.setEntity(monster.entityType(), monster);
        } else {
            LOGGER.warn("entityView is null, cannot set entity");
        }
        if (this.infoPanel != null) {
            LOGGER.debug("Setting monster in infoPanel: {}", (Object)monster.name());
            this.infoPanel.setMonster(monster);
        } else {
            LOGGER.warn("infoPanel is null, cannot set monster");
        }
        this.tabStylesDirty = true;
    }

    private void replaceSelectedMonsterLoot(List<LootItemEntry> newLoot, boolean switchToLootTab) {
        try {
            MonsterEntry updated;
            if (this.selectedMonster == null) {
                return;
            }
            MonsterEntry old = this.selectedMonster;
            if (newLoot == null) {
                newLoot = Collections.emptyList();
            }
            this.selectedMonster = updated = new MonsterEntry(old.name(), old.health(), old.damage(), old.knockbackResistance(), old.armor(), old.armorToughness(), old.movementSpeed(), old.experience(), old.spawnLocation(), newLoot, old.entityType(), old.description(), old.boss());
            if (this.infoPanel != null) {
                this.infoPanel.setMonster(updated);
                this.infoPanel.lootItemsScrollOffset = 0;
            }
            if (this.entityView != null) {
                this.entityView.setEntity(updated.entityType(), updated);
            }
            if (switchToLootTab) {
                this.currentTab = TabType.LOOT;
            }
            this.tabStylesDirty = true;
            LOGGER.debug("Replaced selected monster loot with {} entries for {}", (Object)newLoot.size(), (Object)old.name().getString());
        }
        catch (Exception e) {
            LOGGER.error("Failed to replace selected monster loot: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void applyLootUpdates(Map<EntityType<?>, List<LootItemEntry>> updates) {
        BestiaryScreen.applyLootUpdates(updates, true);
    }

    public static void applyLootUpdates(Map<EntityType<?>, List<LootItemEntry>> updates, boolean switchToLootTab) {
        try {
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (!(screen instanceof BestiaryScreen)) {
                return;
            }
            BestiaryScreen screen2 = (BestiaryScreen)screen;
            if (updates == null || updates.isEmpty()) {
                return;
            }
            if (screen2.selectedMonster == null || screen2.selectedMonster.entityType() == null) {
                return;
            }
            List<LootItemEntry> newLoot = updates.get(screen2.selectedMonster.entityType());
            if (newLoot != null) {
                boolean currentHasLoot;
                boolean incomingEmpty = newLoot.isEmpty();
                boolean bl = currentHasLoot = screen2.selectedMonster.loot() != null && !screen2.selectedMonster.loot().isEmpty();
                if (incomingEmpty && currentHasLoot) {
                    LOGGER.debug("Ignoring empty loot update for {} to preserve existing non-empty loot in UI", (Object)screen2.selectedMonster.entityType().m_20675_());
                } else {
                    screen2.replaceSelectedMonsterLoot(newLoot, switchToLootTab);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error applying loot updates to BestiaryScreen: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void applyAttributeUpdates(Map<EntityType<?>, EntityAttributes> updates) {
        try {
            MonsterEntry updated;
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (!(screen instanceof BestiaryScreen)) {
                return;
            }
            BestiaryScreen screen2 = (BestiaryScreen)screen;
            if (updates == null || updates.isEmpty()) {
                return;
            }
            if (screen2.selectedMonster == null || screen2.selectedMonster.entityType() == null) {
                return;
            }
            EntityAttributes attrs = updates.get(screen2.selectedMonster.entityType());
            if (attrs == null) {
                return;
            }
            MonsterEntry old = screen2.selectedMonster;
            screen2.selectedMonster = updated = new MonsterEntry(old.name(), attrs.health(), attrs.damage(), attrs.knockbackResistance(), attrs.armor(), attrs.armorToughness(), attrs.movementSpeed(), attrs.experience(), old.spawnLocation(), old.loot(), old.entityType(), attrs.description() != null ? attrs.description().getString() : old.description(), attrs.boss());
            if (screen2.infoPanel != null) {
                screen2.infoPanel.setMonster(updated);
                screen2.infoPanel.advAttrScrollOffset = 0;
            }
            if (screen2.entityView != null) {
                screen2.entityView.setEntity(updated.entityType(), updated);
            }
            screen2.updateTabButtonStyles();
            LOGGER.debug("Applied attribute update for {} to UI", (Object)old.name().getString());
        }
        catch (Exception e) {
            LOGGER.error("Error applying attribute updates to BestiaryScreen: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void applySpawnLocationUpdates(Map<EntityType<?>, SpawnLocationInfo> updates) {
        try {
            MonsterEntry updated;
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (!(screen instanceof BestiaryScreen)) {
                return;
            }
            BestiaryScreen screen2 = (BestiaryScreen)screen;
            if (updates == null || updates.isEmpty()) {
                return;
            }
            if (screen2.selectedMonster == null || screen2.selectedMonster.entityType() == null) {
                return;
            }
            SpawnLocationInfo loc = updates.get(screen2.selectedMonster.entityType());
            if (loc == null) {
                return;
            }
            MonsterEntry old = screen2.selectedMonster;
            screen2.selectedMonster = updated = new MonsterEntry(old.name(), old.health(), old.damage(), old.knockbackResistance(), old.armor(), old.armorToughness(), old.movementSpeed(), old.experience(), loc, old.loot(), old.entityType(), old.description(), old.boss());
            if (screen2.infoPanel != null) {
                screen2.infoPanel.setMonster(updated);
                screen2.infoPanel.spawnLocationsScrollOffset = 0;
            }
            if (screen2.entityView != null) {
                screen2.entityView.setEntity(updated.entityType(), updated);
            }
            screen2.updateTabButtonStyles();
            LOGGER.debug("Applied spawn location update for {} to UI", (Object)old.name().getString());
        }
        catch (Exception e) {
            LOGGER.error("Error applying spawn location updates to BestiaryScreen: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void onProgressionDataChanged() {
        try {
            Minecraft mc = Minecraft.m_91087_();
            Screen screen = mc.f_91080_;
            if (!(screen instanceof BestiaryScreen)) {
                return;
            }
            BestiaryScreen screen2 = (BestiaryScreen)screen;
            EntityType<?> selType = screen2.selectedMonster != null ? screen2.selectedMonster.entityType() : null;
            screen2.updateFilteredMonsters();
            if (screen2.monsterList != null) {
                screen2.monsterList.updateEntries(screen2.filteredMonsters);
            }
            if (selType != null) {
                for (MonsterEntry me : screen2.filteredMonsters) {
                    if (me.entityType() != selType) continue;
                    screen2.selectedMonster = me;
                    break;
                }
            }
            if (screen2.selectedMonster != null) {
                if (screen2.infoPanel != null) {
                    screen2.infoPanel.setMonster(screen2.selectedMonster);
                }
                if (screen2.entityView != null) {
                    screen2.entityView.setEntity(screen2.selectedMonster.entityType(), screen2.selectedMonster);
                }
            }
            screen2.updateTabButtonStyles();
        }
        catch (Exception e) {
            LOGGER.error("Error refreshing BestiaryScreen after progression change: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        float scalingFactor = this.getScalingFactor();
        long currentTime = System.currentTimeMillis();
        if (this.lastUpdateTime == 0L) {
            this.lastUpdateTime = currentTime;
        }
        float timeDelta = (float)(currentTime - this.lastUpdateTime) / 1000.0f;
        this.lastUpdateTime = currentTime;
        this.newTextBounceOffset = (float)Math.sin((double)currentTime / 200.0) * 2.0f;
        this.newTextRotation = (float)Math.sin((double)currentTime / 300.0) * 10.0f;
        guiGraphics.m_280168_().m_85836_();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        guiGraphics.m_280168_().m_252880_(centerX, centerY, 0.0f);
        guiGraphics.m_280168_().m_85841_(scalingFactor, scalingFactor, 1.0f);
        guiGraphics.m_280168_().m_252880_(-centerX, -centerY, 0.0f);
        int scaledMouseX = Math.round(((float)mouseX - centerX) / scalingFactor + centerX);
        int scaledMouseY = Math.round(((float)mouseY - centerY) / scalingFactor + centerY);
        int originalWidth = 512;
        int originalHeight = 512;
        float backgroundScale = 0.8f;
        int scaledWidth = (int)((float)originalWidth * backgroundScale);
        int scaledHeight = (int)((float)originalHeight * backgroundScale);
        int x = (this.f_96543_ - scaledWidth) / 2;
        int y = (this.f_96544_ - scaledHeight) / 2;
        guiGraphics.m_280163_(BACKGROUND_TEXTURE, x, y, 0.0f, 0.0f, scaledWidth, scaledHeight, scaledWidth, scaledHeight);
        if (this.cachedFilteredCount != this.filteredMonsters.size()) {
            this.cachedFilteredCount = this.filteredMonsters.size();
            this.cachedMonsterCountText = Component.m_237110_((String)"screen.araxers_bestiary.monsters_count", (Object[])new Object[]{this.cachedFilteredCount}).getString();
        }
        guiGraphics.m_280056_(this.f_96547_, this.cachedMonsterCountText, this.monsterList.m_252754_(), this.monsterList.m_252907_() - 15, 0, false);
        if (this.tabStylesDirty) {
            this.updateTabButtonStyles();
        }
        if (this.categoryMarqueeActive && this.categoryToggleButton != null && this.categoryToggleButton.f_93624_) {
            long now = System.currentTimeMillis();
            if (this.categoryMarqueeLastUpdate == 0L) {
                this.categoryMarqueeLastUpdate = now;
            }
            long interval = 180L;
            if (Config.lowEndMode) {
                double mul = Config.lowEndMarqueeIntervalMultiplier <= 0.0 ? 1.0 : Config.lowEndMarqueeIntervalMultiplier;
                interval = Math.max(50L, Math.round(180.0 * mul));
            }
            if (now - this.categoryMarqueeLastUpdate >= interval) {
                this.categoryMarqueeIndex = (this.categoryMarqueeIndex + 1) % Math.max(1, this.categoryMarqueeBase.length());
                this.categoryMarqueeLastUpdate = now;
                this.updateCategoryMarqueeText();
            }
        }
        super.m_88315_(guiGraphics, scaledMouseX, scaledMouseY, partialTick);
        this.renderGlobalBenefitChipsBelowList(guiGraphics, scaledMouseX, scaledMouseY);
        if (this.hideUnseenButton != null && this.hideUnseenButton.f_93624_ && Config.enableProgressionSystem && this.hideUnseenButton.m_5953_((double)scaledMouseX, (double)scaledMouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.araxers_bestiary.tooltip.hide_undiscovered"), scaledMouseX, scaledMouseY);
        }
        if (this.listTextModeButton != null && this.listTextModeButton.f_93624_ && Config.enableProgressionSystem && this.listTextModeButton.m_5953_((double)scaledMouseX, (double)scaledMouseY)) {
            guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.araxers_bestiary.tooltip.list_text_mode"), scaledMouseX, scaledMouseY);
        }
        if (this.rankXToggleButton != null) {
            boolean showBtn = false;
            int newX = 0;
            int newY = 0;
            if (this.currentTab == TabType.ATTRIBUTES && this.selectedMonster != null && this.selectedMonster.entityType() != null && this.infoPanel != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.selectedMonster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx != null && Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType)) {
                    String rnk = ClientProgressionData.getRank(this.selectedMonster.entityType());
                    boolean eligible = RankUtils.compareRanks(rnk, "S") >= 0;
                    boolean bl = showBtn = eligible && Config.showChallenges;
                    if (!showBtn) {
                        this.infoPanel.showRankXInsteadOfAttributes = false;
                    }
                }
                int btnW = this.rankXToggleButton.m_5711_();
                newX = this.infoPanel.x + this.infoPanel.width - btnW - 6;
                newY = this.infoPanel.y + 22;
            }
            this.rankXToggleButton.f_93624_ = showBtn;
            this.rankXToggleButton.f_93623_ = showBtn;
            if (showBtn) {
                this.rankXToggleButton.m_252865_(newX);
                this.rankXToggleButton.m_253211_(newY);
            }
        }
        if (this.variantPrevButton != null) {
            this.variantPrevButton.f_93624_ = false;
            this.variantPrevButton.f_93623_ = false;
        }
        if (this.variantNextButton != null) {
            this.variantNextButton.f_93624_ = false;
            this.variantNextButton.f_93623_ = false;
        }
        try {
            if (this.entityView != null && this.selectedMonster != null && this.attributesButton != null && this.locationsButton != null && this.lootButton != null) {
                boolean chipUnlocked;
                Entity maybeEntity = this.entityView.renderedEntity;
                boolean showDesc = this.entityView.showDescription;
                boolean bl = chipUnlocked = this.selectedMonster.entityType() != null && ClientProgressionData.shouldShowMobTypeChip(this.selectedMonster.entityType());
                if (!showDesc && chipUnlocked && maybeEntity instanceof LivingEntity) {
                    LivingEntity livingForType = (LivingEntity)maybeEntity;
                    int leftX = Math.min(this.attributesButton.m_252754_(), Math.min(this.locationsButton.m_252754_(), this.lootButton.m_252754_()));
                    int rowY = this.attributesButton.m_252907_();
                    MobType mobType = livingForType.m_6336_();
                    MutableComponent translated = null;
                    if (mobType == null || mobType == MobType.f_21640_) {
                        translated = null;
                    } else if (mobType == MobType.f_21641_ || mobType == MobType.f_21642_ || mobType == MobType.f_21643_ || mobType == MobType.f_21644_) {
                        String baseKey = "screen.araxers_bestiary.mob_type.";
                        String typeKey = mobType == MobType.f_21641_ ? "undead" : (mobType == MobType.f_21642_ ? "arthropod" : (mobType == MobType.f_21643_ ? "illager" : "water"));
                        translated = Component.m_237115_((String)(baseKey + typeKey));
                        String resolved = translated.getString();
                        if (resolved.equals(baseKey + typeKey)) {
                            String human = typeKey.substring(0, 1).toUpperCase(Locale.ROOT) + typeKey.substring(1);
                            translated = Component.m_237113_((String)human);
                        }
                    } else {
                        int dot;
                        String raw = String.valueOf(mobType);
                        String simple = mobType.getClass() != null ? mobType.getClass().getSimpleName() : raw;
                        String base = raw;
                        if (raw.contains("@") || raw.contains(".")) {
                            base = simple;
                        }
                        if ((dot = base.lastIndexOf(46)) >= 0 && dot < base.length() - 1) {
                            base = base.substring(dot + 1);
                        }
                        if (!(base = base.replace('_', ' ').replace('-', ' ').trim()).isEmpty() && !base.equalsIgnoreCase("MobType")) {
                            String[] parts = base.split("\\s+");
                            StringBuilder sb = new StringBuilder();
                            for (int i = 0; i < parts.length; ++i) {
                                String p = parts[i];
                                if (p.isEmpty()) continue;
                                String lower = p.toLowerCase(Locale.ROOT);
                                char first = Character.toUpperCase(lower.charAt(0));
                                sb.append(first);
                                if (lower.length() > 1) {
                                    sb.append(lower.substring(1));
                                }
                                if (i >= parts.length - 1) continue;
                                sb.append(' ');
                            }
                            String title = sb.toString().trim();
                            if (!title.isEmpty()) {
                                translated = Component.m_237113_((String)title);
                            }
                        }
                    }
                    if (translated != null) {
                        float s = 0.8f;
                        int padH = 6;
                        int padV = 3;
                        int tW = this.f_96547_.m_92852_(translated);
                        int chipW = tW + padH * 2;
                        Objects.requireNonNull(this.f_96547_);
                        int chipH = 9 + padV * 2;
                        int chipWScaled = Math.round((float)chipW * s);
                        int chipHScaled = Math.round((float)chipH * s);
                        int chipX = leftX;
                        int chipY = rowY - chipHScaled - 8;
                        int bg = -594735;
                        int border = -4879574;
                        guiGraphics.m_280168_().m_85836_();
                        guiGraphics.m_280168_().m_252880_((float)chipX, (float)chipY, 0.0f);
                        guiGraphics.m_280168_().m_85841_(s, s, 1.0f);
                        guiGraphics.m_280509_(-1, -1, chipW + 1, chipH + 1, border);
                        guiGraphics.m_280509_(0, 0, chipW, chipH, bg);
                        guiGraphics.m_280614_(this.f_96547_, (Component)translated, padH, padV, 0, false);
                        guiGraphics.m_280168_().m_85849_();
                    }
                }
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Mob-type chip render skipped: {}", (Object)t.toString());
        }
        try {
            if (this.entityView != null && this.variantPrevButton != null && this.variantNextButton != null) {
                boolean hasVariants = this.entityView.getVariantCount() > 1;
                boolean fullyDiscoveredForArrows = !Config.enableProgressionSystem || this.selectedMonster != null && this.selectedMonster.entityType() != null && this.isEntityDiscovered(this.selectedMonster.entityType()) && !ClientProgressionData.isPartiallyDiscovered(this.selectedMonster.entityType());
                boolean showArrows = hasVariants && fullyDiscoveredForArrows;
                int btnSize = this.variantPrevButton.m_5711_();
                if (btnSize <= 0) {
                    btnSize = 14;
                }
                int margin = 6;
                int wX = this.entityView.x;
                int wY = this.entityView.y;
                int wS = this.entityView.size;
                int baseY = wY + wS - btnSize - margin + 4;
                int nextX = wX + wS - btnSize - margin + 11;
                int prevX = nextX - (btnSize + 2);
                this.variantPrevButton.f_93624_ = showArrows;
                this.variantPrevButton.f_93623_ = showArrows;
                this.variantNextButton.f_93624_ = showArrows;
                this.variantNextButton.f_93623_ = showArrows;
                if (showArrows) {
                    this.variantPrevButton.m_252865_(prevX);
                    this.variantPrevButton.m_253211_(baseY);
                    this.variantNextButton.m_252865_(nextX);
                    this.variantNextButton.m_253211_(baseY);
                }
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Variant arrow position skipped: {}", (Object)t.toString());
        }
        if (this.selectedMonster != null && this.selectedMonster.entityType() != null && Config.enableProgressionSystem) {
            boolean hideAllTabs;
            boolean isDiscovered = this.isEntityDiscovered(this.selectedMonster.entityType());
            boolean isSightedOnly = ClientProgressionData.isPartiallyDiscovered(this.selectedMonster.entityType());
            boolean bl = hideAllTabs = !isDiscovered || isSightedOnly;
            if (hideAllTabs && this.attributesButton != null && this.locationsButton != null && this.lootButton != null) {
                int left = Math.min(this.attributesButton.m_252754_(), Math.min(this.locationsButton.m_252754_(), this.lootButton.m_252754_()));
                int right = Math.max(this.attributesButton.m_252754_() + this.attributesButton.m_5711_(), Math.max(this.locationsButton.m_252754_() + this.locationsButton.m_5711_(), this.lootButton.m_252754_() + this.lootButton.m_5711_()));
                int spanWidth = Math.max(0, right - left);
                int drawX = left + 2;
                int drawY = this.attributesButton.m_252907_() + 2;
                String key = isSightedOnly ? "screen.araxers_bestiary.unlock_tabs.sighted" : "screen.araxers_bestiary.unlock_tabs.undiscovered";
                MutableComponent comp = Component.m_237115_((String)key);
                guiGraphics.m_280554_(this.f_96547_, (FormattedText)comp, drawX, drawY, Math.max(1, spanWidth - 4), 0);
            }
        }
        guiGraphics.m_280168_().m_85849_();
    }

    private void drawVillagerProgressBarStretched(GuiGraphics guiGraphics, int barX, int barY, int totalWidth, float ratio, int fillColorRGB) {
        if (totalWidth <= 0) {
            return;
        }
        RenderSystem.enableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        float clamped = Math.max(0.0f, Math.min(1.0f, ratio));
        ResourceLocation tex = BestiaryScreen.currentBarTexture();
        int u = BestiaryScreen.currentBarU();
        int vbg = BestiaryScreen.currentBarVBg();
        int vfg = BestiaryScreen.currentBarVfg();
        int tw = BestiaryScreen.currentTexWidth();
        int th = BestiaryScreen.currentTexHeight();
        guiGraphics.m_280411_(tex, barX, barY, totalWidth, 5, (float)u, (float)vbg, 102, 5, tw, th);
        int destFillWidth = (int)((float)totalWidth * clamped);
        if (clamped > 0.0f && destFillWidth == 0) {
            destFillWidth = 1;
        }
        if (destFillWidth > 0) {
            int srcFillWidth = Math.max(1, Math.min(102, Math.round(102.0f * clamped)));
            float r = (float)(fillColorRGB >> 16 & 0xFF) / 255.0f;
            float g = (float)(fillColorRGB >> 8 & 0xFF) / 255.0f;
            float b = (float)(fillColorRGB & 0xFF) / 255.0f;
            RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
            guiGraphics.m_280411_(tex, barX, barY, destFillWidth, 5, (float)u, (float)vfg, srcFillWidth, 5, tw, th);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private void updateTabButtonStyles() {
        if (this.selectedMonster == null) {
            this.attributesButton.f_93624_ = false;
            this.locationsButton.f_93624_ = false;
            this.lootButton.f_93624_ = false;
            this.tabStylesDirty = false;
            return;
        }
        boolean hideAllTabs = false;
        if (this.selectedMonster.entityType() != null && Config.enableProgressionSystem) {
            boolean isDiscovered = this.isEntityDiscovered(this.selectedMonster.entityType());
            boolean isSightedOnly = ClientProgressionData.isPartiallyDiscovered(this.selectedMonster.entityType());
            boolean bl = hideAllTabs = !isDiscovered || isSightedOnly;
        }
        if (hideAllTabs) {
            this.attributesButton.f_93624_ = false;
            this.locationsButton.f_93624_ = false;
            this.lootButton.f_93624_ = false;
            this.tabStylesDirty = false;
            return;
        }
        this.attributesButton.f_93624_ = true;
        this.locationsButton.f_93624_ = true;
        this.lootButton.f_93624_ = true;
        this.attributesButton.f_93623_ = true;
        this.locationsButton.f_93623_ = true;
        this.lootButton.f_93623_ = true;
        boolean hasAnyLoot = false;
        try {
            List<LootItemEntry> uiLoot = this.selectedMonster.loot();
            if (uiLoot != null && !uiLoot.isEmpty()) {
                hasAnyLoot = true;
            } else if (this.selectedMonster.entityType() != null) {
                List<LootItemEntry> cached = EntityDataProvider.getCachedLoot(this.selectedMonster.entityType());
                hasAnyLoot = cached != null && !cached.isEmpty();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!hasAnyLoot) {
            if (this.currentTab == TabType.LOOT) {
                this.currentTab = TabType.ATTRIBUTES;
            }
            this.lootButton.f_93624_ = false;
        } else {
            this.lootButton.f_93624_ = true;
        }
        switch (this.currentTab) {
            case ATTRIBUTES: {
                this.attributesButton.f_93623_ = false;
                break;
            }
            case LOCATIONS: {
                this.locationsButton.f_93623_ = false;
                break;
            }
            case LOOT: {
                this.lootButton.f_93623_ = false;
            }
        }
        this.tabStylesDirty = false;
    }

    public boolean m_7043_() {
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        try {
            if (this.searchBox != null && this.searchBox.m_93696_() || this.m_7222_() instanceof EditBox) {
                return super.m_7933_(keyCode, scanCode, modifiers);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (KeyBindings.openBestiary != null && KeyBindings.openBestiary.m_90832_(keyCode, scanCode)) {
                if (this.f_96541_ != null) {
                    this.f_96541_.m_91152_(null);
                }
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        int bh;
        int bw;
        int by;
        int bx;
        float scalingFactor = this.getScalingFactor();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        double scaledMouseX = (mouseX - (double)centerX) / (double)scalingFactor + (double)centerX;
        double scaledMouseY = (mouseY - (double)centerY) / (double)scalingFactor + (double)centerY;
        if (button == 1 && this.categoryToggleButton != null) {
            bx = this.categoryToggleButton.m_252754_();
            by = this.categoryToggleButton.m_252907_();
            bw = this.categoryToggleButton.m_5711_();
            bh = this.categoryToggleButton.m_93694_();
            if (scaledMouseX >= (double)bx && scaledMouseX <= (double)(bx + bw) && scaledMouseY >= (double)by && scaledMouseY <= (double)(by + bh)) {
                Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                this.cycleCategory(-1);
                return true;
            }
        }
        if (this.variantPrevButton != null && this.variantPrevButton.f_93624_ && this.variantPrevButton.f_93623_) {
            bx = this.variantPrevButton.m_252754_();
            by = this.variantPrevButton.m_252907_();
            bw = this.variantPrevButton.m_5711_();
            bh = this.variantPrevButton.m_93694_();
            if (scaledMouseX >= (double)bx && scaledMouseX <= (double)(bx + bw) && scaledMouseY >= (double)by && scaledMouseY <= (double)(by + bh) && this.variantPrevButton.m_6375_(scaledMouseX, scaledMouseY, button)) {
                return true;
            }
        }
        if (this.variantNextButton != null && this.variantNextButton.f_93624_ && this.variantNextButton.f_93623_) {
            bx = this.variantNextButton.m_252754_();
            by = this.variantNextButton.m_252907_();
            bw = this.variantNextButton.m_5711_();
            bh = this.variantNextButton.m_93694_();
            if (scaledMouseX >= (double)bx && scaledMouseX <= (double)(bx + bw) && scaledMouseY >= (double)by && scaledMouseY <= (double)(by + bh) && this.variantNextButton.m_6375_(scaledMouseX, scaledMouseY, button)) {
                return true;
            }
        }
        if (button == 0) {
            int ax = this.benefitChipsAreaX;
            int ay = this.benefitChipsAreaY;
            int aw = this.benefitChipsAreaW;
            int ah = this.benefitChipsAreaH;
            if (scaledMouseX >= (double)ax && scaledMouseX <= (double)(ax + aw) && scaledMouseY >= (double)ay && scaledMouseY <= (double)(ay + ah)) {
                for (int i = 0; i < this.benefitChipRects.size(); ++i) {
                    boolean clickable;
                    int[] r = this.benefitChipRects.get(i);
                    if (r == null || r.length < 4) continue;
                    int rx = r[0];
                    int ry = r[1];
                    int rs = r[2];
                    int idx = r[3];
                    if (!(scaledMouseX >= (double)rx) || !(scaledMouseX <= (double)(rx + rs)) || !(scaledMouseY >= (double)ry) || !(scaledMouseY <= (double)(ry + rs))) continue;
                    boolean bl = r.length >= 5 ? r[4] == 1 : (clickable = false);
                    if (!clickable) {
                        return true;
                    }
                    boolean currentlyDisabled = ClientProgressionData.isGlobalBenefitDisabled(idx);
                    boolean newDisabled = !currentlyDisabled;
                    ClientProgressionData.setGlobalBenefitDisabledLocally(idx, newDisabled);
                    PacketHandler.sendGlobalBenefitToggle(idx, newDisabled);
                    try {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return true;
                }
            }
        }
        return super.m_6375_(scaledMouseX, scaledMouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        float scalingFactor = this.getScalingFactor();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        double scaledMouseX = (mouseX - (double)centerX) / (double)scalingFactor + (double)centerX;
        double scaledMouseY = (mouseY - (double)centerY) / (double)scalingFactor + (double)centerY;
        return super.m_6348_(scaledMouseX, scaledMouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        float scalingFactor = this.getScalingFactor();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        double scaledMouseX = (mouseX - (double)centerX) / (double)scalingFactor + (double)centerX;
        double scaledMouseY = (mouseY - (double)centerY) / (double)scalingFactor + (double)centerY;
        double scaledDragX = dragX / (double)scalingFactor;
        double scaledDragY = dragY / (double)scalingFactor;
        return super.m_7979_(scaledMouseX, scaledMouseY, button, scaledDragX, scaledDragY);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        float scalingFactor = this.getScalingFactor();
        float centerX = (float)this.f_96543_ / 2.0f;
        float centerY = (float)this.f_96544_ / 2.0f;
        double scaledMouseX = (mouseX - (double)centerX) / (double)scalingFactor + (double)centerX;
        double scaledMouseY = (mouseY - (double)centerY) / (double)scalingFactor + (double)centerY;
        if (this.benefitChipsScrollable) {
            int ax = this.benefitChipsAreaX;
            int ay = this.benefitChipsAreaY;
            int aw = this.benefitChipsAreaW;
            int ah = this.benefitChipsAreaH;
            if (scaledMouseX >= (double)ax && scaledMouseX <= (double)(ax + aw) && scaledMouseY >= (double)ay && scaledMouseY <= (double)(ay + ah)) {
                int step = Math.max(2, this.benefitChipSizeUsed + 3);
                int deltaPx = (int)Math.round(-delta * (double)step);
                this.benefitChipScrollPx = Math.max(0, Math.min(this.benefitChipsMaxOffset, this.benefitChipScrollPx + deltaPx));
                return true;
            }
        }
        return super.m_6050_(scaledMouseX, scaledMouseY, delta);
    }

    private void renderGlobalBenefitChipsBelowList(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        try {
            int available;
            if (!Config.enableProgressionSystem) {
                return;
            }
            String mode = Config.progressionSystemType;
            if (!"ranks".equals(mode)) {
                return;
            }
            if (this.monsterList == null) {
                return;
            }
            List<Integer> thresholds = Config.globalSRankThresholds != null && !Config.globalSRankThresholds.isEmpty() ? Config.globalSRankThresholds : List.of(Integer.valueOf(50));
            List<String> defs = Config.globalBenefits;
            if (defs == null || defs.isEmpty() || thresholds == null || thresholds.isEmpty()) {
                return;
            }
            int sCount = 0;
            int xCount = 0;
            for (MonsterEntry m : this.filteredMonsters) {
                if (m.entityType() == null) continue;
                String r = ClientProgressionData.getRank(m.entityType());
                if (RankUtils.compareRanks(r, "S") >= 0) {
                    ++sCount;
                }
                if (!"X".equals(r)) continue;
                ++xCount;
            }
            String desiredType = currentGlobalRankBarType != null ? currentGlobalRankBarType : Config.globalRankProgressBarType;
            boolean showX = "X".equalsIgnoreCase(desiredType);
            int count = showX ? xCount : sCount;
            int activeIdx = -1;
            int i = 0;
            while (i < thresholds.size() && count >= thresholds.get(i)) {
                activeIdx = i++;
            }
            ArrayList<Integer> chipIndexes = new ArrayList<Integer>();
            ArrayList<String> chipDefs = new ArrayList<String>();
            int maxIdx = Math.min(thresholds.size(), defs.size());
            for (int i2 = 0; i2 < maxIdx; ++i2) {
                String trimmed;
                String def = defs.get(i2);
                if (def == null || (trimmed = def.trim()).isEmpty() || "-".equals(trimmed) || "skip".equalsIgnoreCase(trimmed) || "none".equalsIgnoreCase(trimmed)) continue;
                chipIndexes.add(i2);
                chipDefs.add(trimmed);
            }
            if (chipIndexes.isEmpty()) {
                return;
            }
            int nextUnlockIdx = -1;
            for (int i3 = 0; i3 < chipIndexes.size(); ++i3) {
                int origIdx = (Integer)chipIndexes.get(i3);
                if (origIdx <= activeIdx) continue;
                nextUnlockIdx = origIdx;
                break;
            }
            int listX = this.monsterList.m_252754_();
            int listY = this.monsterList.m_252907_();
            int listW = this.monsterList.m_5711_();
            int listH = this.monsterList.m_93694_();
            int barTotalWidth = listW - 12;
            int barX = listX + 6;
            int visibleX = barX + 5;
            int visibleW = Math.max(0, barTotalWidth - 10);
            int chipSize = 16;
            int spacing = 3;
            int total = chipIndexes.size();
            int totalWidth = total * chipSize + Math.max(0, total - 1) * spacing;
            boolean needScroll = totalWidth > (available = visibleW);
            int maxOffset = Math.max(0, totalWidth - available);
            if (!needScroll) {
                this.benefitChipScrollPx = 0;
            } else {
                if (this.benefitChipScrollPx < 0) {
                    this.benefitChipScrollPx = 0;
                }
                if (this.benefitChipScrollPx > maxOffset) {
                    this.benefitChipScrollPx = maxOffset;
                }
            }
            this.benefitChipSizeUsed = chipSize;
            int chipY = listY + listH + 4;
            this.benefitChipsAreaX = visibleX;
            this.benefitChipsAreaY = chipY;
            this.benefitChipsAreaW = available;
            this.benefitChipsAreaH = chipSize;
            this.benefitChipsScrollable = needScroll;
            this.benefitChipsMaxOffset = maxOffset;
            int startX = needScroll ? visibleX - this.benefitChipScrollPx : visibleX + Math.max(0, (available - totalWidth) / 2);
            this.benefitChipRects.clear();
            for (int ci = 0; ci < total; ++ci) {
                int need;
                String idStr;
                ResourceLocation rid;
                int lastColon;
                int border;
                int bg;
                int idx = (Integer)chipIndexes.get(ci);
                String def = (String)chipDefs.get(ci);
                int cx = startX + ci * (chipSize + spacing);
                int cy = chipY;
                if (needScroll && (cx + chipSize <= visibleX || cx >= visibleX + available)) continue;
                boolean isActive = idx <= activeIdx;
                boolean isDisabled = ClientProgressionData.isGlobalBenefitDisabled(idx);
                if (isActive && isDisabled) {
                    bg = -7661030;
                    border = -43691;
                } else if (isActive) {
                    bg = -13730510;
                    border = -10044566;
                } else {
                    bg = -14013910;
                    border = -10066330;
                }
                guiGraphics.m_280509_(cx, cy, cx + chipSize, cy + chipSize, bg);
                guiGraphics.m_280509_(cx, cy, cx + chipSize, cy + 1, border);
                guiGraphics.m_280509_(cx, cy + chipSize - 1, cx + chipSize, cy + chipSize, border);
                guiGraphics.m_280509_(cx, cy, cx + 1, cy + chipSize, border);
                guiGraphics.m_280509_(cx + chipSize - 1, cy, cx + chipSize, cy + chipSize, border);
                if (idx == nextUnlockIdx) {
                    int gold = -1656832;
                    guiGraphics.m_280509_(cx, cy, cx + chipSize, cy + 1, gold);
                    guiGraphics.m_280509_(cx, cy + chipSize - 1, cx + chipSize, cy + chipSize, gold);
                    guiGraphics.m_280509_(cx, cy, cx + 1, cy + chipSize, gold);
                    guiGraphics.m_280509_(cx + chipSize - 1, cy, cx + chipSize, cy + chipSize, gold);
                }
                if ((lastColon = def.lastIndexOf(58)) > 0 && lastColon < def.length() - 1 && (rid = ResourceLocation.m_135820_((String)(idStr = def.substring(0, lastColon)))) != null) {
                    MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(rid);
                    if (effect != null) {
                        int ix = cx + (chipSize - 16) / 2;
                        int iy = cy + (chipSize - 16) / 2;
                        if (!isActive || isDisabled) {
                            RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
                        }
                        guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42589_), ix, iy);
                        if (!isActive || isDisabled) {
                            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                        }
                    } else {
                        Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(rid);
                        if (attr != null) {
                            String ap = rid.m_135815_();
                            Item itemIcon = "generic.max_health".equals(ap) ? Items.f_42436_ : ("generic.movement_speed".equals(ap) ? Items.f_42463_ : ("generic.attack_damage".equals(ap) ? Items.f_42383_ : ("generic.armor".equals(ap) ? Items.f_42469_ : ("generic.attack_speed".equals(ap) ? Items.f_42402_ : ("generic.knockback_resistance".equals(ap) ? Items.f_42740_ : ("generic.luck".equals(ap) ? Items.f_42616_ : Items.f_42516_))))));
                            int ix2 = cx + (chipSize - 16) / 2;
                            int iy2 = cy + (chipSize - 16) / 2;
                            if (!isActive || isDisabled) {
                                RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
                            }
                            guiGraphics.m_280480_(new ItemStack((ItemLike)itemIcon), ix2, iy2);
                            if (!isActive || isDisabled) {
                                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            }
                        } else {
                            int ix3 = cx + (chipSize - 16) / 2;
                            int iy3 = cy + (chipSize - 16) / 2;
                            if (!isActive || isDisabled) {
                                RenderSystem.setShaderColor((float)0.4f, (float)0.4f, (float)0.4f, (float)1.0f);
                            }
                            guiGraphics.m_280480_(new ItemStack((ItemLike)Items.f_42516_), ix3, iy3);
                            if (!isActive || isDisabled) {
                                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                            }
                        }
                    }
                }
                this.benefitChipRects.add(new int[]{cx, cy, chipSize, idx, isActive ? 1 : 0});
                if (mouseX < cx || mouseX > cx + chipSize || mouseY < cy || mouseY > cy + chipSize) continue;
                ArrayList<MutableComponent> lines = new ArrayList<MutableComponent>();
                Object displayText = def;
                boolean hasDisplay = false;
                int lc = def.lastIndexOf(58);
                if (lc > 0 && lc < def.length() - 1) {
                    String idStr2 = def.substring(0, lc);
                    String valueStr = def.substring(lc + 1);
                    ResourceLocation rid2 = ResourceLocation.m_135820_((String)idStr2);
                    if (rid2 != null) {
                        MobEffect effect2 = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(rid2);
                        if (effect2 != null) {
                            int lvl;
                            String name = Component.m_237115_((String)effect2.m_19481_()).getString();
                            try {
                                lvl = Integer.parseInt(valueStr.trim());
                            }
                            catch (Exception ex) {
                                lvl = 0;
                            }
                            displayText = name + " " + lvl;
                            hasDisplay = true;
                        } else {
                            Attribute attr2 = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(rid2);
                            if (attr2 != null) {
                                String ap2;
                                String seg = ap2 = rid2.m_135815_();
                                int dotIdx = ap2.lastIndexOf(46);
                                if (dotIdx >= 0 && dotIdx < ap2.length() - 1) {
                                    seg = ap2.substring(dotIdx + 1);
                                }
                                String[] partsWords = seg.split("_");
                                StringBuilder fb = new StringBuilder();
                                for (String w : partsWords) {
                                    if (w == null || w.isEmpty()) continue;
                                    if (fb.length() > 0) {
                                        fb.append(' ');
                                    }
                                    char first = w.charAt(0);
                                    fb.append(Character.toUpperCase(first));
                                    if (w.length() <= 1) continue;
                                    fb.append(w.substring(1));
                                }
                                String friendly = fb.toString();
                                displayText = valueStr + " " + friendly;
                                hasDisplay = true;
                            }
                        }
                    }
                }
                if (!hasDisplay) {
                    Object object = displayText = def.isEmpty() ? "" : def;
                }
                if (!((String)displayText).isEmpty()) {
                    lines.add(Component.m_237113_((String)displayText));
                }
                String typ = showX ? "X" : "S";
                int n = need = idx >= 0 && idx < thresholds.size() ? thresholds.get(idx) : 0;
                String stateKey = isActive && isDisabled ? "screen.araxers_bestiary.benefit.state.disabled" : (isActive ? "screen.araxers_bestiary.benefit.state.active" : (idx == nextUnlockIdx ? "screen.araxers_bestiary.benefit.state.available" : "screen.araxers_bestiary.benefit.state.locked"));
                MutableComponent stateComp = Component.m_237115_((String)stateKey);
                lines.add(Component.m_237110_((String)"screen.araxers_bestiary.benefit.state_line", (Object[])new Object[]{stateComp, typ, need}));
                guiGraphics.m_280666_(this.f_96547_, lines, mouseX, mouseY);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static /* synthetic */ Font access$300(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$400(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$500(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$600(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$700(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$800(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$900(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1000(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1100(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1200(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1300(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1400(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1500(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1600(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1700(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1800(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$1900(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$2000(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$8300(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$8400(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$8500(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    static /* synthetic */ Font access$8600(BestiaryScreen x0) {
        return x0.f_96547_;
    }

    private class MonsterListWidget
    extends AbstractWidget {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private List<MonsterEntry> entries;
        private int scrollOffset;
        private final int entryHeight;
        private boolean isDragging;
        private final Map<String, Integer> nameWidthCache;

        public MonsterListWidget(int x, int y, int width, int height, List<MonsterEntry> entries) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.scrollOffset = 0;
            this.isDragging = false;
            this.nameWidthCache = new HashMap<String, Integer>();
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
            this.entries = new ArrayList<MonsterEntry>(entries);
            this.entryHeight = 24;
        }

        public void updateEntries(List<MonsterEntry> newEntries) {
            this.entries = new ArrayList<MonsterEntry>(newEntries);
            this.scrollOffset = 0;
            this.nameWidthCache.clear();
        }

        private void drawMarqueeText(GuiGraphics guiGraphics, String text, int textX, int textY, int color, int clipWidth) {
            float phase;
            float pxPerSec;
            float periodMs;
            if (text == null) {
                return;
            }
            int maxWidth = Math.max(0, clipWidth);
            if (maxWidth <= 0) {
                return;
            }
            int textWidth = this.nameWidthCache.computeIfAbsent(text, k -> BestiaryScreen.this.f_96547_.m_92895_(k));
            if (textWidth <= maxWidth) {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, text, textX, textY, color, false);
                return;
            }
            int scLeft = textX;
            int scTop = textY - 1;
            int scRight = textX + maxWidth;
            Objects.requireNonNull(BestiaryScreen.this.f_96547_);
            int scBottom = textY + 9 + 1;
            BestiaryScreen.this.enableScaledScissor(guiGraphics, scLeft, scTop, scRight, scBottom);
            long nowMs = System.currentTimeMillis();
            float extra = textWidth - maxWidth;
            if (extra < 1.0f) {
                extra = 1.0f;
            }
            if ((periodMs = 2.0f * extra / Math.max(1.0f, pxPerSec = 7.0f) * 1000.0f) < 1.0f) {
                periodMs = 1.0f;
            }
            float tri = (phase = (float)(nowMs % (long)periodMs) / periodMs) < 0.5f ? phase * 2.0f : 2.0f - phase * 2.0f;
            float offsetPx = tri * extra;
            int dx = -Math.round(offsetPx);
            guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, text, textX + dx, textY, color, false);
            guiGraphics.m_280618_();
        }

        public static String getModNameFromModId(String modId) {
            if (ModList.get().isLoaded(modId)) {
                return ModList.get().getModContainerById(modId).map(modContainer -> modContainer.getModInfo().getDisplayName()).orElse(modId);
            }
            return modId;
        }

        /*
         * Unable to fully structure code
         */
        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)BestiaryScreen.TEXTURE);
            guiGraphics.m_280163_(BestiaryScreen.TEXTURE, this.x, this.y, 0.0f, 0.0f, this.width, this.height, 512, 512);
            visibleEntries = this.height / this.entryHeight;
            startIndex = this.scrollOffset;
            endIndex = Math.min(startIndex + visibleEntries, this.entries.size());
            for (i = startIndex; i < endIndex; ++i) {
                block75: {
                    entry = this.entries.get(i);
                    entryY = this.y + (i - startIndex) * this.entryHeight;
                    isSelected = entry == BestiaryScreen.this.selectedMonster || BestiaryScreen.this.selectedMonster != null && entry != null && entry.entityType() != null && BestiaryScreen.this.selectedMonster.entityType() != null && entry.entityType() == BestiaryScreen.this.selectedMonster.entityType();
                    isHovered = this.isMouseOverEntry(mouseX + 10, mouseY, entryY);
                    if (isSelected) {
                        guiGraphics.m_280163_(BestiaryScreen.TEXTURE, this.x + 2, entryY + 2, 0.0f, 260.0f, this.width - 10, this.entryHeight, 512, 512);
                    } else if (isHovered) {
                        guiGraphics.m_280163_(BestiaryScreen.TEXTURE, this.x + 2, entryY + 2, 0.0f, 290.0f, this.width - 10, this.entryHeight, 512, 512);
                    }
                    displayName = entry.name();
                    nameColor = 0;
                    shouldHideInfo = false;
                    if (entry.entityType() != null) {
                        isDiscovered = BestiaryScreen.this.isEntityDiscovered(entry.entityType());
                        if (!isDiscovered || Config.forceObfuscation && !isDiscovered) {
                            shouldHideInfo = true;
                        } else if (ClientProgressionData.isPartiallyDiscovered(entry.entityType()) && Config.enableProgressionSystem) {
                            shouldHideInfo = true;
                        } else if ("kills".equals(Config.progressionSystemType) && !Config.hideZeroKillEntities || "ranks".equals(Config.progressionSystemType) && !Config.hideNoRankEntities) {
                            shouldHideInfo = false;
                        }
                    }
                    if (shouldHideInfo) {
                        displayName = Component.m_237115_((String)"screen.araxers_bestiary.unknown");
                        nameColor = 0x888888;
                    }
                    if (!(!(rawDisplay = displayName.getString()).contains(".") && !rawDisplay.contains(":") || rawDisplay.contains(")") && rawDisplay.contains("("))) {
                        parts = rawDisplay.split("[\\.:]");
                        split = parts[parts.length - 1];
                        name = new StringBuilder();
                        nextUpper = true;
                        for (char c : split.toCharArray()) {
                            if (c == '_') {
                                name.append(' ');
                                nextUpper = true;
                                continue;
                            }
                            name.append(nextUpper != false ? Character.toUpperCase(c) : c);
                            nextUpper = false;
                        }
                        entityNameText = name.toString();
                    } else {
                        entityNameText = rawDisplay;
                    }
                    if (entry.entityType() != null && ClientProgressionData.isNewlyDiscovered(entry.entityType())) {
                        nameWidth = BestiaryScreen.access$300(BestiaryScreen.this).m_92852_((FormattedText)entry.name());
                        guiGraphics.m_280168_().m_85836_();
                        textX = this.x + 2;
                        textY = entryY + 2;
                        guiGraphics.m_280168_().m_252880_((float)textX, (float)textY, 0.0f);
                        guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(BestiaryScreen.this.newTextRotation));
                        guiGraphics.m_280168_().m_252880_(0.0f, BestiaryScreen.this.newTextBounceOffset, 0.0f);
                        guiGraphics.m_280056_(BestiaryScreen.access$400(BestiaryScreen.this), Component.m_237115_((String)"screen.araxers_bestiary.new_indicator").getString(), 0, 0, 0xFFFF00, false);
                        guiGraphics.m_280168_().m_85849_();
                    }
                    if (entry.entityType() != null) {
                        nameWidth = BestiaryScreen.access$500(BestiaryScreen.this).m_92852_((FormattedText)entry.name());
                        nameX = this.x + 5;
                        nameY = entryY + 10;
                        Objects.requireNonNull(BestiaryScreen.access$600(BestiaryScreen.this));
                        nameHeight = 9;
                        v0 = isHoveringOverName = mouseX >= nameX && mouseX <= nameX + nameWidth && mouseY >= nameY && mouseY <= nameY + nameHeight;
                        if (isHoveringOverName && (entityId = ForgeRegistries.ENTITY_TYPES.getKey(entry.entityType())) != null) {
                            modName = MonsterListWidget.getModNameFromModId(entityId.m_135827_());
                            guiGraphics.m_280557_(BestiaryScreen.access$700(BestiaryScreen.this), (Component)Component.m_237113_((String)modName), mouseX, mouseY);
                        }
                    }
                    if ("sighting".equals(Config.progressionSystemType) && (BestiaryScreen.listTextMode == null || BestiaryScreen.listTextMode == ListTextMode.HIDE)) continue;
                    rightTextStartX = this.x + this.width - 20;
                    v1 = hasProgress = Config.enableProgressionSystem != false && entry.entityType() != null && BestiaryScreen.this.killCounts.containsKey(entry.entityType()) != false;
                    if (!hasProgress) break block75;
                    killCount = BestiaryScreen.this.killCounts.getOrDefault(entry.entityType(), 0);
                    v2 = suppressRightText = BestiaryScreen.listTextMode == ListTextMode.HIDE;
                    isRankSystem = BestiaryScreen.listTextMode == null ? "ranks".equals(Config.progressionSystemType) : (BestiaryScreen.listTextMode == ListTextMode.HIDE ? "ranks".equals(Config.progressionSystemType) : BestiaryScreen.listTextMode == ListTextMode.RANK);
                    shouldHideInfo = ClientProgressionData.isPartiallyDiscovered(entry.entityType()) != false && Config.enableProgressionSystem != false;
                    isDiscovered = BestiaryScreen.this.isEntityDiscovered(entry.entityType());
                    if (!isDiscovered && Config.forceObfuscation) {
                        shouldHideInfo = true;
                    } else if (!Config.hideUndiscovered && !isDiscovered) {
                        shouldHideInfo = true;
                    } else if (isRankSystem && !Config.hideNoRankEntities || !isRankSystem && !Config.hideZeroKillEntities) {
                        shouldHideInfo = false;
                    }
                    sighted = Component.m_237115_((String)"screen.araxers_bestiary.sighted").getString();
                    if (isRankSystem) {
                        if (shouldHideInfo) {
                            displayText = ClientProgressionData.getRank(entry.entityType()).equals("") && !ClientProgressionData.isPartiallyDiscovered(entry.entityType()) ? Component.m_237115_((String)"screen.araxers_bestiary.unknown_short").getString() : sighted;
                        } else {
                            rank = ClientProgressionData.getRank(entry.entityType());
                            displayText = rank;
                            if (displayText == null || displayText.isEmpty()) {
                                displayText = ClientProgressionData.getRank(entry.entityType()).equals("") && !ClientProgressionData.isPartiallyDiscovered(entry.entityType()) ? Component.m_237115_((String)"screen.araxers_bestiary.unknown_short").getString() : sighted;
                            }
                        }
                    } else {
                        displayText = shouldHideInfo != false ? Component.m_237115_((String)"screen.araxers_bestiary.defeats_unknown").getString() : String.valueOf(killCount);
                    }
                    setShadow = false;
                    if (shouldHideInfo) {
                        textColor = 0x888888;
                    } else if (isRankSystem) {
                        var29_73 = rank = ClientProgressionData.getRank(entry.entityType());
                        var30_77 = -1;
                        switch (var29_73.hashCode()) {
                            case 88: {
                                if (!var29_73.equals("X")) break;
                                var30_77 = 0;
                                break;
                            }
                            case 83: {
                                if (!var29_73.equals("S")) break;
                                var30_77 = 1;
                                break;
                            }
                            case 65: {
                                if (!var29_73.equals("A")) break;
                                var30_77 = 2;
                                break;
                            }
                            case 66: {
                                if (!var29_73.equals("B")) break;
                                var30_77 = 3;
                                break;
                            }
                            case 67: {
                                if (!var29_73.equals("C")) break;
                                var30_77 = 4;
                                break;
                            }
                            case 68: {
                                if (!var29_73.equals("D")) break;
                                var30_77 = 5;
                                break;
                            }
                            case 69: {
                                if (!var29_73.equals("E")) break;
                                var30_77 = 6;
                            }
                        }
                        switch (var30_77) {
                            case 0: {
                                v3 = 0xAA1111;
                                break;
                            }
                            case 1: {
                                v3 = 0xFFFF55;
                                break;
                            }
                            case 2: {
                                v3 = 16717267;
                                break;
                            }
                            case 3: {
                                v3 = 16716629;
                                break;
                            }
                            case 4: {
                                v3 = 305919;
                                break;
                            }
                            case 5: {
                                v3 = 0x55FF55;
                                break;
                            }
                            case 6: {
                                v3 = 0xEEEEEE;
                                break;
                            }
                            default: {
                                v3 = 0x888888;
                            }
                        }
                        textColor = v3;
                        setShadow = true;
                    } else {
                        textColor = "kills".equals(Config.progressionSystemType) ? (killCount >= Config.lootChanceThreshold ? 43520 : (killCount >= Config.lootIconThreshold ? 0xFFFF00 : (killCount >= Config.spawnLocationThreshold ? 16753920 : 0xFF0000))) : 0;
                    }
                    if (suppressRightText) break block75;
                    textX = this.x + this.width - BestiaryScreen.access$800(BestiaryScreen.this).m_92895_(displayText) - 20;
                    textY = entryY + 10;
                    rightTextStartX = textX;
                    if ("kills".equals(Config.progressionSystemType) || displayText.equals(sighted) || displayText.equals("?")) {
                        guiGraphics.m_280056_(BestiaryScreen.access$900(BestiaryScreen.this), displayText, textX, textY, textColor, false);
                    } else {
                        guiGraphics.m_280056_(BestiaryScreen.access$1000(BestiaryScreen.this), displayText, textX, textY, textColor, setShadow);
                    }
                    if (mouseX < textX || mouseX > textX + BestiaryScreen.access$1100(BestiaryScreen.this).m_92895_(displayText) || mouseY < textY) ** GOTO lbl-1000
                    Objects.requireNonNull(BestiaryScreen.access$1200(BestiaryScreen.this));
                    if (mouseY <= textY + 9) {
                        v4 = true;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v4 = isHoveringText = false;
                    }
                    if (isHoveringText) {
                        if (isRankSystem) {
                            if (!displayText.equals(sighted)) {
                                guiGraphics.m_280557_(BestiaryScreen.access$1300(BestiaryScreen.this), (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.defeats", (Object[])new Object[]{killCount}), mouseX, mouseY);
                            } else {
                                guiGraphics.m_280557_(BestiaryScreen.access$1400(BestiaryScreen.this), (Component)Component.m_237115_((String)"screen.araxers_bestiary.tooltip.sighted"), mouseX, mouseY);
                            }
                        } else if (!shouldHideInfo) {
                            guiGraphics.m_280557_(BestiaryScreen.access$1500(BestiaryScreen.this), (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.defeats", (Object[])new Object[]{killCount}), mouseX, mouseY);
                        }
                    }
                }
                nameX = this.x + 5;
                nameY = entryY + 10;
                clipWidth = Math.max(1, rightTextStartX - nameX - 4);
                this.drawMarqueeText(guiGraphics, entityNameText, nameX, nameY, nameColor, clipWidth);
            }
            if (this.entries.size() > visibleEntries) {
                scrollbarWidth = 6;
                scrollbarX = this.x + this.width - scrollbarWidth - 2;
                scrollbarHeight = (int)((double)this.height * 0.9);
                scrollbarY = this.y + (this.height - scrollbarHeight) / 2;
                guiGraphics.m_280163_(BestiaryScreen.TEXTURE, scrollbarX, scrollbarY, 180.0f, 160.0f, scrollbarWidth, scrollbarHeight, 512, 512);
                contentRatio = (float)visibleEntries / (float)this.entries.size();
                minThumbHeight = 20;
                thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                scrollRatio = (float)this.scrollOffset / (float)Math.max(1, this.entries.size() - visibleEntries);
                thumbY = scrollbarY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                hoveringOverScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                thumbColor = this.isDragging != false || hoveringOverScrollbar != false ? -594735 : -1784461;
                guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
            }
            if (Config.enableProgressionSystem && ("ranks".equals(Config.progressionSystemType) || "sighting".equals(Config.progressionSystemType))) {
                ranksMode = "ranks".equals(Config.progressionSystemType);
                sightingMode = "sighting".equals(Config.progressionSystemType);
                sCount = 0;
                xCount = 0;
                sightCount = 0;
                for (MonsterEntry m : BestiaryScreen.this.monsters) {
                    if (m.entityType() == null) continue;
                    r = ClientProgressionData.getRank(m.entityType());
                    if (RankUtils.compareRanks(r, "S") >= 0) {
                        ++sCount;
                    }
                    if ("X".equals(r)) {
                        ++xCount;
                    }
                    if (!ClientProgressionData.isSpyglassObserved(m.entityType()) && !ClientProgressionData.isFullyDiscovered(m.entityType())) continue;
                    ++sightCount;
                }
                desiredType = BestiaryScreen.currentGlobalRankBarType != null ? BestiaryScreen.currentGlobalRankBarType : Config.globalRankProgressBarType;
                showX = "X".equalsIgnoreCase(desiredType);
                count = showX != false ? xCount : sCount;
                countToUse = sightingMode != false ? sightCount : count;
                thresholds = Config.globalSRankThresholds != null && Config.globalSRankThresholds.isEmpty() == false ? Config.globalSRankThresholds : List.of(Integer.valueOf(50));
                prev = 0;
                next = thresholds.get(0);
                last = thresholds.get(thresholds.size() - 1);
                for (i = 0; i < thresholds.size(); ++i) {
                    t = thresholds.get(i);
                    if (countToUse < t) {
                        next = t;
                        break;
                    }
                    prev = t;
                    next = i + 1 < thresholds.size() ? thresholds.get(i + 1) : t;
                }
                if (countToUse >= last) {
                    ratio = 1.0f;
                    next = last;
                } else {
                    ratio = (float)countToUse / (float)Math.max(1, next);
                }
                barTotalWidth = this.width - 12;
                barX = this.x + 6;
                barY = this.y + this.height - 5 - 6;
                color = sightingMode != false ? 0x55FF55 : (showX != false ? 0xDD2222 : 0x55FF55);
                BestiaryScreen.this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, barTotalWidth, ratio, color);
                hoverBar = mouseX >= barX && mouseX <= barX + barTotalWidth && mouseY >= barY && mouseY <= barY + 5;
                percent = Math.round(ratio * 100.0f);
                if (!hoverBar) {
                    percentText = percent + "%";
                    textW = BestiaryScreen.access$1600(BestiaryScreen.this).m_92895_(percentText);
                    textX = barX + (barTotalWidth - textW) / 2;
                    Objects.requireNonNull(BestiaryScreen.access$1700(BestiaryScreen.this));
                    textY = barY + (5 - 9) / 2;
                    outlineColor = 0;
                    for (dx = -1; dx <= 1; ++dx) {
                        for (dy = -1; dy <= 1; ++dy) {
                            if (dx == 0 && dy == 0) continue;
                            guiGraphics.m_280056_(BestiaryScreen.access$1800(BestiaryScreen.this), percentText, textX + dx, textY + dy, outlineColor, false);
                        }
                    }
                    guiGraphics.m_280056_(BestiaryScreen.access$1900(BestiaryScreen.this), percentText, textX, textY, color, false);
                }
                if (hoverBar) {
                    if (sightingMode) {
                        tipComp = Component.m_237110_((String)"screen.araxers_bestiary.global_bar.tooltip.sighted", (Object[])new Object[]{countToUse, next});
                    } else {
                        key = showX != false ? "screen.araxers_bestiary.global_bar.tooltip.x_ranks" : "screen.araxers_bestiary.global_bar.tooltip.s_ranks";
                        tipComp = Component.m_237110_((String)key, (Object[])new Object[]{count, next});
                    }
                    guiGraphics.m_280557_(BestiaryScreen.access$2000(BestiaryScreen.this), (Component)tipComp, mouseX, mouseY);
                }
            }
            guiGraphics.m_280168_().m_85849_();
        }

        private boolean isMouseOverEntry(int mouseX, int mouseY, int entryY) {
            return mouseX >= this.x && mouseX < this.x + this.width && mouseY >= entryY && mouseY < entryY + this.entryHeight;
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            if (this.entries.size() > this.height / this.entryHeight) {
                int scrollbarWidth = 6;
                int scrollbarX = this.x + this.width - scrollbarWidth - 2;
                int scrollbarHeight = (int)((double)this.height * 0.9);
                int scrollbarY = this.y + (this.height - scrollbarHeight) / 2;
                if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)scrollbarY && mouseY < (double)(scrollbarY + scrollbarHeight)) {
                    this.isDragging = true;
                    return true;
                }
            }
            if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width - 10) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height)) {
                boolean inBar;
                int barTotalWidth = this.width - 12;
                int barX = this.x + 6;
                int barTop = this.y + this.height - 5 - 6;
                int barBottom = barTop + 5;
                boolean bl = inBar = mouseX >= (double)barX && mouseX <= (double)(barX + barTotalWidth) && mouseY >= (double)barTop && mouseY <= (double)barBottom;
                if (inBar) {
                    if ("ranks".equals(Config.progressionSystemType)) {
                        if (Config.enableGlobalRankProgressBarCycling) {
                            String after;
                            int xCount = 0;
                            for (MonsterEntry m : BestiaryScreen.this.monsters) {
                                String r;
                                if (m.entityType() == null || !"X".equals(r = ClientProgressionData.getRank(m.entityType()))) continue;
                                ++xCount;
                            }
                            String before = currentGlobalRankBarType != null ? currentGlobalRankBarType : Config.globalRankProgressBarType;
                            boolean defaultIsS = "S".equalsIgnoreCase(Config.globalRankProgressBarType);
                            if (defaultIsS && "S".equalsIgnoreCase(before) && xCount == 0) {
                                return true;
                            }
                            currentGlobalRankBarType = after = "S".equalsIgnoreCase(before) ? "X" : "S";
                            Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
                            return true;
                        }
                        return true;
                    }
                    return "sighting".equals(Config.progressionSystemType);
                }
                int visibleEntries = this.height / this.entryHeight;
                int clickedIndex = this.scrollOffset + (int)((mouseY - (double)this.y) / (double)this.entryHeight);
                if (clickedIndex >= 0 && clickedIndex < this.entries.size()) {
                    boolean isNewSelection;
                    MonsterEntry clicked = this.entries.get(clickedIndex);
                    EntityType<?> selectedType = BestiaryScreen.this.selectedMonster != null ? BestiaryScreen.this.selectedMonster.entityType() : null;
                    EntityType<?> clickedType = clicked != null ? clicked.entityType() : null;
                    boolean bl2 = isNewSelection = clickedType != null && (selectedType == null || !clickedType.equals(selectedType));
                    if (isNewSelection) {
                        Minecraft.m_91087_().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119752_((SoundEvent)SoundEvents.f_11713_, (float)1.0f));
                    }
                    BestiaryScreen.this.selectMonster(clicked);
                    return true;
                }
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isDragging = false;
            return super.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.isDragging && this.entries.size() > this.height / this.entryHeight) {
                int scrollbarHeight = (int)((double)this.height * 0.9);
                int scrollbarY = this.y + (this.height - scrollbarHeight) / 2;
                float scrollRatio = mouseY < (double)scrollbarY ? 0.0f : (mouseY > (double)(scrollbarY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)scrollbarY) / (float)scrollbarHeight);
                this.scrollOffset = (int)(scrollRatio * (float)this.entries.size());
                this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.entries.size() - this.height / this.entryHeight));
                return true;
            }
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.width) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.height) && this.entries.size() > this.height / this.entryHeight) {
                this.scrollOffset -= (int)delta;
                this.scrollOffset = Math.max(0, Math.min(this.scrollOffset, this.entries.size() - this.height / this.entryHeight));
                return true;
            }
            return false;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)"narration.araxers_bestiary.monster_list"));
        }

        public int m_252754_() {
            return this.x;
        }

        public int m_252907_() {
            return this.y;
        }

        public int m_5711_() {
            return this.width;
        }

        public int m_93694_() {
            return this.height;
        }
    }

    private static enum TabType {
        LOOT,
        LOCATIONS,
        ATTRIBUTES;

    }

    private static enum ListTextMode {
        RANK,
        KILLS,
        HIDE;

    }

    private class EntityViewWidget
    extends AbstractWidget {
        private final int x;
        private final int y;
        private final int size;
        private Entity renderedEntity;
        private MonsterEntry displayedMonster;
        private float rotationYaw;
        private float rotationPitch;
        private float autoRotationSpeed;
        private boolean isDragging;
        private boolean isDraggingScrollbar;
        private int lastMouseX;
        private int lastMouseY;
        private boolean showDescription;
        private Button infoButton;
        private int descriptionScrollOffset;
        private List<String> descriptionLines;
        private int lastDescWrapWidth;
        private Long lastGameTime;
        private float zoom;
        private static final float MIN_ZOOM = 0.5f;
        private static final float MAX_ZOOM = 2.0f;
        private List<ResourceLocation> variantTextures;
        private int currentVariantIndex;
        private VariantController variantController;
        private List<Integer> variantIndexMap;

        private boolean isEntityBoss() {
            if (this.renderedEntity == null) {
                LOGGER.debug("isEntityBoss check failed: renderedEntity is null");
                return false;
            }
            if (this.displayedMonster != null && this.displayedMonster.boss()) {
                return true;
            }
            boolean hasBossBar = EntityViewWidget.hasBossBar(this.renderedEntity);
            return hasBossBar;
        }

        public static boolean hasBossBar(Entity entity) {
            block27: {
                if (entity == null) {
                    return false;
                }
                try {
                    if (RankUtils.isBossEntity(entity)) {
                        return true;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                try {
                    Class<?> cls2 = entity.getClass();
                    Method m = cls2.getMethod("getBossEvent", new Class[0]);
                    if (m == null) break block27;
                    Object ev = null;
                    try {
                        ev = m.invoke((Object)entity, new Object[0]);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (ev != null) {
                        return true;
                    }
                }
                catch (NoSuchMethodException cls2) {
                }
                catch (Throwable cls2) {
                    // empty catch block
                }
            }
            try {
                Class<?> cls3 = entity.getClass();
                String[] names = new String[]{"getBossBar", "getBossInfo", "getBossOverlay"};
                for (String string : names) {
                    try {
                        Method mm = cls3.getMethod(string, new Class[0]);
                        if (mm == null) continue;
                        Object ev = null;
                        try {
                            ev = mm.invoke((Object)entity, new Object[0]);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        if (ev == null) continue;
                        return true;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable cls3) {
                // empty catch block
            }
            try {
                Class<?> cls = entity.getClass();
                String[] fields = new String[]{"bossEvent", "bossInfo", "bossBar"};
                for (Field field : cls.getFields()) {
                    for (String name : fields) {
                        if (!field.getName().equalsIgnoreCase(name)) continue;
                        try {
                            Object v2 = field.get(entity);
                            if (v2 == null) continue;
                            return true;
                        }
                        catch (Throwable v2) {
                            // empty catch block
                        }
                    }
                }
                for (Field field : cls.getDeclaredFields()) {
                    for (String name : fields) {
                        if (!field.getName().equalsIgnoreCase(name)) continue;
                        try {
                            field.setAccessible(true);
                            Object v = field.get(entity);
                            if (v == null) continue;
                            return true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return false;
        }

        public EntityViewWidget(int x, int y, int size, int size1) {
            super(x, y, size, size1, (Component)Component.m_237119_());
            this.rotationYaw = 0.0f;
            this.rotationPitch = 0.0f;
            this.autoRotationSpeed = 1.0f;
            this.isDragging = false;
            this.isDraggingScrollbar = false;
            this.lastMouseX = 0;
            this.lastMouseY = 0;
            this.showDescription = false;
            this.descriptionScrollOffset = 0;
            this.descriptionLines = new ArrayList<String>();
            this.lastDescWrapWidth = -1;
            this.lastGameTime = null;
            this.zoom = 1.0f;
            this.variantTextures = new ArrayList<ResourceLocation>();
            this.currentVariantIndex = 0;
            this.variantController = null;
            this.variantIndexMap = new ArrayList<Integer>();
            this.x = x;
            this.y = y;
            this.size = size;
            this.infoButton = new Button.Builder((Component)Component.m_237113_((String)"i"), button -> {
                this.showDescription = !this.showDescription;
            }).m_252794_(0, 0).m_253046_(20, 20).m_253136_();
            this.infoButton.f_93624_ = false;
            BestiaryScreen.this.m_142416_((GuiEventListener)this.infoButton);
        }

        public void setEntity(EntityType<?> entityType, MonsterEntry monster) {
            this.disposeRenderedEntity();
            this.displayedMonster = monster;
            this.showDescription = false;
            this.descriptionScrollOffset = 0;
            this.descriptionLines.clear();
            this.lastDescWrapWidth = -1;
            this.lastGameTime = null;
            this.zoom = 1.0f;
            if (entityType != null) {
                try {
                    ClientLevel level = Minecraft.m_91087_().f_91073_;
                    if (level != null) {
                        this.renderedEntity = entityType.m_20615_((Level)level);
                        LOGGER.debug("Created entity for rendering: {}", (Object)entityType.m_20675_());
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Failed to create entity for rendering: {}", (Object)e.getMessage());
                }
            }
            this.rebuildVariants();
            int vc = this.getVariantCount();
            if (vc > 0) {
                int idx = vc > 1 ? ThreadLocalRandom.current().nextInt(vc) : 0;
                this.applyVariantByDisplayIndex(idx);
            }
        }

        private VariantController detectVariantController(Entity e) {
            block62: {
                Method m3;
                Method[] cls;
                block61: {
                    block60: {
                        if (e == null) {
                            return null;
                        }
                        cls = e.getClass();
                        try {
                            if (!cls.getSimpleName().contains("Axolotl")) break block60;
                            LOGGER.debug("[Bestiary] Axolotl detection: class=\"{}\" super=\"{}\"", (Object)cls.getName(), (Object)(cls.getSuperclass() != null ? cls.getSuperclass().getName() : "null"));
                            for (Object c = cls; c != null && c != Object.class; c = ((Class)c).getSuperclass()) {
                                try {
                                    Class<?>[] inners = ((Class)c).getDeclaredClasses();
                                    ArrayList<String> innerNames = new ArrayList<String>();
                                    Class<?>[] classArray = inners;
                                    int n = classArray.length;
                                    for (int i = 0; i < n; ++i) {
                                        Class<?> inner = classArray[i];
                                        if (!inner.isEnum()) continue;
                                        innerNames.add(inner.getSimpleName());
                                    }
                                    if (innerNames.isEmpty()) continue;
                                    LOGGER.debug("[Bestiary] Axolotl detection: {} inner-enums={}", (Object)((Class)c).getSimpleName(), innerNames);
                                    continue;
                                }
                                catch (Throwable inners) {
                                    // empty catch block
                                }
                            }
                            try {
                                for (Method m2 : cls.getDeclaredMethods()) {
                                    if (!m2.getName().equals("setVariant") && !m2.getName().equals("setType") || m2.getParameterCount() != 1) continue;
                                    LOGGER.debug("[Bestiary] Axolotl detection: declared method {}({}) on {}", new Object[]{m2.getName(), m2.getParameterTypes()[0].getTypeName(), cls.getSimpleName()});
                                }
                                for (Method m2 : cls.getMethods()) {
                                    if (!m2.getName().equals("setVariant") && !m2.getName().equals("setType") || m2.getParameterCount() != 1) continue;
                                    LOGGER.debug("[Bestiary] Axolotl detection: public method {}({}) from {}", new Object[]{m2.getName(), m2.getParameterTypes()[0].getTypeName(), m2.getDeclaringClass().getSimpleName()});
                                }
                            }
                            catch (Throwable c) {
                            }
                        }
                        catch (Throwable c) {
                            // empty catch block
                        }
                    }
                    try {
                        if ("Cat".equals(cls.getSimpleName())) {
                            m3 = null;
                            for (Method dm : cls.getDeclaredMethods()) {
                                if (dm.getParameterCount() != 1 || dm.getReturnType() != Void.TYPE || !Holder.class.isAssignableFrom(dm.getParameterTypes()[0])) continue;
                                m3 = dm;
                                break;
                            }
                            if (m3 == null) {
                                for (Method pm : cls.getMethods()) {
                                    if (pm.getParameterCount() != 1 || pm.getReturnType() != Void.TYPE || !Holder.class.isAssignableFrom(pm.getParameterTypes()[0])) continue;
                                    m3 = pm;
                                    break;
                                }
                            }
                            if (m3 != null) {
                                m3.setAccessible(true);
                                ArrayList<Object> holders = new ArrayList<Object>();
                                BuiltInRegistries.f_256754_.m_203611_().forEach(h -> holders.add(h));
                                if (holders.size() > 1) {
                                    LOGGER.debug("[Bestiary] Using HolderListVariantController for Cat via {} ({} variants)", (Object)m3.getName(), (Object)holders.size());
                                    return new HolderListVariantController(m3, holders);
                                }
                            }
                        }
                    }
                    catch (Throwable m3) {
                        // empty catch block
                    }
                    try {
                        if (!cls.getSimpleName().contains("Horse")) break block61;
                        m3 = null;
                        try {
                            m3 = cls.getDeclaredMethod("setVariant", Integer.TYPE);
                        }
                        catch (NoSuchMethodException holders) {
                            // empty catch block
                        }
                        if (m3 == null) {
                            try {
                                m3 = cls.getMethod("setVariant", Integer.TYPE);
                            }
                            catch (NoSuchMethodException holders) {
                                // empty catch block
                            }
                        }
                        if (m3 != null) {
                            m3.setAccessible(true);
                            int max = 64;
                            int[] vals = new int[max];
                            for (int i = 0; i < max; ++i) {
                                vals[i] = i;
                            }
                            LOGGER.debug("[Bestiary] Using IntVariantController for Horse-like entity");
                            return new IntVariantController(m3, vals);
                        }
                    }
                    catch (Throwable m4) {
                        // empty catch block
                    }
                }
                try {
                    String[] enumNames = new String[]{"Variant", "Type", "MushroomType", "Marking"};
                    for (Object c = cls; c != null && c != Object.class; c = ((Class)c).getSuperclass()) {
                        Class<?>[] inners;
                        for (Class<?> inner : inners = ((Class)c).getDeclaredClasses()) {
                            if (!inner.isEnum()) continue;
                            String simple = inner.getSimpleName();
                            boolean nameOk = false;
                            for (String en : enumNames) {
                                if (!en.equals(simple)) continue;
                                nameOk = true;
                                break;
                            }
                            if (!nameOk && !simple.endsWith("Variant") && !simple.endsWith("Type") && !simple.endsWith("Marking")) continue;
                            Method chosen = null;
                            for (Method m5 : ((Class)c).getDeclaredMethods()) {
                                if (m5.getParameterCount() != 1 || m5.getParameterTypes()[0] != inner || m5.getReturnType() != Void.TYPE) continue;
                                chosen = m5;
                                break;
                            }
                            if (chosen == null) {
                                for (Method m5 : ((Class)c).getMethods()) {
                                    if (m5.getParameterCount() != 1 || m5.getParameterTypes()[0] != inner || m5.getReturnType() != Void.TYPE) continue;
                                    chosen = m5;
                                    break;
                                }
                            }
                            if (chosen == null) continue;
                            chosen.setAccessible(true);
                            LOGGER.debug("[Bestiary] Using EnumVariantController via {}.{}({})", new Object[]{((Class)c).getSimpleName(), chosen.getName(), inner.getSimpleName()});
                            return new EnumVariantController(inner, chosen);
                        }
                    }
                }
                catch (Throwable enumNames) {
                    // empty catch block
                }
                try {
                    String[] names = new String[]{"setVariant", "setType", "setMushroomType"};
                    ArrayList<Method> methods = new ArrayList<Method>();
                    for (Method m6 : cls.getMethods()) {
                        methods.add(m6);
                    }
                    for (Method m7 : cls.getDeclaredMethods()) {
                        methods.add(m7);
                    }
                    for (Method m8 : methods) {
                        String mname = m8.getName();
                        for (String n : names) {
                            Class<?> p;
                            if (!mname.equals(n) || m8.getParameterCount() != 1 || !(p = m8.getParameterTypes()[0]).isEnum()) continue;
                            m8.setAccessible(true);
                            LOGGER.debug("[Bestiary] Using generic EnumVariantController via {}({})", (Object)m8.getName(), (Object)p.getSimpleName());
                            return new EnumVariantController(p, m8);
                        }
                    }
                }
                catch (Throwable names) {
                    // empty catch block
                }
                try {
                    String[] intSetters = new String[]{"setVariant", "setType"};
                    for (Object c = cls; c != null && c != Object.class; c = ((Class)c).getSuperclass()) {
                        for (String n : intSetters) {
                            Method m9 = null;
                            try {
                                m9 = ((Class)c).getDeclaredMethod(n, Integer.TYPE);
                            }
                            catch (NoSuchMethodException simple) {
                                // empty catch block
                            }
                            if (m9 == null) {
                                try {
                                    m9 = ((Class)c).getMethod(n, Integer.TYPE);
                                }
                                catch (NoSuchMethodException simple) {
                                    // empty catch block
                                }
                            }
                            if (m9 == null) continue;
                            m9.setAccessible(true);
                            int max = 32;
                            int[] vals = new int[max];
                            for (int i = 0; i < max; ++i) {
                                vals[i] = i;
                            }
                            LOGGER.debug("[Bestiary] Using generic IntVariantController via {}.{}(int)", (Object)((Class)c).getSimpleName(), (Object)n);
                            return new IntVariantController(m9, vals);
                        }
                    }
                }
                catch (Throwable intSetters) {
                    // empty catch block
                }
                try {
                    if (!cls.getSimpleName().contains("TropicalFish")) break block62;
                    m3 = null;
                    try {
                        m3 = cls.getDeclaredMethod("setVariant", Integer.TYPE);
                    }
                    catch (NoSuchMethodException c) {
                        // empty catch block
                    }
                    if (m3 == null) {
                        try {
                            m3 = cls.getMethod("setVariant", Integer.TYPE);
                        }
                        catch (NoSuchMethodException c) {
                            // empty catch block
                        }
                    }
                    if (m3 != null) {
                        m3.setAccessible(true);
                        int[] vals = new int[]{0, 1, 2, 3, 4, 5};
                        LOGGER.debug("[Bestiary] Using IntVariantController for TropicalFish");
                        return new IntVariantController(m3, vals);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void rebuildVariants() {
            int controllerCount;
            long tStart;
            block23: {
                ClientLevel level;
                block22: {
                    tStart = System.nanoTime();
                    this.variantTextures.clear();
                    this.variantIndexMap.clear();
                    this.currentVariantIndex = 0;
                    if (this.renderedEntity == null || this.displayedMonster == null || this.displayedMonster.entityType() == null) {
                        this.variantController = null;
                        return;
                    }
                    this.variantController = this.detectVariantController(this.renderedEntity);
                    if (this.variantController == null) {
                        LOGGER.debug("[Bestiary] No variant controller detected for {}", this.displayedMonster.entityType());
                        return;
                    }
                    controllerCount = 0;
                    try {
                        controllerCount = Math.max(0, this.variantController.count());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    int cap = Math.min(controllerCount > 0 ? controllerCount : 32, 32);
                    level = Minecraft.m_91087_().f_91073_;
                    if (level != null) break block22;
                    for (int i = 0; i < cap; ++i) {
                        this.variantIndexMap.add(i);
                    }
                    LOGGER.debug("[Bestiary] Level is null; exposing {} provisional variants for {}", (Object)this.variantIndexMap.size(), this.displayedMonster.entityType());
                    long durMs = (System.nanoTime() - tStart) / 1000000L;
                    if (durMs < 5L) return;
                    try {
                        LOGGER.debug("[Bestiary] rebuildVariants for {} took {} ms (exposed {} variants)", new Object[]{this.displayedMonster.entityType(), durMs, this.getVariantCount()});
                        return;
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    return;
                }
                int total = controllerCount > 0 ? Math.min(controllerCount, 32) : 32;
                HashSet<String> seen = new HashSet<String>();
                for (int i = 0; i < total; ++i) {
                    String key;
                    ResourceLocation tex = this.variantController.textureFor((Level)level, this.displayedMonster.entityType(), i);
                    if (tex == null || !seen.add(key = tex.toString())) continue;
                    this.variantTextures.add(tex);
                    this.variantIndexMap.add(i);
                }
                if (this.variantIndexMap.size() <= 1 && controllerCount > 1) {
                    this.variantTextures.clear();
                    this.variantIndexMap.clear();
                    int limit = Math.min(controllerCount, 32);
                    for (int i = 0; i < limit; ++i) {
                        this.variantIndexMap.add(i);
                    }
                    LOGGER.debug("[Bestiary] Texture dedup collapsed variants; falling back to raw index map size={} for {}", (Object)limit, this.displayedMonster.entityType());
                    break block23;
                }
                LOGGER.debug("[Bestiary] Sampled {} unique textures (mapped from {} attempts) for {}", new Object[]{this.variantIndexMap.size(), total, this.displayedMonster.entityType()});
            }
            long durMs = (System.nanoTime() - tStart) / 1000000L;
            if (durMs < 5L) return;
            try {
                LOGGER.debug("[Bestiary] rebuildVariants for {} took {} ms (exposed {} variants)", new Object[]{this.displayedMonster.entityType(), durMs, this.getVariantCount()});
                return;
            }
            catch (Throwable seen) {}
            return;
            catch (Exception ex) {
                block24: {
                    try {
                        LOGGER.debug("Variant detection failed: {}", (Object)ex.toString());
                        if (!this.variantIndexMap.isEmpty() || controllerCount <= 1) break block24;
                        int limit = Math.min(controllerCount, 32);
                        for (int i = 0; i < limit; ++i) {
                            this.variantIndexMap.add(i);
                        }
                    }
                    catch (Throwable throwable) {
                        long durMs2 = (System.nanoTime() - tStart) / 1000000L;
                        if (durMs2 < 5L) throw throwable;
                        try {
                            LOGGER.debug("[Bestiary] rebuildVariants for {} took {} ms (exposed {} variants)", new Object[]{this.displayedMonster.entityType(), durMs2, this.getVariantCount()});
                            throw throwable;
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        throw throwable;
                    }
                }
                if ((durMs = (System.nanoTime() - tStart) / 1000000L) < 5L) return;
                try {
                    LOGGER.debug("[Bestiary] rebuildVariants for {} took {} ms (exposed {} variants)", new Object[]{this.displayedMonster.entityType(), durMs, this.getVariantCount()});
                    return;
                }
                catch (Throwable throwable) {}
                return;
            }
        }

        public int getVariantCount() {
            if (!this.variantIndexMap.isEmpty()) {
                return this.variantIndexMap.size();
            }
            if (this.variantController != null) {
                try {
                    return Math.min(Math.max(0, this.variantController.count()), 32);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return this.variantTextures.size();
        }

        public void cycleVariant(int delta) {
            int cnt = this.getVariantCount();
            if (cnt <= 1) {
                return;
            }
            int next = Math.floorMod(this.currentVariantIndex + delta, cnt);
            this.applyVariantByDisplayIndex(next);
        }

        private void applyVariantByDisplayIndex(int displayIndex) {
            if (this.variantController == null || this.displayedMonster == null || this.displayedMonster.entityType() == null) {
                return;
            }
            int cnt = this.getVariantCount();
            if (cnt == 0) {
                return;
            }
            int mapped = this.variantIndexMap.get(Math.floorMod(displayIndex, cnt));
            try {
                ClientLevel level = Minecraft.m_91087_().f_91073_;
                if (level == null) {
                    return;
                }
                if (this.renderedEntity != null) {
                    this.renderedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                }
                this.renderedEntity = this.displayedMonster.entityType().m_20615_((Level)level);
                if (this.renderedEntity == null) {
                    return;
                }
                this.variantController.apply(this.renderedEntity, mapped);
                this.currentVariantIndex = Math.floorMod(displayIndex, cnt);
                this.lastGameTime = null;
            }
            catch (Exception ex) {
                LOGGER.debug("Failed to apply variant: {}", (Object)ex.toString());
            }
        }

        private void disposeRenderedEntity() {
            if (this.renderedEntity != null) {
                try {
                    this.renderedEntity.m_142687_(Entity.RemovalReason.DISCARDED);
                    LOGGER.debug("Disposed entity: {}", (Object)this.renderedEntity.m_7755_().getString());
                    this.renderedEntity = null;
                }
                catch (Exception e) {
                    LOGGER.error("Failed to dispose entity: {}", (Object)e.getMessage());
                }
            }
        }

        private void renderDescription(GuiGraphics guiGraphics, int mouseX, int mouseY) {
            int targetWidth;
            if (this.displayedMonster == null || this.displayedMonster.description() == null || this.displayedMonster.description().isEmpty()) {
                String text = "No description available";
                guiGraphics.m_280137_(BestiaryScreen.this.f_96547_, text, this.x + this.size / 2, this.y + this.size / 2, 0);
                return;
            }
            int padding = 10;
            int textX = this.x + padding;
            int textY = this.y + padding;
            int baseTextWidth = this.size - padding * 2;
            Objects.requireNonNull(BestiaryScreen.this.f_96547_);
            int lineHeight = 9 + 2;
            int visibleLines = (this.size - padding * 2) / lineHeight;
            int scrollbarWidth = 6;
            int scrollbarGap = 6;
            int widthWithScrollbar = Math.max(0, baseTextWidth - (scrollbarWidth + scrollbarGap));
            int n = targetWidth = this.lastDescWrapWidth > 0 ? this.lastDescWrapWidth : baseTextWidth;
            if (this.descriptionLines.isEmpty() || this.lastDescWrapWidth <= 0) {
                targetWidth = baseTextWidth;
            }
            if (this.descriptionLines.isEmpty() || this.lastDescWrapWidth != targetWidth) {
                int finalWidth;
                this.descriptionScrollOffset = 0;
                String description = this.displayedMonster.description();
                ArrayList<String> initial = new ArrayList<String>();
                String[] words = description.split(" ");
                StringBuilder currentLine = new StringBuilder();
                for (String string : words) {
                    if (BestiaryScreen.this.f_96547_.m_92895_(String.valueOf(currentLine) + (currentLine.length() > 0 ? " " : "") + string) < baseTextWidth) {
                        if (currentLine.length() > 0) {
                            currentLine.append(" ");
                        }
                        currentLine.append(string);
                        continue;
                    }
                    if (currentLine.length() > 0) {
                        initial.add(currentLine.toString());
                        currentLine = new StringBuilder(string);
                        continue;
                    }
                    initial.add(string);
                }
                if (currentLine.length() > 0) {
                    initial.add(currentLine.toString());
                }
                boolean needsScrollbar = initial.size() > visibleLines && widthWithScrollbar > 0;
                int n2 = finalWidth = needsScrollbar ? widthWithScrollbar : baseTextWidth;
                if (!needsScrollbar) {
                    this.descriptionLines = initial;
                } else {
                    ArrayList<String> rerender = new ArrayList<String>();
                    String[] words2 = description.split(" ");
                    StringBuilder currentLine2 = new StringBuilder();
                    for (String word : words2) {
                        if (BestiaryScreen.this.f_96547_.m_92895_(String.valueOf(currentLine2) + (currentLine2.length() > 0 ? " " : "") + word) < finalWidth) {
                            if (currentLine2.length() > 0) {
                                currentLine2.append(" ");
                            }
                            currentLine2.append(word);
                            continue;
                        }
                        if (currentLine2.length() > 0) {
                            rerender.add(currentLine2.toString());
                            currentLine2 = new StringBuilder(word);
                            continue;
                        }
                        rerender.add(word);
                    }
                    if (currentLine2.length() > 0) {
                        rerender.add(currentLine2.toString());
                    }
                    this.descriptionLines = rerender;
                }
                this.lastDescWrapWidth = finalWidth;
            }
            int maxScroll = Math.max(0, this.descriptionLines.size() - visibleLines);
            this.descriptionScrollOffset = Math.max(0, Math.min(this.descriptionScrollOffset, maxScroll));
            for (int i = 0; i < visibleLines && i + this.descriptionScrollOffset < this.descriptionLines.size(); ++i) {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, this.descriptionLines.get(i + this.descriptionScrollOffset), textX, textY + i * lineHeight, 0, false);
            }
            if (this.descriptionLines.size() > visibleLines) {
                int scrollbarX = this.x + this.size - scrollbarWidth - 4;
                int scrollbarHeight = this.size - padding * 2;
                int scrollbarY = this.y + padding;
                guiGraphics.m_280163_(TEXTURE, scrollbarX, scrollbarY, 180.0f, 160.0f, scrollbarWidth, scrollbarHeight, 512, 512);
                float contentRatio = (float)visibleLines / (float)this.descriptionLines.size();
                int thumbHeight = Math.max(20, (int)((float)scrollbarHeight * contentRatio));
                int thumbY = scrollbarY + (int)((float)(scrollbarHeight - thumbHeight) * ((float)this.descriptionScrollOffset / (float)(this.descriptionLines.size() - visibleLines)));
                boolean bl = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                int thumbColor = this.isDraggingScrollbar || bl ? -594735 : -1784461;
                guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
            }
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            guiGraphics.m_280163_(TEXTURE, this.x, this.y, 180.0f, 0.0f, this.size, this.size, 512, 512);
            if (this.displayedMonster != null) {
                boolean showInfoButton;
                boolean isBoss;
                boolean isPartiallyDiscovered = false;
                if (this.displayedMonster.entityType() != null) {
                    boolean isDiscovered = BestiaryScreen.this.isEntityDiscovered(this.displayedMonster.entityType());
                    if (!isDiscovered || Config.forceObfuscation && !isDiscovered) {
                        isPartiallyDiscovered = true;
                    } else if (ClientProgressionData.isPartiallyDiscovered(this.displayedMonster.entityType()) && Config.enableProgressionSystem) {
                        isPartiallyDiscovered = true;
                    } else if ("kills".equals(Config.progressionSystemType) && !Config.hideZeroKillEntities || "ranks".equals(Config.progressionSystemType) && !Config.hideNoRankEntities) {
                        isPartiallyDiscovered = false;
                    }
                }
                MutableComponent entityName = isPartiallyDiscovered ? Component.m_237113_((String)"???") : this.displayedMonster.name();
                boolean bl = isBoss = (!isPartiallyDiscovered || Config.enableProgressionSystem) && this.isEntityBoss();
                if (isBoss) {
                    entityName = Component.m_237115_((String)"screen.araxers_bestiary.boss_prefix").m_7220_((Component)entityName);
                }
                int nameOffsetY = 15;
                int textWidth = BestiaryScreen.this.f_96547_.m_92852_((FormattedText)entityName);
                int centeredX = this.x + this.size / 2 - textWidth / 2;
                int textColor = isPartiallyDiscovered ? 0x888888 : 0;
                String rawName = entityName.getString();
                if (!(!rawName.contains(".") && !rawName.contains(":") || rawName.contains(")") && rawName.contains("("))) {
                    String[] parts = rawName.split("[\\.:]");
                    String split = parts[parts.length - 1];
                    StringBuilder displayName = new StringBuilder();
                    boolean nextUpper = true;
                    for (char c : split.toCharArray()) {
                        if (c == '_') {
                            displayName.append(' ');
                            nextUpper = true;
                            continue;
                        }
                        displayName.append(nextUpper ? Character.toUpperCase(c) : c);
                        nextUpper = false;
                    }
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, displayName.toString(), centeredX, this.y - nameOffsetY, textColor, false);
                } else {
                    guiGraphics.m_280614_(BestiaryScreen.this.f_96547_, (Component)entityName, centeredX, this.y - nameOffsetY, textColor, false);
                }
                boolean hasDescription = this.displayedMonster.description() != null && !this.displayedMonster.description().isEmpty();
                boolean hasReachedThreshold = !Config.enableProgressionSystem || ClientProgressionData.shouldShowDescription(this.displayedMonster.entityType());
                boolean isDiscovered = BestiaryScreen.this.isEntityDiscovered(this.displayedMonster.entityType());
                this.infoButton.f_93624_ = showInfoButton = hasDescription && hasReachedThreshold && isDiscovered;
                if (showInfoButton) {
                    int buttonSpacing = 5;
                    int buttonWidth = this.infoButton.m_5711_();
                    int buttonX = this.x + this.size - buttonWidth - buttonSpacing;
                    int buttonY = this.y - nameOffsetY - 20 - 2;
                    this.infoButton.m_252865_(buttonX);
                    this.infoButton.m_253211_(buttonY);
                }
            } else {
                this.infoButton.f_93624_ = false;
            }
            boolean hasReachedThreshold = !Config.enableProgressionSystem || this.displayedMonster != null && this.displayedMonster.entityType() != null && ClientProgressionData.shouldShowDescription(this.displayedMonster.entityType());
            BestiaryScreen.this.enableScaledScissor(guiGraphics, this.x + 2, this.y + 2, this.x + this.size - 2, this.y + this.size - 2);
            if (this.showDescription && this.displayedMonster != null && hasReachedThreshold) {
                this.renderDescription(guiGraphics, mouseX, mouseY);
            } else {
                if (!this.isDragging && this.renderedEntity != null) {
                    this.rotationYaw += this.autoRotationSpeed;
                    if (this.rotationYaw > 360.0f) {
                        this.rotationYaw -= 360.0f;
                    }
                }
                if (this.renderedEntity != null) {
                    int entityScale = Math.max(1, Math.round(30.0f * this.zoom));
                    this.renderEntity(guiGraphics, this.x + this.size / 2, this.y + Math.round((float)this.size / 1.5f), entityScale, this.rotationYaw, this.rotationPitch);
                } else if (BestiaryScreen.this.selectedMonster != null) {
                    String text = Component.m_237115_((String)"screen.araxers_bestiary.no_preview").getString();
                    guiGraphics.m_280137_(BestiaryScreen.this.f_96547_, text, this.x + this.size / 2, this.y + this.size / 2, 0xFFFFFF);
                }
            }
            guiGraphics.m_280618_();
            guiGraphics.m_280168_().m_85849_();
        }

        private void renderEntity(GuiGraphics guiGraphics, int posX, int posY, int scale, float yaw, float pitch) {
            boolean usePoseStackRotation;
            guiGraphics.m_280168_().m_85836_();
            guiGraphics.m_280168_().m_85837_((double)posX, (double)posY, 1050.0);
            guiGraphics.m_280168_().m_85841_(1.0f, 1.0f, -1.0f);
            float scaleFactor = this.getScaleFactorForEntity(this.renderedEntity);
            float entityScale = (float)scale * scaleFactor;
            if (!Float.isFinite(entityScale) || entityScale <= 0.0f) {
                entityScale = 30.0f;
            }
            if (entityScale < 5.0f) {
                entityScale = 5.0f;
            }
            if (entityScale > 120.0f) {
                entityScale = 120.0f;
            }
            guiGraphics.m_280168_().m_85841_(entityScale, entityScale, entityScale);
            guiGraphics.m_280168_().m_252781_(Axis.f_252403_.m_252977_(180.0f));
            boolean bl = usePoseStackRotation = !(this.renderedEntity instanceof LivingEntity) || this.isHugeOrSpecial(this.renderedEntity);
            if (usePoseStackRotation) {
                guiGraphics.m_280168_().m_252781_(Axis.f_252436_.m_252977_(yaw));
                guiGraphics.m_280168_().m_252781_(Axis.f_252529_.m_252977_(pitch));
            }
            EntityRenderDispatcher dispatcher = Minecraft.m_91087_().m_91290_();
            dispatcher.m_114468_(false);
            boolean isPartiallyDiscovered = false;
            if (BestiaryScreen.this.selectedMonster != null && BestiaryScreen.this.selectedMonster.entityType() != null) {
                boolean isDiscovered = BestiaryScreen.this.isEntityDiscovered(BestiaryScreen.this.selectedMonster.entityType());
                if (!isDiscovered || Config.forceObfuscation && !isDiscovered) {
                    isPartiallyDiscovered = true;
                } else if (ClientProgressionData.isPartiallyDiscovered(BestiaryScreen.this.selectedMonster.entityType()) && Config.enableProgressionSystem) {
                    isPartiallyDiscovered = true;
                } else if ("kills".equals(Config.progressionSystemType) && !Config.hideZeroKillEntities || "ranks".equals(Config.progressionSystemType) && !Config.hideNoRankEntities) {
                    isPartiallyDiscovered = false;
                }
            }
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            if (isPartiallyDiscovered) {
                RenderSystem.setShaderColor((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            }
            float pt = Minecraft.m_91087_().m_91296_();
            ClientLevel lvl = Minecraft.m_91087_().f_91073_;
            if (lvl != null) {
                long dt;
                long now = lvl.m_46467_();
                if (this.lastGameTime == null) {
                    this.lastGameTime = now;
                }
                if ((dt = now - this.lastGameTime) != 0L) {
                    this.renderedEntity.f_19797_ += (int)dt;
                    this.lastGameTime = now;
                }
            }
            LivingEntity living = this.renderedEntity instanceof LivingEntity ? (LivingEntity)this.renderedEntity : null;
            float oldBody = 0.0f;
            float oldBodyO = 0.0f;
            float oldHead = 0.0f;
            float oldHeadO = 0.0f;
            float oldY = 0.0f;
            float oldYO = 0.0f;
            float oldX = 0.0f;
            float oldXO = 0.0f;
            double prevXO = this.renderedEntity.f_19854_;
            double prevYO = this.renderedEntity.f_19855_;
            double prevZO = this.renderedEntity.f_19856_;
            if (living != null && !usePoseStackRotation) {
                float yawAdj;
                oldBody = living.f_20883_;
                oldBodyO = living.f_20884_;
                oldHead = living.f_20885_;
                oldHeadO = living.f_20886_;
                oldY = living.m_146908_();
                oldYO = living.f_19859_;
                oldX = living.m_146909_();
                oldXO = living.f_19860_;
                living.f_20883_ = living.f_20884_ = (yawAdj = 180.0f + yaw);
                living.f_20885_ = living.f_20886_ = yawAdj;
                living.m_146922_(yawAdj);
                living.f_19859_ = yawAdj;
                living.m_146926_(-pitch);
                living.f_19860_ = -pitch;
                living.m_20334_(0.0, 0.0, 0.0);
                this.renderedEntity.f_19854_ = this.renderedEntity.m_20185_();
                this.renderedEntity.f_19855_ = this.renderedEntity.m_20186_();
                this.renderedEntity.f_19856_ = this.renderedEntity.m_20189_();
            }
            RenderSystem.runAsFancy(() -> dispatcher.m_114384_(this.renderedEntity, 0.0, 0.0, 0.0, 0.0f, pt, guiGraphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0));
            bufferSource.m_109911_();
            if (isPartiallyDiscovered) {
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
            if (living != null && !usePoseStackRotation) {
                living.f_20883_ = oldBody;
                living.f_20884_ = oldBodyO;
                living.f_20885_ = oldHead;
                living.f_20886_ = oldHeadO;
                living.m_146922_(oldY);
                living.f_19859_ = oldYO;
                living.m_146926_(oldX);
                living.f_19860_ = oldXO;
                this.renderedEntity.f_19854_ = prevXO;
                this.renderedEntity.f_19855_ = prevYO;
                this.renderedEntity.f_19856_ = prevZO;
            }
            guiGraphics.m_280168_().m_85849_();
            dispatcher.m_114468_(true);
        }

        private float getScaleFactorForEntity(Entity entity) {
            float baseFactor = 1.0f;
            try {
                float clampedScale;
                float width = entity.m_20205_();
                float height = entity.m_20206_();
                float referenceSize = Math.max(width, height);
                float scaleFactor = 1.0f / (referenceSize * referenceSize);
                float calibrationFactor = 2.0f;
                scaleFactor *= calibrationFactor;
                float minScale = 0.1f;
                float maxScale = 0.35f;
                if (referenceSize > 16.0f) {
                    float extraScaleFactor = 30.0f / referenceSize;
                    clampedScale = Math.min(Math.max(scaleFactor *= extraScaleFactor, minScale * extraScaleFactor), maxScale);
                } else {
                    clampedScale = Math.min(Math.max(scaleFactor, minScale), maxScale) * 3.5f;
                }
                return clampedScale;
            }
            catch (Exception e) {
                LOGGER.debug("Could not determine size for entity, using default scale. Error: {}", (Object)e.getMessage());
                return 0.35f;
            }
        }

        private boolean isHugeOrSpecial(Entity entity) {
            try {
                float height;
                if (entity instanceof EnderDragon) {
                    return true;
                }
                float width = entity.m_20205_();
                float reference = Math.max(width, height = entity.m_20206_());
                return reference >= 6.0f;
            }
            catch (Exception e) {
                return false;
            }
        }

        public boolean m_6375_(double mouseX, double mouseY, int button) {
            int bh;
            int bw;
            int by;
            int bx;
            if (BestiaryScreen.this.variantPrevButton != null && BestiaryScreen.this.variantPrevButton.f_93624_) {
                bx = BestiaryScreen.this.variantPrevButton.m_252754_();
                by = BestiaryScreen.this.variantPrevButton.m_252907_();
                bw = BestiaryScreen.this.variantPrevButton.m_5711_();
                bh = BestiaryScreen.this.variantPrevButton.m_93694_();
                if (mouseX >= (double)bx && mouseX <= (double)(bx + bw) && mouseY >= (double)by && mouseY <= (double)(by + bh)) {
                    return false;
                }
            }
            if (BestiaryScreen.this.variantNextButton != null && BestiaryScreen.this.variantNextButton.f_93624_) {
                bx = BestiaryScreen.this.variantNextButton.m_252754_();
                by = BestiaryScreen.this.variantNextButton.m_252907_();
                bw = BestiaryScreen.this.variantNextButton.m_5711_();
                bh = BestiaryScreen.this.variantNextButton.m_93694_();
                if (mouseX >= (double)bx && mouseX <= (double)(bx + bw) && mouseY >= (double)by && mouseY <= (double)(by + bh)) {
                    return false;
                }
            }
            if (mouseX >= (double)this.x && mouseX < (double)(this.x + this.size) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.size)) {
                if (this.showDescription) {
                    int padding = 10;
                    Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                    int lineHeight = 9 + 2;
                    int visibleLines = (this.size - padding * 2) / lineHeight;
                    if (this.descriptionLines.size() > visibleLines) {
                        boolean clickedOnTrack;
                        int scrollbarWidth = 6;
                        int scrollbarX = this.x + this.size - scrollbarWidth - 4;
                        int scrollbarHeight = this.size - padding * 2;
                        int scrollbarY = this.y + padding;
                        float contentRatio = (float)visibleLines / (float)this.descriptionLines.size();
                        int thumbHeight = Math.max(20, (int)((float)scrollbarHeight * contentRatio));
                        float scrollRatio = (float)this.descriptionScrollOffset / (float)Math.max(1, this.descriptionLines.size() - visibleLines);
                        int thumbY = scrollbarY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                        boolean clickedOnThumb = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight);
                        boolean bl = clickedOnTrack = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)scrollbarY && mouseY <= (double)(scrollbarY + scrollbarHeight);
                        if (clickedOnThumb) {
                            this.isDraggingScrollbar = true;
                            return true;
                        }
                        if (clickedOnTrack) {
                            float newScrollRatio = (float)(mouseY - (double)scrollbarY) / (float)scrollbarHeight;
                            this.descriptionScrollOffset = (int)(newScrollRatio * (float)(this.descriptionLines.size() - visibleLines));
                            this.descriptionScrollOffset = Math.max(0, Math.min(this.descriptionScrollOffset, this.descriptionLines.size() - visibleLines));
                            return true;
                        }
                    }
                    return true;
                }
                this.isDragging = true;
                this.lastMouseX = (int)mouseX;
                this.lastMouseY = (int)mouseY;
                return true;
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isDragging = false;
            this.isDraggingScrollbar = false;
            return super.m_6348_(mouseX, mouseY, button);
        }

        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.isDragging && this.renderedEntity != null) {
                this.rotationYaw = (float)((double)this.rotationYaw + (mouseX - (double)this.lastMouseX) * 1.0);
                this.rotationPitch = (float)((double)this.rotationPitch + (mouseY - (double)this.lastMouseY) * 0.5);
                if (this.rotationPitch > 30.0f) {
                    this.rotationPitch = 30.0f;
                }
                if (this.rotationPitch < -30.0f) {
                    this.rotationPitch = -30.0f;
                }
                this.lastMouseX = (int)mouseX;
                this.lastMouseY = (int)mouseY;
                return true;
            }
            if (this.isDraggingScrollbar && this.showDescription) {
                int padding = 10;
                Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                int lineHeight = 9 + 2;
                int visibleLines = (this.size - padding * 2) / lineHeight;
                if (this.descriptionLines.size() > visibleLines) {
                    int scrollbarHeight = this.size - padding * 2;
                    int scrollbarY = this.y + padding;
                    float scrollRatio = mouseY < (double)scrollbarY ? 0.0f : (mouseY > (double)(scrollbarY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)scrollbarY) / (float)scrollbarHeight);
                    this.descriptionScrollOffset = (int)(scrollRatio * (float)(this.descriptionLines.size() - visibleLines));
                    this.descriptionScrollOffset = Math.max(0, Math.min(this.descriptionScrollOffset, this.descriptionLines.size() - visibleLines));
                    return true;
                }
            }
            return false;
        }

        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            boolean inside;
            boolean bl = inside = mouseX >= (double)this.x && mouseX < (double)(this.x + this.size) && mouseY >= (double)this.y && mouseY < (double)(this.y + this.size);
            if (!inside) {
                return false;
            }
            if (this.showDescription) {
                int padding = 10;
                Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                int lineHeight = 9 + 2;
                int visibleLines = (this.size - padding * 2) / lineHeight;
                if (this.descriptionLines.size() > visibleLines) {
                    this.descriptionScrollOffset -= (int)delta;
                    int maxScroll = Math.max(0, this.descriptionLines.size() - visibleLines);
                    this.descriptionScrollOffset = Math.max(0, Math.min(this.descriptionScrollOffset, maxScroll));
                    return true;
                }
                return false;
            }
            if (this.renderedEntity != null) {
                float step = 0.1f;
                float newZoom = this.zoom + (float)delta * step;
                if (newZoom < 0.5f) {
                    newZoom = 0.5f;
                }
                if (newZoom > 2.0f) {
                    newZoom = 2.0f;
                }
                if (newZoom != this.zoom) {
                    this.zoom = newZoom;
                    return true;
                }
            }
            return false;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)"narration.araxers_bestiary.entity_view"));
        }

        private static interface VariantController {
            public int count();

            public void apply(Entity var1, int var2) throws Exception;

            public ResourceLocation textureFor(Level var1, EntityType<?> var2, int var3);
        }

        private class HolderListVariantController
        implements VariantController {
            private final Method setter;
            private final List<Object> holders;

            HolderListVariantController(Method setter, List<Object> holders) {
                this.setter = setter;
                this.holders = holders;
            }

            @Override
            public int count() {
                return this.holders != null ? this.holders.size() : 0;
            }

            @Override
            public void apply(Entity e, int index) throws Exception {
                if (this.holders == null || this.holders.isEmpty()) {
                    return;
                }
                int idx = Math.floorMod(index, this.holders.size());
                this.setter.invoke((Object)e, this.holders.get(idx));
            }

            @Override
            public ResourceLocation textureFor(Level level, EntityType<?> type, int index) {
                try {
                    Entity tmp = type.m_20615_(level);
                    if (tmp == null) {
                        return null;
                    }
                    this.apply(tmp, index);
                    EntityRenderDispatcher disp = Minecraft.m_91087_().m_91290_();
                    EntityRenderer renderer = disp.m_114382_(tmp);
                    ResourceLocation tex = renderer.m_5478_(tmp);
                    tmp.m_142687_(Entity.RemovalReason.DISCARDED);
                    return tex;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }

        private class IntVariantController
        implements VariantController {
            private final Method setter;
            private final int[] values;

            IntVariantController(Method setter, int[] values) {
                this.setter = setter;
                this.values = values;
            }

            @Override
            public int count() {
                return this.values.length;
            }

            @Override
            public void apply(Entity e, int index) throws Exception {
                if (this.values.length == 0) {
                    return;
                }
                int idx = Math.floorMod(index, this.values.length);
                this.setter.invoke((Object)e, this.values[idx]);
            }

            @Override
            public ResourceLocation textureFor(Level level, EntityType<?> type, int index) {
                try {
                    Entity tmp = type.m_20615_(level);
                    if (tmp == null) {
                        return null;
                    }
                    this.apply(tmp, index);
                    EntityRenderDispatcher disp = Minecraft.m_91087_().m_91290_();
                    EntityRenderer renderer = disp.m_114382_(tmp);
                    ResourceLocation tex = renderer.m_5478_(tmp);
                    tmp.m_142687_(Entity.RemovalReason.DISCARDED);
                    return tex;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }

        private class EnumVariantController
        implements VariantController {
            private final Class<?> enumClass;
            private final Object[] constants;
            private final Method setter;

            EnumVariantController(Class<?> enumClass, Method setter) {
                this.enumClass = enumClass;
                this.constants = enumClass.getEnumConstants();
                this.setter = setter;
            }

            @Override
            public int count() {
                return this.constants != null ? this.constants.length : 0;
            }

            @Override
            public void apply(Entity e, int index) throws Exception {
                if (this.constants == null || this.constants.length == 0) {
                    return;
                }
                int idx = Math.floorMod(index, this.constants.length);
                this.setter.invoke((Object)e, this.constants[idx]);
            }

            @Override
            public ResourceLocation textureFor(Level level, EntityType<?> type, int index) {
                try {
                    Entity tmp = type.m_20615_(level);
                    if (tmp == null) {
                        return null;
                    }
                    this.apply(tmp, index);
                    EntityRenderDispatcher disp = Minecraft.m_91087_().m_91290_();
                    EntityRenderer renderer = disp.m_114382_(tmp);
                    ResourceLocation tex = renderer.m_5478_(tmp);
                    tmp.m_142687_(Entity.RemovalReason.DISCARDED);
                    return tex;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }

        private class HorsePairHolderVariantController
        implements VariantController {
            private final Method setter;
            private final Constructor<?> variantCtor;
            private final List<Object> coats;
            private final List<Object> markings;

            HorsePairHolderVariantController(Method setter, Constructor<?> variantCtor, List<Object> coats, List<Object> markings) {
                this.setter = setter;
                this.variantCtor = variantCtor;
                this.coats = coats;
                this.markings = markings;
            }

            @Override
            public int count() {
                int b;
                int a = this.coats != null ? this.coats.size() : 0;
                long prod = (long)a * (long)(b = this.markings != null ? this.markings.size() : 0);
                if (prod > 64L) {
                    return 64;
                }
                return (int)prod;
            }

            private Object buildVariant(int index) throws Exception {
                if (this.coats == null || this.markings == null || this.coats.isEmpty() || this.markings.isEmpty()) {
                    return null;
                }
                int a = this.coats.size();
                int b = this.markings.size();
                int total = a * b;
                int idx = Math.floorMod(index, Math.max(1, total));
                int ci = a == 0 ? 0 : idx % a;
                int mi = a == 0 ? 0 : idx / Math.max(1, a) % b;
                Object coat = this.coats.get(ci);
                Object mark = this.markings.get(mi);
                return this.variantCtor.newInstance(coat, mark);
            }

            @Override
            public void apply(Entity e, int index) throws Exception {
                Object hv = this.buildVariant(index);
                if (hv == null) {
                    return;
                }
                this.setter.invoke((Object)e, hv);
            }

            @Override
            public ResourceLocation textureFor(Level level, EntityType<?> type, int index) {
                try {
                    Entity tmp = type.m_20615_(level);
                    if (tmp == null) {
                        return null;
                    }
                    this.apply(tmp, index);
                    EntityRenderDispatcher disp = Minecraft.m_91087_().m_91290_();
                    EntityRenderer renderer = disp.m_114382_(tmp);
                    ResourceLocation tex = renderer.m_5478_(tmp);
                    tmp.m_142687_(Entity.RemovalReason.DISCARDED);
                    return tex;
                }
                catch (Exception ex) {
                    return null;
                }
            }
        }
    }

    private class InfoPanel
    extends AbstractWidget {
        private final int x;
        private final int y;
        private final int width;
        private final int height;
        private MonsterEntry monster;
        private int spawnLocationsScrollOffset;
        private int lootItemsScrollOffset;
        private boolean isDragging;
        private boolean isDraggingLoot;
        private int rankXScrollOffset;
        private boolean isDraggingRankX;
        private boolean showRankXInsteadOfAttributes;
        private int advAttrScrollOffset;
        private boolean isDraggingAdvAttr;
        private final Map<String, Integer> spawnTextWidthCache;
        private final Map<EntityType<?>, List<AdvRowType>> advRowsCache;
        private final Map<EntityType<?>, LiveAttrs> liveAttrsCache;
        private final Map<String, ItemStack> challengeIconCache;
        private int rxTooltipScrollOffset;
        private int rxTTX;
        private int rxTTY;
        private int rxTTW;
        private int rxTTH;
        private int rxTTTotalLines;
        private int rxTTVisibleLines;

        public InfoPanel(int x, int y, int width, int height) {
            super(x, y, width, height, (Component)Component.m_237119_());
            this.spawnLocationsScrollOffset = 0;
            this.lootItemsScrollOffset = 0;
            this.isDragging = false;
            this.isDraggingLoot = false;
            this.rankXScrollOffset = 0;
            this.isDraggingRankX = false;
            this.showRankXInsteadOfAttributes = false;
            this.advAttrScrollOffset = 0;
            this.isDraggingAdvAttr = false;
            this.spawnTextWidthCache = new HashMap<String, Integer>();
            this.advRowsCache = new HashMap();
            this.liveAttrsCache = new HashMap();
            this.challengeIconCache = new HashMap<String, ItemStack>();
            this.rxTooltipScrollOffset = 0;
            this.rxTTX = 0;
            this.rxTTY = 0;
            this.rxTTW = 0;
            this.rxTTH = 0;
            this.rxTTTotalLines = 0;
            this.rxTTVisibleLines = 0;
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        public void setMonster(MonsterEntry monster) {
            this.monster = monster;
            this.spawnLocationsScrollOffset = 0;
            this.lootItemsScrollOffset = 0;
            this.rankXScrollOffset = 0;
            this.isDraggingRankX = false;
            this.showRankXInsteadOfAttributes = false;
            this.advAttrScrollOffset = 0;
            this.isDraggingAdvAttr = false;
            this.spawnTextWidthCache.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<AdvRowType> buildAdvancedRows(MonsterEntry m) {
            ArrayList<AdvRowType> rows = new ArrayList<AdvRowType>();
            if (m == null || m.entityType() == null) {
                return rows;
            }
            EntityType<?> et = m.entityType();
            List<AdvRowType> cached = this.advRowsCache.get(et);
            if (cached != null) {
                return cached;
            }
            rows.add(AdvRowType.KNOCKBACK);
            rows.add(AdvRowType.ARMOR);
            rows.add(AdvRowType.TOUGHNESS);
            rows.add(AdvRowType.MOVEMENT);
            rows.add(AdvRowType.EXPERIENCE);
            if (Minecraft.m_91087_().f_91073_ != null) {
                ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                Entity temp = null;
                try {
                    temp = et.m_20615_((Level)lvl);
                    if (temp instanceof LivingEntity) {
                        LivingEntity le = (LivingEntity)temp;
                        if (le.m_21051_(Attributes.f_22277_) != null) {
                            rows.add(AdvRowType.FOLLOW_RANGE);
                        }
                        if (le.m_21051_(Attributes.f_22282_) != null) {
                            rows.add(AdvRowType.ATTACK_KNOCKBACK);
                        }
                        if (le.m_21051_(Attributes.f_22280_) != null) {
                            rows.add(AdvRowType.FLY_SPEED);
                        }
                        if (le.m_21051_(Attributes.f_22283_) != null) {
                            rows.add(AdvRowType.ATTACK_SPEED);
                        }
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (temp != null) {
                        temp.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
            List<AdvRowType> unmodifiable = Collections.unmodifiableList(rows);
            this.advRowsCache.put(et, unmodifiable);
            return unmodifiable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private LiveAttrs getLiveAttrsFor(EntityType<?> et) {
            if (et == null) {
                return null;
            }
            LiveAttrs cached = this.liveAttrsCache.get(et);
            if (cached != null) {
                return cached;
            }
            Double fr = null;
            Double akb = null;
            Double fly = null;
            Double as = null;
            if (Minecraft.m_91087_().f_91073_ != null) {
                ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                Entity temp = null;
                try {
                    temp = et.m_20615_((Level)lvl);
                    if (temp instanceof LivingEntity) {
                        LivingEntity le = (LivingEntity)temp;
                        AttributeInstance inst = le.m_21051_(Attributes.f_22277_);
                        if (inst != null) {
                            fr = inst.m_22135_();
                        }
                        if ((inst = le.m_21051_(Attributes.f_22282_)) != null) {
                            akb = inst.m_22135_();
                        }
                        if ((inst = le.m_21051_(Attributes.f_22280_)) != null) {
                            fly = inst.m_22135_();
                        }
                        if ((inst = le.m_21051_(Attributes.f_22283_)) != null) {
                            as = inst.m_22135_();
                        }
                    }
                }
                catch (Exception exception) {
                }
                finally {
                    if (temp != null) {
                        temp.m_142687_(Entity.RemovalReason.DISCARDED);
                    }
                }
            }
            LiveAttrs la = new LiveAttrs(fr, akb, fly, as);
            this.liveAttrsCache.put(et, la);
            return la;
        }

        private ItemStack iconForChallengeId(String id) {
            if (id == null) {
                return new ItemStack((ItemLike)Items.f_42517_);
            }
            String key = id.toLowerCase(Locale.ROOT);
            ItemStack cached = this.challengeIconCache.get(key);
            if (cached != null) {
                return cached;
            }
            ItemStack stack = key.equals("observe") || key.startsWith("observe_") ? new ItemStack((ItemLike)Items.f_151059_) : (key.equals("biome_diversity") ? new ItemStack((ItemLike)Items.f_42573_) : (key.startsWith("elite_streak") ? new ItemStack((ItemLike)Items.f_42686_) : (key.equals("no_armor_no_shield_clear") ? new ItemStack((ItemLike)Items.f_42408_) : (key.equals("per_entity_count") ? new ItemStack((ItemLike)Items.f_42383_) : (key.equals("util_unique_interaction") ? new ItemStack((ItemLike)Items.f_41978_) : (key.equals("pacifist_bonus") ? new ItemStack((ItemLike)Items.f_42535_) : (key.equals("non_lethal_interaction") ? new ItemStack((ItemLike)Items.f_42655_) : (key.equals("proximity_survival") ? new ItemStack((ItemLike)Items.f_42740_) : (key.equals("clean_clear") ? new ItemStack((ItemLike)Items.f_42455_) : (key.equals("no_cheese_clear") ? new ItemStack((ItemLike)Items.f_42127_) : (key.equals("observe_before_fight") ? new ItemStack((ItemLike)Items.f_151059_) : (key.equals("team_bonus") ? new ItemStack((ItemLike)Items.f_42436_) : (key.equals("breed") ? new ItemStack((ItemLike)Items.f_42405_) : new ItemStack((ItemLike)Items.f_42517_))))))))))))));
            this.challengeIconCache.put(key, stack);
            return stack;
        }

        private String localizeChallengeName(String chId) {
            Object localized;
            block7: {
                if (chId == null) {
                    return "";
                }
                String keyCh = "screen.araxers_bestiary.rankx.challenge." + chId;
                localized = Component.m_237115_((String)keyCh).getString();
                if (((String)localized).equals(keyCh) || ((String)localized).contains(keyCh)) {
                    if (chId.startsWith("elite_streak_")) {
                        try {
                            int n = Integer.parseInt(chId.substring("elite_streak_".length()));
                            String eliteKey = "screen.araxers_bestiary.rankx.challenge.elite_streak";
                            String elite = Component.m_237110_((String)eliteKey, (Object[])new Object[]{n}).getString();
                            if (!elite.equals(eliteKey) && !elite.contains(eliteKey)) {
                                localized = elite;
                                break block7;
                            }
                            localized = "Elite streak " + n;
                        }
                        catch (NumberFormatException ignored) {
                            localized = chId.replace('_', ' ');
                        }
                    } else {
                        localized = chId.replace('_', ' ');
                    }
                }
            }
            return localized;
        }

        private void drawVillagerProgressBarStretched(GuiGraphics guiGraphics, int barX, int barY, int totalWidth, float ratio, int fillColorRGB) {
            if (totalWidth <= 0) {
                return;
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            float clamped = Math.max(0.0f, Math.min(1.0f, ratio));
            ResourceLocation tex2 = BestiaryScreen.currentBarTexture();
            int u2 = BestiaryScreen.currentBarU();
            int vbg2 = BestiaryScreen.currentBarVBg();
            int vfg2 = BestiaryScreen.currentBarVfg();
            int tw2 = BestiaryScreen.currentTexWidth();
            int th2 = BestiaryScreen.currentTexHeight();
            guiGraphics.m_280411_(tex2, barX, barY, totalWidth, 5, (float)u2, (float)vbg2, 102, 5, tw2, th2);
            int destFillWidth = (int)((float)totalWidth * clamped);
            if (clamped > 0.0f && destFillWidth == 0) {
                destFillWidth = 1;
            }
            if (destFillWidth > 0) {
                int srcFillWidth = Math.max(1, Math.min(102, Math.round(102.0f * clamped)));
                float r = (float)(fillColorRGB >> 16 & 0xFF) / 255.0f;
                float g = (float)(fillColorRGB >> 8 & 0xFF) / 255.0f;
                float b = (float)(fillColorRGB & 0xFF) / 255.0f;
                RenderSystem.setShaderColor((float)r, (float)g, (float)b, (float)1.0f);
                guiGraphics.m_280411_(tex2, barX, barY, destFillWidth, 5, (float)u2, (float)vfg2, srcFillWidth, 5, tw2, th2);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }

        private void drawVillagerProgressBarStretched(GuiGraphics guiGraphics, int barX, int barY, int totalWidth, float ratio) {
            this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, totalWidth, ratio, 0xFFFFFF);
        }

        private void drawSpawnLocationMarqueeText(GuiGraphics guiGraphics, String text, int textX, int textY, int color, int clipWidth) {
            float phase;
            float pxPerSec;
            float periodMs;
            if (text == null) {
                return;
            }
            int maxWidth = Math.max(0, Math.min(clipWidth, 138));
            if (maxWidth <= 0) {
                return;
            }
            int textWidth = this.spawnTextWidthCache.computeIfAbsent(text, k -> BestiaryScreen.this.f_96547_.m_92895_(k));
            if (textWidth <= maxWidth) {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, text, textX, textY, color, false);
                return;
            }
            int scLeft = textX;
            int scTop = textY - 1;
            int scRight = textX + maxWidth;
            Objects.requireNonNull(BestiaryScreen.this.f_96547_);
            int scBottom = textY + 9 + 1;
            BestiaryScreen.this.enableScaledScissor(guiGraphics, scLeft, scTop, scRight, scBottom);
            long nowMs = System.currentTimeMillis();
            float extra = textWidth - maxWidth;
            if (extra < 1.0f) {
                extra = 1.0f;
            }
            if ((periodMs = 2.0f * extra / Math.max(1.0f, pxPerSec = 7.0f) * 1000.0f) < 1.0f) {
                periodMs = 1.0f;
            }
            float tri = (phase = (float)(nowMs % (long)periodMs) / periodMs) < 0.5f ? phase * 2.0f : 2.0f - phase * 2.0f;
            float offsetPx = tri * extra;
            int dx = -Math.round(offsetPx);
            guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, text, textX + dx, textY, color, false);
            guiGraphics.m_280618_();
        }

        private void drawMarqueeText(GuiGraphics guiGraphics, String text, int textX, int textY, int color, int clipWidth) {
            float phase;
            float pxPerSec;
            float periodMs;
            if (text == null) {
                return;
            }
            int maxWidth = Math.max(0, clipWidth);
            if (maxWidth <= 0) {
                return;
            }
            int textWidth = this.spawnTextWidthCache.computeIfAbsent(text, k -> BestiaryScreen.this.f_96547_.m_92895_(k));
            if (textWidth <= maxWidth) {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, text, textX, textY, color, false);
                return;
            }
            int scLeft = textX;
            int scTop = textY - 1;
            int scRight = textX + maxWidth;
            Objects.requireNonNull(BestiaryScreen.this.f_96547_);
            int scBottom = textY + 9 + 1;
            BestiaryScreen.this.enableScaledScissor(guiGraphics, scLeft, scTop, scRight, scBottom);
            long nowMs = System.currentTimeMillis();
            float extra = textWidth - maxWidth;
            if (extra < 1.0f) {
                extra = 1.0f;
            }
            if ((periodMs = 2.0f * extra / Math.max(1.0f, pxPerSec = 7.0f) * 1000.0f) < 1.0f) {
                periodMs = 1.0f;
            }
            float tri = (phase = (float)(nowMs % (long)periodMs) / periodMs) < 0.5f ? phase * 2.0f : 2.0f - phase * 2.0f;
            float offsetPx = tri * extra;
            int dx = -Math.round(offsetPx);
            guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, text, textX + dx, textY, color, false);
            guiGraphics.m_280618_();
        }

        public void m_87963_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
            guiGraphics.m_280168_().m_85836_();
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
            guiGraphics.m_280163_(TEXTURE, this.x, this.y, 340.0f, 0.0f, this.width, this.height, 512, 512);
            int statsX = this.x + 10;
            int statsY = this.y + 10;
            if (this.monster == null) {
                String text = "Select a monster to view details";
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, text, this.x, this.y + this.height / 2, 0, false);
                guiGraphics.m_280168_().m_85849_();
                return;
            }
            boolean shouldShowContent = true;
            if (this.monster.entityType() != null && Config.enableProgressionSystem) {
                boolean isDiscovered = BestiaryScreen.this.isEntityDiscovered(this.monster.entityType());
                boolean isSightedOnly = ClientProgressionData.isPartiallyDiscovered(this.monster.entityType());
                boolean bl = shouldShowContent = isDiscovered && !isSightedOnly;
            }
            if (!shouldShowContent) {
                guiGraphics.m_280168_().m_85849_();
                return;
            }
            int killCount = 0;
            if (Config.enableProgressionSystem && this.monster.entityType() != null && BestiaryScreen.this.killCounts.containsKey(this.monster.entityType())) {
                killCount = BestiaryScreen.this.killCounts.getOrDefault(this.monster.entityType(), 0);
            }
            switch (BestiaryScreen.this.currentTab) {
                case ATTRIBUTES: {
                    this.renderAttributesTab(guiGraphics, mouseX, mouseY, this.x, statsY, killCount);
                    break;
                }
                case LOCATIONS: {
                    this.renderLocationsTab(guiGraphics, mouseX, mouseY, this.x, statsY, killCount);
                    break;
                }
                case LOOT: {
                    this.renderLootTab(guiGraphics, mouseX, mouseY, this.x, statsY, killCount);
                }
            }
            guiGraphics.m_280168_().m_85849_();
        }

        private void renderAttributesTab(GuiGraphics guiGraphics, int mouseX, int mouseY, int statsX, int statsY, int killCount) {
            boolean rxEligible = false;
            EntityAttributes attrsForToggle = null;
            RankXConfig rxForToggle = null;
            boolean canToggleRX = false;
            if (this.monster.entityType() != null) {
                attrsForToggle = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rxForToggle = attrsForToggle != null ? attrsForToggle.rankX() : null;
                if (rxForToggle != null && Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType)) {
                    String rnk = ClientProgressionData.getRank(this.monster.entityType());
                    rxEligible = RankUtils.compareRanks(rnk, "S") >= 0;
                    canToggleRX = true;
                }
            }
            if (!rxEligible) {
                this.showRankXInsteadOfAttributes = false;
            }
            if (rxEligible && this.showRankXInsteadOfAttributes && rxForToggle != null && rxEligible) {
                boolean hoverRx;
                int sectionY = statsY;
                String header = Component.m_237115_((String)"screen.araxers_bestiary.rankx.header").getString();
                if (header.equals("screen.araxers_bestiary.rankx.header")) {
                    header = "Rank-X Progress";
                }
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, header, statsX, sectionY, 0, false);
                sectionY += 12;
                int pts = ClientProgressionData.getRankXPoints(this.monster.entityType());
                int target = Math.max(1, rxForToggle.getTarget());
                int barX = statsX;
                int barY = sectionY += 10;
                int totalWidth = Math.max(1, this.width - 20);
                float ratio = Math.min(1.0f, (float)pts / (float)target);
                int rxColor = 0xDD2222;
                this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, totalWidth, ratio, rxColor);
                boolean bl = hoverRx = mouseX >= barX && mouseX <= barX + totalWidth && mouseY >= barY && mouseY <= barY + 5;
                if (!hoverRx) {
                    int percent = Math.round(ratio * 100.0f);
                    String percentText = percent + "%";
                    int textW = BestiaryScreen.this.f_96547_.m_92895_(percentText);
                    int textX = barX + (totalWidth - textW) / 2;
                    Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                    int textY = barY + (5 - 9) / 2;
                    int outlineColor = 0;
                    for (int dx = -1; dx <= 1; ++dx) {
                        for (int dy = -1; dy <= 1; ++dy) {
                            if (dx == 0 && dy == 0) continue;
                            guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX + dx, textY + dy, outlineColor, false);
                        }
                    }
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX, textY, rxColor, false);
                }
                if (hoverRx) {
                    MutableComponent tipComp = Component.m_237110_((String)"screen.araxers_bestiary.rankx.points", (Object[])new Object[]{pts, target});
                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)tipComp, mouseX, mouseY);
                }
                sectionY += 17;
                List<RankXConfig.Challenge> challenges = rxForToggle.getChallenges();
                if (!challenges.isEmpty()) {
                    String chHeader = Component.m_237115_((String)"screen.araxers_bestiary.rankx.challenges").getString();
                    if (chHeader.contains("screen.araxers_bestiary.rankx.challenges")) {
                        chHeader = "Challenges:";
                    }
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, chHeader, statsX, sectionY, 0, false);
                    int listY = sectionY += 10;
                    int lineHeight = 10;
                    int visibleRows = Math.max(1, Math.min(6, challenges.size()));
                    int maxOffset = Math.max(0, challenges.size() - visibleRows);
                    if (this.rankXScrollOffset > maxOffset) {
                        this.rankXScrollOffset = maxOffset;
                    }
                    if (this.rankXScrollOffset < 0) {
                        this.rankXScrollOffset = 0;
                    }
                    Map<String, Integer> awarded = ClientProgressionData.getRankXChallengeProgress(this.monster.entityType());
                    int startIndex = Math.min(this.rankXScrollOffset, Math.max(0, challenges.size() - visibleRows));
                    int endIndex = Math.min(startIndex + visibleRows, challenges.size());
                    int drawY = listY;
                    for (int i = startIndex; i < endIndex; ++i) {
                        Object localized;
                        int val;
                        RankXConfig.Challenge c;
                        block77: {
                            c = challenges.get(i);
                            val = awarded.getOrDefault(c.id(), 0);
                            String chId = c.id();
                            String keyCh = "screen.araxers_bestiary.rankx.challenge." + chId;
                            localized = Component.m_237115_((String)keyCh).getString();
                            if (((String)localized).equals(keyCh) || ((String)localized).contains(keyCh)) {
                                if (chId.startsWith("elite_streak_")) {
                                    try {
                                        int n = Integer.parseInt(chId.substring("elite_streak_".length()));
                                        String eliteKey = "screen.araxers_bestiary.rankx.challenge.elite_streak";
                                        String elite = Component.m_237110_((String)eliteKey, (Object[])new Object[]{n}).getString();
                                        if (!elite.equals(eliteKey) && !elite.contains(eliteKey)) {
                                            localized = elite;
                                            break block77;
                                        }
                                        localized = "Elite streak " + n;
                                    }
                                    catch (NumberFormatException ignored) {
                                        localized = chId.replace('_', ' ');
                                    }
                                } else {
                                    localized = chId.replace('_', ' ');
                                }
                            }
                        }
                        String line = "- " + (String)localized + ": " + val + "/" + c.cap() + " (" + c.points() + ")";
                        int sbw = 6;
                        boolean hasScrollbar = challenges.size() > visibleRows;
                        int rightBound = this.x + this.width - (hasScrollbar ? sbw + 5 : 6);
                        int clipWidth = Math.max(1, rightBound - statsX - 2);
                        this.drawMarqueeText(guiGraphics, line, statsX, drawY, 0, clipWidth);
                        drawY += lineHeight;
                    }
                    if (challenges.size() > visibleRows) {
                        int scrollbarWidth = 6;
                        int scrollbarX = this.x + this.width - scrollbarWidth - 5;
                        int scrollbarHeight = visibleRows * lineHeight;
                        guiGraphics.m_280163_(TEXTURE, scrollbarX, listY, 180.0f, 160.0f, scrollbarWidth, scrollbarHeight, 512, 512);
                        float contentRatio = (float)visibleRows / (float)challenges.size();
                        int minThumbHeight = 15;
                        int thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                        float scrollRatio = (float)startIndex / (float)Math.max(1, challenges.size() - visibleRows);
                        int thumbY = listY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                        boolean hovering = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                        int thumbColor = this.isDraggingRankX || hovering ? -594735 : -1784461;
                        guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
                    }
                }
                return;
            }
            if (this.monster.entityType() != null) {
                int esThRaw;
                String rankStr;
                RankXConfig rxTopBar;
                EntityAttributes attrsTopBar = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rxTopBar = attrsTopBar != null ? attrsTopBar.rankX() : null;
                if (rxTopBar != null && Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType) && RankUtils.compareRanks(ClientProgressionData.getRank(this.monster.entityType()), "S") >= 0) {
                    String currentRankStr;
                    boolean isX;
                    boolean hoverRxTop;
                    int pts = ClientProgressionData.getRankXPoints(this.monster.entityType());
                    int target = Math.max(1, rxTopBar.getTarget());
                    int barX = this.x + 6;
                    int barY = this.y;
                    int totalWidth = Math.max(1, this.width - 12);
                    float ratio = Math.min(1.0f, (float)pts / (float)target);
                    int rxColorTop = 0xDD2222;
                    this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, totalWidth, ratio, rxColorTop);
                    List<RankXConfig.Challenge> chList = rxTopBar.getChallenges();
                    int nIcons = chList != null ? chList.size() : 0;
                    boolean hasIcons = chList != null && !chList.isEmpty() && this.monster.entityType() != null;
                    int iconSize = 16;
                    int pad = 8;
                    int avail = Math.max(1, totalWidth - pad * 2);
                    double step = hasIcons ? (double)avail / (double)(nIcons + 1) : 0.0;
                    int iconY = barY - (iconSize - 5) / 2 - 1;
                    boolean overAnyIcon = false;
                    if (hasIcons) {
                        for (int i = 0; i < nIcons; ++i) {
                            int iconCenterX = barX + pad + (int)Math.round(step * (double)(i + 1));
                            int iconX = iconCenterX - iconSize / 2;
                            if (mouseX < iconX || mouseX > iconX + iconSize || mouseY < iconY || mouseY > iconY + iconSize) continue;
                            overAnyIcon = true;
                            break;
                        }
                    }
                    boolean bl = hoverRxTop = mouseX >= barX && mouseX <= barX + totalWidth && mouseY >= barY && mouseY <= barY + 5;
                    if (!hoverRxTop && !hasIcons) {
                        int percent = Math.round(ratio * 100.0f);
                        String percentText = percent + "%";
                        int textW = BestiaryScreen.this.f_96547_.m_92895_(percentText);
                        int textX = barX + (totalWidth - textW) / 2;
                        Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                        int textY = barY + (5 - 9) / 2;
                        int outlineColor = 0;
                        for (int dx = -1; dx <= 1; ++dx) {
                            for (int dy = -1; dy <= 1; ++dy) {
                                if (dx == 0 && dy == 0) continue;
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX + dx, textY + dy, outlineColor, false);
                            }
                        }
                        guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX, textY, rxColorTop, false);
                    }
                    boolean bl2 = isX = RankUtils.compareRanks(currentRankStr = ClientProgressionData.getRank(this.monster.entityType()), "X") >= 0;
                    if (hoverRxTop && !overAnyIcon) {
                        int haveDays;
                        RankXConfig.GateConfig gates;
                        int needDays;
                        int remDays;
                        int percent = Math.round(ratio * 100.0f);
                        ArrayList<MutableComponent> tooltipLines = new ArrayList<MutableComponent>();
                        tooltipLines.add(Component.m_237110_((String)"screen.araxers_bestiary.rankx.points", (Object[])new Object[]{pts, target}));
                        if (ratio >= 1.0f && !isX && (remDays = Math.max(0, (needDays = (gates = rxTopBar.getGates()) != null ? gates.getMinDaysSinceS() : 0) - Math.max(0, haveDays = ClientProgressionData.getRankXDaysSinceS(this.monster.entityType())))) > 0) {
                            String key = remDays == 1 ? "screen.araxers_bestiary.rankx.locked_days_remaining.one" : "screen.araxers_bestiary.rankx.locked_days_remaining.other";
                            tooltipLines.add(Component.m_237110_((String)key, (Object[])new Object[]{remDays}));
                        }
                        guiGraphics.m_280677_(BestiaryScreen.this.f_96547_, tooltipLines, Optional.empty(), mouseX, mouseY);
                    }
                    if (hasIcons) {
                        Map<String, Integer> prog = ClientProgressionData.getRankXChallengeProgress(this.monster.entityType());
                        boolean tooltipShown = false;
                        for (int i = 0; i < nIcons; ++i) {
                            RankXConfig.Challenge c = chList.get(i);
                            String chId = c.id();
                            ItemStack stack = this.iconForChallengeId(chId);
                            int iconCenterX = barX + pad + (int)Math.round(step * (double)(i + 1));
                            int iconX = iconCenterX - iconSize / 2;
                            guiGraphics.m_280480_(stack, iconX, iconY);
                            if (tooltipShown || mouseX < iconX || mouseX > iconX + iconSize || mouseY < iconY || mouseY > iconY + iconSize) continue;
                            int val = prog.getOrDefault(chId, 0);
                            String name = this.localizeChallengeName(chId);
                            ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
                            tip.add(Component.m_237113_((String)name));
                            tip.add(Component.m_237113_((String)(val + "/" + c.cap() + " (" + c.points() + ")")));
                            guiGraphics.m_280677_(BestiaryScreen.this.f_96547_, tip, Optional.empty(), mouseX, mouseY);
                            tooltipShown = true;
                        }
                    }
                }
                if (Config.enableProgressionSystem && "ranks".equals(Config.progressionSystemType) && RankUtils.compareRanks(rankStr = ClientProgressionData.getRank(this.monster.entityType()), "S") < 0 && (esThRaw = ClientProgressionData.getESThreshold(this.monster.entityType())) > 0) {
                    boolean hoverES;
                    int esPts = ClientProgressionData.getESPoints(this.monster.entityType());
                    int esTh = esThRaw;
                    int barX = this.x + 6;
                    int barY = this.y;
                    int totalWidth = Math.max(1, this.width - 12);
                    float ratio = Math.min(1.0f, esTh > 0 ? (float)esPts / (float)esTh : 0.0f);
                    this.drawVillagerProgressBarStretched(guiGraphics, barX, barY, totalWidth, ratio);
                    boolean bl = hoverES = mouseX >= barX && mouseX <= barX + totalWidth && mouseY >= barY && mouseY <= barY + 5;
                    if (!hoverES) {
                        int percent = Math.round(ratio * 100.0f);
                        String percentText = percent + "%";
                        int textW = BestiaryScreen.this.f_96547_.m_92895_(percentText);
                        int textX = barX + (totalWidth - textW) / 2;
                        Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                        int textY = barY + (5 - 9) / 2;
                        int outlineColor = 0;
                        for (int dx = -1; dx <= 1; ++dx) {
                            for (int dy = -1; dy <= 1; ++dy) {
                                if (dx == 0 && dy == 0) continue;
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX + dx, textY + dy, outlineColor, false);
                            }
                        }
                        int esColor = 0x55FF55;
                        guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, percentText, textX, textY, esColor, false);
                    }
                    if (mouseX >= barX && mouseX <= barX + totalWidth && mouseY >= barY && mouseY <= barY + 5) {
                        String from;
                        String string = from = rankStr != null && !rankStr.isEmpty() ? rankStr : "E";
                        if (from.equals("") || from.equals("")) {
                            from = "E";
                        }
                        String to = RankUtils.getNextRank(from);
                        MutableComponent tipComp = Component.m_237113_((String)("Rank " + from + " -> " + to + ": " + esPts + "/" + esTh));
                        guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)tipComp, mouseX, mouseY);
                    }
                }
            }
            int health = this.monster.health();
            int yOffset = statsY;
            guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.stats.health").getString(), statsX, yOffset, 0, false);
            int textWidth = BestiaryScreen.this.f_96547_.m_92895_(Component.m_237115_((String)"screen.araxers_bestiary.stats.health").getString());
            if (health <= 20) {
                int i;
                int heartWidth = 9;
                int heartHeight = 9;
                int heartSpacing = 1;
                ResourceLocation iconsTexture = ResourceLocation.m_135820_((String)"minecraft:textures/gui/icons.png");
                int fullHearts = health / 2;
                boolean hasHalfHeart = health % 2 == 1;
                int heartsStartX = statsX + textWidth;
                int heartsEndX = heartsStartX + 10 * (heartWidth + heartSpacing);
                for (i = 0; i < 10; ++i) {
                    int heartX = statsX + textWidth + i * (heartWidth + heartSpacing);
                    guiGraphics.m_280163_(iconsTexture, heartX, yOffset, 16.0f, 0.0f, heartWidth, heartHeight, 256, 256);
                }
                for (i = 0; i < fullHearts; ++i) {
                    int heartX = statsX + textWidth + i * (heartWidth + heartSpacing);
                    guiGraphics.m_280163_(iconsTexture, heartX, yOffset, 52.0f, 0.0f, heartWidth, heartHeight, 256, 256);
                }
                if (hasHalfHeart) {
                    int heartX = statsX + textWidth + fullHearts * (heartWidth + heartSpacing);
                    guiGraphics.m_280163_(iconsTexture, heartX, yOffset, 61.0f, 0.0f, heartWidth, heartHeight, 256, 256);
                }
                if (mouseX >= heartsStartX && mouseX <= heartsEndX && mouseY >= yOffset && mouseY <= yOffset + heartHeight) {
                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.health", (Object[])new Object[]{health}), mouseX, mouseY);
                }
            } else {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, String.valueOf(health), statsX + textWidth, yOffset, 0, false);
            }
            this.drawMarqueeText(guiGraphics, Component.m_237115_((String)"screen.araxers_bestiary.stats.damage").getString() + this.monster.damage(), statsX, statsY + 15, 0, Math.max(1, this.x + this.width - 6 - 2 - statsX - 2));
            if (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowAdvancedAttributes(this.monster.entityType())) {
                if (!this.showRankXInsteadOfAttributes) {
                    ArrayList<Object> combinedAttrs = new ArrayList<Object>();
                    String knockbackText = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                    combinedAttrs.add(knockbackText);
                    int armor = this.monster.armor();
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString() + ": " + armor);
                    float armorToughness = this.monster.armorToughness();
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString() + ": " + String.format("%.1f", Float.valueOf(armorToughness)));
                    float movementSpeed = this.monster.movementSpeed();
                    String speedCategory = movementSpeed == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (movementSpeed <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (movementSpeed <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (movementSpeed <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (movementSpeed <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                    String speedText = Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{speedCategory}).getString() + " (" + String.format("%.3f", Float.valueOf(movementSpeed)) + ")";
                    combinedAttrs.add(speedText);
                    int experience = this.monster.experience();
                    if (experience == 0) {
                        combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString());
                    } else {
                        combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + experience + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString());
                    }
                    List<AdvRowType> rows = this.buildAdvancedRows(this.monster);
                    LiveAttrs la = this.getLiveAttrsFor(this.monster.entityType());
                    Double frVal = la != null ? la.followRange : null;
                    Double akbVal = la != null ? la.attackKnockback : null;
                    Double flyVal = la != null ? la.flyingSpeed : null;
                    Double asVal = la != null ? la.attackSpeed : null;
                    int listY = statsY + 30;
                    int lineHeight = 15;
                    int visibleRows = 5;
                    int areaHeight = visibleRows * lineHeight;
                    int content = rows.size();
                    int maxOffset = Math.max(0, content - visibleRows);
                    if (this.advAttrScrollOffset > maxOffset) {
                        this.advAttrScrollOffset = maxOffset;
                    }
                    if (this.advAttrScrollOffset < 0) {
                        this.advAttrScrollOffset = 0;
                    }
                    int startIndex = Math.min(this.advAttrScrollOffset, Math.max(0, maxOffset));
                    int endIndex = Math.min(startIndex + visibleRows, content);
                    int drawY = listY;
                    ResourceLocation iconsTexture = ResourceLocation.m_135820_((String)"minecraft:textures/gui/icons.png");
                    int advScrollbarWidth = 6;
                    int advRightBound = this.x + this.width - advScrollbarWidth - 2;
                    int advClipWidthFromStatsX = Math.max(1, advRightBound - statsX - 2);
                    for (int i = startIndex; i < endIndex; ++i) {
                        AdvRowType type = rows.get(i);
                        switch (type) {
                            case KNOCKBACK: {
                                String knockText = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                                this.drawMarqueeText(guiGraphics, knockText, statsX, drawY, 0, advClipWidthFromStatsX);
                                break;
                            }
                            case ARMOR: {
                                int k;
                                int armorVal = this.monster.armor();
                                String lbl = Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString();
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, lbl, statsX, drawY, 0, false);
                                int textW = BestiaryScreen.this.f_96547_.m_92895_(lbl);
                                if (armorVal <= 20) {
                                    int ax;
                                    int armorWidth = 9;
                                    int armorHeight = 9;
                                    int armorSpacing = 1;
                                    int fullArmor = armorVal / 2;
                                    boolean half = armorVal % 2 == 1;
                                    int startX = statsX + textW;
                                    for (k = 0; k < 10; ++k) {
                                        ax = startX + k * (armorWidth + armorSpacing);
                                        guiGraphics.m_280163_(iconsTexture, ax, drawY, 16.0f, 9.0f, armorWidth, armorHeight, 256, 256);
                                    }
                                    for (k = 0; k < fullArmor; ++k) {
                                        ax = statsX + textW + k * (armorWidth + armorSpacing);
                                        guiGraphics.m_280163_(iconsTexture, ax, drawY, 34.0f, 9.0f, armorWidth, armorHeight, 256, 256);
                                    }
                                    if (half) {
                                        int ax2 = statsX + textW + fullArmor * (armorWidth + armorSpacing);
                                        guiGraphics.m_280163_(iconsTexture, ax2, drawY, 25.0f, 9.0f, armorWidth, armorHeight, 256, 256);
                                    }
                                    int start = statsX + textW;
                                    int end = start + 10 * (armorWidth + armorSpacing);
                                    if (mouseX < start || mouseX > end || mouseY < drawY || mouseY > drawY + armorHeight) break;
                                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.armor", (Object[])new Object[]{armorVal}), mouseX, mouseY);
                                    break;
                                }
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, String.valueOf(armorVal), statsX + textW, drawY, 0, false);
                                break;
                            }
                            case TOUGHNESS: {
                                float tough = this.monster.armorToughness();
                                int toughHalf = (int)(tough * 2.0f);
                                String lbl = Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString();
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, lbl, statsX, drawY, 0, false);
                                int textW = BestiaryScreen.this.f_96547_.m_92895_(lbl);
                                if (toughHalf <= 20) {
                                    int px;
                                    int k;
                                    int w = 9;
                                    int h = 9;
                                    int s = 1;
                                    int full = toughHalf / 2;
                                    boolean half = toughHalf % 2 == 1;
                                    int startX = statsX + textW;
                                    for (k = 0; k < 10; ++k) {
                                        px = startX + k * (w + s);
                                        guiGraphics.m_280163_(iconsTexture, px, drawY, 16.0f, 9.0f, w, h, 256, 256);
                                    }
                                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                    for (k = 0; k < full; ++k) {
                                        px = statsX + textW + k * (w + s);
                                        guiGraphics.m_280163_(iconsTexture, px, drawY, 34.0f, 9.0f, w, h, 256, 256);
                                    }
                                    if (half) {
                                        int px2 = statsX + textW + full * (w + s);
                                        guiGraphics.m_280163_(iconsTexture, px2, drawY, 25.0f, 9.0f, w, h, 256, 256);
                                    }
                                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                    int start = statsX + textW;
                                    int end = start + 10 * (w + s);
                                    if (mouseX < start || mouseX > end || mouseY < drawY || mouseY > drawY + h) break;
                                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.toughness", (Object[])new Object[]{Float.valueOf(tough)}), mouseX, mouseY);
                                    break;
                                }
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, String.format("%.1f", Float.valueOf(tough)), statsX + textW, drawY, 0, false);
                                break;
                            }
                            case MOVEMENT: {
                                float ms = this.monster.movementSpeed();
                                String spdCat = ms == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (ms <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (ms <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (ms <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (ms <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                String label = Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{spdCat}).getString();
                                this.drawMarqueeText(guiGraphics, label, statsX, drawY, 0, advClipWidthFromStatsX);
                                int widthLbl = BestiaryScreen.this.f_96547_.m_92895_(label);
                                if (mouseX < statsX || mouseX > statsX + widthLbl || mouseY < drawY) break;
                                Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                                if (mouseY > drawY + 9) break;
                                guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.speed", (Object[])new Object[]{Float.valueOf(ms)}), mouseX, mouseY);
                                break;
                            }
                            case EXPERIENCE: {
                                int k;
                                int expVal = this.monster.experience();
                                String lbl = Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString();
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, lbl, statsX, drawY, 0, false);
                                int expTextWidth = BestiaryScreen.this.f_96547_.m_92895_(lbl);
                                if (expVal == 0) {
                                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString(), statsX + expTextWidth, drawY, 0, false);
                                    break;
                                }
                                if (expVal <= 10) {
                                    int orbWidth = 8;
                                    int orbHeight = 8;
                                    int orbSpacing = 1;
                                    ResourceLocation expOrbTexture = ResourceLocation.m_135820_((String)"minecraft:textures/entity/experience_orb.png");
                                    int startX = statsX + expTextWidth;
                                    int endX = startX + expVal * (orbWidth + orbSpacing);
                                    RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
                                    for (k = 0; k < expVal; ++k) {
                                        int ox = startX + k * (orbWidth + orbSpacing);
                                        guiGraphics.m_280163_(expOrbTexture, ox, drawY, 8.0f, 8.0f, orbWidth, orbHeight, 32, 32);
                                    }
                                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                                    if (mouseX < startX || mouseX > endX || mouseY < drawY || mouseY > drawY + orbHeight) break;
                                    guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.experience", (Object[])new Object[]{expVal}), mouseX, mouseY);
                                    break;
                                }
                                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, String.valueOf(expVal) + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString(), statsX + expTextWidth, drawY, 0, false);
                                break;
                            }
                            case FOLLOW_RANGE: {
                                if (frVal == null) break;
                                this.drawMarqueeText(guiGraphics, Component.m_237110_((String)"screen.araxers_bestiary.stats.follow_range", (Object[])new Object[]{String.format("%.2f", frVal)}).getString(), statsX, drawY, 0, advClipWidthFromStatsX);
                                break;
                            }
                            case ATTACK_KNOCKBACK: {
                                if (akbVal == null) break;
                                this.drawMarqueeText(guiGraphics, Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_knockback", (Object[])new Object[]{String.format("%.2f", akbVal)}).getString(), statsX, drawY, 0, advClipWidthFromStatsX);
                                break;
                            }
                            case FLY_SPEED: {
                                if (flyVal == null) break;
                                float fs = flyVal.floatValue();
                                String spdCat = fs == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (fs <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (fs <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (fs <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (fs <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                String label = Component.m_237110_((String)"screen.araxers_bestiary.stats.fly_speed", (Object[])new Object[]{spdCat}).getString();
                                this.drawMarqueeText(guiGraphics, label, statsX, drawY, 0, advClipWidthFromStatsX);
                                int widthLbl = BestiaryScreen.this.f_96547_.m_92895_(label);
                                if (mouseX < statsX || mouseX > statsX + widthLbl || mouseY < drawY) break;
                                Objects.requireNonNull(BestiaryScreen.this.f_96547_);
                                if (mouseY > drawY + 9) break;
                                guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, (Component)Component.m_237110_((String)"screen.araxers_bestiary.tooltip.speed", (Object[])new Object[]{Float.valueOf(fs)}), mouseX, mouseY);
                                break;
                            }
                            case ATTACK_SPEED: {
                                if (asVal == null) break;
                                this.drawMarqueeText(guiGraphics, Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_speed", (Object[])new Object[]{String.format("%.2f", asVal)}).getString(), statsX, drawY, 0, advClipWidthFromStatsX);
                            }
                        }
                        drawY += lineHeight;
                    }
                    if (content > visibleRows) {
                        int scrollbarWidth = 6;
                        int scrollbarX = this.x + this.width - scrollbarWidth - 2;
                        guiGraphics.m_280163_(TEXTURE, scrollbarX, listY, 180.0f, 160.0f, scrollbarWidth, areaHeight, 512, 512);
                        int minThumbHeight = 15;
                        int thumbHeight = Math.max((int)((float)areaHeight * ((float)visibleRows / (float)content)), minThumbHeight);
                        float scrollRatio = (float)this.advAttrScrollOffset / (float)Math.max(1, content - visibleRows);
                        int thumbY = listY + (int)((float)(areaHeight - thumbHeight) * scrollRatio);
                        boolean hoveringOverScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                        int thumbColor = this.isDraggingAdvAttr || hoveringOverScrollbar ? -594735 : -1784461;
                        guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
                    }
                }
            } else {
                int advScrollbarWidth = 6;
                int advRightBound = this.x + this.width - advScrollbarWidth - 2;
                int advClipWidth = Math.max(1, advRightBound - statsX - 2);
                String advLockedMsg = Component.m_237115_((String)"screen.araxers_bestiary.stats.advanced_locked").getString();
                this.drawMarqueeText(guiGraphics, advLockedMsg, statsX, statsY + 30, 0xFF0000, advClipWidth);
                String advNeedMsg = "kills".equals(Config.progressionSystemType) ? Component.m_237110_((String)"screen.araxers_bestiary.stats.need_defeats", (Object[])new Object[]{Config.advancedAttributesThreshold}).getString() : Component.m_237110_((String)"screen.araxers_bestiary.stats.need_rank", (Object[])new Object[]{Config.advancedAttributesRank}).getString();
                this.drawMarqueeText(guiGraphics, advNeedMsg, statsX, statsY + 45, 0xFF0000, advClipWidth);
            }
            if (this.monster.entityType() != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx == null || !Config.enableProgressionSystem || !"ranks".equals(Config.progressionSystemType) || rxEligible) {
                    // empty if block
                }
            }
        }

        private void renderLocationsTab(GuiGraphics guiGraphics, int mouseX, int mouseY, int statsX, int statsY, int killCount) {
            if (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowSpawnLocations(this.monster.entityType())) {
                if (this.monster.spawnLocation().hasMultipleLocations()) {
                    List<Component> locations = this.monster.spawnLocation().getAllLocations();
                    int maxVisibleLocations = 7;
                    int rowHeight = 12;
                    int rowGap = 2;
                    int rowStride = 14;
                    int startIndex = Math.min(this.spawnLocationsScrollOffset, Math.max(0, locations.size() - maxVisibleLocations));
                    int endIndex = Math.min(startIndex + maxVisibleLocations, locations.size());
                    int scrollbarWidth = 6;
                    int rightReserve = 20;
                    for (int i = startIndex; i < endIndex; ++i) {
                        String locText;
                        int locationY = statsY + (i - startIndex) * 14;
                        int rowX = statsX + 5;
                        int availableWidth = this.x + this.width - rowX;
                        int rowW = Math.max(1, availableWidth - 20);
                        guiGraphics.m_280163_(TEXTURE, rowX, locationY, 0.0f, 320.0f, rowW, 12, 512, 512);
                        int textX = rowX + 6;
                        int textY = locationY + 2;
                        if (locations.get(i).getString().contains(".")) {
                            String split;
                            if (locations.get(i).getString().contains("/")) {
                                split = locations.get(i).getString().split("/")[1];
                            } else {
                                String[] parts = locations.get(i).getString().split("\\.");
                                split = parts[parts.length - 1];
                            }
                            StringBuilder displayName = new StringBuilder();
                            boolean nextUpper = true;
                            for (char c : split.toCharArray()) {
                                if (c == '_') {
                                    displayName.append(' ');
                                    nextUpper = true;
                                    continue;
                                }
                                displayName.append(nextUpper ? Character.toUpperCase(c) : c);
                                nextUpper = false;
                            }
                            locText = displayName.toString();
                        } else {
                            locText = locations.get(i).getString();
                        }
                        int clipWidth = Math.max(1, rowW - (textX - rowX) - 2);
                        this.drawSpawnLocationMarqueeText(guiGraphics, locText, textX, textY, 0, clipWidth);
                    }
                    if (locations.size() > maxVisibleLocations) {
                        int scrollbarX = this.x + this.width - 6 - 10;
                        int scrollbarHeight = maxVisibleLocations * 14;
                        guiGraphics.m_280163_(TEXTURE, scrollbarX, statsY, 180.0f, 160.0f, 6, scrollbarHeight, 512, 512);
                        float contentRatio = (float)maxVisibleLocations / (float)locations.size();
                        int minThumbHeight = 15;
                        int thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                        float scrollRatio = (float)this.spawnLocationsScrollOffset / (float)Math.max(1, locations.size() - maxVisibleLocations);
                        int thumbY = statsY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                        boolean hoveringOverScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + 6 && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                        int thumbColor = this.isDragging || hoveringOverScrollbar ? -594735 : -1784461;
                        guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + 6, thumbY + thumbHeight, thumbColor);
                    }
                } else {
                    int scrollbarWidth = 6;
                    int rightReserve = 20;
                    int locationY = statsY + 20;
                    int rowX = statsX + 5;
                    int availableWidth = this.x + this.width - rowX;
                    int rowW = Math.max(1, availableWidth - 20);
                    int rowHeight = 12;
                    guiGraphics.m_280163_(TEXTURE, rowX, locationY, 0.0f, 320.0f, rowW, 12, 512, 512);
                    String primary = this.monster.spawnLocation().getPrimaryLocation().getString();
                    int textX = rowX + 6;
                    int textY = locationY + 2;
                    int clipWidth = Math.max(1, rowW - (textX - rowX) - 2);
                    this.drawSpawnLocationMarqueeText(guiGraphics, primary, textX, textY, 0, clipWidth);
                }
            } else {
                int locRightBound = this.x + this.width - 6;
                int locClipWidth = Math.max(1, locRightBound - statsX - 2);
                String spawnLocked = Component.m_237115_((String)"screen.araxers_bestiary.spawn.locked").getString();
                this.drawMarqueeText(guiGraphics, spawnLocked, statsX, statsY + 20, 0xFF0000, locClipWidth);
                String spawnNeed = "kills".equals(Config.progressionSystemType) ? Component.m_237110_((String)"screen.araxers_bestiary.spawn.need_defeats", (Object[])new Object[]{Config.spawnLocationThreshold}).getString() : Component.m_237110_((String)"screen.araxers_bestiary.spawn.need_rank", (Object[])new Object[]{Config.spawnLocationRank}).getString();
                this.drawMarqueeText(guiGraphics, spawnNeed, statsX, statsY + 35, 0xFF0000, locClipWidth);
            }
        }

        private void renderLootTab(GuiGraphics guiGraphics, int mouseX, int mouseY, int statsX, int statsY, int killCount) {
            boolean showIcons;
            if (this.monster.loot().isEmpty()) {
                guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, Component.m_237115_((String)"screen.araxers_bestiary.loot.no_drops").getString(), statsX, statsY + 20, 0, false);
                return;
            }
            boolean bl = showIcons = !Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootIcons(this.monster.entityType());
            if (!showIcons) {
                int lootRightBound = this.x + this.width - 6;
                int lootClipWidth = Math.max(1, lootRightBound - statsX - 2);
                String lootLocked = Component.m_237115_((String)"screen.araxers_bestiary.loot.locked").getString();
                this.drawMarqueeText(guiGraphics, lootLocked, statsX, statsY + 20, 0xFF0000, lootClipWidth);
                String lootNeed = "kills".equals(Config.progressionSystemType) ? Component.m_237110_((String)"screen.araxers_bestiary.loot.need_defeats", (Object[])new Object[]{Config.lootIconThreshold}).getString() : Component.m_237110_((String)"screen.araxers_bestiary.loot.need_rank", (Object[])new Object[]{Config.lootIconRank}).getString();
                this.drawMarqueeText(guiGraphics, lootNeed, statsX, statsY + 35, 0xFF0000, lootClipWidth);
                return;
            }
            int itemX = statsX;
            int itemY = statsY;
            int itemsPerRow = 5;
            int maxVisibleRows = 3;
            int maxVisibleItems = itemsPerRow * maxVisibleRows;
            boolean showDropChances = !Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootChances(this.monster.entityType());
            int totalRows = (this.monster.loot().size() + itemsPerRow - 1) / itemsPerRow;
            int startIndex = Math.min(this.lootItemsScrollOffset * itemsPerRow, Math.max(0, this.monster.loot().size() - maxVisibleItems));
            int endIndex = Math.min(startIndex + maxVisibleItems, this.monster.loot().size());
            for (int i = startIndex; i < endIndex; ++i) {
                Component tooltipComp;
                LootItemEntry lootEntry = this.monster.loot().get(i);
                int adjustedIndex = i - startIndex;
                int row = adjustedIndex / itemsPerRow;
                int col = adjustedIndex % itemsPerRow;
                int itemPosX = itemX + col * BestiaryScreen.this.scaledItemSpacing;
                int itemPosY = itemY + row * BestiaryScreen.this.scaledItemSpacing;
                guiGraphics.m_280163_(TEXTURE, itemPosX - 2, itemPosY - 2, 200.0f, 200.0f, 20, 20, 512, 512);
                guiGraphics.m_280480_(lootEntry.itemStack(), itemPosX, itemPosY);
                if (showDropChances) {
                    String dropChance = lootEntry.getDropChanceString();
                    int dropChanceWidth = BestiaryScreen.this.f_96547_.m_92895_(dropChance);
                    guiGraphics.m_280056_(BestiaryScreen.this.f_96547_, dropChance, itemPosX + (16 - dropChanceWidth) / 2, itemPosY + 16 + 3, 0, false);
                }
                if (mouseX < itemPosX || mouseX >= itemPosX + 16 || mouseY < itemPosY || mouseY >= itemPosY + 16) continue;
                String baseStr = "";
                String dispStr = "";
                try {
                    baseStr = lootEntry.itemStack().m_41786_().getString();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    dispStr = lootEntry.displayName() != null ? lootEntry.displayName().getString() : "";
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (dispStr == null) {
                    dispStr = "";
                }
                if (baseStr == null) {
                    baseStr = "";
                }
                baseStr = baseStr.trim();
                if ((dispStr = dispStr.trim()).isEmpty()) {
                    tooltipComp = lootEntry.itemStack().m_41786_();
                } else {
                    boolean containsBase = !baseStr.isEmpty() && dispStr.toLowerCase(Locale.ROOT).contains(baseStr.toLowerCase(Locale.ROOT));
                    tooltipComp = containsBase ? Component.m_237113_((String)dispStr) : lootEntry.itemStack().m_41786_().m_6881_().m_130946_(" ").m_7220_(lootEntry.displayName());
                }
                guiGraphics.m_280557_(BestiaryScreen.this.f_96547_, tooltipComp, mouseX, mouseY);
            }
            if (this.monster.loot().size() > maxVisibleItems) {
                int scrollbarWidth = 6;
                int scrollbarX = this.x + this.width - scrollbarWidth - 5;
                int scrollbarHeight = maxVisibleRows * BestiaryScreen.this.scaledItemSpacing;
                guiGraphics.m_280163_(TEXTURE, scrollbarX, statsY, 180.0f, 160.0f, scrollbarWidth, scrollbarHeight, 512, 512);
                float contentRatio = (float)maxVisibleRows / (float)totalRows;
                int minThumbHeight = 15;
                int thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                float scrollRatio = (float)this.lootItemsScrollOffset / (float)Math.max(1, totalRows - maxVisibleRows);
                int thumbY = statsY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                boolean hoveringOverScrollbar = mouseX >= scrollbarX && mouseX <= scrollbarX + scrollbarWidth && mouseY >= thumbY && mouseY <= thumbY + thumbHeight;
                int thumbColor = this.isDraggingLoot || hoveringOverScrollbar ? -594735 : -1784461;
                guiGraphics.m_280509_(scrollbarX, thumbY, scrollbarX + scrollbarWidth, thumbY + thumbHeight, thumbColor);
            }
            if (Config.enableProgressionSystem && (this.monster.entityType() == null || !ClientProgressionData.shouldShowLootChances(this.monster.entityType()))) {
                int messageY = itemY + maxVisibleRows * BestiaryScreen.this.scaledItemSpacing + 10;
                int dcRightBound = this.x + this.width - 6;
                int dcClipWidth = Math.max(1, dcRightBound - statsX - 2);
                String dcLocked = Component.m_237115_((String)"screen.araxers_bestiary.loot.drop_chances_locked").getString();
                this.drawMarqueeText(guiGraphics, dcLocked, statsX, messageY - 23, 0xFF0000, dcClipWidth);
                String dcNeed = "kills".equals(Config.progressionSystemType) ? Component.m_237110_((String)"screen.araxers_bestiary.loot.need_defeats", (Object[])new Object[]{Config.lootChanceThreshold}).getString() : Component.m_237110_((String)"screen.araxers_bestiary.loot.need_rank", (Object[])new Object[]{Config.lootChanceRank}).getString();
                this.drawMarqueeText(guiGraphics, dcNeed, statsX, messageY - 8, 0xFF0000, dcClipWidth);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean m_6375_(double mouseX, double mouseY, int button) {
            int scrollbarHeight;
            if (BestiaryScreen.this.currentTab == TabType.ATTRIBUTES && this.monster != null && this.monster.entityType() != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx != null && !rx.getChallenges().isEmpty() && this.showRankXInsteadOfAttributes) {
                    int statsY = this.y + 10;
                    int listY = statsY + 58;
                    int lineHeight = 10;
                    int visibleRows = Math.max(1, Math.min(4, rx.getChallenges().size()));
                    if (rx.getChallenges().size() > visibleRows) {
                        int scrollbarWidth = 6;
                        int scrollbarX = this.x + this.width - scrollbarWidth - 5;
                        scrollbarHeight = visibleRows * lineHeight;
                        if (mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)listY && mouseY <= (double)(listY + scrollbarHeight)) {
                            this.isDraggingRankX = true;
                            int minThumbHeight = 15;
                            int thumbHeight = Math.max((int)((float)scrollbarHeight * ((float)visibleRows / (float)rx.getChallenges().size())), minThumbHeight);
                            float ratio = (float)(mouseY - (double)listY) / (float)Math.max(1, scrollbarHeight - thumbHeight);
                            int maxOffset = Math.max(0, rx.getChallenges().size() - visibleRows);
                            this.rankXScrollOffset = Math.max(0, Math.min((int)(ratio * (float)maxOffset), maxOffset));
                            return true;
                        }
                    }
                }
            }
            if (!(BestiaryScreen.this.currentTab != TabType.ATTRIBUTES || this.monster == null || this.monster.entityType() == null || this.showRankXInsteadOfAttributes || Config.enableProgressionSystem && !ClientProgressionData.shouldShowAdvancedAttributes(this.monster.entityType()))) {
                ArrayList<Object> combinedAttrs = new ArrayList<Object>();
                String knockbackText = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                combinedAttrs.add(knockbackText);
                combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString() + ": " + this.monster.armor());
                combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString() + ": " + String.format("%.1f", Float.valueOf(this.monster.armorToughness())));
                float ms = this.monster.movementSpeed();
                String sc = ms == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (ms <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (ms <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (ms <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (ms <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{sc}).getString() + " (" + String.format("%.3f", Float.valueOf(ms)) + ")");
                int xp = this.monster.experience();
                if (xp == 0) {
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString());
                } else {
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + xp + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString());
                }
                if (Minecraft.m_91087_().f_91073_ != null) {
                    ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                    Entity temp = null;
                    try {
                        temp = this.monster.entityType().m_20615_((Level)lvl);
                        if (temp instanceof LivingEntity) {
                            LivingEntity le = (LivingEntity)temp;
                            AttributeInstance inst = le.m_21051_(Attributes.f_22277_);
                            if (inst != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.follow_range", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                            if ((inst = le.m_21051_(Attributes.f_22282_)) != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_knockback", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                            if ((inst = le.m_21051_(Attributes.f_22280_)) != null) {
                                float fs = (float)inst.m_22135_();
                                String scFS = fs == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (fs <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (fs <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (fs <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (fs <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.fly_speed", (Object[])new Object[]{scFS}).getString() + " (" + String.format("%.3f", Float.valueOf(fs)) + ")");
                            }
                            if ((inst = le.m_21051_(Attributes.f_22283_)) != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_speed", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                        }
                    }
                    catch (Exception le) {
                    }
                    finally {
                        if (temp != null) {
                            temp.m_142687_(Entity.RemovalReason.DISCARDED);
                        }
                    }
                }
                int statsY = this.y + 10;
                int listY = statsY + 30;
                int lineHeight = 15;
                int visibleRows = 5;
                int areaHeight = visibleRows * lineHeight;
                int scrollbarWidth = 6;
                int content = combinedAttrs.size();
                if (content > visibleRows) {
                    boolean withinTrack;
                    int scrollbarX = this.x + this.width - scrollbarWidth - 2;
                    boolean bl = withinTrack = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)listY && mouseY <= (double)(listY + areaHeight);
                    if (withinTrack) {
                        this.isDraggingAdvAttr = true;
                        int maxOffset = Math.max(0, content - visibleRows);
                        int minThumbHeight = 15;
                        int thumbHeight = Math.max((int)((float)areaHeight * ((float)visibleRows / (float)content)), minThumbHeight);
                        float ratio = (float)(mouseY - (double)listY) / (float)Math.max(1, areaHeight - thumbHeight);
                        this.advAttrScrollOffset = Math.max(0, Math.min((int)(ratio * (float)maxOffset), maxOffset));
                        return true;
                    }
                }
            }
            if (BestiaryScreen.this.currentTab == TabType.LOCATIONS && this.monster != null && this.monster.spawnLocation().hasMultipleLocations() && (!Config.enableProgressionSystem || ClientProgressionData.shouldShowSpawnLocations(this.monster.entityType()))) {
                List<Component> locations = this.monster.spawnLocation().getAllLocations();
                int maxVisibleLocations = 7;
                int rowHeight = 12;
                int rowGap = 2;
                int rowStride = 14;
                if (locations.size() > maxVisibleLocations) {
                    boolean clickedOnTrack;
                    int scrollbarWidth = 6;
                    int scrollbarX = this.x + this.width - scrollbarWidth - 10;
                    int statsY = this.y + 10;
                    scrollbarHeight = maxVisibleLocations * 14;
                    float contentRatio = (float)maxVisibleLocations / (float)locations.size();
                    int minThumbHeight = 15;
                    int thumbHeight = Math.max((int)((float)scrollbarHeight * contentRatio), minThumbHeight);
                    float scrollRatio = (float)this.spawnLocationsScrollOffset / (float)Math.max(1, locations.size() - maxVisibleLocations);
                    int thumbY = statsY + (int)((float)(scrollbarHeight - thumbHeight) * scrollRatio);
                    boolean clickedOnThumb = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight);
                    boolean bl = clickedOnTrack = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)statsY && mouseY <= (double)(statsY + scrollbarHeight);
                    if (clickedOnThumb) {
                        this.isDragging = true;
                        return true;
                    }
                    if (clickedOnTrack) {
                        float newScrollRatio = (float)(mouseY - (double)statsY) / (float)scrollbarHeight;
                        this.spawnLocationsScrollOffset = (int)(newScrollRatio * (float)(locations.size() - maxVisibleLocations));
                        this.spawnLocationsScrollOffset = Math.max(0, Math.min(this.spawnLocationsScrollOffset, locations.size() - maxVisibleLocations));
                        return true;
                    }
                }
            } else if (BestiaryScreen.this.currentTab == TabType.LOOT && this.monster != null && !this.monster.loot().isEmpty() && (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootIcons(this.monster.entityType()))) {
                int itemsPerRow = 5;
                int maxVisibleRows = 3;
                int maxVisibleItems = itemsPerRow * maxVisibleRows;
                int statsY = this.y + 10;
                if (this.monster.loot().size() > maxVisibleItems) {
                    boolean clickedOnTrack;
                    int scrollbarWidth = 6;
                    int scrollbarX = this.x + this.width - scrollbarWidth - 5;
                    int scrollbarHeight2 = maxVisibleRows * BestiaryScreen.this.scaledItemSpacing;
                    int totalRows = (this.monster.loot().size() + itemsPerRow - 1) / itemsPerRow;
                    float contentRatio = (float)maxVisibleRows / (float)totalRows;
                    int minThumbHeight = 15;
                    int thumbHeight = Math.max((int)((float)scrollbarHeight2 * contentRatio), minThumbHeight);
                    float scrollRatio = (float)this.lootItemsScrollOffset / (float)Math.max(1, totalRows - maxVisibleRows);
                    int thumbY = statsY + (int)((float)(scrollbarHeight2 - thumbHeight) * scrollRatio);
                    boolean clickedOnThumb = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)thumbY && mouseY <= (double)(thumbY + thumbHeight);
                    boolean bl = clickedOnTrack = mouseX >= (double)scrollbarX && mouseX <= (double)(scrollbarX + scrollbarWidth) && mouseY >= (double)statsY && mouseY <= (double)(statsY + scrollbarHeight2);
                    if (clickedOnThumb) {
                        this.isDraggingLoot = true;
                        return true;
                    }
                    if (clickedOnTrack) {
                        float newScrollRatio = (float)(mouseY - (double)statsY) / (float)scrollbarHeight2;
                        int totalVisibleRows = totalRows - maxVisibleRows;
                        this.lootItemsScrollOffset = (int)(newScrollRatio * (float)totalVisibleRows);
                        this.lootItemsScrollOffset = Math.max(0, Math.min(this.lootItemsScrollOffset, totalVisibleRows));
                        return true;
                    }
                }
            }
            return false;
        }

        public boolean m_6348_(double mouseX, double mouseY, int button) {
            this.isDragging = false;
            this.isDraggingLoot = false;
            this.isDraggingRankX = false;
            this.isDraggingAdvAttr = false;
            return super.m_6348_(mouseX, mouseY, button);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
            if (this.isDragging && BestiaryScreen.this.currentTab == TabType.LOCATIONS && this.monster != null && this.monster.spawnLocation().hasMultipleLocations() && (!Config.enableProgressionSystem || ClientProgressionData.shouldShowSpawnLocations(this.monster.entityType()))) {
                List<Component> locations = this.monster.spawnLocation().getAllLocations();
                int maxVisibleLocations = 7;
                int rowHeight = 12;
                int rowGap = 2;
                int rowStride = 14;
                int statsY = this.y + 10;
                int scrollbarHeight = maxVisibleLocations * 14;
                float scrollRatio = mouseY < (double)statsY ? 0.0f : (mouseY > (double)(statsY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)statsY) / (float)scrollbarHeight);
                this.spawnLocationsScrollOffset = (int)(scrollRatio * (float)(locations.size() - maxVisibleLocations));
                this.spawnLocationsScrollOffset = Math.max(0, Math.min(this.spawnLocationsScrollOffset, locations.size() - maxVisibleLocations));
                return true;
            }
            if (this.isDraggingLoot && BestiaryScreen.this.currentTab == TabType.LOOT && this.monster != null && !this.monster.loot().isEmpty() && (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootIcons(this.monster.entityType()))) {
                int itemsPerRow = 5;
                int maxVisibleRows = 3;
                int statsY = this.y + 10;
                int scrollbarHeight = maxVisibleRows * BestiaryScreen.this.scaledItemSpacing;
                int totalRows = (this.monster.loot().size() + itemsPerRow - 1) / itemsPerRow;
                float scrollRatio = mouseY < (double)statsY ? 0.0f : (mouseY > (double)(statsY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)statsY) / (float)scrollbarHeight);
                int totalVisibleRows = totalRows - maxVisibleRows;
                this.lootItemsScrollOffset = (int)(scrollRatio * (float)totalVisibleRows);
                this.lootItemsScrollOffset = Math.max(0, Math.min(this.lootItemsScrollOffset, totalVisibleRows));
                return true;
            }
            if (this.isDraggingRankX && BestiaryScreen.this.currentTab == TabType.ATTRIBUTES && this.monster != null && this.monster.entityType() != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx != null && !rx.getChallenges().isEmpty() && this.showRankXInsteadOfAttributes) {
                    int statsY = this.y + 10;
                    int listY = statsY + 58;
                    int lineHeight = 10;
                    int visibleRows = Math.max(1, Math.min(4, rx.getChallenges().size()));
                    int scrollbarHeight = visibleRows * lineHeight;
                    float ratio = mouseY < (double)listY ? 0.0f : (mouseY > (double)(listY + scrollbarHeight) ? 1.0f : (float)(mouseY - (double)listY) / (float)Math.max(1, scrollbarHeight));
                    int maxOffset = Math.max(0, rx.getChallenges().size() - visibleRows);
                    this.rankXScrollOffset = Math.max(0, Math.min((int)(ratio * (float)maxOffset), maxOffset));
                    return true;
                }
            } else if (this.isDraggingAdvAttr && BestiaryScreen.this.currentTab == TabType.ATTRIBUTES && this.monster != null && this.monster.entityType() != null && !this.showRankXInsteadOfAttributes) {
                ArrayList<Object> combinedAttrs = new ArrayList<Object>();
                String knockbackText2 = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                combinedAttrs.add(knockbackText2);
                combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString() + ": " + this.monster.armor());
                combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString() + ": " + String.format("%.1f", Float.valueOf(this.monster.armorToughness())));
                float ms2 = this.monster.movementSpeed();
                String sc2 = ms2 == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (ms2 <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (ms2 <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (ms2 <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (ms2 <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{sc2}).getString() + " (" + String.format("%.3f", Float.valueOf(ms2)) + ")");
                int xp2 = this.monster.experience();
                if (xp2 == 0) {
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString());
                } else {
                    combinedAttrs.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + xp2 + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString());
                }
                if (Minecraft.m_91087_().f_91073_ != null) {
                    ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                    Entity temp = null;
                    try {
                        temp = this.monster.entityType().m_20615_((Level)lvl);
                        if (temp instanceof LivingEntity) {
                            LivingEntity le = (LivingEntity)temp;
                            AttributeInstance inst = le.m_21051_(Attributes.f_22277_);
                            if (inst != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.follow_range", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                            if ((inst = le.m_21051_(Attributes.f_22282_)) != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_knockback", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                            if ((inst = le.m_21051_(Attributes.f_22280_)) != null) {
                                float fs = (float)inst.m_22135_();
                                String scFS = fs == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (fs <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (fs <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (fs <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (fs <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.fly_speed", (Object[])new Object[]{scFS}).getString() + " (" + String.format("%.3f", Float.valueOf(fs)) + ")");
                            }
                            if ((inst = le.m_21051_(Attributes.f_22283_)) != null) {
                                combinedAttrs.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_speed", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                            }
                        }
                    }
                    catch (Exception le) {
                    }
                    finally {
                        if (temp != null) {
                            temp.m_142687_(Entity.RemovalReason.DISCARDED);
                        }
                    }
                }
                int statsY = this.y + 10;
                int listY = statsY + 30;
                int lineHeight = 15;
                int visibleRows = 5;
                int areaHeight = visibleRows * lineHeight;
                int content = combinedAttrs.size();
                if (content > visibleRows) {
                    int minThumbHeight = 15;
                    int thumbHeight = Math.max((int)((float)areaHeight * ((float)visibleRows / (float)content)), minThumbHeight);
                    float ratio = mouseY < (double)listY ? 0.0f : (mouseY > (double)(listY + areaHeight) ? 1.0f : (float)(mouseY - (double)listY) / (float)Math.max(1, areaHeight - thumbHeight));
                    int maxOffset = Math.max(0, content - visibleRows);
                    this.advAttrScrollOffset = Math.max(0, Math.min((int)(ratio * (float)maxOffset), maxOffset));
                    return true;
                }
            }
            return super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean m_6050_(double mouseX, double mouseY, double delta) {
            if (BestiaryScreen.this.currentTab == TabType.LOCATIONS && this.monster != null && this.monster.spawnLocation().hasMultipleLocations() && (!Config.enableProgressionSystem || ClientProgressionData.shouldShowSpawnLocations(this.monster.entityType()))) {
                List<Component> locations = this.monster.spawnLocation().getAllLocations();
                int maxVisibleLocations = 7;
                if (locations.size() > maxVisibleLocations) {
                    if (delta < 0.0 && this.spawnLocationsScrollOffset < locations.size() - maxVisibleLocations) {
                        ++this.spawnLocationsScrollOffset;
                        return true;
                    }
                    if (delta > 0.0 && this.spawnLocationsScrollOffset > 0) {
                        --this.spawnLocationsScrollOffset;
                        return true;
                    }
                }
            } else if (BestiaryScreen.this.currentTab == TabType.LOOT && this.monster != null && !this.monster.loot().isEmpty() && (!Config.enableProgressionSystem || this.monster.entityType() != null && ClientProgressionData.shouldShowLootIcons(this.monster.entityType()))) {
                int itemsPerRow = 5;
                int maxVisibleRows = 3;
                int maxVisibleItems = itemsPerRow * maxVisibleRows;
                int totalRows = (this.monster.loot().size() + itemsPerRow - 1) / itemsPerRow;
                if (this.monster.loot().size() > maxVisibleItems) {
                    int totalVisibleRows = totalRows - maxVisibleRows;
                    if (delta < 0.0 && this.lootItemsScrollOffset < totalVisibleRows) {
                        ++this.lootItemsScrollOffset;
                        return true;
                    }
                    if (delta > 0.0 && this.lootItemsScrollOffset > 0) {
                        --this.lootItemsScrollOffset;
                        return true;
                    }
                }
            } else if (BestiaryScreen.this.currentTab == TabType.ATTRIBUTES && this.monster != null && this.monster.entityType() != null) {
                RankXConfig rx;
                EntityAttributes attrs = BestiaryAttributeManager.getAttributesForEntity(this.monster.entityType());
                RankXConfig rankXConfig = rx = attrs != null ? attrs.rankX() : null;
                if (rx != null && !rx.getChallenges().isEmpty() && this.showRankXInsteadOfAttributes) {
                    int statsY = this.y + 10;
                    int listY = statsY + 58;
                    int lineHeight = 10;
                    int visibleRows = Math.max(1, Math.min(4, rx.getChallenges().size()));
                    if (rx.getChallenges().size() > visibleRows && mouseY >= (double)listY && mouseY <= (double)(listY + visibleRows * lineHeight)) {
                        int maxOffset = rx.getChallenges().size() - visibleRows;
                        if (delta < 0.0 && this.rankXScrollOffset < maxOffset) {
                            ++this.rankXScrollOffset;
                            return true;
                        }
                        if (delta > 0.0 && this.rankXScrollOffset > 0) {
                            --this.rankXScrollOffset;
                            return true;
                        }
                    }
                } else if (!(this.showRankXInsteadOfAttributes || Config.enableProgressionSystem && !ClientProgressionData.shouldShowAdvancedAttributes(this.monster.entityType()))) {
                    ArrayList<Object> combinedAttrs2 = new ArrayList<Object>();
                    String knock2 = Component.m_237110_((String)"screen.araxers_bestiary.stats.knockback_resistance", (Object[])new Object[]{Float.valueOf(this.monster.knockbackResistance() * 100.0f)}).getString();
                    combinedAttrs2.add(knock2);
                    combinedAttrs2.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.armor").getString() + ": " + this.monster.armor());
                    combinedAttrs2.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.toughness").getString() + ": " + String.format("%.1f", Float.valueOf(this.monster.armorToughness())));
                    float ms3 = this.monster.movementSpeed();
                    String sc3 = ms3 == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (ms3 <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (ms3 <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (ms3 <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (ms3 <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.movement_speed", (Object[])new Object[]{sc3}).getString() + " (" + String.format("%.3f", Float.valueOf(ms3)) + ")");
                    int xp3 = this.monster.experience();
                    if (xp3 == 0) {
                        combinedAttrs2.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString());
                    } else {
                        combinedAttrs2.add(Component.m_237115_((String)"screen.araxers_bestiary.stats.experience").getString() + ": " + xp3 + Component.m_237115_((String)"screen.araxers_bestiary.stats.xp").getString());
                    }
                    if (Minecraft.m_91087_().f_91073_ != null) {
                        ClientLevel lvl = Minecraft.m_91087_().f_91073_;
                        Entity temp = null;
                        try {
                            temp = this.monster.entityType().m_20615_((Level)lvl);
                            if (temp instanceof LivingEntity) {
                                LivingEntity le = (LivingEntity)temp;
                                AttributeInstance inst = le.m_21051_(Attributes.f_22277_);
                                if (inst != null) {
                                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.follow_range", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                                }
                                if ((inst = le.m_21051_(Attributes.f_22282_)) != null) {
                                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_knockback", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                                }
                                if ((inst = le.m_21051_(Attributes.f_22280_)) != null) {
                                    float fs = (float)inst.m_22135_();
                                    String scFS = fs == 0.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.none").getString() : (fs <= 0.25f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_slow").getString() : (fs <= 0.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_normal").getString() : (fs <= 1.0f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_fast").getString() : (fs <= 1.5f ? Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_very_fast").getString() : Component.m_237115_((String)"screen.araxers_bestiary.stats.speed_lightning").getString()))));
                                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.fly_speed", (Object[])new Object[]{scFS}).getString() + " (" + String.format("%.3f", Float.valueOf(fs)) + ")");
                                }
                                if ((inst = le.m_21051_(Attributes.f_22283_)) != null) {
                                    combinedAttrs2.add(Component.m_237110_((String)"screen.araxers_bestiary.stats.attack_speed", (Object[])new Object[]{String.format("%.2f", inst.m_22135_())}).getString());
                                }
                            }
                        }
                        catch (Exception le) {
                        }
                        finally {
                            if (temp != null) {
                                temp.m_142687_(Entity.RemovalReason.DISCARDED);
                            }
                        }
                    }
                    int statsY = this.y + 10;
                    int listY2 = statsY + 30;
                    int lineHeight2 = 15;
                    int visibleRows2 = 5;
                    int areaHeight2 = visibleRows2 * lineHeight2;
                    int content2 = combinedAttrs2.size();
                    if (content2 > visibleRows2) {
                        boolean overArea;
                        boolean bl = overArea = mouseX >= (double)(this.x + 6) && mouseX <= (double)(this.x + this.width - 8) && mouseY >= (double)listY2 && mouseY <= (double)(listY2 + areaHeight2);
                        if (overArea) {
                            int maxOffset2 = content2 - visibleRows2;
                            if (delta < 0.0 && this.advAttrScrollOffset < maxOffset2) {
                                ++this.advAttrScrollOffset;
                                return true;
                            }
                            if (delta > 0.0 && this.advAttrScrollOffset > 0) {
                                --this.advAttrScrollOffset;
                                return true;
                            }
                        }
                    }
                }
            }
            return false;
        }

        protected void m_168797_(NarrationElementOutput narrationElementOutput) {
            narrationElementOutput.m_169146_(NarratedElementType.TITLE, (Component)Component.m_237115_((String)"narration.araxers_bestiary.info_panel"));
        }

        private static enum AdvRowType {
            KNOCKBACK,
            ARMOR,
            TOUGHNESS,
            MOVEMENT,
            EXPERIENCE,
            FOLLOW_RANGE,
            ATTACK_KNOCKBACK,
            FLY_SPEED,
            ATTACK_SPEED;

        }

        private static class LiveAttrs {
            final Double followRange;
            final Double attackKnockback;
            final Double flyingSpeed;
            final Double attackSpeed;

            LiveAttrs(Double fr, Double akb, Double fly, Double as) {
                this.followRange = fr;
                this.attackKnockback = akb;
                this.flyingSpeed = fly;
                this.attackSpeed = as;
            }
        }
    }
}

