/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.client.gui;

import com.araxer.araxers_bestiary.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ConfigListScreen
extends Screen {
    private final Screen parent;
    private final List<Entry> entries = new ArrayList<Entry>();
    private int page = 0;
    private static final int ROW_HEIGHT = 22;
    private static final int ENTRIES_PER_PAGE = 12;

    public ConfigListScreen(Screen parent) {
        super((Component)Component.m_237115_((String)"screen.araxers_bestiary.config.title"));
        this.parent = parent;
    }

    protected void m_7856_() {
        this.entries.clear();
        this.buildEntries();
        this.buildPage();
    }

    private void buildEntries() {
        this.entries.add(new Entry("hideZeroKillEntities", (Component)Component.m_237115_((String)"screen.araxers_bestiary.config.hide_zero_kill"), Config.hideZeroKillEntities, v -> Config.setHideZeroKillEntities((Boolean)v)));
        this.entries.add(new Entry("hideNoRankEntities", (Component)Component.m_237113_((String)"Hide no-rank entities"), Config.hideNoRankEntities, v -> Config.setHideNoRankEntities((Boolean)v)));
        this.entries.add(new Entry("forceObfuscation", (Component)Component.m_237113_((String)"Force obfuscation"), Config.forceObfuscation, v -> Config.setForceObfuscation((Boolean)v)));
        this.entries.add(new Entry("hideUndiscovered", (Component)Component.m_237115_((String)"screen.araxers_bestiary.config.hide_undiscovered"), Config.hideUndiscovered, v -> Config.setHideUndiscovered((Boolean)v)));
        this.entries.add(new Entry("debugMode", (Component)Component.m_237115_((String)"screen.araxers_bestiary.config.debug_mode"), Config.debugMode, v -> Config.setDebugMode((Boolean)v)));
        this.entries.add(new Entry("showChallenges", (Component)Component.m_237113_((String)"Show Challenges page"), Config.showChallenges, v -> Config.setShowChallenges((Boolean)v)));
        this.entries.add(new Entry("enableGlobalRankProgressBarCycling", (Component)Component.m_237113_((String)"Allow cycling global progress bar"), Config.enableGlobalRankProgressBarCycling, v -> Config.setEnableGlobalRankProgressBarCycling((Boolean)v)));
        this.entries.add(Entry.cycling("progressBarSpriteSource", (Component)Component.m_237113_((String)"Progress bar sprite source"), Config.progressBarSpriteSource, Arrays.asList("vanilla", "mod"), v -> Config.setProgressBarSpriteSource(String.valueOf(v))));
        this.entries.add(new Entry("enableKeybind", (Component)Component.m_237115_((String)"screen.araxers_bestiary.config.enable_keybind"), Config.enableKeybind, v -> Config.setEnableKeybind((Boolean)v)));
        this.entries.add(new Entry("lowEndMode", (Component)Component.m_237115_((String)"screen.araxers_bestiary.config.low_end_mode"), Config.lowEndMode, v -> Config.setLowEndMode((Boolean)v)));
        this.entries.add(new Entry("lowEndEntityPreview", (Component)Component.m_237113_((String)"Low-end: entity preview"), Config.lowEndEntityPreview, v -> Config.setLowEndEntityPreview((Boolean)v)));
        this.entries.add(new Entry("guiMaxEntityScale", (Component)Component.m_237113_((String)"GUI max entity scale"), Config.guiMaxEntityScale, v -> Config.setGuiMaxEntityScale((Integer)v)));
        this.entries.add(new Entry("lowEndMarqueeIntervalMultiplier", (Component)Component.m_237113_((String)"Low-end: marquee interval multiplier"), Config.lowEndMarqueeIntervalMultiplier, v -> Config.setLowEndMarqueeIntervalMultiplier((Double)v)));
    }

    private static List<String> asStringList(Object v) {
        if (v instanceof List) {
            List l = (List)v;
            ArrayList<String> out = new ArrayList<String>();
            for (Object o : l) {
                if (o == null) continue;
                out.add(String.valueOf(o).trim());
            }
            return out;
        }
        if (v instanceof String) {
            String s = (String)v;
            if (s.isBlank()) {
                return new ArrayList<String>();
            }
            String[] parts = s.split(",");
            ArrayList<String> out = new ArrayList<String>();
            for (String p : parts) {
                String t = p.trim();
                if (t.isEmpty()) continue;
                out.add(t);
            }
            return out;
        }
        return new ArrayList<String>();
    }

    private static List<Integer> asIntList(Object v) {
        ArrayList<Integer> out = new ArrayList<Integer>();
        for (String s : ConfigListScreen.asStringList(v)) {
            try {
                out.add(Integer.parseInt(s));
            }
            catch (Exception exception) {}
        }
        return out;
    }

    private void buildPage() {
        this.m_169413_();
        int start = this.page * 12;
        int end = Math.min(this.entries.size(), start + 12);
        int xLabel = this.f_96543_ / 2 - 160;
        int xControl = this.f_96543_ / 2 + 20;
        int y = 40;
        for (int i = start; i < end; ++i) {
            Entry e = this.entries.get(i);
            switch (e.type) {
                case BOOLEAN: 
                case CYCLING: {
                    String text = ConfigListScreen.formatValue(e);
                    e.button = Button.m_253074_((Component)Component.m_237113_((String)text), b -> {
                        if (e.type == Type.BOOLEAN) {
                            e.value = (Boolean)e.value == false;
                        } else {
                            int idx = e.cycleValues.indexOf(String.valueOf(e.value));
                            if (idx < 0) {
                                idx = 0;
                            }
                            idx = (idx + 1) % e.cycleValues.size();
                            e.value = e.cycleValues.get(idx);
                        }
                        b.m_93666_((Component)Component.m_237113_((String)ConfigListScreen.formatValue(e)));
                    }).m_252987_(xControl, y - 4, 140, 20).m_253136_();
                    if (e.tooltip != null) {
                        e.button.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)e.tooltip)));
                    }
                    this.m_142416_((GuiEventListener)e.button);
                    break;
                }
                case INT: 
                case DOUBLE: 
                case STRING: 
                case STRING_LIST: 
                case INT_LIST: {
                    e.edit = new EditBox(this.f_96547_, xControl, y - 2, 160, 18, e.label);
                    e.edit.m_94144_(ConfigListScreen.stringify(e.value));
                    this.m_142416_((GuiEventListener)e.edit);
                }
            }
            e.resetButton = Button.m_253074_((Component)Component.m_237115_((String)"controls.reset"), b -> this.resetToDefault(e)).m_252987_(xControl + 165, y - 4, 60, 20).m_253136_();
            this.m_142416_((GuiEventListener)e.resetButton);
            y += 22;
        }
        int bottomY = this.f_96544_ - 28;
        Button prev = Button.m_253074_((Component)Component.m_237113_((String)"<"), b -> {
            if (this.page > 0) {
                --this.page;
                this.buildPage();
            }
        }).m_252987_(this.f_96543_ / 2 - 160, bottomY, 20, 20).m_253136_();
        prev.f_93623_ = this.page > 0;
        this.m_142416_((GuiEventListener)prev);
        Button next = Button.m_253074_((Component)Component.m_237113_((String)">"), b -> {
            int maxPage = (this.entries.size() - 1) / 12;
            if (this.page < maxPage) {
                ++this.page;
                this.buildPage();
            }
        }).m_252987_(this.f_96543_ / 2 - 135, bottomY, 20, 20).m_253136_();
        int maxPage = (this.entries.size() - 1) / 12;
        next.f_93623_ = this.page < maxPage;
        this.m_142416_((GuiEventListener)next);
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130656_, b -> this.m_7379_()).m_252987_(this.f_96543_ / 2 - 62 - 100, bottomY, 100, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)CommonComponents.f_130655_, b -> this.applyAndSave()).m_252987_(this.f_96543_ / 2 - 62, bottomY, 124, 20).m_253136_());
        this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"options.resetAll"), b -> this.resetAllToDefaults()).m_252987_(this.f_96543_ / 2 + 65, bottomY, 100, 20).m_253136_());
    }

    private void resetToDefault(Entry e) {
        switch (e.key) {
            case "hideZeroKillEntities": {
                e.value = false;
                break;
            }
            case "hideNoRankEntities": {
                e.value = false;
                break;
            }
            case "forceObfuscation": {
                e.value = false;
                break;
            }
            case "hideUndiscovered": {
                e.value = false;
                break;
            }
            case "debugMode": {
                e.value = false;
                break;
            }
            case "showChallenges": {
                e.value = true;
                break;
            }
            case "enableGlobalRankProgressBarCycling": {
                e.value = true;
                break;
            }
            case "progressBarSpriteSource": {
                e.value = "mod";
                break;
            }
            case "enableKeybind": {
                e.value = true;
                break;
            }
            case "lowEndMode": {
                e.value = false;
                break;
            }
            case "lowEndEntityPreview": {
                e.value = true;
                break;
            }
            case "guiMaxEntityScale": {
                e.value = 100;
                break;
            }
            case "lowEndMarqueeIntervalMultiplier": {
                e.value = 1.5;
            }
        }
        if (e.button != null && (e.type == Type.BOOLEAN || e.type == Type.CYCLING)) {
            e.button.m_93666_((Component)Component.m_237113_((String)ConfigListScreen.formatValue(e)));
        }
        if (e.edit != null) {
            e.edit.m_94144_(ConfigListScreen.stringify(e.value));
        }
    }

    private void resetAllToDefaults() {
        int start = this.page * 12;
        int end = Math.min(this.entries.size(), start + 12);
        for (int i = start; i < end; ++i) {
            this.resetToDefault(this.entries.get(i));
        }
    }

    private static String stringify(Object value) {
        if (value instanceof List) {
            List l = (List)value;
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (Object o : l) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(Objects.toString(o));
                first = false;
            }
            return sb.toString();
        }
        return String.valueOf(value);
    }

    private static String formatValue(Entry e) {
        if (e.type == Type.BOOLEAN) {
            return (Boolean)e.value != false ? "ON" : "OFF";
        }
        if (e.type == Type.CYCLING) {
            return String.valueOf(e.value).toUpperCase(Locale.ROOT);
        }
        return ConfigListScreen.stringify(e.value);
    }

    private void applyAndSave() {
        int start = this.page * 12;
        int end = Math.min(this.entries.size(), start + 12);
        for (int i = start; i < end; ++i) {
            Entry e = this.entries.get(i);
            Object v = e.value;
            if (e.edit != null) {
                v = e.edit.m_94155_();
            }
            try {
                switch (e.type) {
                    case BOOLEAN: {
                        e.apply.accept(v);
                        break;
                    }
                    case CYCLING: 
                    case STRING: {
                        e.apply.accept(String.valueOf(v));
                        break;
                    }
                    case INT: {
                        e.apply.accept(Integer.parseInt(String.valueOf(v).trim()));
                        break;
                    }
                    case DOUBLE: {
                        e.apply.accept(Double.parseDouble(String.valueOf(v).trim()));
                        break;
                    }
                    case STRING_LIST: {
                        e.apply.accept(ConfigListScreen.asStringList(v));
                        break;
                    }
                    case INT_LIST: {
                        e.apply.accept(ConfigListScreen.asIntList(v));
                    }
                }
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.m_7379_();
    }

    public void m_7379_() {
        Minecraft.m_91087_().m_91152_(this.parent);
    }

    public void m_88315_(GuiGraphics gg, int mouseX, int mouseY, float partialTick) {
        this.m_280273_(gg);
        gg.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 10, 0xFFFFFF);
        int maxPage = Math.max(0, (this.entries.size() - 1) / 12);
        String pageTxt = "(" + (this.page + 1) + "/" + (maxPage + 1) + ")";
        gg.m_280056_(this.f_96547_, pageTxt, this.f_96543_ - 10 - this.f_96547_.m_92895_(pageTxt), 16, 0xA0A0A0, false);
        int start = this.page * 12;
        int end = Math.min(this.entries.size(), start + 12);
        int xLabel = this.f_96543_ / 2 - 160;
        int y = 40;
        for (int i = start; i < end; ++i) {
            Entry e = this.entries.get(i);
            gg.m_280614_(this.f_96547_, e.label, xLabel, y, 0xFFFFFF, false);
            y += 22;
        }
        super.m_88315_(gg, mouseX, mouseY, partialTick);
    }

    private static class Entry {
        final String key;
        final Component label;
        Type type;
        Object value;
        final Consumer<Object> apply;
        EditBox edit;
        Button button;
        Button resetButton;
        String tooltip;
        List<String> cycleValues;

        Entry(String key, Component label, boolean value, Consumer<Object> apply) {
            this.key = key;
            this.label = label;
            this.type = Type.BOOLEAN;
            this.value = value;
            this.apply = apply;
        }

        Entry(String key, Component label, int value, Consumer<Object> apply) {
            this.key = key;
            this.label = label;
            this.type = Type.INT;
            this.value = value;
            this.apply = apply;
        }

        Entry(String key, Component label, double value, Consumer<Object> apply) {
            this.key = key;
            this.label = label;
            this.type = Type.DOUBLE;
            this.value = value;
            this.apply = apply;
        }

        Entry(String key, Component label, String value, Consumer<Object> apply) {
            this.key = key;
            this.label = label;
            this.type = Type.STRING;
            this.value = value;
            this.apply = apply;
        }

        Entry(String key, Component label, List<String> value, Consumer<Object> apply) {
            this.key = key;
            this.label = label;
            this.type = Type.STRING_LIST;
            this.value = new ArrayList<String>(value);
            this.apply = apply;
        }

        Entry ints(String key, Component label, List<Integer> value, Consumer<Object> apply) {
            Entry e = new Entry(key, label, 0, apply);
            e.type = Type.INT_LIST;
            e.value = new ArrayList<Integer>(value);
            return e;
        }

        static Entry cycling(String key, Component label, String value, List<String> allowed, Consumer<Object> apply) {
            Entry e = new Entry(key, label, value, apply);
            e.type = Type.CYCLING;
            e.cycleValues = allowed;
            return e;
        }
    }

    private static enum Type {
        BOOLEAN,
        INT,
        DOUBLE,
        STRING,
        STRING_LIST,
        INT_LIST,
        CYCLING;

    }
}

