/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.config;

import com.araxer.araxers_bestiary.client.gui.BestiaryScreen;
import com.araxer.araxers_bestiary.data.GlobalPlayerProgressionData;
import com.araxer.araxers_bestiary.data.PlayerProgressionData;
import com.mojang.logging.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="araxers_bestiary", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Config {
    private static final ForgeConfigSpec.Builder SERVER_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.Builder CLIENT_BUILDER = new ForgeConfigSpec.Builder();
    private static final ForgeConfigSpec.BooleanValue ENABLE_PROGRESSION_SYSTEM;
    private static final ForgeConfigSpec.ConfigValue<String> PROGRESSION_SYSTEM_TYPE_VALUE;
    private static final ForgeConfigSpec.IntValue SPAWN_LOCATION_THRESHOLD_VALUE;
    private static final ForgeConfigSpec.IntValue LOOT_ICON_THRESHOLD_VALUE;
    private static final ForgeConfigSpec.IntValue LOOT_CHANCE_THRESHOLD_VALUE;
    private static final ForgeConfigSpec.IntValue ADVANCED_ATTRIBUTES_THRESHOLD_VALUE;
    private static final ForgeConfigSpec.IntValue DESCRIPTION_THRESHOLD_VALUE;
    private static final ForgeConfigSpec.IntValue MOB_TYPE_CHIP_KILLS_THRESHOLD_VALUE;
    private static final ForgeConfigSpec.ConfigValue<String> MOB_TYPE_CHIP_RANK_VALUE;
    private static final ForgeConfigSpec.DoubleValue RANK_KILL_CHANCE_VALUE;
    private static final ForgeConfigSpec.DoubleValue RANK_FEED_CHANCE_VALUE;
    private static final ForgeConfigSpec.DoubleValue RANK_HIT_CHANCE_VALUE;
    private static final ForgeConfigSpec.DoubleValue RANK_TRADE_CHANCE_VALUE;
    private static final ForgeConfigSpec.DoubleValue COMMAND_ROLLS_VALUE;
    private static final ForgeConfigSpec.DoubleValue BOSS_RANK_MULTIPLIER_VALUE;
    private static final ForgeConfigSpec.BooleanValue ALLOW_OBSERVATION_CHANCE_ROLLS;
    private static final ForgeConfigSpec.ConfigValue<String> ES_MODE_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_E_TO_D_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_D_TO_C_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_C_TO_B_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_B_TO_A_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_A_TO_S_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_KILL_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_FEED_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_HIT_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_TRADE_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_BREED_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_OBSERVE_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_TAME_VALUE;
    private static final ForgeConfigSpec.IntValue POINTS_SPECIAL_BIOME_VALUE;
    private static final ForgeConfigSpec.DoubleValue POINTS_BOSS_MULTIPLIER_VALUE;
    private static final ForgeConfigSpec.BooleanValue ENABLE_PROGRESSIVE_RANK_DIFFICULTY_VALUE;
    private static final ForgeConfigSpec.DoubleValue RANK_D_DIFFICULTY_MULTIPLIER_VALUE;
    private static final ForgeConfigSpec.DoubleValue RANK_C_DIFFICULTY_MULTIPLIER_VALUE;
    private static final ForgeConfigSpec.DoubleValue RANK_B_DIFFICULTY_MULTIPLIER_VALUE;
    private static final ForgeConfigSpec.DoubleValue RANK_A_DIFFICULTY_MULTIPLIER_VALUE;
    private static final ForgeConfigSpec.DoubleValue RANK_S_DIFFICULTY_MULTIPLIER_VALUE;
    private static final ForgeConfigSpec.ConfigValue<String> SPAWN_LOCATION_RANK_VALUE;
    private static final ForgeConfigSpec.ConfigValue<String> LOOT_ICON_RANK_VALUE;
    private static final ForgeConfigSpec.ConfigValue<String> LOOT_CHANCE_RANK_VALUE;
    private static final ForgeConfigSpec.ConfigValue<String> ADVANCED_ATTRIBUTES_RANK_VALUE;
    private static final ForgeConfigSpec.ConfigValue<String> DESCRIPTION_RANK_VALUE;
    private static final ForgeConfigSpec.IntValue RANK_E_WEIGHT_VALUE;
    private static final ForgeConfigSpec.IntValue RANK_D_WEIGHT_VALUE;
    private static final ForgeConfigSpec.IntValue RANK_C_WEIGHT_VALUE;
    private static final ForgeConfigSpec.IntValue RANK_B_WEIGHT_VALUE;
    private static final ForgeConfigSpec.IntValue RANK_A_WEIGHT_VALUE;
    private static final ForgeConfigSpec.IntValue RANK_S_WEIGHT_VALUE;
    private static final ForgeConfigSpec.BooleanValue ENABLE_CHEESE_DETECTION;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MONSTER_CATEGORIES_VALUE;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_BLACKLIST_VALUE;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> ENTITY_INCLUDELIST_VALUE;
    private static final ForgeConfigSpec.IntValue INITIAL_LOOT_SAMPLE_BATCHES_VALUE;
    private static final ForgeConfigSpec.BooleanValue PREWARM_LOOT_CACHE_ON_START_VALUE;
    private static final ForgeConfigSpec.IntValue PREWARM_MAX_ENTITIES_PER_TICK_VALUE;
    private static final ForgeConfigSpec.BooleanValue ENABLE_LOOT_JSON_INSPECTION_FALLBACK_VALUE;
    private static final ForgeConfigSpec.BooleanValue ENABLE_GLOBAL_LOOT_MODIFIER_SUPPLEMENT_VALUE;
    private static final ForgeConfigSpec.BooleanValue ENABLE_DYNAMIC_DROP_TRACKING_VALUE;
    private static final ForgeConfigSpec.IntValue DYNAMIC_DROP_SAMPLE_SIZE_VALUE;
    private static final ForgeConfigSpec.DoubleValue DYNAMIC_DROP_WEIGHT_VALUE;
    private static final ForgeConfigSpec.BooleanValue IGNORE_MODIFIED_DROP_EVENTS_VALUE;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> MODIFIED_DROP_ENCHANTMENTS_VALUE;
    private static final ForgeConfigSpec.ConfigValue<List<? extends Integer>> GLOBAL_S_RANK_THRESHOLDS_VALUE;
    private static final ForgeConfigSpec.ConfigValue<List<? extends String>> GLOBAL_BENEFITS_VALUE;
    private static final ForgeConfigSpec.ConfigValue<String> GLOBAL_RANK_PROGRESS_BAR_TYPE_VALUE;
    private static final ForgeConfigSpec.BooleanValue HIDE_ZERO_KILL_ENTITIES_VALUE;
    private static final ForgeConfigSpec.BooleanValue HIDE_NO_RANK_ENTITIES_VALUE;
    private static final ForgeConfigSpec.BooleanValue FORCE_OBFUSCATION;
    private static final ForgeConfigSpec.BooleanValue HIDE_UNDISCOVERED_VALUE;
    private static final ForgeConfigSpec.BooleanValue DEBUG_MODE;
    private static final ForgeConfigSpec.BooleanValue SHOW_CHALLENGES;
    private static final ForgeConfigSpec.BooleanValue ENABLE_GLOBAL_RANK_PROGRESS_BAR_CYCLING;
    private static final ForgeConfigSpec.ConfigValue<String> PROGRESS_BAR_SPRITE_SOURCE_VALUE;
    private static final ForgeConfigSpec.BooleanValue ENABLE_KEYBIND_VALUE;
    private static final ForgeConfigSpec.BooleanValue LOW_END_MODE;
    private static final ForgeConfigSpec.BooleanValue LOW_END_ENTITY_PREVIEW;
    private static final ForgeConfigSpec.IntValue GUI_MAX_ENTITY_SCALE;
    private static final ForgeConfigSpec.DoubleValue LOW_END_MARQUEE_INTERVAL_MULTIPLIER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static List<ParsedBenefit> parsedGlobalBenefits;
    public static boolean enableProgressionSystem;
    public static String progressionSystemType;
    public static int spawnLocationThreshold;
    public static int lootIconThreshold;
    public static int lootChanceThreshold;
    public static int advancedAttributesThreshold;
    public static int descriptionThreshold;
    public static int mobTypeChipKillsThreshold;
    public static String mobTypeChipRank;
    public static double rankKillChance;
    public static double rankFeedChance;
    public static double rankHitChance;
    public static double rankTradeChance;
    public static double commandRolls;
    public static double bossRankMultiplier;
    public static boolean allowObservationChanceRolls;
    public static String spawnLocationRank;
    public static String lootIconRank;
    public static String lootChanceRank;
    public static String advancedAttributesRank;
    public static String descriptionRank;
    public static String esMode;
    public static int pointsEToD;
    public static int pointsDToC;
    public static int pointsCToB;
    public static int pointsBToA;
    public static int pointsAToS;
    public static int pointsKill;
    public static int pointsFeed;
    public static int pointsHit;
    public static int pointsTrade;
    public static int pointsBreed;
    public static int pointsObserve;
    public static int pointsTame;
    public static int pointsSpecialBiome;
    public static double pointsBossMultiplier;
    public static boolean enableProgressiveRankDifficulty;
    public static double rankDDifficultyMultiplier;
    public static double rankCDifficultyMultiplier;
    public static double rankBDifficultyMultiplier;
    public static double rankADifficultyMultiplier;
    public static double rankSDifficultyMultiplier;
    public static int rankEWeight;
    public static int rankDWeight;
    public static int rankCWeight;
    public static int rankBWeight;
    public static int rankAWeight;
    public static int rankSWeight;
    public static boolean enableCheeseDetection;
    public static List<String> monsterCategories;
    public static List<String> entityBlacklist;
    public static List<String> entityIncludeList;
    public static int initialLootSampleBatches;
    public static boolean prewarmLootCacheOnStart;
    public static int prewarmMaxEntitiesPerTick;
    public static boolean enableLootJsonInspectionFallback;
    public static boolean enableGlobalLootModifierSupplement;
    public static boolean enableDynamicDropTracking;
    public static int dynamicDropSampleSize;
    public static double dynamicDropWeight;
    public static boolean ignoreModifiedDropEvents;
    public static List<String> modifiedDropEnchantments;
    public static List<String> globalBenefits;
    public static boolean hideZeroKillEntities;
    public static boolean hideNoRankEntities;
    public static boolean forceObfuscation;
    public static boolean hideUndiscovered;
    public static boolean debugMode;
    public static boolean showChallenges;
    public static List<Integer> globalSRankThresholds;
    public static String globalRankProgressBarType;
    public static boolean enableGlobalRankProgressBarCycling;
    public static String progressBarSpriteSource;
    public static boolean enableKeybind;
    public static boolean lowEndMode;
    public static boolean lowEndEntityPreview;
    public static int guiMaxEntityScale;
    public static double lowEndMarqueeIntervalMultiplier;

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        if (!event.getConfig().getModId().equals("araxers_bestiary")) {
            return;
        }
        switch (event.getConfig().getType()) {
            case SERVER: {
                PlayerProgressionData data;
                enableProgressionSystem = (Boolean)ENABLE_PROGRESSION_SYSTEM.get();
                progressionSystemType = (String)PROGRESSION_SYSTEM_TYPE_VALUE.get();
                spawnLocationThreshold = (Integer)SPAWN_LOCATION_THRESHOLD_VALUE.get();
                lootIconThreshold = (Integer)LOOT_ICON_THRESHOLD_VALUE.get();
                lootChanceThreshold = (Integer)LOOT_CHANCE_THRESHOLD_VALUE.get();
                advancedAttributesThreshold = (Integer)ADVANCED_ATTRIBUTES_THRESHOLD_VALUE.get();
                descriptionThreshold = (Integer)DESCRIPTION_THRESHOLD_VALUE.get();
                mobTypeChipKillsThreshold = (Integer)MOB_TYPE_CHIP_KILLS_THRESHOLD_VALUE.get();
                mobTypeChipRank = (String)MOB_TYPE_CHIP_RANK_VALUE.get();
                rankKillChance = (Double)RANK_KILL_CHANCE_VALUE.get();
                rankFeedChance = (Double)RANK_FEED_CHANCE_VALUE.get();
                rankHitChance = (Double)RANK_HIT_CHANCE_VALUE.get();
                rankTradeChance = (Double)RANK_TRADE_CHANCE_VALUE.get();
                commandRolls = (Double)COMMAND_ROLLS_VALUE.get();
                bossRankMultiplier = (Double)BOSS_RANK_MULTIPLIER_VALUE.get();
                allowObservationChanceRolls = (Boolean)ALLOW_OBSERVATION_CHANCE_ROLLS.get();
                spawnLocationRank = (String)SPAWN_LOCATION_RANK_VALUE.get();
                lootIconRank = (String)LOOT_ICON_RANK_VALUE.get();
                lootChanceRank = (String)LOOT_CHANCE_RANK_VALUE.get();
                advancedAttributesRank = (String)ADVANCED_ATTRIBUTES_RANK_VALUE.get();
                descriptionRank = (String)DESCRIPTION_RANK_VALUE.get();
                esMode = (String)ES_MODE_VALUE.get();
                pointsEToD = (Integer)POINTS_E_TO_D_VALUE.get();
                pointsDToC = (Integer)POINTS_D_TO_C_VALUE.get();
                pointsCToB = (Integer)POINTS_C_TO_B_VALUE.get();
                pointsBToA = (Integer)POINTS_B_TO_A_VALUE.get();
                pointsAToS = (Integer)POINTS_A_TO_S_VALUE.get();
                pointsKill = (Integer)POINTS_KILL_VALUE.get();
                pointsFeed = (Integer)POINTS_FEED_VALUE.get();
                pointsHit = (Integer)POINTS_HIT_VALUE.get();
                pointsTrade = (Integer)POINTS_TRADE_VALUE.get();
                pointsBreed = (Integer)POINTS_BREED_VALUE.get();
                pointsObserve = (Integer)POINTS_OBSERVE_VALUE.get();
                pointsTame = (Integer)POINTS_TAME_VALUE.get();
                pointsSpecialBiome = (Integer)POINTS_SPECIAL_BIOME_VALUE.get();
                pointsBossMultiplier = (Double)POINTS_BOSS_MULTIPLIER_VALUE.get();
                enableProgressiveRankDifficulty = (Boolean)ENABLE_PROGRESSIVE_RANK_DIFFICULTY_VALUE.get();
                rankDDifficultyMultiplier = (Double)RANK_D_DIFFICULTY_MULTIPLIER_VALUE.get();
                rankCDifficultyMultiplier = (Double)RANK_C_DIFFICULTY_MULTIPLIER_VALUE.get();
                rankBDifficultyMultiplier = (Double)RANK_B_DIFFICULTY_MULTIPLIER_VALUE.get();
                rankADifficultyMultiplier = (Double)RANK_A_DIFFICULTY_MULTIPLIER_VALUE.get();
                rankSDifficultyMultiplier = (Double)RANK_S_DIFFICULTY_MULTIPLIER_VALUE.get();
                rankEWeight = (Integer)RANK_E_WEIGHT_VALUE.get();
                rankDWeight = (Integer)RANK_D_WEIGHT_VALUE.get();
                rankCWeight = (Integer)RANK_C_WEIGHT_VALUE.get();
                rankBWeight = (Integer)RANK_B_WEIGHT_VALUE.get();
                rankAWeight = (Integer)RANK_A_WEIGHT_VALUE.get();
                rankSWeight = (Integer)RANK_S_WEIGHT_VALUE.get();
                enableCheeseDetection = (Boolean)ENABLE_CHEESE_DETECTION.get();
                monsterCategories = new ArrayList<String>((Collection)MONSTER_CATEGORIES_VALUE.get());
                entityBlacklist = new ArrayList<String>((Collection)ENTITY_BLACKLIST_VALUE.get());
                entityIncludeList = new ArrayList<String>((Collection)ENTITY_INCLUDELIST_VALUE.get());
                initialLootSampleBatches = (Integer)INITIAL_LOOT_SAMPLE_BATCHES_VALUE.get();
                prewarmLootCacheOnStart = (Boolean)PREWARM_LOOT_CACHE_ON_START_VALUE.get();
                prewarmMaxEntitiesPerTick = (Integer)PREWARM_MAX_ENTITIES_PER_TICK_VALUE.get();
                enableLootJsonInspectionFallback = (Boolean)ENABLE_LOOT_JSON_INSPECTION_FALLBACK_VALUE.get();
                enableGlobalLootModifierSupplement = (Boolean)ENABLE_GLOBAL_LOOT_MODIFIER_SUPPLEMENT_VALUE.get();
                enableDynamicDropTracking = (Boolean)ENABLE_DYNAMIC_DROP_TRACKING_VALUE.get();
                dynamicDropSampleSize = (Integer)DYNAMIC_DROP_SAMPLE_SIZE_VALUE.get();
                dynamicDropWeight = (Double)DYNAMIC_DROP_WEIGHT_VALUE.get();
                ignoreModifiedDropEvents = (Boolean)IGNORE_MODIFIED_DROP_EVENTS_VALUE.get();
                modifiedDropEnchantments = new ArrayList<String>((Collection)MODIFIED_DROP_ENCHANTMENTS_VALUE.get());
                try {
                    List raw = (List)GLOBAL_S_RANK_THRESHOLDS_VALUE.get();
                    globalSRankThresholds = new ArrayList<Integer>();
                    if (raw != null) {
                        for (Object v : raw) {
                            if (v == null || (Integer)v <= 0) continue;
                            globalSRankThresholds.add((Integer)v);
                        }
                    }
                    if (globalSRankThresholds.isEmpty()) {
                        globalSRankThresholds.add(50);
                    }
                    Collections.sort(globalSRankThresholds);
                    LinkedHashSet<Integer> set = new LinkedHashSet<Integer>(globalSRankThresholds);
                    globalSRankThresholds.clear();
                    globalSRankThresholds.addAll(set);
                }
                catch (Exception e) {
                    globalSRankThresholds = new ArrayList<Integer>();
                    globalSRankThresholds.add(50);
                }
                ArrayList<String> oldBenefits = globalBenefits != null ? new ArrayList<String>(globalBenefits) : null;
                try {
                    List benefitsRaw = (List)GLOBAL_BENEFITS_VALUE.get();
                    globalBenefits = new ArrayList<String>();
                    if (benefitsRaw != null) {
                        for (String s : benefitsRaw) {
                            String t;
                            if (s == null || (t = s.trim()).isEmpty()) continue;
                            globalBenefits.add(t);
                        }
                    }
                }
                catch (Exception e) {
                    globalBenefits = new ArrayList<String>();
                }
                try {
                    ArrayList<ParsedBenefit> parsed = new ArrayList<ParsedBenefit>();
                    for (int i = 0; globalBenefits != null && i < globalBenefits.size(); ++i) {
                        String def = globalBenefits.get(i);
                        if (def == null) {
                            parsed.add(new ParsedBenefit(null, true, null, 0, null, 0.0, UUID.nameUUIDFromBytes(("araxers_bestiary:global_benefit:" + i).getBytes(StandardCharsets.UTF_8))));
                            continue;
                        }
                        String trimmed = def.trim();
                        boolean skip = trimmed.isEmpty() || "-".equals(trimmed) || "skip".equalsIgnoreCase(trimmed) || "none".equalsIgnoreCase(trimmed);
                        UUID uuid = UUID.nameUUIDFromBytes(("araxers_bestiary:global_benefit:" + i).getBytes(StandardCharsets.UTF_8));
                        if (skip) {
                            parsed.add(new ParsedBenefit(trimmed, true, null, 0, null, 0.0, uuid));
                            continue;
                        }
                        int lastColon = trimmed.lastIndexOf(58);
                        if (lastColon <= 0 || lastColon >= trimmed.length() - 1) {
                            parsed.add(new ParsedBenefit(trimmed, true, null, 0, null, 0.0, uuid));
                            continue;
                        }
                        String idStr = trimmed.substring(0, lastColon);
                        String valueStr = trimmed.substring(lastColon + 1);
                        ResourceLocation id = ResourceLocation.m_135820_((String)idStr);
                        if (id == null) {
                            parsed.add(new ParsedBenefit(trimmed, true, null, 0, null, 0.0, uuid));
                            continue;
                        }
                        MobEffect effect = (MobEffect)ForgeRegistries.MOB_EFFECTS.getValue(id);
                        if (effect != null) {
                            int level;
                            try {
                                level = Integer.parseInt(valueStr.trim());
                            }
                            catch (Exception ex) {
                                level = 1;
                            }
                            if (level < 1) {
                                level = 1;
                            }
                            parsed.add(new ParsedBenefit(trimmed, false, effect, level, null, 0.0, uuid));
                            continue;
                        }
                        Attribute attr = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(id);
                        if (attr != null) {
                            double amount;
                            try {
                                amount = Double.parseDouble(valueStr.trim());
                            }
                            catch (Exception ex) {
                                amount = 0.0;
                            }
                            parsed.add(new ParsedBenefit(trimmed, false, null, 0, attr, amount, uuid));
                            continue;
                        }
                        parsed.add(new ParsedBenefit(trimmed, true, null, 0, null, 0.0, uuid));
                    }
                    parsedGlobalBenefits = Collections.unmodifiableList(parsed);
                }
                catch (Exception ex) {
                    parsedGlobalBenefits = Collections.emptyList();
                }
                try {
                    MinecraftServer server;
                    boolean benefitsChanged;
                    boolean bl = benefitsChanged = oldBenefits == null && globalBenefits != null && !globalBenefits.isEmpty() || oldBenefits != null && !oldBenefits.equals(globalBenefits);
                    if (benefitsChanged && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
                        data = GlobalPlayerProgressionData.get(server).data();
                        for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                            try {
                                data.reconcileGlobalBenefitsForPlayer(sp);
                            }
                            catch (Exception exception) {}
                        }
                    }
                }
                catch (Exception benefitsChanged) {
                    // empty catch block
                }
                String oldBarType = globalRankProgressBarType;
                try {
                    globalRankProgressBarType = (String)GLOBAL_RANK_PROGRESS_BAR_TYPE_VALUE.get();
                    if (globalRankProgressBarType == null || globalRankProgressBarType.isEmpty()) {
                        globalRankProgressBarType = "S";
                    }
                }
                catch (Exception e) {
                    globalRankProgressBarType = "S";
                }
                try {
                    MinecraftServer server;
                    if (oldBarType == null || oldBarType.equalsIgnoreCase(globalRankProgressBarType) || (server = ServerLifecycleHooks.getCurrentServer()) == null) break;
                    data = GlobalPlayerProgressionData.get(server).data();
                    for (ServerPlayer sp : server.m_6846_().m_11314_()) {
                        try {
                            data.reconcileGlobalBenefitsForPlayer(sp);
                        }
                        catch (Exception exception) {}
                    }
                    break;
                }
                catch (Exception exception) {
                    break;
                }
            }
            case CLIENT: {
                hideZeroKillEntities = (Boolean)HIDE_ZERO_KILL_ENTITIES_VALUE.get();
                hideNoRankEntities = (Boolean)HIDE_NO_RANK_ENTITIES_VALUE.get();
                forceObfuscation = (Boolean)FORCE_OBFUSCATION.get();
                hideUndiscovered = (Boolean)HIDE_UNDISCOVERED_VALUE.get();
                debugMode = (Boolean)DEBUG_MODE.get();
                showChallenges = (Boolean)SHOW_CHALLENGES.get();
                try {
                    enableGlobalRankProgressBarCycling = (Boolean)ENABLE_GLOBAL_RANK_PROGRESS_BAR_CYCLING.get();
                }
                catch (Exception e) {
                    enableGlobalRankProgressBarCycling = true;
                }
                try {
                    progressBarSpriteSource = (String)PROGRESS_BAR_SPRITE_SOURCE_VALUE.get();
                    if (progressBarSpriteSource == null || progressBarSpriteSource.isEmpty()) {
                        progressBarSpriteSource = "vanilla";
                    }
                }
                catch (Exception e) {
                    progressBarSpriteSource = "vanilla";
                }
                enableKeybind = (Boolean)ENABLE_KEYBIND_VALUE.get();
                try {
                    lowEndMode = (Boolean)LOW_END_MODE.get();
                }
                catch (Exception e) {
                    lowEndMode = false;
                }
                try {
                    lowEndEntityPreview = (Boolean)LOW_END_ENTITY_PREVIEW.get();
                }
                catch (Exception e) {
                    lowEndEntityPreview = true;
                }
                try {
                    guiMaxEntityScale = (Integer)GUI_MAX_ENTITY_SCALE.get();
                }
                catch (Exception e) {
                    guiMaxEntityScale = 100;
                }
                try {
                    lowEndMarqueeIntervalMultiplier = (Double)LOW_END_MARQUEE_INTERVAL_MULTIPLIER.get();
                }
                catch (Exception e) {
                    lowEndMarqueeIntervalMultiplier = 1.5;
                }
                DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> Config.refreshBestiaryScreen());
                break;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void refreshBestiaryScreen() {
        try {
            Minecraft minecraft = Minecraft.m_91087_();
            if (minecraft.f_91080_ instanceof BestiaryScreen) {
                minecraft.execute(() -> minecraft.m_91152_((Screen)new BestiaryScreen()));
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Error refreshing bestiary screen: {}", (Object)e.getMessage());
        }
    }

    public static void setEnableProgressionSystem(boolean v) {
        try {
            ENABLE_PROGRESSION_SYSTEM.set((Object)v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setProgressionSystemType(String v) {
        try {
            PROGRESSION_SYSTEM_TYPE_VALUE.set((Object)v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEsMode(String v) {
        try {
            ES_MODE_VALUE.set((Object)v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setSpawnLocationThreshold(int v) {
        try {
            SPAWN_LOCATION_THRESHOLD_VALUE.set((Object)v);
            spawnLocationThreshold = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLootIconThreshold(int v) {
        try {
            LOOT_ICON_THRESHOLD_VALUE.set((Object)v);
            lootIconThreshold = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLootChanceThreshold(int v) {
        try {
            LOOT_CHANCE_THRESHOLD_VALUE.set((Object)v);
            lootChanceThreshold = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setAdvancedAttributesThreshold(int v) {
        try {
            ADVANCED_ATTRIBUTES_THRESHOLD_VALUE.set((Object)v);
            advancedAttributesThreshold = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setDescriptionThreshold(int v) {
        try {
            DESCRIPTION_THRESHOLD_VALUE.set((Object)v);
            descriptionThreshold = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setMobTypeChipKillsThreshold(int v) {
        try {
            MOB_TYPE_CHIP_KILLS_THRESHOLD_VALUE.set((Object)v);
            mobTypeChipKillsThreshold = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setMobTypeChipRank(String v) {
        try {
            MOB_TYPE_CHIP_RANK_VALUE.set((Object)v);
            mobTypeChipRank = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankKillChance(double v) {
        try {
            RANK_KILL_CHANCE_VALUE.set((Object)v);
            rankKillChance = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankFeedChance(double v) {
        try {
            RANK_FEED_CHANCE_VALUE.set((Object)v);
            rankFeedChance = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankHitChance(double v) {
        try {
            RANK_HIT_CHANCE_VALUE.set((Object)v);
            rankHitChance = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankTradeChance(double v) {
        try {
            RANK_TRADE_CHANCE_VALUE.set((Object)v);
            rankTradeChance = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setCommandRolls(double v) {
        try {
            COMMAND_ROLLS_VALUE.set((Object)v);
            commandRolls = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setBossRankMultiplier(double v) {
        try {
            BOSS_RANK_MULTIPLIER_VALUE.set((Object)v);
            bossRankMultiplier = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setAllowObservationChanceRolls(boolean v) {
        try {
            ALLOW_OBSERVATION_CHANCE_ROLLS.set((Object)v);
            allowObservationChanceRolls = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setSpawnLocationRank(String v) {
        try {
            SPAWN_LOCATION_RANK_VALUE.set((Object)v);
            spawnLocationRank = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLootIconRank(String v) {
        try {
            LOOT_ICON_RANK_VALUE.set((Object)v);
            lootIconRank = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLootChanceRank(String v) {
        try {
            LOOT_CHANCE_RANK_VALUE.set((Object)v);
            lootChanceRank = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setAdvancedAttributesRank(String v) {
        try {
            ADVANCED_ATTRIBUTES_RANK_VALUE.set((Object)v);
            advancedAttributesRank = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setDescriptionRank(String v) {
        try {
            DESCRIPTION_RANK_VALUE.set((Object)v);
            descriptionRank = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsEToD(int v) {
        try {
            POINTS_E_TO_D_VALUE.set((Object)v);
            pointsEToD = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsDToC(int v) {
        try {
            POINTS_D_TO_C_VALUE.set((Object)v);
            pointsDToC = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsCToB(int v) {
        try {
            POINTS_C_TO_B_VALUE.set((Object)v);
            pointsCToB = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsBToA(int v) {
        try {
            POINTS_B_TO_A_VALUE.set((Object)v);
            pointsBToA = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsAToS(int v) {
        try {
            POINTS_A_TO_S_VALUE.set((Object)v);
            pointsAToS = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsKill(int v) {
        try {
            POINTS_KILL_VALUE.set((Object)v);
            pointsKill = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsFeed(int v) {
        try {
            POINTS_FEED_VALUE.set((Object)v);
            pointsFeed = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsHit(int v) {
        try {
            POINTS_HIT_VALUE.set((Object)v);
            pointsHit = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsTrade(int v) {
        try {
            POINTS_TRADE_VALUE.set((Object)v);
            pointsTrade = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsBreed(int v) {
        try {
            POINTS_BREED_VALUE.set((Object)v);
            pointsBreed = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsObserve(int v) {
        try {
            POINTS_OBSERVE_VALUE.set((Object)v);
            pointsObserve = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsTame(int v) {
        try {
            POINTS_TAME_VALUE.set((Object)v);
            pointsTame = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsSpecialBiome(int v) {
        try {
            POINTS_SPECIAL_BIOME_VALUE.set((Object)v);
            pointsSpecialBiome = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPointsBossMultiplier(double v) {
        try {
            POINTS_BOSS_MULTIPLIER_VALUE.set((Object)v);
            pointsBossMultiplier = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEnableProgressiveRankDifficulty(boolean v) {
        try {
            ENABLE_PROGRESSIVE_RANK_DIFFICULTY_VALUE.set((Object)v);
            enableProgressiveRankDifficulty = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankDDifficultyMultiplier(double v) {
        try {
            RANK_D_DIFFICULTY_MULTIPLIER_VALUE.set((Object)v);
            rankDDifficultyMultiplier = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankCDifficultyMultiplier(double v) {
        try {
            RANK_C_DIFFICULTY_MULTIPLIER_VALUE.set((Object)v);
            rankCDifficultyMultiplier = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankBDifficultyMultiplier(double v) {
        try {
            RANK_B_DIFFICULTY_MULTIPLIER_VALUE.set((Object)v);
            rankBDifficultyMultiplier = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankADifficultyMultiplier(double v) {
        try {
            RANK_A_DIFFICULTY_MULTIPLIER_VALUE.set((Object)v);
            rankADifficultyMultiplier = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankSDifficultyMultiplier(double v) {
        try {
            RANK_S_DIFFICULTY_MULTIPLIER_VALUE.set((Object)v);
            rankSDifficultyMultiplier = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankEWeight(int v) {
        try {
            RANK_E_WEIGHT_VALUE.set((Object)v);
            rankEWeight = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankDWeight(int v) {
        try {
            RANK_D_WEIGHT_VALUE.set((Object)v);
            rankDWeight = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankCWeight(int v) {
        try {
            RANK_C_WEIGHT_VALUE.set((Object)v);
            rankCWeight = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankBWeight(int v) {
        try {
            RANK_B_WEIGHT_VALUE.set((Object)v);
            rankBWeight = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankAWeight(int v) {
        try {
            RANK_A_WEIGHT_VALUE.set((Object)v);
            rankAWeight = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setRankSWeight(int v) {
        try {
            RANK_S_WEIGHT_VALUE.set((Object)v);
            rankSWeight = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEnableCheeseDetection(boolean v) {
        try {
            ENABLE_CHEESE_DETECTION.set((Object)v);
            enableCheeseDetection = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setMonsterCategories(List<String> v) {
        try {
            MONSTER_CATEGORIES_VALUE.set(v);
            monsterCategories = new ArrayList<String>(v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEntityBlacklist(List<String> v) {
        try {
            ENTITY_BLACKLIST_VALUE.set(v);
            entityBlacklist = new ArrayList<String>(v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEntityIncludeList(List<String> v) {
        try {
            ENTITY_INCLUDELIST_VALUE.set(v);
            entityIncludeList = new ArrayList<String>(v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setInitialLootSampleBatches(int v) {
        try {
            INITIAL_LOOT_SAMPLE_BATCHES_VALUE.set((Object)v);
            initialLootSampleBatches = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPrewarmLootCacheOnStart(boolean v) {
        try {
            PREWARM_LOOT_CACHE_ON_START_VALUE.set((Object)v);
            prewarmLootCacheOnStart = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setPrewarmMaxEntitiesPerTick(int v) {
        try {
            PREWARM_MAX_ENTITIES_PER_TICK_VALUE.set((Object)v);
            prewarmMaxEntitiesPerTick = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEnableLootJsonInspectionFallback(boolean v) {
        try {
            ENABLE_LOOT_JSON_INSPECTION_FALLBACK_VALUE.set((Object)v);
            enableLootJsonInspectionFallback = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEnableGlobalLootModifierSupplement(boolean v) {
        try {
            ENABLE_GLOBAL_LOOT_MODIFIER_SUPPLEMENT_VALUE.set((Object)v);
            enableGlobalLootModifierSupplement = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEnableDynamicDropTracking(boolean v) {
        try {
            ENABLE_DYNAMIC_DROP_TRACKING_VALUE.set((Object)v);
            enableDynamicDropTracking = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setDynamicDropSampleSize(int v) {
        try {
            DYNAMIC_DROP_SAMPLE_SIZE_VALUE.set((Object)v);
            dynamicDropSampleSize = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setDynamicDropWeight(double v) {
        try {
            DYNAMIC_DROP_WEIGHT_VALUE.set((Object)v);
            dynamicDropWeight = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setIgnoreModifiedDropEvents(boolean v) {
        try {
            IGNORE_MODIFIED_DROP_EVENTS_VALUE.set((Object)v);
            ignoreModifiedDropEvents = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setModifiedDropEnchantments(List<String> v) {
        try {
            MODIFIED_DROP_ENCHANTMENTS_VALUE.set(v);
            modifiedDropEnchantments = new ArrayList<String>(v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setHideUndiscovered(boolean v) {
        try {
            HIDE_UNDISCOVERED_VALUE.set((Object)v);
            hideUndiscovered = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setHideZeroKillEntities(boolean v) {
        try {
            HIDE_ZERO_KILL_ENTITIES_VALUE.set((Object)v);
            hideZeroKillEntities = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setHideNoRankEntities(boolean v) {
        try {
            HIDE_NO_RANK_ENTITIES_VALUE.set((Object)v);
            hideNoRankEntities = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setForceObfuscation(boolean v) {
        try {
            FORCE_OBFUSCATION.set((Object)v);
            forceObfuscation = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEnableKeybind(boolean v) {
        try {
            ENABLE_KEYBIND_VALUE.set((Object)v);
            enableKeybind = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setDebugMode(boolean v) {
        try {
            DEBUG_MODE.set((Object)v);
            debugMode = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setShowChallenges(boolean v) {
        try {
            SHOW_CHALLENGES.set((Object)v);
            showChallenges = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setGlobalSRankThresholds(List<Integer> v) {
        try {
            GLOBAL_S_RANK_THRESHOLDS_VALUE.set(v);
            globalSRankThresholds = new ArrayList<Integer>(v);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setGlobalRankProgressBarType(String v) {
        try {
            GLOBAL_RANK_PROGRESS_BAR_TYPE_VALUE.set((Object)v);
            globalRankProgressBarType = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setEnableGlobalRankProgressBarCycling(boolean v) {
        try {
            ENABLE_GLOBAL_RANK_PROGRESS_BAR_CYCLING.set((Object)v);
            enableGlobalRankProgressBarCycling = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setProgressBarSpriteSource(String v) {
        try {
            PROGRESS_BAR_SPRITE_SOURCE_VALUE.set((Object)v);
            progressBarSpriteSource = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLowEndMode(boolean v) {
        try {
            LOW_END_MODE.set((Object)v);
            lowEndMode = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLowEndEntityPreview(boolean v) {
        try {
            LOW_END_ENTITY_PREVIEW.set((Object)v);
            lowEndEntityPreview = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setGuiMaxEntityScale(int v) {
        try {
            GUI_MAX_ENTITY_SCALE.set((Object)v);
            guiMaxEntityScale = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setLowEndMarqueeIntervalMultiplier(double v) {
        try {
            LOW_END_MARQUEE_INTERVAL_MULTIPLIER.set((Object)v);
            lowEndMarqueeIntervalMultiplier = v;
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        SERVER_BUILDER.push("progression");
        ENABLE_PROGRESSION_SYSTEM = SERVER_BUILDER.comment("Enable the progression system where entity information is gradually revealed as you progress").define("enableProgressionSystem", true);
        PROGRESSION_SYSTEM_TYPE_VALUE = SERVER_BUILDER.comment("Type of progression system to use: \"kills\" (original), \"ranks\" (rank-based), or \"sighting\" (spyglass)").define("progressionSystemType", (Object)"ranks");
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("killThresholds");
        SPAWN_LOCATION_THRESHOLD_VALUE = SERVER_BUILDER.comment("Number of kills required to unlock spawn locations").defineInRange("spawnLocationThreshold", 10, 1, Integer.MAX_VALUE);
        LOOT_ICON_THRESHOLD_VALUE = SERVER_BUILDER.comment("Number of kills required to unlock loot icons").defineInRange("lootIconThreshold", 20, 1, Integer.MAX_VALUE);
        LOOT_CHANCE_THRESHOLD_VALUE = SERVER_BUILDER.comment("Number of kills required to unlock loot drop chances").defineInRange("lootChanceThreshold", 50, 1, Integer.MAX_VALUE);
        ADVANCED_ATTRIBUTES_THRESHOLD_VALUE = SERVER_BUILDER.comment("Number of kills required to unlock advanced attributes (knockback resistance, armor, movement speed)").defineInRange("advancedAttributesThreshold", 30, 1, Integer.MAX_VALUE);
        DESCRIPTION_THRESHOLD_VALUE = SERVER_BUILDER.comment("Number of kills required to unlock entity descriptions").defineInRange("descriptionThreshold", 40, 1, Integer.MAX_VALUE);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("mobTypeChip");
        MOB_TYPE_CHIP_KILLS_THRESHOLD_VALUE = SERVER_BUILDER.comment("Number of kills required to unlock the mob-type chip (kills mode)").defineInRange("mobTypeChipKillsThreshold", 1, 1, Integer.MAX_VALUE);
        MOB_TYPE_CHIP_RANK_VALUE = SERVER_BUILDER.comment("Minimum rank required to unlock the mob-type chip (E, D, C, B, A, S) - ranks mode").define("mobTypeChipRank", (Object)"E");
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("chanceMode");
        RANK_KILL_CHANCE_VALUE = SERVER_BUILDER.comment("Base chance (0.0-1.0) to increase rank when killing an entity (used when esMode = 'chance')").defineInRange("rankKillChance", 0.15, 0.01, 1.0);
        RANK_FEED_CHANCE_VALUE = SERVER_BUILDER.comment("Base chance (0.0-1.0) to increase rank when feeding an entity (used when esMode = 'chance')").defineInRange("rankFeedChance", 0.03, 0.01, 1.0);
        RANK_HIT_CHANCE_VALUE = SERVER_BUILDER.comment("Base chance (0.0-1.0) to increase rank when hitting an entity (used when esMode = 'chance')").defineInRange("rankHitChance", 0.01, 0.01, 1.0);
        RANK_TRADE_CHANCE_VALUE = SERVER_BUILDER.comment("Base chance (0.0-1.0) to increase rank when trading with a villager (used when esMode = 'chance')").defineInRange("rankTradeChance", 0.1, 0.01, 1.0);
        COMMAND_ROLLS_VALUE = SERVER_BUILDER.comment("Chance (0.0-1.0) used by the /bestiary rank roll command to apply a rolled rank").defineInRange("commandRolls", 0.15, 0.0, 1.0);
        BOSS_RANK_MULTIPLIER_VALUE = SERVER_BUILDER.comment("Multiplier for rank increase chance when interacting with boss entities (higher value = easier) - chance mode only").defineInRange("bossRankMultiplier", 3.0, 1.0, 10.0);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("observation");
        ALLOW_OBSERVATION_CHANCE_ROLLS = SERVER_BUILDER.comment("If true, completing a spyglass observation may assign an initial rank via weighted roll; if false, observation only awards E\u2192S points (no chance roll). Default: false").define("allowObservationChanceRolls", false);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("progression");
        ES_MODE_VALUE = SERVER_BUILDER.comment("E\u2192S progression mode: 'chance' (existing behavior) or 'points' (deterministic points)").define("esMode", (Object)"points");
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("pointsMode");
        POINTS_E_TO_D_VALUE = SERVER_BUILDER.comment("Points required to advance from E to D (points mode)").defineInRange("pointsEToD", 50, 1, Integer.MAX_VALUE);
        POINTS_D_TO_C_VALUE = SERVER_BUILDER.comment("Points required to advance from D to C (points mode)").defineInRange("pointsDToC", 100, 1, Integer.MAX_VALUE);
        POINTS_C_TO_B_VALUE = SERVER_BUILDER.comment("Points required to advance from C to B (points mode)").defineInRange("pointsCToB", 200, 1, Integer.MAX_VALUE);
        POINTS_B_TO_A_VALUE = SERVER_BUILDER.comment("Points required to advance from B to A (points mode)").defineInRange("pointsBToA", 300, 1, Integer.MAX_VALUE);
        POINTS_A_TO_S_VALUE = SERVER_BUILDER.comment("Points required to advance from A to S (points mode)").defineInRange("pointsAToS", 400, 1, Integer.MAX_VALUE);
        POINTS_KILL_VALUE = SERVER_BUILDER.comment("Points awarded on killing an entity (points mode)").defineInRange("pointsKill", 3, 0, Integer.MAX_VALUE);
        POINTS_FEED_VALUE = SERVER_BUILDER.comment("Points awarded on feeding an entity (points mode)").defineInRange("pointsFeed", 1, 0, Integer.MAX_VALUE);
        POINTS_HIT_VALUE = SERVER_BUILDER.comment("Points awarded on hitting an entity (points mode)").defineInRange("pointsHit", 0, 0, Integer.MAX_VALUE);
        POINTS_TRADE_VALUE = SERVER_BUILDER.comment("Points awarded on trading with a villager (points mode)").defineInRange("pointsTrade", 2, 0, Integer.MAX_VALUE);
        POINTS_BREED_VALUE = SERVER_BUILDER.comment("Points awarded on breeding (points mode)").defineInRange("pointsBreed", 2, 0, Integer.MAX_VALUE);
        POINTS_OBSERVE_VALUE = SERVER_BUILDER.comment("Points awarded on observing with spyglass (points mode)").defineInRange("pointsObserve", 5, 0, Integer.MAX_VALUE);
        POINTS_TAME_VALUE = SERVER_BUILDER.comment("Points awarded on taming (points mode)").defineInRange("pointsTame", 4, 0, Integer.MAX_VALUE);
        POINTS_SPECIAL_BIOME_VALUE = SERVER_BUILDER.comment("Points awarded for special biome (points mode, reserved)").defineInRange("pointsSpecialBiome", 0, 0, Integer.MAX_VALUE);
        POINTS_BOSS_MULTIPLIER_VALUE = SERVER_BUILDER.comment("Multiplier applied to point awards when the context entity is a boss (points mode)").defineInRange("pointsBossMultiplier", 2.0, 0.0, 100.0);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("progressiveDifficulty");
        ENABLE_PROGRESSIVE_RANK_DIFFICULTY_VALUE = SERVER_BUILDER.comment("Enable progressive rank difficulty (higher ranks are harder to achieve)").define("enableProgressiveRankDifficulty", true);
        RANK_D_DIFFICULTY_MULTIPLIER_VALUE = SERVER_BUILDER.comment("Difficulty multiplier for rank D (lower value = harder)").defineInRange("rankDDifficultyMultiplier", 0.4, 0.01, 1.0);
        RANK_C_DIFFICULTY_MULTIPLIER_VALUE = SERVER_BUILDER.comment("Difficulty multiplier for rank C (lower value = harder)").defineInRange("rankCDifficultyMultiplier", 0.3, 0.01, 1.0);
        RANK_B_DIFFICULTY_MULTIPLIER_VALUE = SERVER_BUILDER.comment("Difficulty multiplier for rank B (lower value = harder)").defineInRange("rankBDifficultyMultiplier", 0.2, 0.01, 1.0);
        RANK_A_DIFFICULTY_MULTIPLIER_VALUE = SERVER_BUILDER.comment("Difficulty multiplier for rank A (lower value = harder)").defineInRange("rankADifficultyMultiplier", 0.1, 0.01, 1.0);
        RANK_S_DIFFICULTY_MULTIPLIER_VALUE = SERVER_BUILDER.comment("Difficulty multiplier for rank S (lower value = harder)").defineInRange("rankSDifficultyMultiplier", 0.05, 0.01, 1.0);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("rankUnlockThresholds");
        SPAWN_LOCATION_RANK_VALUE = SERVER_BUILDER.comment("Minimum rank required to unlock spawn locations (E, D, C, B, A, S)").define("spawnLocationRank", (Object)"D");
        LOOT_ICON_RANK_VALUE = SERVER_BUILDER.comment("Minimum rank required to unlock loot icons (E, D, C, B, A, S)").define("lootIconRank", (Object)"C");
        LOOT_CHANCE_RANK_VALUE = SERVER_BUILDER.comment("Minimum rank required to unlock loot drop chances (E, D, C, B, A, S)").define("lootChanceRank", (Object)"A");
        ADVANCED_ATTRIBUTES_RANK_VALUE = SERVER_BUILDER.comment("Minimum rank required to unlock advanced attributes (E, D, C, B, A, S)").define("advancedAttributesRank", (Object)"B");
        DESCRIPTION_RANK_VALUE = SERVER_BUILDER.comment("Minimum rank required to unlock entity descriptions (E, D, C, B, A, S)").define("descriptionRank", (Object)"B");
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("rankWeights");
        RANK_E_WEIGHT_VALUE = SERVER_BUILDER.comment("Weight for rank E when discovering new entities (higher value = more common)").defineInRange("rankEWeight", 150, 0, 1000);
        RANK_D_WEIGHT_VALUE = SERVER_BUILDER.comment("Weight for rank D when discovering new entities (higher value = more common)").defineInRange("rankDWeight", 50, 0, 1000);
        RANK_C_WEIGHT_VALUE = SERVER_BUILDER.comment("Weight for rank C when discovering new entities (higher value = more common)").defineInRange("rankCWeight", 25, 0, 1000);
        RANK_B_WEIGHT_VALUE = SERVER_BUILDER.comment("Weight for rank B when discovering new entities (higher value = more common)").defineInRange("rankBWeight", 15, 0, 1000);
        RANK_A_WEIGHT_VALUE = SERVER_BUILDER.comment("Weight for rank A when discovering new entities (higher value = more common)").defineInRange("rankAWeight", 10, 0, 1000);
        RANK_S_WEIGHT_VALUE = SERVER_BUILDER.comment("Weight for rank S when discovering new entities (higher value = more common)").defineInRange("rankSWeight", 2, 0, 1000);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("cheese");
        ENABLE_CHEESE_DETECTION = SERVER_BUILDER.comment("Enable Rank-X boss 'cheese' detection (beds, end crystals, respawn anchors). If false, disallowedCheese from datapacks are ignored.").define("enableCheeseDetection", true);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("content");
        MONSTER_CATEGORIES_VALUE = SERVER_BUILDER.comment("List of mob categories to be considered as monsters (all categories: \"monster\", \"creature\", \"water_creature\", \"underground_water_creature\", \"ambient\", \"water_ambient\", \"axolotls\", \"misc\")").defineList("monsterCategories", List.of(), s -> s instanceof String);
        ENTITY_BLACKLIST_VALUE = SERVER_BUILDER.comment("List of entities that should not be shown in the bestiary (format: \"minecraft:sheep\")").defineList("entityBlacklist", Arrays.asList("minecraft:armor_stand"), s -> s instanceof String);
        ENTITY_INCLUDELIST_VALUE = SERVER_BUILDER.comment("List of entities that should be prioritized and included in the bestiary regardless of their category (format: \"minecraft:sheep\")").defineList("entityIncludeList", Arrays.asList(new String[0]), s -> s instanceof String);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("loot");
        INITIAL_LOOT_SAMPLE_BATCHES_VALUE = SERVER_BUILDER.comment("Number of random loot sampling iterations used to estimate initial drop chances from loot tables (higher = more accurate, slower). Applies to initial generation before dynamic refinement.").defineInRange("initialLootSampleBatches", 300, 50, 2000);
        PREWARM_LOOT_CACHE_ON_START_VALUE = SERVER_BUILDER.comment("If true, gradually prewarm the loot cache over ticks after server start; if false, loot is generated lazily on demand").define("prewarmLootCacheOnStart", false);
        PREWARM_MAX_ENTITIES_PER_TICK_VALUE = SERVER_BUILDER.comment("Maximum number of entities to prewarm per server tick when prewarmLootCacheOnStart is enabled").defineInRange("prewarmMaxEntitiesPerTick", 10, 1, 500);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("lootSafety");
        ENABLE_LOOT_JSON_INSPECTION_FALLBACK_VALUE = SERVER_BUILDER.comment("Enable best-effort loot table JSON inspection fallback to extract items without running deserializers. Safer in modded environments.").define("enableLootJsonInspectionFallback", true);
        ENABLE_GLOBAL_LOOT_MODIFIER_SUPPLEMENT_VALUE = SERVER_BUILDER.comment("Enable supplementing loot from Global Loot Modifiers (GLMs) by reading their JSON directly. Disable if your pack logs condition decode errors (safer default).").define("enableGlobalLootModifierSupplement", false);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("dynamicDrops");
        ENABLE_DYNAMIC_DROP_TRACKING_VALUE = SERVER_BUILDER.comment("Enable tracking of actual entity drops to enhance loot information").define("enableDynamicDropTracking", true);
        DYNAMIC_DROP_SAMPLE_SIZE_VALUE = SERVER_BUILDER.comment("Number of drop events to track before calculating drop chances (higher value means more accurate chances)").defineInRange("dynamicDropSampleSize", 50, 10, 1000);
        DYNAMIC_DROP_WEIGHT_VALUE = SERVER_BUILDER.comment("Weight given to dynamic drops vs. loot table entries (0.0 = only use loot tables, 1.0 = only use dynamic drops)").defineInRange("dynamicDropWeight", 0.7, 0.0, 1.0);
        IGNORE_MODIFIED_DROP_EVENTS_VALUE = SERVER_BUILDER.comment("Ignore recording drops if killer's tool or enchantments may have modified the drops (e.g., Looting, Fire Aspect)").define("ignoreModifiedDropEvents", true);
        MODIFIED_DROP_ENCHANTMENTS_VALUE = SERVER_BUILDER.comment("When ignoreModifiedDropEvents is true: If this list is non-empty, only ignore drop events when the killer's held item has any enchantment from this list (e.g., \"minecraft:looting\"). If empty, any enchantment on the held item will cause the event to be ignored.").defineList("modifiedDropEnchantments", Arrays.asList("minecraft:looting", "minecraft:fire_aspect"), s -> s instanceof String);
        SERVER_BUILDER.pop();
        SERVER_BUILDER.push("globalProgressBar");
        GLOBAL_S_RANK_THRESHOLDS_VALUE = SERVER_BUILDER.comment("Thresholds for total S-ranked entities to advance global progression. Progress fills between consecutive values. Default: [50]").defineList("globalSRankThresholds", Arrays.asList(50), o -> o instanceof Integer);
        GLOBAL_BENEFITS_VALUE = SERVER_BUILDER.comment("Global benefits applied to players when reaching each corresponding threshold. Format per entry: 'namespace:id:value'.\n- If id is a Mob Effect (e.g., minecraft:strength), value is the effect level (1-based, e.g., 2 = Strength II). Multiple entries of the same effect ID STACK additively across unlocked thresholds (e.g., Strength 2 + Strength 3 -> Strength 5 total).\n- If id is an Attribute (e.g., minecraft:generic.max_health), value is the amount added. Attribute entries naturally stack additively via separate modifiers.\nApplied in the same order as globalSRankThresholds. Extra entries are ignored; missing entries do nothing.\nTip: To intentionally skip a benefit for a threshold index, put '-' (or 'skip') at that position in the list.").defineList("globalBenefits", Arrays.asList(new String[0]), o -> o instanceof String);
        GLOBAL_RANK_PROGRESS_BAR_TYPE_VALUE = SERVER_BUILDER.comment("Which global progress bar to use for thresholds/benefits: 'S' (count S-and-above) or 'X' (count Rank-X). Server-controlled.").define("globalRankProgressBarType", (Object)"S");
        SERVER_BUILDER.pop();
        CLIENT_BUILDER.push("filter");
        HIDE_ZERO_KILL_ENTITIES_VALUE = CLIENT_BUILDER.comment("Hide entities with 0 kills in the client UI (kill-based progression)").define("hideZeroKillEntities", false);
        HIDE_NO_RANK_ENTITIES_VALUE = CLIENT_BUILDER.comment("Hide entities with no rank in the client UI (rank-based progression)").define("hideNoRankEntities", false);
        FORCE_OBFUSCATION = CLIENT_BUILDER.comment("Force obfuscation of undiscovered entities in the UI").define("forceObfuscation", false);
        HIDE_UNDISCOVERED_VALUE = CLIENT_BUILDER.comment("Hide undiscovered entities completely instead of showing obfuscated entries").define("hideUndiscovered", false);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("debug");
        DEBUG_MODE = CLIENT_BUILDER.comment("Enable client debug visuals/logs for Bestiary UI").define("debugMode", false);
        SHOW_CHALLENGES = CLIENT_BUILDER.comment("Show the Challenges page in the Bestiary UI").define("showChallenges", false);
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("globalProgressBar");
        ENABLE_GLOBAL_RANK_PROGRESS_BAR_CYCLING = CLIENT_BUILDER.comment("Allow cycling the global progress bar between S and X by clicking it").define("enableGlobalRankProgressBarCycling", true);
        PROGRESS_BAR_SPRITE_SOURCE_VALUE = CLIENT_BUILDER.comment("Which sprite to use for progress bars: 'vanilla' (villager2.png) or 'mod' (bestiary.png). Default: mod").define("progressBarSpriteSource", (Object)"mod");
        CLIENT_BUILDER.pop();
        CLIENT_BUILDER.push("keybind");
        ENABLE_KEYBIND_VALUE = CLIENT_BUILDER.comment("Enable the keybind to open the Bestiary screen").define("enableKeybind", true);
        CLIENT_BUILDER.pop();
        LOW_END_MODE = CLIENT_BUILDER.comment("Enable low-end mode optimizations for GUI rendering and previews").define("lowEndMode", false);
        LOW_END_ENTITY_PREVIEW = CLIENT_BUILDER.comment("Reduce cost of 3D entity preview in Bestiary when lowEndMode is enabled").define("lowEndEntityPreview", true);
        GUI_MAX_ENTITY_SCALE = CLIENT_BUILDER.comment("Maximum scale for entity preview in Bestiary to avoid overdraw on low-end GPUs").defineInRange("guiMaxEntityScale", 100, 40, 200);
        LOW_END_MARQUEE_INTERVAL_MULTIPLIER = CLIENT_BUILDER.comment("Multiplier for category marquee step interval in lowEndMode (e.g., 1.5 = 50% slower)").defineInRange("lowEndMarqueeIntervalMultiplier", 1.5, 1.0, 5.0);
        SERVER_SPEC = SERVER_BUILDER.build();
        CLIENT_SPEC = CLIENT_BUILDER.build();
        parsedGlobalBenefits = Collections.emptyList();
    }

    public static class ParsedBenefit {
        public final String raw;
        public final boolean skip;
        public final MobEffect effect;
        public final int effectLevel;
        public final Attribute attribute;
        public final double attributeAmount;
        public final UUID uuid;

        public ParsedBenefit(String raw, boolean skip, MobEffect effect, int effectLevel, Attribute attribute, double attributeAmount, UUID uuid) {
            this.raw = raw;
            this.skip = skip;
            this.effect = effect;
            this.effectLevel = effectLevel;
            this.attribute = attribute;
            this.attributeAmount = attributeAmount;
            this.uuid = uuid;
        }
    }
}

