/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.network;

import com.araxer.araxers_bestiary.client.PacketHandler;
import com.araxer.araxers_bestiary.network.CommonPacketHandler;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgeNetwork {
    public static final String PROTOCOL_VERSION = "1";
    public static final ResourceLocation MAIN_CHANNEL_ID = new ResourceLocation("araxers_bestiary", "main");
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)MAIN_CHANNEL_ID, () -> "1", "1"::equals, "1"::equals);
    private static int nextId = 0;

    public static void register() {
        CHANNEL.registerMessage(nextId++, RelayS2CMessage.class, RelayS2CMessage::encode, RelayS2CMessage::decode, RelayS2CMessage::handle, Optional.of(NetworkDirection.PLAY_TO_CLIENT));
    }

    public static void sendToClient(ServerPlayer player, ResourceLocation subChannel, FriendlyByteBuf buf) {
        FriendlyByteBuf copy = new FriendlyByteBuf(Unpooled.buffer((int)buf.readableBytes()));
        int startIndex = buf.readerIndex();
        copy.writeBytes((ByteBuf)buf, startIndex, buf.readableBytes());
        RelayS2CMessage msg = new RelayS2CMessage(subChannel, copy);
        CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)msg);
    }

    public static class RelayS2CMessage {
        public final ResourceLocation channelId;
        public final byte[] data;

        public RelayS2CMessage(ResourceLocation channelId, FriendlyByteBuf dataBuf) {
            this.channelId = channelId;
            byte[] b = new byte[dataBuf.readableBytes()];
            dataBuf.readBytes(b);
            this.data = b;
        }

        public RelayS2CMessage(ResourceLocation channelId, byte[] data) {
            this.channelId = channelId;
            this.data = data;
        }

        public static void encode(RelayS2CMessage msg, FriendlyByteBuf out) {
            out.m_130085_(msg.channelId);
            out.m_130130_(msg.data.length);
            out.writeBytes(msg.data);
        }

        public static RelayS2CMessage decode(FriendlyByteBuf in) {
            ResourceLocation id = in.m_130281_();
            int len = in.m_130242_();
            byte[] data = new byte[len];
            in.readBytes(data);
            return new RelayS2CMessage(id, data);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void handle(RelayS2CMessage msg, Supplier<NetworkEvent.Context> ctxSupplier) {
            NetworkEvent.Context ctx = ctxSupplier.get();
            try {
                FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])msg.data));
                if (CommonPacketHandler.LOOT_SYNC_CHANNEL.equals((Object)msg.channelId)) {
                    PacketHandler.parseLootSync(buf);
                } else if (CommonPacketHandler.PROGRESSION_SYNC_CHANNEL.equals((Object)msg.channelId)) {
                    PacketHandler.parseProgressionSync(buf);
                } else if (CommonPacketHandler.PROGRESSION_UPDATE_CHANNEL.equals((Object)msg.channelId)) {
                    PacketHandler.parseProgressionUpdate(buf);
                } else if (CommonPacketHandler.PROGRESSION_TOAST_CHANNEL.equals((Object)msg.channelId)) {
                    PacketHandler.parseProgressionToast(buf);
                } else if (CommonPacketHandler.SPAWN_LOCATION_SYNC_CHANNEL.equals((Object)msg.channelId)) {
                    PacketHandler.parseSpawnLocationSync(buf);
                } else if (CommonPacketHandler.ATTRIBUTE_SYNC_CHANNEL.equals((Object)msg.channelId)) {
                    PacketHandler.parseAttributeSync(buf);
                } else if (CommonPacketHandler.SCANNING_PROGRESS_CHANNEL.equals((Object)msg.channelId)) {
                    PacketHandler.parseScanningProgress(buf);
                }
            }
            catch (Exception exception) {
            }
            finally {
                ctx.setPacketHandled(true);
            }
        }
    }
}

