/*
 * Decompiled with CFR 0.152.
 */
package com.araxer.araxers_bestiary.network;

import com.araxer.araxers_bestiary.config.Config;
import com.araxer.araxers_bestiary.data.BestiaryLootManager;
import com.araxer.araxers_bestiary.data.EntityDataProvider;
import com.araxer.araxers_bestiary.data.EntityDataServerHelper;
import com.araxer.araxers_bestiary.data.GlobalPlayerProgressionData;
import com.araxer.araxers_bestiary.data.LootItemEntry;
import com.araxer.araxers_bestiary.data.PlayerProgressionData;
import com.araxer.araxers_bestiary.network.CommonPacketHandler;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.slf4j.Logger;

@Mod.EventBusSubscriber(modid="araxers_bestiary")
public class ServerPacketHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    private static String summarizeLoot(List<LootItemEntry> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        boolean first = true;
        for (LootItemEntry e : list) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            Item item = e.itemStack().m_41720_();
            ResourceLocation id = ForgeRegistries.ITEMS.getKey((Object)item);
            String idStr = id != null ? id.toString() : "unknown:item";
            String name = e.displayName() != null ? e.displayName().getString() : idStr;
            String chance = e.getDropChanceString();
            sb.append(name).append(" (").append(idStr).append(") chance=").append(chance);
        }
        sb.append("]");
        return sb.toString();
    }

    public static void init() {
        LOGGER.debug("Initializing server packet handler");
        try {
            if (CommonPacketHandler.VIEWED_CHANNEL == null) {
                LOGGER.warn("CommonPacketHandler channels are not initialized yet. Attempting to initialize them now.");
                CommonPacketHandler.init();
                if (CommonPacketHandler.VIEWED_CHANNEL == null) {
                    LOGGER.error("Failed to initialize CommonPacketHandler channels. Entity viewed packets may not work correctly.");
                    return;
                }
            }
            CommonPacketHandler.VIEWED_CHANNEL.addListener(ServerPacketHandler::handleEntityViewedPacket);
            LOGGER.debug("Successfully registered server-side listener for entity viewed packets");
            if (CommonPacketHandler.SCOPING_CHANNEL != null) {
                CommonPacketHandler.SCOPING_CHANNEL.addListener(ServerPacketHandler::handleScopingStatePacket);
                LOGGER.debug("Successfully registered server-side listener for scoping state heartbeats");
            } else {
                LOGGER.error("Scoping channel is null, cannot add listener");
            }
            if (CommonPacketHandler.GLOBAL_BENEFIT_TOGGLE != null) {
                CommonPacketHandler.GLOBAL_BENEFIT_TOGGLE.addListener(ServerPacketHandler::handleGlobalBenefitTogglePacket);
                LOGGER.debug("Successfully registered server-side listener for global benefit toggle");
            } else {
                LOGGER.error("Global benefit toggle channel is null, cannot add listener");
            }
        }
        catch (Exception e) {
            LOGGER.error("Error initializing server packet handler: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    @SubscribeEvent
    public static void onServerStarting(ServerStartingEvent event) {
        LOGGER.debug("Server starting, initializing server packet handler");
        ServerPacketHandler.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void handleEntityViewedPacket(NetworkEvent.ClientCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            ResourceLocation entityTypeId;
            if (buf == null) {
                LOGGER.error("Cannot process entity viewed packet: payload buffer is null");
                return;
            }
            int readable = buf.readableBytes();
            if (readable <= 0) {
                LOGGER.debug("Received empty entity viewed payload ({} bytes). Ignoring.", (Object)readable);
                return;
            }
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            try {
                entityTypeId = buf.m_130281_();
            }
            catch (Exception ex) {
                LOGGER.error("Malformed entity viewed payload (could not read ResourceLocation, remaining={}): {}", (Object)buf.readableBytes(), (Object)ex.toString());
                context.setPacketHandled(true);
                if (buf != null && buf.readableBytes() > 0) {
                    LOGGER.warn("Consuming {} remaining bytes in the buffer after processing entity viewed packet", (Object)buf.readableBytes());
                    buf.skipBytes(buf.readableBytes());
                }
                return;
            }
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player == null) {
                    LOGGER.error("Cannot process entity viewed packet: player is null");
                    return;
                }
                ServerLevel level = (ServerLevel)player.m_9236_();
                if (level == null) {
                    LOGGER.error("Cannot process entity viewed packet: level is null");
                    return;
                }
                EntityType entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(entityTypeId);
                if (entityType == null) {
                    LOGGER.error("Cannot process entity viewed packet: unknown entity type {}", (Object)entityTypeId);
                    return;
                }
                LOGGER.debug("Received entity viewed packet from player {} for entity {}", (Object)player.m_7755_().getString(), (Object)entityType.m_20675_());
                GlobalPlayerProgressionData.get(level.m_7654_()).data().markAsViewed(player.m_20148_(), entityType);
                LOGGER.debug("Successfully marked entity {} as viewed for player {} (global)", (Object)entityType.m_20675_(), (Object)player.m_7755_().getString());
                try {
                    List<LootItemEntry> lootEntries;
                    List<LootItemEntry> before = EntityDataProvider.getCachedLoot(entityType);
                    try {
                        LOGGER.debug("[Loot][Cache] {} entries for {}: {}", new Object[]{before == null ? 0 : before.size(), entityType.m_20675_(), ServerPacketHandler.summarizeLoot(before)});
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (before == null || before.isEmpty()) {
                        lootEntries = EntityDataServerHelper.generateLootEntriesFromTable(entityType, level);
                        if (lootEntries == null) {
                            lootEntries = new ArrayList<LootItemEntry>();
                        }
                        ArrayList<LootItemEntry> tableOnlyLog = new ArrayList<LootItemEntry>(lootEntries);
                        try {
                            LOGGER.debug("[Loot][LootTable] {} entries for {}: {}", new Object[]{tableOnlyLog.size(), entityType.m_20675_(), ServerPacketHandler.summarizeLoot(tableOnlyLog)});
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        List<LootItemEntry> dp = null;
                        if (BestiaryLootManager.hasLootForEntity(entityType)) {
                            dp = BestiaryLootManager.getLootForEntity(entityType);
                        }
                        if (dp != null && !dp.isEmpty()) {
                            if (!lootEntries.isEmpty()) {
                                HashMap<Item, LootItemEntry> map = new HashMap<Item, LootItemEntry>();
                                for (LootItemEntry lootItemEntry : lootEntries) {
                                    map.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
                                }
                                for (LootItemEntry lootItemEntry : dp) {
                                    int n;
                                    Item item = lootItemEntry.itemStack().m_41720_();
                                    LootItemEntry lootItemEntry2 = (LootItemEntry)map.get(item);
                                    if (lootItemEntry2 == null) {
                                        lootEntries.add(lootItemEntry);
                                        continue;
                                    }
                                    if (!lootItemEntry2.hasUnknownDropChance() || lootItemEntry.hasUnknownDropChance() || (n = lootEntries.indexOf(lootItemEntry2)) < 0) continue;
                                    lootEntries.set(n, new LootItemEntry(lootItemEntry2.itemStack(), lootItemEntry.displayName().getString().isEmpty() ? lootItemEntry2.displayName() : lootItemEntry.displayName(), lootItemEntry.dropChance(), lootItemEntry2.override() || lootItemEntry.override()));
                                }
                            } else {
                                lootEntries = new ArrayList<LootItemEntry>(dp);
                            }
                        }
                        try {
                            LOGGER.debug("[Loot][Generated] {} entries for {}: {}", new Object[]{lootEntries.size(), entityType.m_20675_(), ServerPacketHandler.summarizeLoot(lootEntries)});
                        }
                        catch (Throwable map) {}
                    } else {
                        boolean alreadySimulated = EntityDataProvider.hasBeenSimulatedOnClick(entityType);
                        if (!alreadySimulated) {
                            boolean needsSimulate = false;
                            for (LootItemEntry e2 : before) {
                                if (!e2.hasUnknownDropChance()) continue;
                                needsSimulate = true;
                                break;
                            }
                            if (needsSimulate) {
                                List<LootItemEntry> gen = EntityDataServerHelper.generateLootEntriesFromTable(entityType, level);
                                if (gen == null) {
                                    gen = new ArrayList<LootItemEntry>();
                                }
                                try {
                                    LOGGER.debug("[Loot][LootTable] {} entries for {}: {}", new Object[]{gen.size(), entityType.m_20675_(), ServerPacketHandler.summarizeLoot(gen)});
                                }
                                catch (Throwable e2) {
                                    // empty catch block
                                }
                                HashMap<Item, LootItemEntry> map = new HashMap<Item, LootItemEntry>();
                                for (LootItemEntry lootItemEntry : before) {
                                    map.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
                                }
                                ArrayList<LootItemEntry> arrayList = new ArrayList<LootItemEntry>(before);
                                for (LootItemEntry lootItemEntry : gen) {
                                    Item item = lootItemEntry.itemStack().m_41720_();
                                    LootItemEntry existing = (LootItemEntry)map.get(item);
                                    if (existing == null) {
                                        arrayList.add(lootItemEntry);
                                        map.put(item, lootItemEntry);
                                        continue;
                                    }
                                    if (!existing.hasUnknownDropChance() || lootItemEntry.hasUnknownDropChance()) continue;
                                    int idx = arrayList.indexOf(existing);
                                    if (idx >= 0) {
                                        arrayList.set(idx, new LootItemEntry(existing.itemStack(), existing.displayName(), lootItemEntry.dropChance(), existing.override()));
                                    }
                                    map.put(item, (LootItemEntry)arrayList.get(idx >= 0 ? idx : arrayList.size() - 1));
                                }
                                try {
                                    List<LootItemEntry> list;
                                    if (BestiaryLootManager.hasLootForEntity(entityType) && (list = BestiaryLootManager.getLootForEntity(entityType)) != null && !list.isEmpty()) {
                                        for (LootItemEntry lootItemEntry : list) {
                                            it = lootItemEntry.itemStack().m_41720_();
                                            LootItemEntry existing = (LootItemEntry)map.get(it);
                                            if (existing == null) {
                                                arrayList.add(lootItemEntry);
                                                map.put(it, lootItemEntry);
                                                continue;
                                            }
                                            if (!existing.hasUnknownDropChance() || lootItemEntry.hasUnknownDropChance()) continue;
                                            idx = arrayList.indexOf(existing);
                                            if (idx >= 0) {
                                                arrayList.set(idx, new LootItemEntry(existing.itemStack(), lootItemEntry.displayName().getString().isEmpty() ? existing.displayName() : lootItemEntry.displayName(), lootItemEntry.dropChance(), existing.override() || lootItemEntry.override()));
                                            }
                                            map.put(it, (LootItemEntry)arrayList.get(idx >= 0 ? idx : arrayList.size() - 1));
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                lootEntries = arrayList;
                                try {
                                    LOGGER.debug("[Loot][Generated] {} entries for {}: {}", new Object[]{lootEntries.size(), entityType.m_20675_(), ServerPacketHandler.summarizeLoot(lootEntries)});
                                }
                                catch (Throwable throwable) {}
                            } else {
                                int batches = Config.initialLootSampleBatches;
                                if (batches <= 0) {
                                    batches = 100;
                                }
                                if (batches > 300) {
                                    batches = 300;
                                }
                                if ((sampled = EntityDataServerHelper.simulateAdditionalLootSamples(entityType, level, batches / 2)) == null) {
                                    sampled = Collections.emptyList();
                                }
                                try {
                                    LOGGER.debug("[Loot][LootTable] sampling supplement for {} (cache had no unknowns): {}", (Object)entityType.m_20675_(), (Object)ServerPacketHandler.summarizeLoot(sampled));
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                HashMap<Item, LootItemEntry> hashMap = new HashMap<Item, LootItemEntry>();
                                for (LootItemEntry lootItemEntry : before) {
                                    hashMap.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
                                }
                                ArrayList<LootItemEntry> arrayList = new ArrayList<LootItemEntry>(before);
                                for (LootItemEntry lootItemEntry : sampled) {
                                    it = lootItemEntry.itemStack().m_41720_();
                                    if (hashMap.containsKey(it)) continue;
                                    arrayList.add(lootItemEntry);
                                    hashMap.put(it, lootItemEntry);
                                }
                                try {
                                    List<LootItemEntry> list;
                                    if (BestiaryLootManager.hasLootForEntity(entityType) && (list = BestiaryLootManager.getLootForEntity(entityType)) != null && !list.isEmpty()) {
                                        for (LootItemEntry de : list) {
                                            Item it = de.itemStack().m_41720_();
                                            if (hashMap.containsKey(it)) continue;
                                            arrayList.add(de);
                                            hashMap.put(it, de);
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                lootEntries = arrayList;
                                try {
                                    LOGGER.debug("[Loot][Generated] {} entries for {}: {}", new Object[]{lootEntries.size(), entityType.m_20675_(), ServerPacketHandler.summarizeLoot(lootEntries)});
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                            EntityDataProvider.markSimulatedOnClick(entityType);
                        } else {
                            int suppBatches;
                            int batches = Config.initialLootSampleBatches;
                            if (batches <= 0) {
                                batches = 60;
                            }
                            if (batches > 300) {
                                batches = 300;
                            }
                            if ((sampled = EntityDataServerHelper.simulateAdditionalLootSamples(entityType, level, suppBatches = Math.max(20, Math.min(80, batches / 3)))) == null) {
                                sampled = Collections.emptyList();
                            }
                            try {
                                LOGGER.debug("[Loot][LootTable] lightweight sampling supplement for {} (already simulated): {}", (Object)entityType.m_20675_(), (Object)ServerPacketHandler.summarizeLoot(sampled));
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            HashMap<Item, LootItemEntry> hashMap = new HashMap<Item, LootItemEntry>();
                            for (LootItemEntry lootItemEntry : before) {
                                hashMap.put(lootItemEntry.itemStack().m_41720_(), lootItemEntry);
                            }
                            ArrayList<LootItemEntry> arrayList = new ArrayList<LootItemEntry>(before);
                            for (LootItemEntry lootItemEntry : sampled) {
                                it = lootItemEntry.itemStack().m_41720_();
                                LootItemEntry existing = (LootItemEntry)hashMap.get(it);
                                if (existing == null) {
                                    arrayList.add(lootItemEntry);
                                    hashMap.put(it, lootItemEntry);
                                    continue;
                                }
                                if (!existing.hasUnknownDropChance() || lootItemEntry.hasUnknownDropChance() || (idx = arrayList.indexOf(existing)) < 0) continue;
                                arrayList.set(idx, new LootItemEntry(existing.itemStack(), existing.displayName(), lootItemEntry.dropChance(), existing.override()));
                            }
                            lootEntries = arrayList;
                            try {
                                LOGGER.debug("[Loot][Generated] {} entries for {}: {}", new Object[]{lootEntries.size(), entityType.m_20675_(), ServerPacketHandler.summarizeLoot(lootEntries)});
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (lootEntries != null && !lootEntries.isEmpty()) {
                        List<LootItemEntry> beforeNow = EntityDataProvider.getCachedLoot(entityType);
                        HashMap<Item, Float> beforeMap = new HashMap<Item, Float>();
                        for (LootItemEntry be : beforeNow) {
                            beforeMap.put(be.itemStack().m_41720_(), Float.valueOf(be.dropChance()));
                        }
                        boolean changed = beforeNow.isEmpty();
                        float EPS = 1.0E-4f;
                        if (!changed) {
                            for (LootItemEntry lootItemEntry : lootEntries) {
                                Item item = lootItemEntry.itemStack().m_41720_();
                                Float f = (Float)beforeMap.get(item);
                                if (f == null) {
                                    changed = true;
                                    break;
                                }
                                float oldVal = f.floatValue();
                                boolean oldUnknown = oldVal == -1.0f;
                                boolean newUnknown = lootItemEntry.hasUnknownDropChance();
                                if (oldUnknown && !newUnknown) {
                                    changed = true;
                                    break;
                                }
                                if (oldUnknown || newUnknown || !(Math.abs(oldVal - lootItemEntry.dropChance()) > 1.0E-4f)) continue;
                                changed = true;
                                break;
                            }
                        }
                        EntityDataProvider.updateLootCache(entityType, lootEntries);
                        if (changed) {
                            EntityDataProvider.sendLootUpdatePacket(player, entityType, lootEntries);
                            LOGGER.debug("Resolved and sent {} loot entries for {} to {} (on-click, changed={})", new Object[]{lootEntries.size(), entityType.m_20675_(), player.m_7755_().getString(), true});
                        } else if (EntityDataProvider.hasBeenSimulatedOnClick(entityType)) {
                            EntityDataProvider.sendLootUpdatePacket(player, entityType, lootEntries);
                            LOGGER.debug("Sent cached loot for {} to {} (on-click, already simulated)", (Object)entityType.m_20675_(), (Object)player.m_7755_().getString());
                        } else {
                            LOGGER.debug("Resolved loot for {} on click but no new items or refined chances; skipping network update", (Object)entityType.m_20675_());
                        }
                    } else {
                        LOGGER.debug("No loot resolved for {} on click; not sending empty update (dimension-agnostic)", (Object)entityType.m_20675_());
                    }
                    EntityDataProvider.enqueueLazyBatchGeneration(level, entityType);
                }
                catch (Exception genEx) {
                    LOGGER.error("Error resolving loot on-demand for {}: {}", (Object)entityType.m_20675_(), (Object)genEx.toString());
                }
            });
            context.setPacketHandled(true);
        }
        catch (Exception e) {
            LOGGER.error("Error processing entity viewed packet: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            if (buf != null && buf.readableBytes() > 0) {
                LOGGER.warn("Consuming {} remaining bytes in the buffer after processing entity viewed packet", (Object)buf.readableBytes());
                buf.skipBytes(buf.readableBytes());
            }
        }
    }

    private static void handleScopingStatePacket(NetworkEvent.ClientCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
        ServerPlayer player = context.getSender();
        if (player == null) {
            return;
        }
        context.enqueueWork(() -> {
            try {
                ServerLevel level = (ServerLevel)player.m_9236_();
                PlayerProgressionData data = PlayerProgressionData.getOrCreate(level);
                data.recordClientScopingHeartbeat(player);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        context.setPacketHandled(true);
        try {
            if (buf != null && buf.readableBytes() > 0) {
                buf.skipBytes(buf.readableBytes());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void handleGlobalBenefitTogglePacket(NetworkEvent.ClientCustomPayloadEvent event) {
        FriendlyByteBuf buf = event.getPayload();
        try {
            boolean disabled;
            int index;
            if (buf == null) {
                return;
            }
            int readable = buf.readableBytes();
            if (readable <= 0) {
                return;
            }
            NetworkEvent.Context context = (NetworkEvent.Context)event.getSource().get();
            try {
                index = buf.readInt();
                disabled = buf.readBoolean();
            }
            catch (Exception ex) {
                context.setPacketHandled(true);
                return;
            }
            context.enqueueWork(() -> {
                ServerPlayer player = context.getSender();
                if (player == null) {
                    return;
                }
                ServerLevel level = (ServerLevel)player.m_9236_();
                if (level == null) {
                    return;
                }
                PlayerProgressionData data = GlobalPlayerProgressionData.get(level.m_7654_()).data();
                data.setBenefitDisabled(player, index, disabled);
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

