/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun;

import com.jdolphin.ricksportalgun.RicksPortalGunCommonMain;
import com.jdolphin.ricksportalgun.common.config.PGClientConfig;
import com.jdolphin.ricksportalgun.common.config.PGCommonConfig;
import com.jdolphin.ricksportalgun.common.init.NeoForgePackets;
import com.jdolphin.ricksportalgun.common.init.PGBlockEntities;
import com.jdolphin.ricksportalgun.common.init.PGBlocks;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGEntities;
import com.jdolphin.ricksportalgun.common.init.PGItems;
import com.jdolphin.ricksportalgun.common.init.PGMenuTypes;
import com.jdolphin.ricksportalgun.common.init.PGRecipeSerializers;
import com.jdolphin.ricksportalgun.common.init.PGRecipeTypes;
import com.jdolphin.ricksportalgun.common.packet.clientbound.CBSyncDimensionListPacket;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGConfigHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@Mod(value="ricksportalgun")
public class RicksPortalGunNeoForgeMain {
    public RicksPortalGunNeoForgeMain(IEventBus bus) {
        RicksPortalGunCommonMain.init();
        NeoForge.EVENT_BUS.addListener(this::onPlayerJoin);
        bus.addListener(this::buildContents);
        bus.addListener(this::registerPackets);
        RicksPortalGunNeoForgeMain.bind(bus, Registries.DATA_COMPONENT_TYPE, PGDataComponents::init);
        RicksPortalGunNeoForgeMain.bind(bus, Registries.BLOCK, PGBlocks::init);
        RicksPortalGunNeoForgeMain.bind(bus, Registries.ITEM, PGItems::init);
        RicksPortalGunNeoForgeMain.bind(bus, Registries.BLOCK_ENTITY_TYPE, PGBlockEntities::init);
        RicksPortalGunNeoForgeMain.bind(bus, Registries.ENTITY_TYPE, PGEntities::init);
        RicksPortalGunNeoForgeMain.bind(bus, Registries.MENU, PGMenuTypes::init);
        RicksPortalGunNeoForgeMain.bind(bus, Registries.RECIPE_TYPE, PGRecipeTypes::init);
        RicksPortalGunNeoForgeMain.bind(bus, Registries.RECIPE_SERIALIZER, PGRecipeSerializers::init);
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)PGCommonConfig.SPEC, "ricksportalgun-common.toml");
        ModLoadingContext.get().getActiveContainer().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)PGClientConfig.SPEC, "ricksportalgun-client.toml");
    }

    public void registerPackets(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        NeoForgePackets.init(registrar);
    }

    private void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer serverPlayer;
        MinecraftServer server;
        Player player = event.getEntity();
        if (player instanceof ServerPlayer && (server = (serverPlayer = (ServerPlayer)player).getServer()) != null) {
            ArrayList<String> dims = new ArrayList<String>(LevelHelper.getDimensionsAsString(server.getAllLevels()).stream().filter(s -> !PGConfigHelper.getDisabledDimensions().contains(s)).toList());
            if (!dims.contains(PGHelper.id("blender").toString()) && !PGConfigHelper.getDisabledDimensions().contains(PGHelper.id("blender").toString())) {
                dims.add(PGHelper.id("blender").toString());
            }
            CBSyncDimensionListPacket dimSync = new CBSyncDimensionListPacket(dims);
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)dimSync, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    private static <T> void bind(IEventBus bus, ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        bus.addListener(event -> {
            if (registry.equals(event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    public void buildContents(BuildCreativeModeTabContentsEvent event) {
        ResourceKey key = event.getTabKey();
        for (Map.Entry<Item, ResourceKey<CreativeModeTab>> entry : PGItems.TABS.entrySet()) {
            ResourceKey<CreativeModeTab> entryKey = entry.getValue();
            if (!key.equals(entryKey)) continue;
            event.accept((ItemLike)entry.getKey());
        }
    }
}

