/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.SettingsScreen;
import com.jdolphin.ricksportalgun.client.screen.portalgun.WaypointScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.client.screen.widget.SuggestionTextFieldWidget;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.init.PGTags;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBActivateSelfDestructPacket;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBCoordCheckerPacket;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBOpenLocatorScreenPacket;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBSetDestinationPacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.LevelHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class CoordTravelScreen
extends AbstractBaseScreen {
    private PGImageButton waypoints;
    private PGImageButton randomiseDim;
    private PGImageButton randomiseCoord;
    private PGImageButton locator;
    private PGImageButton settings;
    private PGImageButton selfDestruct;
    private String dS;
    private String xS;
    private String yS;
    private String zS;
    private EditBox xInput;
    private EditBox yInput;
    private EditBox zInput;
    private SuggestionTextFieldWidget dimInput;
    private final List<String> dimSuggestions;
    private PGTextButton select;
    private PGTextButton cancel;
    public static ResourceLocation WAYPOINT_TEXTURE = PGHelper.id("textures/gui/sprites/icon/waypoint.png");
    public static ResourceLocation PLAYER_LOC_TEXTURE = PGHelper.id("textures/gui/sprites/icon/locator.png");
    public static ResourceLocation RANDOMIZER_TEXTURE = PGHelper.id("textures/gui/sprites/icon/randomizer.png");
    public static ResourceLocation SETTINGS_TEXTURE = PGHelper.id("textures/gui/sprites/icon/settings.png");
    public static ResourceLocation SELF_DESTRUCT_TEXTURE = PGHelper.id("textures/gui/sprites/icon/self_destruct.png");

    public CoordTravelScreen(List<String> suggestions) {
        super("menu.ricksportalgun.coord");
        this.dimSuggestions = suggestions;
    }

    protected void init() {
        super.init();
        assert (this.minecraft != null);
        LocalPlayer player = this.minecraft.player;
        assert (player != null);
        ItemStack stack = this.getItemStack();
        this.dimInput = (SuggestionTextFieldWidget)this.addWidget((GuiEventListener)new SuggestionTextFieldWidget(this.width / 2 - 32, this.height / 2 - 64, 112, 16, Component.translatable((String)"chat.editBox"), this.dimSuggestions));
        this.addWidget((GuiEventListener)this.dimInput.getSuggestionList());
        this.xInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 32, this.height / 2 - 40, 64, 16, (Component)Component.translatable((String)"chat.editBox")));
        this.yInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 32, this.height / 2 - 16, 64, 16, (Component)Component.translatable((String)"chat.editBox")));
        this.zInput = (EditBox)this.addWidget((GuiEventListener)new EditBox(this.font, this.width / 2 - 32, this.height / 2 + 8, 64, 16, (Component)Component.translatable((String)"chat.editBox")));
        this.randomiseDim = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.dimInput.getX() + this.dimInput.getWidth() + 5, this.dimInput.getY() - 1, 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.randomise.dimension"), button -> {
            List<String> strings = this.dimInput.getSuggestions();
            String s = PGHelper.getRandomFromList(strings);
            this.dimInput.setValue(s);
        }, 20, 18, RANDOMIZER_TEXTURE));
        this.randomiseCoord = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.randomiseDim.getX(), this.yInput.getY(), 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.randomise.coord"), button -> {
            if (stack.is(PGTags.Items.PORTAL_GUNS)) {
                Level level = player.level();
                String dim = this.dimInput.getValue().isEmpty() ? LevelHelper.getLevelDimensionLocation(level).toString() : this.dimInput.getValue();
                SBCoordCheckerPacket packet = new SBCoordCheckerPacket(dim);
                PGHelper.sendPacketToServer(packet);
            }
            this.onClose();
        }, 20, 18, RANDOMIZER_TEXTURE));
        this.selfDestruct = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.yInput.getX() - 96, this.yInput.getY() - 2, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.self_destruct.activate"), button -> {
            if (stack.is(PGTags.Items.PORTAL_GUNS)) {
                SBActivateSelfDestructPacket packet = new SBActivateSelfDestructPacket();
                PGHelper.sendPacketToServer(packet);
            }
            this.onClose();
        }, 20, 18, SELF_DESTRUCT_TEXTURE));
        this.selfDestruct.active = (Boolean)stack.getOrDefault(PGDataComponents.SELF_DESTRUCT, (Object)false);
        this.waypoints = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 - 36, this.height / 2 + 32, 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.waypoint"), button -> this.minecraft.setScreen((Screen)new WaypointScreen()), 20, 18, WAYPOINT_TEXTURE));
        this.locator = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 - 10, this.height / 2 + 32, 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.locator"), button -> {
            SBOpenLocatorScreenPacket packet = new SBOpenLocatorScreenPacket();
            PGHelper.sendPacketToServer(packet);
        }, 20, 18, PLAYER_LOC_TEXTURE));
        this.settings = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 + 16, this.height / 2 + 32, 20, 18, (Component)Component.translatable((String)"ricksportalgun.button.settings"), button -> this.minecraft.setScreen((Screen)new SettingsScreen()), 20, 18, SETTINGS_TEXTURE));
        this.select = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 - 136, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.select"), button -> {
            this.setCoords();
            this.onClose();
        }, this.font));
        this.cancel = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 + 8, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.onClose(), this.font));
        if (!((Boolean)stack.getOrDefault(PGDataComponents.EXTRA_DIMENSIONS, (Object)true)).booleanValue()) {
            this.randomiseDim.active = false;
            this.dimInput.setEditable(false);
            this.dimInput.getSuggestionList().active = false;
        }
        if (!((Boolean)stack.getOrDefault(PGDataComponents.HAS_WAYPOINTS, (Object)true)).booleanValue()) {
            this.waypoints.active = false;
        }
        if (!((Boolean)stack.getOrDefault(PGDataComponents.BIOME_LOC, (Object)true)).booleanValue()) {
            this.locator.active = false;
        }
        if (!((Boolean)stack.getOrDefault(PGDataComponents.SETTINGS, (Object)true)).booleanValue()) {
            this.settings.active = false;
        }
        PortalGunStyle style = this.getStyle();
        this.dimInput.getSuggestionList().setBorderColor(style.highlightColor());
        this.setupEditBox(this.dimInput, style);
        this.setupEditBox(this.xInput, style);
        this.setupEditBox(this.yInput, style);
        this.setupEditBox(this.zInput, style);
        this.setupImgButtons(this.settings, style);
        this.setupImgButtons(this.waypoints, style);
        this.setupImgButtons(this.locator, style);
        this.setupImgButtons(this.randomiseCoord, style);
        this.setupImgButtons(this.randomiseDim, style);
        this.setupImgButtons(this.selfDestruct, style);
        ResourceLocation location = LevelHelper.getPlayerDimensionLocation((Player)player);
        this.dS = location.getNamespace().equals("minecraft") ? location.getPath() : location.toString();
        this.dimInput.setSuggestion(this.dS);
        BlockPos dest = (BlockPos)stack.getOrDefault(PGDataComponents.PORTAL_POS, (Object)player.blockPosition());
        this.xS = String.valueOf(dest.getX());
        this.yS = String.valueOf(dest.getY());
        this.zS = String.valueOf(dest.getZ());
        this.xInput.setSuggestion(this.xS);
        this.yInput.setSuggestion(this.yS);
        this.zInput.setSuggestion(this.zS);
        GuiHelper.setTooltip((AbstractWidget)this.randomiseCoord, (Component)Component.translatable((String)"ricksportalgun.button.randomise.coord"));
    }

    private void setupImgButtons(PGImageButton button, PortalGunStyle style) {
        button.setColor(style.highlightColor());
        button.setRenderBackground(false);
    }

    private void setupEditBox(EditBox box, PortalGunStyle style) {
        box.setResponder(this::onEdited);
        box.setMaxLength(256);
        box.setTextColor(style.textColor());
    }

    public void tick() {
        super.tick();
        assert (this.minecraft != null);
        LocalPlayer player = this.minecraft.player;
        if (player != null) {
            if (!this.dimInput.isFocused() && this.dimInput.getValue().isEmpty()) {
                this.dimInput.setSuggestion(player.clientLevel.dimension().location().toString());
            } else {
                this.dimInput.setSuggestion("");
            }
        }
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Optional optional = this.getChildAt(mouseX, mouseY);
        if (optional.isEmpty()) {
            this.dimInput.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float delta) {
        PortalGunStyle style = this.getStyle();
        graphics.fill(this.width / 2 - 154, this.height / 2 - 110, this.width / 2 + 165, this.height / 2 + 100, style.bgColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"menu.ricksportalgun.coord"), this.width / 2, this.height / 2 - 92, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.x", (Object[])new Object[]{""}), this.width / 2 - 88, this.xInput.getY() + 3, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.y", (Object[])new Object[]{""}), this.width / 2 - 88, this.yInput.getY() + 3, style.textColor());
        graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.z", (Object[])new Object[]{""}), this.width / 2 - 88, this.zInput.getY() + 3, style.textColor());
        GuiHelper.renderWidgets(graphics, pMouseX, pMouseY, delta, new AbstractWidget[]{this.xInput, this.yInput, this.zInput});
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.xInput, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.yInput, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.zInput, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.randomiseCoord, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.select, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.cancel, style.highlightColor());
        ItemStack stack = this.getItemStack();
        if (((Boolean)stack.getOrDefault(PGDataComponents.SELF_DESTRUCT, (Object)false)).booleanValue()) {
            GuiHelper.renderOutline(graphics, (AbstractWidget)this.selfDestruct, style.highlightColor());
            this.selfDestruct.render(graphics, pMouseX, pMouseY, delta);
            GuiHelper.setTooltip((AbstractWidget)this.selfDestruct, (Component)Component.translatable((String)"ricksportalgun.button.self_destruct.activate"));
        }
        if (((Boolean)stack.getOrDefault(PGDataComponents.EXTRA_DIMENSIONS, (Object)false)).booleanValue()) {
            this.dimInput.render(graphics, pMouseX, pMouseY, delta);
            this.randomiseDim.render(graphics, pMouseX, pMouseY, delta);
            graphics.drawString(this.font, (Component)Component.translatable((String)"ricksportalgun.dimension", (Object[])new Object[]{""}), this.width / 2 - 88, this.dimInput.getY() + 3, style.textColor());
            GuiHelper.setTooltip((AbstractWidget)this.randomiseDim, (Component)Component.translatable((String)"ricksportalgun.button.randomise.dimension"));
            GuiHelper.renderOutline(graphics, (AbstractWidget)this.randomiseDim, style.highlightColor());
            GuiHelper.renderOutline(graphics, (AbstractWidget)this.dimInput, style.highlightColor());
        }
        if (((Boolean)stack.getOrDefault(PGDataComponents.HAS_WAYPOINTS, (Object)false)).booleanValue()) {
            this.waypoints.render(graphics, pMouseX, pMouseY, delta);
            GuiHelper.renderOutline(graphics, (AbstractWidget)this.waypoints, style.highlightColor());
            GuiHelper.setTooltip((AbstractWidget)this.waypoints, (Component)Component.translatable((String)"ricksportalgun.button.waypoint"));
        }
        if (((Boolean)stack.getOrDefault(PGDataComponents.SETTINGS, (Object)false)).booleanValue()) {
            this.settings.render(graphics, pMouseX, pMouseY, delta);
            GuiHelper.renderOutline(graphics, (AbstractWidget)this.settings, style.highlightColor());
            GuiHelper.setTooltip((AbstractWidget)this.settings, (Component)Component.translatable((String)"ricksportalgun.button.settings"));
        }
        if (((Boolean)stack.getOrDefault(PGDataComponents.BIOME_LOC, (Object)false)).booleanValue()) {
            this.locator.render(graphics, pMouseX, pMouseY, delta);
            GuiHelper.renderOutline(graphics, (AbstractWidget)this.locator, style.highlightColor());
            GuiHelper.setTooltip((AbstractWidget)this.locator, (Component)Component.translatable((String)"ricksportalgun.button.locator"));
        }
        RenderSystem.enableBlend();
        graphics.blit(BG_LOCATION, this.width / 2 - 158, this.height / 2 - 115, 0.0f, 0.0f, 330, 224, 330, 224);
        RenderSystem.disableBlend();
        Style guiStyle = GuiHelper.getStyle(pMouseX, pMouseY);
        if (guiStyle != null && guiStyle.getHoverEvent() != null) {
            this.renderWithTooltip(graphics, pMouseX, pMouseY, delta);
        }
        super.render(graphics, pMouseX, pMouseY, delta);
    }

    private void onEdited(String string) {
        String xValue = this.xInput.getValue();
        String yValue = this.yInput.getValue();
        String zValue = this.zInput.getValue();
        this.dimInput.setSuggestion("");
        this.dimInput.update();
        if (this.xS.startsWith(this.xInput.getValue())) {
            this.xInput.setSuggestion(this.xS.substring(xValue.length()));
        } else {
            this.xInput.setSuggestion("");
        }
        if (this.yS.startsWith(this.yInput.getValue())) {
            this.yInput.setSuggestion(this.yS.substring(yValue.length()));
        } else {
            this.yInput.setSuggestion("");
        }
        if (this.zS.startsWith(this.zInput.getValue())) {
            this.zInput.setSuggestion(this.zS.substring(zValue.length()));
        } else {
            this.zInput.setSuggestion("");
        }
    }

    public void setCoords() {
        try {
            assert (this.minecraft != null && this.minecraft.player != null);
            LocalPlayer player = this.minecraft.player;
            String value = this.dimInput.getValue();
            if (value.equals("end")) {
                this.dimInput.setValue("the_end");
            }
            if (value.equals("nether")) {
                this.dimInput.setValue("the_nether");
            }
            ResourceLocation resourceLocation = ResourceLocation.parse((String)(value.isEmpty() ? LevelHelper.getPlayerDimensionLocation((Player)player).toString() : value));
            SBSetDestinationPacket packet = new SBSetDestinationPacket(this.getCoords(player), resourceLocation.toString());
            PGHelper.sendPacketToServer(packet);
            this.onClose();
        }
        catch (Exception error) {
            this.dimInput.setSuggestion(" \u00a7c" + error.getLocalizedMessage());
        }
    }

    private int getInt(EditBox box, int fallback) {
        return box.getValue().isEmpty() ? fallback : Integer.parseInt(box.getValue());
    }

    @NotNull
    private BlockPos getCoords(LocalPlayer player) {
        int x = this.getInt(this.xInput, (int)player.getX());
        int y = this.getInt(this.yInput, (int)player.getY());
        int z = this.getInt(this.zInput, (int)player.getZ());
        return new BlockPos(x, y, z);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        switch (pKeyCode) {
            case 257: 
            case 335: {
                if (this.getFocused() instanceof Button) {
                    return super.keyPressed(pKeyCode, pScanCode, pModifiers);
                }
                this.setCoords();
                break;
            }
            case 258: {
                if (this.dimInput.isFocused()) {
                    this.dimInput.setValue(this.dS);
                }
                if (this.xInput.isFocused()) {
                    this.xInput.setValue(this.xS);
                }
                if (this.yInput.isFocused()) {
                    this.yInput.setValue(this.yS);
                }
                if (!this.zInput.isFocused()) break;
                this.zInput.setValue(this.zS);
            }
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }
}

