/*
 * Decompiled with CFR 0.152.
 */
package com.jdolphin.ricksportalgun.client.screen.portalgun;

import com.jdolphin.ricksportalgun.client.screen.AbstractBaseScreen;
import com.jdolphin.ricksportalgun.client.screen.widget.PGCycleButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGImageButton;
import com.jdolphin.ricksportalgun.client.screen.widget.PGTextButton;
import com.jdolphin.ricksportalgun.client.screen.widget.SuggestionTextFieldWidget;
import com.jdolphin.ricksportalgun.common.init.PGDataComponents;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBLocatePacket;
import com.jdolphin.ricksportalgun.common.packet.serverbound.SBOpenCoordGuiPacket;
import com.jdolphin.ricksportalgun.common.util.PortalGunStyle;
import com.jdolphin.ricksportalgun.common.util.helper.GuiHelper;
import com.jdolphin.ricksportalgun.common.util.helper.PGHelper;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.ItemStack;

public class LocatorScreen
extends AbstractBaseScreen {
    private SuggestionTextFieldWidget input;
    private PGTextButton select;
    private PGTextButton cancel;
    private PGCycleButton<LocatorType> locatorType;
    private final List<String> playerList;
    private final List<String> biomeList;
    private final List<String> structureList;
    private PGImageButton backButton;

    public LocatorScreen(List<String> playerList, List<String> biomeList, List<String> structureList) {
        super("menu.ricksportalgun.player_locator");
        this.playerList = playerList;
        this.biomeList = biomeList;
        this.structureList = structureList;
    }

    private List<String> getListFromType(LocatorType type) {
        switch (type.ordinal()) {
            case 2: {
                return this.structureList;
            }
            case 1: {
                return this.playerList;
            }
        }
        return this.biomeList;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Optional optional = this.getChildAt(mouseX, mouseY);
        if (optional.isEmpty()) {
            this.input.setFocused(false);
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private LocatorType[] getAllowedLocators() {
        ItemStack stack = this.getItemStack();
        boolean canPlayerLocate = (Boolean)stack.getOrDefault(PGDataComponents.PLAYER_LOC, (Object)false);
        boolean canStructureLocate = (Boolean)stack.getOrDefault(PGDataComponents.STRUCTURE_LOC, (Object)false);
        if (canPlayerLocate && canStructureLocate) {
            return LocatorType.values();
        }
        if (!canPlayerLocate && !canStructureLocate) {
            return new LocatorType[]{LocatorType.BIOME};
        }
        if (canPlayerLocate && !canStructureLocate) {
            return new LocatorType[]{LocatorType.BIOME, LocatorType.PLAYER};
        }
        return new LocatorType[0];
    }

    protected void init() {
        this.locatorType = (PGCycleButton)this.addRenderableWidget((GuiEventListener)PGCycleButton.builder(LocatorType::getDisplayName).withValues((LocatorType[])this.getAllowedLocators()).create(this.width / 2 - 64, this.height / 2 - 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.locator"), (button, type) -> {
            List<String> list = this.getListFromType((LocatorType)((Object)type));
            this.input.setSuggestions(list);
        }));
        this.input = (SuggestionTextFieldWidget)this.addWidget((GuiEventListener)new SuggestionTextFieldWidget(this.width / 2 - 64, this.height / 2 - 32, 128, 24, Component.translatable((String)"chat.editBox"), this.getListFromType(this.locatorType.getValue())));
        this.addRenderableWidget((GuiEventListener)this.input.getSuggestionList());
        this.select = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 - 136, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.select"), button -> {
            this.setCoords();
            this.onClose();
        }, this.font));
        this.backButton = (PGImageButton)this.addRenderableWidget((GuiEventListener)new PGImageButton(this.width / 2 - 140, this.height / 2 - 96, 20, 20, (Component)Component.translatable((String)"ricksportalgun.button.back"), button -> {
            SBOpenCoordGuiPacket packet = new SBOpenCoordGuiPacket();
            PGHelper.sendPacketToServer(packet);
        }, 20, 20, BACK_BUTTON_TEXTURE));
        this.cancel = (PGTextButton)this.addRenderableWidget((GuiEventListener)new PGTextButton(this.width / 2 + 8, this.height / 2 + 64, 128, 20, (Component)Component.translatable((String)"ricksportalgun.button.cancel"), button -> this.onClose(), this.font));
        PortalGunStyle style = this.getStyle();
        this.input.setMaxLength(256);
        this.input.setBordered(true);
        this.input.setResponder(s -> this.input.update());
        this.locatorType.setRenderBackground(false);
        this.locatorType.setTextColor(style.textColor());
        this.locatorType.setRenderArrows(true);
        this.input.getSuggestionList().setBorderColor(style.highlightColor());
        this.backButton.setColor(style.highlightColor());
        this.backButton.setRenderBackground(false);
        GuiHelper.setTooltip((AbstractWidget)this.backButton, (Component)Component.translatable((String)"ricksportalgun.button.back"));
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        PortalGunStyle style = this.getStyle();
        graphics.fill(this.width / 2 - 154, this.height / 2 - 110, this.width / 2 + 165, this.height / 2 + 100, style.bgColor());
        graphics.drawCenteredString(this.font, (Component)Component.translatable((String)"menu.ricksportalgun.locator"), this.width / 2, this.height / 2 - 92, style.textColor());
        if (this.input != null) {
            this.input.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.select, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.cancel, style.highlightColor());
        GuiHelper.renderOutline(graphics, this.locatorType, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.input, style.highlightColor());
        GuiHelper.renderOutline(graphics, (AbstractWidget)this.backButton, style.highlightColor());
        Style guiStyle = GuiHelper.getStyle(pMouseX, pMouseY);
        if (guiStyle != null && guiStyle.getHoverEvent() != null) {
            this.renderWithTooltip(graphics, pMouseX, pMouseY, pPartialTick);
        }
        RenderSystem.enableBlend();
        graphics.blit(BG_LOCATION, this.width / 2 - 158, this.height / 2 - 115, 0.0f, 0.0f, 330, 224, 330, 224);
        RenderSystem.disableBlend();
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public void setCoords() {
        SBLocatePacket packet = new SBLocatePacket(this.input.getValue(), this.locatorType.getValue().ordinal());
        PGHelper.sendPacketToServer(packet);
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        switch (pKeyCode) {
            case 257: 
            case 335: {
                if (this.getFocused() instanceof Button) {
                    return super.keyPressed(pKeyCode, pScanCode, pModifiers);
                }
                this.setCoords();
            }
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public static enum LocatorType {
        BIOME("biome"),
        PLAYER("player"),
        STRUCTURE("structure");

        final String key;

        private LocatorType(String key) {
            this.key = key;
        }

        public Component getDisplayName() {
            return Component.translatable((String)("ricksportalgun.button.locator." + this.key));
        }
    }
}

